/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.notification;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Vibrator;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import com.appsflyer.AppsFlyerLib;
import com.bumptech.glide.Glide;
import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.response.SaveFcmResponseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.ToastUtils;
import com.game.sdk.ui.other.GamePresenterImpl;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.model.NtfModel;
import com.mobgame.model.TimerData;
import com.mobgame.model.TimerObject;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MobFirebaseMessagingService
extends FirebaseMessagingService {
    private static final String TAG = MobFirebaseMessagingService.class.getSimpleName();
    private static MobFirebaseMessagingService INSTANCE;

    public int getDrawableSmall(Context c) {
        return Res.drawableResource(c, R.drawable.transparent);
    }

    public static MobFirebaseMessagingService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MobFirebaseMessagingService();
        }
        return INSTANCE;
    }

    public void sendRegistrationToServer(final Activity activity, final String user, String refreshedToken) {
        try {
            Log.d((String)TAG, (String)("sendToken/RegId to server: " + refreshedToken));
            AppsFlyerLib.getInstance().updateServerUninstallToken(MobGameSDK.getApplicationContext(), refreshedToken);
            Preference.save(MobGameSDK.getApplicationContext(), "save_fcm_key", refreshedToken);
            if (!TextUtils.isEmpty((CharSequence)refreshedToken)) {
                GamePresenterImpl gamePresenter = new GamePresenterImpl(new BaseView(){

                    @Override
                    public void showProgress(String mess) {
                    }

                    @Override
                    public void hideProgress() {
                    }

                    public void success(Object x) {
                        if (x instanceof SaveFcmResponseObj) {
                            LogUtils.d(TAG, "Save FCM success : " + user);
                            if (TextUtils.isEmpty((CharSequence)user)) {
                                PrefManager.saveBoolean((Context)activity, "SAVE_FCM_NON_TOKEN", true);
                            } else {
                                PrefManager.saveBoolean((Context)activity, "SAVE_FCM_NON_TOKEN" + AuthenConfigs.getInstance().getAccessToken(), true);
                            }
                        }
                    }

                    public void error(Object o) {
                        BaseObj baseObj = (BaseObj)o;
                        ToastUtils.showErrToast((Context)activity, baseObj.getMessage());
                    }
                });
                gamePresenter.saveFCM(user, refreshedToken);
            }
        }
        catch (Exception e) {
            LogUtils.d(TAG, e.getMessage());
        }
    }

    @SuppressLint(value={"MissingPermission", "CheckResult"})
    public void onMessageReceived(RemoteMessage remoteMessage) {
        try {
            Context context = this.getApplicationContext();
            LogUtils.i(TAG, "onMessage: " + remoteMessage);
            Boolean forcelogoutNotifi = Boolean.valueOf((String)remoteMessage.getData().get("forcelogout"));
            LogUtils.i(TAG, "forcelogoutNotifi: " + forcelogoutNotifi);
            if (forcelogoutNotifi.booleanValue()) {
                Intent intent = new Intent("com.mobgame.broadcast");
                intent.putExtra("category", "forcelogout");
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
            }
            if (remoteMessage.getData().size() <= 0) {
                return;
            }
            Map map = remoteMessage.getData();
            String title = (String)map.get("title");
            String message = (String)map.get("body");
            String id2 = Integer.parseInt((String)map.get("id")) < 10 ? (String)map.get("id") : null;
            String url = (String)map.get("url");
            String timer = (String)map.get("timer");
            String deepLink = (String)map.get("deep_link");
            LogUtils.i(TAG, "id: " + id2);
            LogUtils.i(TAG, "title: " + title);
            LogUtils.i(TAG, "message: " + message);
            LogUtils.i(TAG, "url: " + url);
            LogUtils.i(TAG, "timer: " + timer);
            LogUtils.i(TAG, "deepLink: " + deepLink);
            if (url != null) {
                Glide.with((Context)context.getApplicationContext()).load(url).downloadOnly(512, 256);
            }
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "gcm");
            intent.putExtra("id", id2);
            intent.putExtra("title", title);
            intent.putExtra("mesage", message);
            if (!TextUtils.isEmpty((CharSequence)deepLink)) {
                intent.putExtra("deep_link", deepLink);
                Preference.save(context, "deep_link", deepLink);
            }
            if (timer != null || timer == "") {
                Log.d((String)TAG, (String)"VAO DAY");
                this.parseTimerData(context, timer, intent);
            }
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
            if (!TextUtils.isEmpty((CharSequence)id2)) {
                NtfModel ntfModel = new NtfModel();
                ntfModel.setId(Integer.parseInt(id2));
                ntfModel.setTitle(title);
                ntfModel.setNoti(Boolean.parseBoolean(message));
                NotificationUtils.addNtf(context, ntfModel);
            }
            if (!TextUtils.isEmpty((CharSequence)title) || !TextUtils.isEmpty((CharSequence)message)) {
                NotificationUtils notificationUtils = NotificationUtils.getInstance(context);
                if (!TextUtils.isEmpty((CharSequence)deepLink)) {
                    notificationUtils.setDeeplink(deepLink);
                }
                notificationUtils.setMainClass(null).setMessage(message).setTitle(title).setSmallIcon(this.getDrawableSmall(context));
                if (url != null) {
                    notificationUtils.setImageUrl(url).showNotificationWithImage();
                } else {
                    notificationUtils.showNotification();
                }
                Vibrator v = (Vibrator)context.getSystemService("vibrator");
                if (v != null) {
                    v.vibrate(30L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseTimerData(Context context, String timer, Intent intent) {
        if (!TextUtils.isEmpty((CharSequence)timer)) {
            try {
                Log.d((String)TAG, (String)("Timer : " + timer));
                JSONArray timerArray = new JSONArray(timer);
                for (int i = 0; i < timerArray.length(); ++i) {
                    JSONObject timerJsonObj = timerArray.getJSONObject(i);
                    long startTime = TimeUtils.getMilisecondByTimestamp(timerJsonObj.optLong("start"));
                    long endTime = TimeUtils.getMilisecondByTimestamp(timerJsonObj.optLong("end"));
                    int id2 = timerJsonObj.getInt("id");
                    long now = Calendar.getInstance().getTimeInMillis();
                    TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData(context);
                    if (timerData == null) {
                        Log.d((String)TAG, (String)"vao null");
                        ArrayList<TimerObject> listTimerObject = new ArrayList<TimerObject>();
                        TimerObject timerObject = new TimerObject();
                        timerObject.setId(id2);
                        timerObject.setStartTime(startTime);
                        timerObject.setEndTime(endTime);
                        listTimerObject.add(timerObject);
                        timerData = new TimerData();
                        timerData.setListTimerObject(listTimerObject);
                        timerData.saveData(context, timerData);
                        if (startTime > now || now >= endTime) continue;
                        FloatButtonTimerHelper.setcanRunTimer(true);
                        FloatButtonTimerHelper.setisRuningTimer(true);
                        continue;
                    }
                    Log.d((String)TAG, (String)"Vao khong null");
                    ArrayList<Object> listTimer = new ArrayList();
                    listTimer = timerData.getListTimerObject();
                    TimerObject timerObj = new TimerObject();
                    timerObj.setId(id2);
                    timerObj.setStartTime(startTime);
                    timerObj.setEndTime(endTime);
                    listTimer.add(timerObj);
                    timerData.setListTimerObject(listTimer);
                    timerData.saveData(context, timerData);
                    if (FloatButtonTimerHelper.isRuningTimer()) {
                        FloatButtonTimerHelper.setcanRunTimer(false);
                        continue;
                    }
                    if (startTime <= now && now < endTime) {
                        FloatButtonTimerHelper.setcanRunTimer(true);
                        FloatButtonTimerHelper.setisRuningTimer(true);
                        continue;
                    }
                    FloatButtonTimerHelper.setcanRunTimer(false);
                }
                intent.putExtra("show-timer", true);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}

