/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.game;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.TextView;
import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.js.JsBase;
import com.game.sdk.comon.listener.IWebViewClientListener;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.comon.utils.WvUtil;
import com.mobgame.R;
import com.mobgame.gui.MobGameWebView2;
import java.util.HashMap;
import java.util.Objects;

public abstract class BaseDialogWebFragment
extends DialogFragment {
    public Activity mActivity;
    public MobGameWebView2 webView;
    TextView btnBack;
    TextView btnClose;
    SwipeRefreshLayout swipeRefreshLayout;
    public static String URL_WEBVIEW = "URL_WEBVIEW";
    private IWebViewClientListener clientListener;

    public void onAttach(Context context) {
        super.onAttach(context);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(1, R.style.DialogTheme);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mActivity = activity;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.dialog_web, container, false);
        this.getDialog().getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.getDialog().getWindow().setDimAmount(0.8f);
        return v;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        int orientation = this.mActivity.getResources().getConfiguration().orientation;
        PrefManager.saveInt((Context)this.mActivity, this.getTag() + "SCREEN_ORIENTATION_CURRENT", orientation);
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
    }

    public void onResume() {
        super.onResume();
    }

    public void onStop() {
        super.onStop();
    }

    public void showProgressDialog(boolean show, String mess) {
        Utils.showLoading(this.mActivity, show);
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
    }

    protected void initView(View v) {
        this.clientListener = this.getWebListener();
        this.btnClose = (TextView)v.findViewById(R.id.btnClose);
        this.btnBack = (TextView)v.findViewById(R.id.btnBack);
        this.webView = (MobGameWebView2)v.findViewById(R.id.webview);
        this.swipeRefreshLayout = (SwipeRefreshLayout)v.findViewById(R.id.swRegister);
        this.initWebView();
        this.btnClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BaseDialogWebFragment.this.dismiss();
            }
        });
        this.btnBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BaseDialogWebFragment.this.webView.canGoBack()) {
                    BaseDialogWebFragment.this.webView.goBack();
                }
            }
        });
        this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                if (BaseDialogWebFragment.this.webView != null) {
                    BaseDialogWebFragment.this.webView.reload();
                }
            }
        });
    }

    public void initWebView() {
        try {
            this.webView.clearCache(true);
            this.webView.setInitialScale((int)DeviceUtils.getDensity((Context)Objects.requireNonNull(this.getActivity())));
            this.webView.setLayerType(1, null);
            WebSettings webSettings = this.webView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webSettings.setDomStorageEnabled(true);
            webSettings.setBuiltInZoomControls(false);
            webSettings.setAllowFileAccess(true);
            webSettings.setDatabaseEnabled(true);
            webSettings.setCacheMode(-1);
            webSettings.setLoadWithOverviewMode(true);
            webSettings.setUseWideViewPort(true);
            webSettings.setLoadsImagesAutomatically(true);
            WebView.setWebContentsDebuggingEnabled((boolean)false);
            this.webView.setWebChromeClient(new WebChromeClient(){

                public void onProgressChanged(WebView view, int progress) {
                }
            });
            this.webView.setWebViewClient(new WebViewClient(){

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    BaseDialogWebFragment.this.showProgressDialog(true, "");
                    if (Utils.isPlfUrl(url)) {
                        BaseDialogWebFragment.this.loadUrlWithLibraryHeaders(url);
                        return true;
                    }
                    if (BaseDialogWebFragment.this.clientListener != null) {
                        BaseDialogWebFragment.this.clientListener.shouldOverrideUrlLoading(view, url);
                    }
                    return super.shouldOverrideUrlLoading(view, url);
                }

                @SuppressLint(value={"JavascriptInterface"})
                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    view.addJavascriptInterface((Object)BaseDialogWebFragment.this, "android");
                    if (BaseDialogWebFragment.this.clientListener != null) {
                        BaseDialogWebFragment.this.clientListener.onPageStarted(view, url, favicon);
                    }
                }

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    BaseDialogWebFragment.this.showProgressDialog(false, "");
                    WvUtil.showErrorPage((Context)BaseDialogWebFragment.this.mActivity, view, failingUrl);
                }

                public void onPageFinished(WebView view, String url) {
                    BaseDialogWebFragment.this.showProgressDialog(false, "");
                    if (BaseDialogWebFragment.this.swipeRefreshLayout != null) {
                        BaseDialogWebFragment.this.swipeRefreshLayout.setRefreshing(false);
                    }
                    if (Utils.isPlfUrl(url)) {
                        BaseDialogWebFragment.this.parseWebView();
                    }
                    if (BaseDialogWebFragment.this.webView.canGoBack()) {
                        BaseDialogWebFragment.this.btnBack.setVisibility(0);
                    } else {
                        BaseDialogWebFragment.this.btnBack.setVisibility(8);
                    }
                    if (BaseDialogWebFragment.this.clientListener != null) {
                        BaseDialogWebFragment.this.clientListener.onPageFinished(view, url);
                    }
                }
            });
            this.webView.addJavascriptInterface(this.getJsHandler(), "JsHandler");
            String url = this.getArguments().getString(URL_WEBVIEW, "");
            if (Utils.isPlfUrl(url)) {
                this.loadUrlWithLibraryHeaders(url);
            }
            this.webView.setTag("RegisterFragment");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadUrlWithLibraryHeaders(String url) {
        try {
            if (Utils.isPlfUrl(url)) {
                Context context = Objects.requireNonNull(this.getActivity()).getApplicationContext();
                Uri uri = Uri.parse((String)url);
                WvUtil.setCookieToURLWebview(this.webView.getContext(), url);
                HashMap<String, String> extraHeaders = new HashMap<String, String>();
                extraHeaders.put("access_token", AuthenConfigs.getInstance().getAccessToken());
                extraHeaders.put("Authorization", AuthenConfigs.getInstance().getAccessToken());
                extraHeaders.put("device_name", Utils.stringNormalize(DeviceUtils.getDevice()));
                extraHeaders.put("device_os", Utils.stringNormalize(DeviceUtils.getOSInfo()));
                extraHeaders.put("device_resolution", Utils.stringNormalize(DeviceUtils.getResolution((Context)this.getActivity())));
                extraHeaders.put("sdk_version", Utils.stringNormalize(Utils.getSDKVersion(context)));
                extraHeaders.put("device_network", Utils.stringNormalize(Utils.getNetwork(context)));
                extraHeaders.put("appsflyer_id", DeviceUtils.getAppsflyerUID(context));
                extraHeaders.put("advertising_id", DeviceUtils.getAdvertisingID(context));
                this.webView.stopLoading();
                this.webView.loadUrl(uri.toString(), extraHeaders);
            } else {
                this.loadUrl(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadUrl(String url) {
        if (this.isAdded()) {
            this.webView.stopLoading();
            this.webView.loadUrl(url);
        }
    }

    private void parseWebView() {
        try {
            if (!this.isAdded()) {
                return;
            }
            String inject = WvUtil.parseWebView((Context)this.mActivity);
            this.webView.loadUrl("javascript:" + inject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void goBack() {
        if (this.webView != null) {
            this.webView.post(new Runnable(){

                @Override
                public void run() {
                    if (BaseDialogWebFragment.this.webView.canGoBack()) {
                        BaseDialogWebFragment.this.webView.goBack();
                    }
                }
            });
        }
    }

    protected abstract JsBase getJsHandler();

    protected abstract IWebViewClientListener getWebListener();
}

