package com.mobgame.gui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.widget.SwipeRefreshLayout;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.appsflyer.AppsFlyerLib;
import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.constants.ConstantApi;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.tracking.AppsFyer;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.comon.utils.WvUtil;
import com.mobgame.R;
import com.mobgame.api.PostTask;
import com.mobgame.component.FirebaseAnalyticsManager;
import com.mobgame.gui.MobGameWebView.OnPropertyChangedListener;
import com.mobgame.gui.view.MobSwipRefreshLayout;
import com.mobgame.js.JsHandler;
import com.mobgame.model.MUrl;
import com.mobgame.utils.Constants;
import com.mobgame.utils.EncryptionUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.ExecutionException;

@SuppressWarnings("deprecation")
@SuppressLint("NewApi")
public class MobGameWebFragment extends Fragment {

    //	private static final String TAG = MobWebFragment.class.getSimpleName();
    private static final String KEY_URL = "url";
    private static final String KEY_POST_PARAMS = "post_params";
    private static final String KEY_WEBVIEW_TAG = "fragment_web";
    private static final String KEY_ID = "id";
    public static final String HIDE_SWIPE = "hideSwipe";
    private final String TAG = MobGameWebFragment.class.getSimpleName();
    private int ntfId = 0;

    private MobGameWebView webView;
    private EventListener eventListener;
    private Bundle args;
    private String js = "";
    private MobSwipRefreshLayout mSwipeRefreshLayout;
    //	private int realHeight = 0;
    private JsHandler jsHandler;
    private Stack<String> historyBackstack;
    private static HashMap<String, MUrl> cachedUrls;
    private String urlToLoad = "";
    private boolean isHideSwipe = false;

    private String urlLoadFail = "";

    {
        args = new Bundle();
        historyBackstack = new Stack<String>();
        cachedUrls = new HashMap<String, MUrl>();
    }

    public MobGameWebFragment() {
    }

    @SuppressLint("ValidFragment")
    public MobGameWebFragment(String url) {
        loadUrlWithMobHeaders(url);
    }


    @SuppressLint("ValidFragment")
    public MobGameWebFragment(String url, int id) {
        loadUrlWithMobHeaders(url);
        ntfId = id;
    }

    @SuppressLint("ValidFragment")
    public MobGameWebFragment(String url, boolean loadUrlLater, int id) {
        if (loadUrlLater) {
            urlToLoad = url;
        } else {
            loadUrlWithMobHeaders(url);
        }
        ntfId = id;
    }

    public static MobGameWebFragment newInstance(String url) {

        Bundle args = new Bundle();
        MobGameWebFragment fragment = new MobGameWebFragment(url);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_web, container, false);
        return view;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            mSwipeRefreshLayout = (MobSwipRefreshLayout) view.findViewById(
                    R.id.activity_main_swipe_refresh_layout);
            mSwipeRefreshLayout.setColorSchemeResources(R.color.green);

            getActivity().getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN);
            webView = (MobGameWebView) view.findViewById(R.id.webview);
            initWebView();
            if (!isHideSwipe) {
                mSwipeRefreshLayout.setEnabled(true);
                mSwipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
                    @Override
                    public void onRefresh() {
                        reload();
                        Log.d(TAG, "onRefresh: ntf id=" + ntfId);
                        Intent intent = new Intent(Constants.INTENT_FILTER);
                        intent.putExtra("category", "swipe_refresh");
                        intent.putExtra("id", String.valueOf(ntfId));
                        LocalBroadcastManager.getInstance(getActivity().getApplicationContext()).sendBroadcast(intent);
                    }
                });
            } else {
                mSwipeRefreshLayout.setEnabled(false);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    private void loadUrl(String url) {
        try {
            if (isAdded()) {
                webView.stopLoading();
                setCookieToURLWebview(webView.getContext(), url);
                webView.loadUrl(url);
            } else {
                args.putString(KEY_URL, url);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadUrlWithMobHeaders(String url) {
        try {
            if (!isAdded()) {
                args.putString(KEY_URL, url);
                return;
            }
            if (Utils.isPlfUrl(url)) {
                Context context = getActivity().getApplicationContext();
                Uri uri = Uri.parse(url);

                setCookieToURLWebview(webView.getContext(), url);
                Map<String, String> extraHeaders = new HashMap<String, String>();
                String token = AuthenConfigs.getInstance().getAccessToken();
                if (token != null && !TextUtils.isEmpty(token))
                    extraHeaders.put(ConstantApi.HEADER_ATHORIZATION, "Bearer " + token);

                webView.stopLoading();
                webView.loadUrl(uri.toString(), extraHeaders);
            } else {
                loadUrl(url);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void postUrl(MUrl url) {
        postUrl(url.getPath());
    }

    private void postUrl(String url) {
        try {
            webView.postUrl(url, null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postUrlWithMobHeaders(String url, HashMap<String, String> postParams)
            throws InterruptedException, ExecutionException, UnsupportedEncodingException {
        postUrlWithMobHeaders(url, postParams, null);
    }

    public void postUrlWithMobHeaders(String url, HashMap<String, String> postParams, PostTask.Callback callback)
            throws InterruptedException, ExecutionException, UnsupportedEncodingException {
        MUrl mUrl = cachedUrls.get(url);
        if (mUrl == null) {
            mUrl = new MUrl(url);
        }
        postUrlWithMobHeaders(mUrl, postParams, callback);
    }

    public void postUrlWithMobHeaders(MUrl url, HashMap<String, String> postParams)
            throws InterruptedException, ExecutionException, UnsupportedEncodingException {
        postUrlWithMobHeaders(url, postParams, null);
    }

    public void postUrlWithMobHeaders(final MUrl url, HashMap<String, String> postParams, final PostTask.Callback callback)
            throws InterruptedException, ExecutionException, UnsupportedEncodingException {

        if (!isAdded()) {
            args.putParcelable(KEY_URL, url);
            args.putSerializable(KEY_POST_PARAMS, postParams);
            return;
        }
        if (Utils.isPlfUrl(url)) {
            Uri uri = url.toUri();
            final String postUrl = uri.toString();
            String postData = "hl=en";
            for (String key : postParams.keySet()) {
                postData += "&" + key + "=" + URLEncoder.encode(postParams.get(key), "UTF-8");
            }
            setCookieToURLWebview(webView.getContext(), postUrl);
            webView.postUrl(postUrl, postData.getBytes());

        } else {
            postUrl(url);
        }
    }

    BroadcastReceiver broadcastReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            Log.i(TAG, "reloadFromIntent");
            String category = intent.getStringExtra("category_from_bug");
            if ("refresh_from_bug".equals(category)) {
                reload();
            }
        }
    };

    public void reload() {
        try {
            if (webView != null) {
                if (webView.getUrl() != null) {
                    Log.d(TAG, "reload: url=" + webView.getUrl());
                    if (webView.getUrl().equalsIgnoreCase("data:text/html;charset=utf-8;base64,")) {
                        loadUrlWithMobHeaders(urlLoadFail);
                    } else {
                        webView.reload();
                    }
                } else {
                    Log.d(TAG, "reload: webview url null, cannot reload!");
                }
            } else {
                Log.d(TAG, "reload: webview null, cannot reload!");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void invokeJavascript(String script) {
        webView.loadUrl("javascript:" + script);
    }

    public void stopLoading() {
        webView.stopLoading();
    }

    public void goBack() {
        try {
            historyBackstack.pop();
            String url = historyBackstack.peek();
            if (url.contains("PaymentWallets/showPaymentWallet")) {
                historyBackstack.pop();
                url = historyBackstack.peek();
            }
            loadUrlWithMobHeaders(url);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean canGoBack() {
        return historyBackstack.size() > 1;
    }

    public String getTitle() {
        if (webView != null) {
            return webView.getTitle();
        }
        return "_";
    }

    public String getUrl() {
        if (webView != null) {
            return webView.getUrl();
        }
        return "_";
    }

    public WebView getWebView() {
        return webView;
    }

    public void setWebViewTag(String tag) {
        try {
            if (isAdded()) {
                webView.setTag(tag);
            }
            args.putString(KEY_WEBVIEW_TAG, tag);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getWebViewTag() {
        try {
            return args.getString(KEY_WEBVIEW_TAG);
        } catch (Exception e) {
            e.printStackTrace();
            return "_";
        }
    }

    public int getScrollX() {
        if (webView != null) {
            return webView.getScrollX();
        } else {
            Log.d(TAG, "webview is null");
            return 0;
        }

    }

    public int getScrollY() {
        if (webView != null) {
            return webView.getScrollY();
        } else {
            Log.d(TAG, "webview is null");
            return 0;
        }

    }

    public int computeVerticalScrollRange() {
        // TODO could throw NullPointerException
        return webView.computeVerticalScrollRange();
    }


    @SuppressWarnings({"unchecked"})
    @SuppressLint({"SetJavaScriptEnabled", "JavascriptInterface", "ClickableViewAccessibility"})
    private void initWebView() {
        try {
            webView.clearCache(true);
            webView.setInitialScale((int) DeviceUtils.getDensity(getActivity()));
            webView.setBackgroundColor(Color.parseColor("#000000"));
            webView.requestFocus(View.FOCUS_DOWN);
            WebSettings webSettings = webView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webSettings.setDomStorageEnabled(true);
            webSettings.setBuiltInZoomControls(false);

            webSettings.setAllowFileAccess(true);
            webSettings.setDatabaseEnabled(true);
            webSettings.setCacheMode(WebSettings.LOAD_DEFAULT);
            //improve webview performance
            webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
            webView.setScrollBarStyle(View.SCROLLBARS_INSIDE_OVERLAY);
            webSettings.setDomStorageEnabled(true);
            webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
            webSettings.setUseWideViewPort(true);
            webSettings.setSaveFormData(true);

            webSettings.setLoadWithOverviewMode(true);
            webSettings.setLoadsImagesAutomatically(true);

            webView.setWebChromeClient(new WebChromeClient() {

                @Override
                public void onProgressChanged(WebView view, int progress) {
                    if (eventListener != null) {
                        eventListener.onProgressChanged(view, progress);
                    }
                }
            });

            webView.setWebViewClient(new WebViewClient() {

                @Override
                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if (Utils.isPlfUrl(url)) {

                        loadUrlWithMobHeaders(url);
                        return true;
                    }
                    return super.shouldOverrideUrlLoading(view, url);
                }

                @Override
                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    addToBackstack(url);
                    Log.d(TAG, "TROI OI : " + url);

                    String resultCompareUrl = Utils.getResultCompareUrl(url);
                    switch (resultCompareUrl) {
                        case "EMAIL_LOGIN":
                            Log.d(TAG, "event name : " + "Login Email");
                            break;
                        case "":
                            break;
                    }

                    if (!isHideSwipe) mSwipeRefreshLayout.setRefreshing(false);
                    if (eventListener != null) {
                        eventListener.onPageStarted(view, url, favicon);
                    }

                }

                @Override
                public void onReceivedError(WebView view, int errorCode,
                                            String description, String failingUrl) {
                    urlLoadFail = failingUrl;
                    WvUtil.showErrorPage(getContext(), view, failingUrl);
                    if (!isHideSwipe) mSwipeRefreshLayout.setRefreshing(false);

                }

                @Override
                public void onPageFinished(WebView view, String url) {

                    HashMap<String, Object> map = new HashMap<>();
                    map.put(Constants.TITLE_WEBVIEW, view.getTitle() + "");
                    FirebaseAnalyticsManager.getInstance().firebaseEventTrack(getActivity(), Constants.TITLE_WEBVIEW, map);
                    if (eventListener != null) {
                        eventListener.onPageFinished(view, url);
                    }

                }

            });

            webView.setOnScrollChangedListener(new OnPropertyChangedListener() {

                @Override
                public void onScroll(int l, int t, int oldl, int oldt) {
                    if (eventListener != null) {
                        eventListener.onScrollChanged(webView, l, t, oldl, oldt);
                    }
                }

                @Override
                public void onSizeChanged(int w, int h, int ow, int oh) {
                    if (eventListener != null) {
                        eventListener.onSizeChanged(webView, w, h, ow, oh);
                    }
                }

            });

            jsHandler = new JsHandler(getActivity(), this);
            webView.addJavascriptInterface(jsHandler, "JsHandler");
            jsHandler.mobAppSDKexecute("mobGetError", ""); // clear list photo in report issue webpage

            String url = args.getString(KEY_URL);
            int id = 0;
            id = args.getInt(KEY_ID);
            HashMap<String, String> postParams = (HashMap<String, String>)
                    args.getSerializable(KEY_POST_PARAMS);
            String webViewTag = args.getString(KEY_WEBVIEW_TAG);
            if (url != null) {
                if (postParams != null) {
                    try {
                        postUrlWithMobHeaders(url, postParams);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    } catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                } else {
                    loadUrlWithMobHeaders(url);
                }
            }
            webView.setTag(webViewTag);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addToBackstack(String url) {
        try {
            if (url.equalsIgnoreCase("about:blank")) return;
            if (historyBackstack.isEmpty()) {
                if (url != null) {
                    historyBackstack.push(url);
                }
            } else {
                Uri lastUri = Uri.parse(historyBackstack.peek());
                Uri uri = Uri.parse(url);
                if (lastUri.getPath() == null) {
                    historyBackstack.pop();
                    addToBackstack(url);
                } else {
                    if (!lastUri.getPath().equalsIgnoreCase(uri.getPath())) {
                        if (url != null) {
                            if (isRedirectUrl(url)) {
                                historyBackstack.pop();
                            }
                            historyBackstack.push(url);
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isRedirectUrl(String url) {
        if (url.contains("isRedirect=true")
                || url.contains("isRedirect=1")) {
            return true;
        } else {
            return false;
        }
    }

    public static void setCookieToURLWebview(Context context, String url) {
        try {
            HashSet<String> cookies = (HashSet<String>) Preference.getStringSet(context, Constants.SHARED_PREF_COOKIES, new HashSet<String>());
            CookieSyncManager cookieSyncManager = CookieSyncManager.createInstance(context);
            CookieManager cookieManager = CookieManager.getInstance();

            cookieManager.setAcceptCookie(true);
            for (String cookie : cookies) {
                cookieManager.setCookie(url, cookie);
            }
            cookieSyncManager.sync();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadUrlToLoadIfHave() {
        try {
            if (!urlToLoad.isEmpty()) {
                loadUrlWithMobHeaders(urlToLoad);
                urlToLoad = "";
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public interface EventListener {
        void onProgressChanged(WebView view, int progress);

        void onPageStarted(WebView view, String url, Bitmap favicon);

        void onPageFinished(WebView view, String url);

        //		public boolean shouldOverrideUrlLoading(WebView view, String url);
        void onScrollChanged(WebView view, int l, int t, int oldl, int oldt);

        void onSizeChanged(WebView view, int w, int h, int oldw, int oldh);
    }

    @Override
    public void onPause() {
        super.onPause();
        try {
            Log.d(TAG, "onPause");
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(broadcastReceiver);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        try {
            Log.d(TAG, "onResume");
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(
                    broadcastReceiver, new IntentFilter(Constants.INTENT_FILTER)
            );
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint("MissingSuperCall")
    @Override
    public void onDetach() {
        super.onDestroy();
        try {
//            keyboardProvider.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}