package com.mobgame.api;

import okhttp3.ResponseBody;

import org.json.JSONException;
import org.json.JSONObject;

import retrofit2.Call;
import retrofit2.Callback;

import android.content.Context;
import android.os.AsyncTask;

import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.object.UserObj;
import com.google.gson.Gson;
import com.mobgame.MobGameSDK;

public class ProcessIABReceiptTask extends AsyncTask<Void, Void, Void> {
	
	private String itemType;
	private String signature;
	private String data;
	
	private Callback<ResponseBody> callback;

	public ProcessIABReceiptTask(String itemType, String signature, String data) {
		this.itemType = itemType;
		this.signature = signature;
		this.data = data;
	}
	
	public ProcessIABReceiptTask(String itemType, String signature, String data, Callback<ResponseBody> callback) {
		this.itemType = itemType;
		this.signature = signature;
		this.data = data;
		this.callback = callback;
	}
	
	public void setCallback(Callback<ResponseBody> callback) {
		this.callback = callback;
	}

	@Override
	protected Void doInBackground(Void... params) {
		try {
			Context c = MobGameSDK.getApplicationContext();
			Gson gson = new Gson();
			UserObj user = GameConfigs.getInstance().getUser();
			JSONObject jsonPurchase = new JSONObject();
			jsonPurchase.put("data", this.data);
			jsonPurchase.put("itemType", this.itemType);
			jsonPurchase.put("signature", this.signature);
			jsonPurchase.put("user", gson.toJson(user));
			RestfulApi.removeInstance();
			RestfulApi api = RestfulApi.getInstance();
			Call<ResponseBody> call = api.processGooglePayment(jsonPurchase.toString());
			call.enqueue(callback);
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return null;
	}
}