package com.game.sdk.ui.comon;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.AppOpsManager;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.Gravity;
import android.view.Window;

import com.game.sdk.comon.tracking.TrackingUtil;
import com.mobgame.R;
import com.mobgame.model.MPermission;
import com.mobgame.utils.Res;

import java.util.ArrayList;
import java.util.Objects;

import static com.mobgame.MobGameSDK.getApplicationContext;

public class PermissionFragment extends DialogFragment {
    private boolean canDraw;
    public static Activity activity;
    public static String PACKAGE_NAME;
    private AppOpsManager.OnOpChangedListener onOpChangedListener = null;
    private Dialog dialog;

    public final static String PERMISSIONS = "permissions";


    private static final int REQUEST_CODE_PERMISSIONS = 20001;

    public static PermissionFragment newInstance(String[] permissions) {
        PermissionFragment fr = new PermissionFragment();

        Bundle args = new Bundle();
        args.putStringArray(PERMISSIONS, permissions);
        fr.setArguments(args);

        return fr;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        dialog = super.onCreateDialog(savedInstanceState);
        PACKAGE_NAME = getApplicationContext().getPackageName();
        // request a window without the title
        dialog.getWindow().requestFeature(Window.FEATURE_NO_TITLE);
        dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));

        return dialog;
    }

    @TargetApi(23)
    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Log.d("chieuhv", "vào day");
        Bundle args = getArguments();
        if (args != null) {
            Log.d("chieuhv", "vào args ! null");
            String[] permisisons = args.getStringArray(PERMISSIONS);
            TrackingUtil.getInstance().trackStartPermisison();
            requestPermissions(
                    permisisons,
                    REQUEST_CODE_PERMISSIONS);
            Log.d("chieuhv", "request" + REQUEST_CODE_PERMISSIONS);
        } else {
            dismiss();

        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == REQUEST_CODE_PERMISSIONS) {
            TrackingUtil.getInstance().trackEndPermisison();
            try {
                Log.d("chieuhv", "fail");
                // If request is cancelled, the result arrays are empty.
                ArrayList<MPermission> result = new ArrayList<MPermission>();
                boolean grantDeny = false;
                for (int i = 0; i < grantResults.length; i++) {
                    String permission = permissions[i];
                    int granted = grantResults[i];
                    MPermission m = new MPermission(permission, granted);
                    result.add(m);
                    if (granted == -1) {
                        grantDeny = true;
                    }
                }
                if (!grantDeny) {
                    dialog.dismiss();
                    return;
                }


                AlertDialog.Builder alert = new AlertDialog.Builder(getActivity());
                alert.setMessage(getString(R.string.text_dashboard_sheet));
                alert.setCancelable(true);
                alert.setNegativeButton("SETTING",
                        new DialogInterface.OnClickListener() {
                            @RequiresApi(api = Build.VERSION_CODES.M)
                            @Override
                            public void onClick(DialogInterface dialog,
                                                int which) {
                                startActivity(new Intent(android.provider.Settings.ACTION_APPLICATION_DETAILS_SETTINGS, Uri.parse("package:" + getApplicationContext().getPackageName())));
                                Log.d("chieuhv", "package: " + getApplicationContext().getPackageName());

                            }

                        });

                AlertDialog dialog_card = alert.create();
                Objects.requireNonNull(dialog_card.getWindow()).setGravity(Gravity.BOTTOM);
                dialog_card.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialogMore) {
                        dialog.dismiss();
                    }
                });
                dialog_card.show();


            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {

            Log.d("qwewqewqqweq", "success: ");
        }

    }


}