package com.game.sdk.comon.game;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.TextView;

import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.constants.ConstantApi;
import com.game.sdk.comon.constants.Constants;
import com.game.sdk.comon.js.JsBase;
import com.game.sdk.comon.listener.IWebViewClientListener;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.comon.utils.WvUtil;
import com.mobgame.BuildConfig;
import com.mobgame.R;
import com.mobgame.gui.MobGameWebView2;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import static com.game.sdk.comon.utils.WvUtil.setCookieToURLWebview;

public abstract class BaseDialogWebFragment extends DialogFragment {

    public Activity mActivity;

    public MobGameWebView2 webView;
    TextView btnBack, btnClose;
    SwipeRefreshLayout swipeRefreshLayout;
    public static String URL_WEBVIEW = "URL_WEBVIEW";
    private IWebViewClientListener clientListener;

    /**
     * Layout of activity
     *
     * @return id of resource layout
     */

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setStyle(DialogFragment.STYLE_NO_TITLE, R.style.DialogTheme);
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        mActivity = activity;
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.dialog_web, container, false);
        //Setting dialog background and animation
        getDialog().getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        getDialog().getWindow().setDimAmount(0.8f);
        return v;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        int orientation = mActivity.getResources().getConfiguration().orientation;
        PrefManager.saveInt(mActivity, getTag() + Constants.SCREEN_ORIENTATION_CURRENT, orientation);
        super.onViewCreated(view, savedInstanceState);
        initView(view);
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    @Override
    public void onStop() {
        super.onStop();
    }

    public void showProgressDialog(boolean show, String mess) {
       Utils.showLoading(mActivity,show);
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
    }

    protected void initView(View v) {
        clientListener = getWebListener();
        btnClose = (TextView) v.findViewById(R.id.btnClose);
        btnBack = (TextView) v.findViewById(R.id.btnBack);
        webView = (MobGameWebView2) v.findViewById(R.id.webview);
        swipeRefreshLayout = (SwipeRefreshLayout) v.findViewById(R.id.swRegister);
        initWebView();
        btnClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });
        btnBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (webView.canGoBack())
                    webView.goBack();
            }
        });

        swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                if (webView != null)
                    webView.reload();
            }
        });

    }

    public void initWebView() {
        try {
            webView.clearCache(true);
            webView.setInitialScale((int) DeviceUtils.getDensity(Objects.requireNonNull(getActivity())));
            webView.setLayerType(View.LAYER_TYPE_SOFTWARE, null);

            WebSettings webSettings = webView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webSettings.setDomStorageEnabled(true);
            webSettings.setBuiltInZoomControls(false);
            webSettings.setAllowFileAccess(true);
            webSettings.setDatabaseEnabled(true);
            webSettings.setCacheMode(WebSettings.LOAD_DEFAULT);
            webSettings.setLoadWithOverviewMode(true);
            webSettings.setUseWideViewPort(true);
            webSettings.setLoadsImagesAutomatically(true);
            WebView.setWebContentsDebuggingEnabled(BuildConfig.DEBUG);

            webView.setWebChromeClient(new WebChromeClient() {

                @Override
                public void onProgressChanged(WebView view, int progress) {
//                    progressbarPredict.setVisibility(View.VISIBLE);
//                    progressbarPredict.setProgress(progress);
                }
            });

            webView.setWebViewClient(new WebViewClient() {

                @Override
                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    showProgressDialog(true, "");
                    if (Utils.isPlfUrl(url)) {
                        loadUrlWithLibraryHeaders(url);
                        return true;
                    }
                    if (clientListener != null)
                        clientListener.shouldOverrideUrlLoading(view, url);
                    return super.shouldOverrideUrlLoading(view, url);
                }

                @SuppressLint("JavascriptInterface")
                @Override
                public void onPageStarted(WebView view, String url, Bitmap favicon) {
//                    showProgressDialog(true,"");
                    view.addJavascriptInterface(BaseDialogWebFragment.this, "android");
                    if (clientListener != null)
                        clientListener.onPageStarted(view, url, favicon);
                }

                @Override
                public void onReceivedError(WebView view, int errorCode,
                                            String description, String failingUrl) {
                    showProgressDialog(false, "");
                    WvUtil.showErrorPage(mActivity, view, failingUrl);
                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    showProgressDialog(false, "");
                    if (swipeRefreshLayout != null)
                        swipeRefreshLayout.setRefreshing(false);
                    if (Utils.isPlfUrl(url)) {
                        parseWebView();
                    }
//                    GoogleAnalyticsManager.getInstance().trackScreen(view.getTitle());
                    if (webView.canGoBack())
                        btnBack.setVisibility(View.VISIBLE);
                    else
                        btnBack.setVisibility(View.GONE);

                    if (clientListener != null)
                        clientListener.onPageFinished(view, url);
                }


            });

            webView.addJavascriptInterface(getJsHandler(), "JsHandler");
            String url = getArguments().getString(URL_WEBVIEW, "");
            if (Utils.isPlfUrl(url)) {
                loadUrlWithLibraryHeaders(url);
            }
            webView.setTag("RegisterFragment");
        } catch (
                Exception e) {
            e.printStackTrace();
        }

    }


    public void loadUrlWithLibraryHeaders(String url) {
        try {
            if (Utils.isPlfUrl(url)) {
                Context context = Objects.requireNonNull(getActivity()).getApplicationContext();
                Uri uri = Uri.parse(url);
                setCookieToURLWebview(webView.getContext(), url);
                Map<String, String> extraHeaders = new HashMap<String, String>();
                extraHeaders.put("access_token", AuthenConfigs.getInstance().getAccessToken());
                extraHeaders.put(ConstantApi.HEADER_ATHORIZATION, AuthenConfigs.getInstance().getAccessToken());
                extraHeaders.put("device_name", Utils.stringNormalize(DeviceUtils.getDevice()));
                extraHeaders.put("device_os", Utils.stringNormalize(DeviceUtils.getOSInfo()));
                extraHeaders.put("device_resolution", Utils.stringNormalize(DeviceUtils.getResolution(getActivity())));
                extraHeaders.put("sdk_version", Utils.stringNormalize(Utils.getSDKVersion(context)));
                extraHeaders.put("device_network", Utils.stringNormalize(Utils.getNetwork(context)));
                extraHeaders.put("appsflyer_id", DeviceUtils.getAppsflyerUID(context));
                extraHeaders.put("advertising_id", DeviceUtils.getAdvertisingID(context));
                webView.stopLoading();
                webView.loadUrl(uri.toString(), extraHeaders);
            } else {
                loadUrl(url);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadUrl(String url) {
        if (isAdded()) {
            webView.stopLoading();
            webView.loadUrl(url);
        }
    }

    private void parseWebView() {
        try {
            if (!isAdded()) return;
            String inject = WvUtil.parseWebView(mActivity);
            webView.loadUrl("javascript:" + inject);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void goBack() {
        if (webView != null)
            webView.post(new Runnable() {
                @Override
                public void run() {
                    if (webView.canGoBack())
                        webView.goBack();
                }
            });
    }

    protected abstract JsBase getJsHandler();

    protected abstract IWebViewClientListener getWebListener();
}
