package com.mobgame.model;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by HATIBOY on 9/14/2017.
 */

public class MobPopup implements Parcelable {

    private String link;
    private boolean is_show;

    public MobPopup(String link, boolean is_show){
        this.link = link;
        this.is_show = is_show;
    }


    private MobPopup(Parcel in) {
        link = in.readString();
        is_show = in.readByte() != 0;
    }
    public MobPopup(){

    }

    public static final Creator<MobPopup> CREATOR = new Creator<MobPopup>() {
        @Override
        public MobPopup createFromParcel(Parcel in) {
            return new MobPopup(in);
        }

        @Override
        public MobPopup[] newArray(int size) {
            return new MobPopup[size];
        }
    };

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public boolean is_show() {
        return is_show;
    }

    public void setIs_show(boolean is_show) {
        this.is_show = is_show;
    }




    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(link);
        dest.writeByte((byte) (is_show ? 1 : 0));
    }
}
