package com.mobgame.api;

import android.app.Activity;
import android.os.AsyncTask;
import android.util.Log;

import com.mobgame.model.ForceLogoutResponse;

import org.jetbrains.annotations.NotNull;

import java.util.Objects;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class GetCheckForceLogoutTask extends AsyncTask<Void, Void, Void> {
    private static final String TAG = GetCheckForceLogoutTask.class.getSimpleName();
    private Listener callback;
    private Activity mActivity;

    public GetCheckForceLogoutTask(Activity activity, Listener callback) {
        this.mActivity = activity;
        this.callback = callback;
    }

    @Override
    protected Void doInBackground(Void... params) {
        RestfulApi.removeInstance();
        RestfulApi api = RestfulApi.getInstance();
        Call<ForceLogoutResponse> call = api.getCheckForceLogout();
        call.enqueue(new Callback<ForceLogoutResponse>() {
            @Override
            public void onResponse(@NotNull Call<ForceLogoutResponse> call, @NotNull Response<ForceLogoutResponse> response) {
                try {
                    Log.i("TAG", "responseGetCheckForceLogoutTask :" + Objects.requireNonNull(response.body()).toString());
                    if (response.isSuccessful()) {

                        boolean isAuth = response.body().getData().isIsAuth();

                        Log.i(TAG , "isAuth : " + isAuth);

                        if (callback != null) {
                            callback.onSuccess(isAuth);
                        }
                    } else {
                        if (callback != null) {
                            callback.onFailure(new Exception());
                        }
                    }
                } catch (Exception e) {
                    if (callback != null) {
                        callback.onFailure(e);
                    }
                }
            }

            @Override
            public void onFailure(@NotNull Call<ForceLogoutResponse> call, @NotNull Throwable t) {
                if (callback != null) {
                    callback.onFailure(t);
                }
            }
        });

        return null;
    }

    public interface Listener {
        public void onSuccess(Boolean isAuth);

        public void onFailure(Throwable t);
    }
}