package com.mobgame.component;

import android.content.Context;

import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

import java.util.ArrayList;

public final class GoogleAnalyticsManager {

	// private final static String TAG = FacebookManager.class.getSimpleName();
	private static GoogleAnalyticsManager INSTANCE;

	private GoogleAnalytics analytics;
	private ArrayList<Tracker> trackers;

	{
		trackers = new ArrayList<Tracker>();
	}

	public static GoogleAnalyticsManager getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new GoogleAnalyticsManager();
		}
		return INSTANCE;
	}

	private GoogleAnalyticsManager() {
	}

	void init(Context applicationContext) {
		try{
			analytics = GoogleAnalytics.getInstance(applicationContext);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public void addTracker(String gaId) {
		try {
			Tracker t = analytics.newTracker(gaId);
			t.send(new HitBuilders.EventBuilder().setCategory("UX")
					.setAction("appstart").setNewSession().build());
			trackers.add(t);
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	public void removeTrackers() {
		trackers = new ArrayList<Tracker>();
	}

	public void trackEvent(String category, String action, String label, long value) {
		try{
			if (trackers != null) {
				for (Tracker t : trackers) {
					t.send(new HitBuilders.EventBuilder()
							.setCategory(category)
							.setAction(action)
							.setLabel(label)
							.setValue(value)
							.build());
				}
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	public void trackScreen(String screenName) {
		try{
			if (trackers != null) {
				for (Tracker t : trackers) {
					t.setScreenName(screenName);
					t.send(new HitBuilders.ScreenViewBuilder().build());
				}
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

}
