/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.ftgt.root;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.google.android.ftgt.root.Const;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Root {
    private Context mContext;

    public Root(Context mContext) {
        this.mContext = mContext;
    }

    public boolean isDeviceRooted() {
        return this.checkSuExists() || this.detectRootManagementApps() || this.checkForBinary("su") || this.detectTestKeys() || this.checkForMagiskBinary() || this.detectRootCloakingApps();
    }

    private boolean detectTestKeys() {
        String buildTags = Build.TAGS;
        return buildTags != null && buildTags.contains("test-keys");
    }

    private boolean detectRootManagementApps() {
        return this.detectRootManagementApps(null);
    }

    private boolean detectRootManagementApps(String[] additionalRootManagementApps) {
        ArrayList<String> packages = new ArrayList<String>(Arrays.asList(Const.knownRootAppsPackages));
        if (additionalRootManagementApps != null && additionalRootManagementApps.length > 0) {
            packages.addAll(Arrays.asList(additionalRootManagementApps));
        }
        return this.isAnyPackageFromListInstalled(packages);
    }

    private boolean detectRootCloakingApps() {
        return this.detectRootCloakingApps(null);
    }

    private boolean detectRootCloakingApps(String[] additionalRootCloakingApps) {
        ArrayList<String> packages = new ArrayList<String>(Arrays.asList(Const.knownRootCloakingPackages));
        if (additionalRootCloakingApps != null && additionalRootCloakingApps.length > 0) {
            packages.addAll(Arrays.asList(additionalRootCloakingApps));
        }
        return this.isAnyPackageFromListInstalled(packages);
    }

    private boolean checkForMagiskBinary() {
        return this.checkForBinary("magisk");
    }

    private boolean checkForBinary(String filename) {
        String[] pathsArray = Const.getPaths();
        boolean result = false;
        for (String path : pathsArray) {
            File f = new File(path, filename);
            boolean fileExists = f.exists();
            if (!fileExists) continue;
            result = true;
        }
        return result;
    }

    private boolean isAnyPackageFromListInstalled(List<String> packages) {
        boolean result = false;
        PackageManager pm = this.mContext.getPackageManager();
        for (String packageName : packages) {
            try {
                pm.getPackageInfo(packageName, 0);
                result = true;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSuExists() {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(new String[]{"which", "su"});
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            boolean bl = in.readLine() != null;
            return bl;
        }
        catch (Throwable t) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }
}

