/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.ftgt.crypto;

import android.util.Base64;
import com.google.android.ftgt.crypto.Blake2b;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.MessageDigest;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    private final byte[] FLAG = new byte[]{52, 54, 55, 53, 52, 101, 55, 52, 51, 52, 55, 48, 53, 51, 53, 50};
    private final byte[] KEY = new byte[]{53, 116, 79, 67, 72, 105, 54, 118, 78, 53, 52, 86, 81, 72, 82, 111, 57, 110, 48, 79, 101, 119, 80, 88, 66, 90, 76, 109, 73, 118, 114, 76};

    public byte[] getEntry(JarFile jarFile, ZipEntry ze) {
        try {
            InputStream inputStream = jarFile.getInputStream(ze);
            byte[] result = this.getBytes(inputStream);
            if (inputStream != null) {
                inputStream.close();
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String pixelToHex(int r, int g, int b) {
        String blueValue;
        String greenValue;
        String redValue = Integer.toString(r, 16);
        if (redValue.length() == 1) {
            redValue = "0" + redValue;
        }
        if ((greenValue = Integer.toString(g, 16)).length() == 1) {
            greenValue = "0" + greenValue;
        }
        if ((blueValue = Integer.toString(b, 16)).length() == 1) {
            blueValue = "0" + blueValue;
        }
        return redValue + greenValue + blueValue;
    }

    private byte[] getBytes(InputStream is) {
        try {
            int buf;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((buf = is.read(buffer)) != -1) {
                os.write(buffer, 0, buf);
            }
            os.flush();
            return os.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String b64Dec(String text) {
        try {
            byte[] data = Base64.decode((String)text, (int)2);
            return new String(data, Charset.forName("UTF-8"));
        }
        catch (Exception e) {
            return "exception:" + e.getMessage();
        }
    }

    public String b64Enc(String text) {
        try {
            byte[] data = text.getBytes(Charset.forName("UTF-8"));
            return Base64.encodeToString((byte[])data, (int)2);
        }
        catch (Exception e) {
            return "exception:" + e.getMessage();
        }
    }

    public String aesDecrypt(String cipherText) {
        try {
            if (!cipherText.isEmpty()) {
                Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
                SecretKeySpec keySpec = new SecretKeySpec(this.KEY, "AES");
                IvParameterSpec ivSpec = new IvParameterSpec(this.FLAG);
                cipher.init(2, (Key)keySpec, ivSpec);
                byte[] decryptedText = cipher.doFinal(Base64.decode((String)cipherText, (int)2));
                return new String(decryptedText);
            }
            return "";
        }
        catch (Exception e) {
            return "exception:" + e.getMessage();
        }
    }

    public String aesEncrypt(String plaintext) {
        try {
            if (!plaintext.isEmpty()) {
                Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
                SecretKeySpec keySpec = new SecretKeySpec(this.KEY, "AES");
                IvParameterSpec ivSpec = new IvParameterSpec(this.FLAG);
                cipher.init(1, (Key)keySpec, ivSpec);
                byte[] cipherText = cipher.doFinal(plaintext.getBytes());
                return Base64.encodeToString((byte[])cipherText, (int)2);
            }
            return "";
        }
        catch (Exception e) {
            return "exception:" + e.getMessage();
        }
    }

    public String checkSumB2(byte[] data, byte[] timeStamp, int digestLen, byte[] personal) {
        try {
            byte[] salt = this.genVal(timeStamp).getBytes();
            String person = this.genVal(personal);
            person = this.sXor(person, new String(this.FLAG));
            Blake2b.Param param = new Blake2b.Param().setDigestLength(digestLen).setSalt(salt).setPersonal(person.getBytes());
            Blake2b.Digest digest = Blake2b.Digest.newInstance(param);
            digest.reset();
            digest.update(data, 0, data.length);
            byte[] result = digest.digest();
            return String.format("%0" + result.length * 2 + "x", new BigInteger(1, result));
        }
        catch (Exception e) {
            return "exception:" + e.getMessage();
        }
    }

    public String mDigest(String text) {
        try {
            Blake2b.Param param = new Blake2b.Param().setDigestLength(32).setSalt(this.FLAG);
            Blake2b.Digest digest = Blake2b.Digest.newInstance(param);
            digest.reset();
            byte[] data = text.getBytes();
            if (data != null) {
                digest.update(data, 0, data.length);
                byte[] result = digest.digest();
                return String.format("%0" + result.length * 2 + "x", new BigInteger(1, result));
            }
            return "";
        }
        catch (Exception e) {
            return "exception:" + e.getMessage();
        }
    }

    public String bDigest(byte[] data) {
        try {
            Blake2b.Param param = new Blake2b.Param().setDigestLength(32).setSalt(this.FLAG);
            Blake2b.Digest digest = Blake2b.Digest.newInstance(param);
            digest.reset();
            if (data != null) {
                digest.update(data, 0, data.length);
                byte[] result = digest.digest();
                return String.format("%0" + result.length * 2 + "x", new BigInteger(1, result));
            }
            return "";
        }
        catch (Exception e) {
            return "exception:" + e.getMessage();
        }
    }

    public String zDigest(JarFile jarFile, ZipEntry ze) {
        try {
            InputStream inputStream = jarFile.getInputStream(ze);
            String result = this.bDigest(this.getBytes(inputStream));
            if (inputStream != null) {
                inputStream.close();
            }
            return result;
        }
        catch (Exception e) {
            return "exception:" + e.getMessage();
        }
    }

    public String fDigest(File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            String result = this.bDigest(this.getBytes(inputStream));
            if (inputStream != null) {
                inputStream.close();
            }
            return result;
        }
        catch (Exception e) {
            return "exception:" + e.getMessage();
        }
    }

    private String sXor(String s1, String s2) {
        int len = s1.length();
        String result = "";
        for (int i = 0; i < len; i += 2) {
            int i2;
            int i1 = Integer.parseInt(String.valueOf(s1.charAt(i)) + s1.charAt(i + 1), 16);
            String h = Integer.toHexString(i1 ^ (i2 = Integer.parseInt(String.valueOf(s2.charAt(i)) + s2.charAt(i + 1), 16)));
            if (h.length() <= 1) {
                h = '0' + h;
            }
            result = result + h;
        }
        return result;
    }

    private String genVal(byte[] data) {
        Blake2b.Param param = new Blake2b.Param().setDigestLength(8);
        Blake2b.Digest digest = Blake2b.Digest.newInstance(param);
        digest.reset();
        digest.update(data, 0, data.length);
        byte[] result = digest.digest();
        return String.format("%0" + result.length * 2 + "x", new BigInteger(1, result));
    }

    public String mSha1(String data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            byte[] b = digest.digest(data.getBytes());
            return String.format("%0" + b.length * 2 + "x", new BigInteger(1, b));
        }
        catch (Exception e) {
            return "exception:" + e.getMessage();
        }
    }

    public String zSha1(JarFile jarFile, ZipEntry ze) {
        try {
            InputStream inputStream = jarFile.getInputStream(ze);
            String result = this.bSha1(this.getBytes(inputStream));
            if (inputStream != null) {
                inputStream.close();
            }
            return result;
        }
        catch (Exception e) {
            return "exception:" + e.getMessage();
        }
    }

    public String fSha1(File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            String result = this.bSha1(this.getBytes(inputStream));
            if (inputStream != null) {
                inputStream.close();
            }
            return result;
        }
        catch (Exception e) {
            return "exception:" + e.getMessage();
        }
    }

    private String bSha1(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            if (data != null) {
                byte[] result = digest.digest(data);
                return Base64.encodeToString((byte[])result, (int)2);
            }
            return "";
        }
        catch (Exception e) {
            return "exception:" + e.getMessage();
        }
    }
}

