/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.ftgt.crypto;

import java.io.Serializable;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public interface Blake2b {
    public void update(byte[] var1);

    public void update(byte var1);

    public void update(byte[] var1, int var2, int var3);

    public byte[] digest();

    public byte[] digest(byte[] var1);

    public void digest(byte[] var1, int var2, int var3);

    public void reset();

    public ResumeHandle state();

    public static class Param
    implements AlgorithmParameterSpec {
        static final byte[] default_bytes = new byte[64];
        static final long[] default_h;
        private boolean hasKey = false;
        private byte[] key_bytes = null;
        private byte[] bytes = null;
        private final long[] h = new long[8];

        public Param() {
            System.arraycopy(default_h, 0, this.h, 0, 8);
        }

        public long[] initialized_H() {
            return this.h;
        }

        public byte[] getBytes() {
            this.lazyInitBytes();
            byte[] copy = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, copy, 0, this.bytes.length);
            return copy;
        }

        final byte getByteParam(int xoffset) {
            byte[] _bytes = this.bytes;
            if (_bytes == null) {
                _bytes = default_bytes;
            }
            return _bytes[xoffset];
        }

        final int getIntParam(int xoffset) {
            byte[] _bytes = this.bytes;
            if (_bytes == null) {
                _bytes = default_bytes;
            }
            return Engine.LittleEndian.readInt(_bytes, xoffset);
        }

        final long getLongParam(int xoffset) {
            byte[] _bytes = this.bytes;
            if (_bytes == null) {
                _bytes = default_bytes;
            }
            return Engine.LittleEndian.readLong(_bytes, xoffset);
        }

        public final int getDigestLength() {
            return this.getByteParam(0);
        }

        public final int getKeyLength() {
            return this.getByteParam(1);
        }

        public final int getFanout() {
            return this.getByteParam(2);
        }

        public final int getDepth() {
            return this.getByteParam(3);
        }

        public final int getLeafLength() {
            return this.getIntParam(4);
        }

        public final long getNodeOffset() {
            return this.getLongParam(8);
        }

        public final int getNodeDepth() {
            return this.getByteParam(16);
        }

        public final int getInnerLength() {
            return this.getByteParam(17);
        }

        public final boolean hasKey() {
            return this.hasKey;
        }

        public Param clone() {
            Param clone = new Param();
            System.arraycopy(this.h, 0, clone.h, 0, this.h.length);
            clone.lazyInitBytes();
            System.arraycopy(this.bytes, 0, clone.bytes, 0, this.bytes.length);
            if (this.hasKey) {
                clone.hasKey = this.hasKey;
                clone.key_bytes = new byte[128];
                System.arraycopy(this.key_bytes, 0, clone.key_bytes, 0, this.key_bytes.length);
            }
            return clone;
        }

        final void lazyInitBytes() {
            if (this.bytes == null) {
                this.bytes = new byte[64];
                System.arraycopy(default_bytes, 0, this.bytes, 0, 64);
            }
        }

        public final Param setDigestLength(int len) {
            assert (len > 0) : Engine.Assert.assertFail("len", len, "'%s' %d is <= %d", 0);
            assert (len <= 64) : Engine.Assert.assertFail("len", len, "'%s' %d is > %d", 64);
            this.lazyInitBytes();
            this.bytes[0] = (byte)len;
            this.h[0] = Engine.LittleEndian.readLong(this.bytes, 0);
            this.h[0] = this.h[0] ^ Spec.IV[0];
            return this;
        }

        public final Param setKey(Key key) {
            assert (key != null) : "key is null";
            byte[] keybytes = key.getEncoded();
            assert (keybytes != null) : "key.encoded() is null";
            return this.setKey(keybytes);
        }

        public final Param setKey(byte[] key) {
            assert (key != null) : "key is null";
            assert (key.length >= 0) : Engine.Assert.assertFail("key.length", key.length, "'%s' %d is > %d", 0);
            assert (key.length <= 64) : Engine.Assert.assertFail("key.length", key.length, "'%s' %d is > %d", 64);
            this.key_bytes = new byte[128];
            System.arraycopy(key, 0, this.key_bytes, 0, key.length);
            this.lazyInitBytes();
            this.bytes[1] = (byte)key.length;
            this.h[0] = Engine.LittleEndian.readLong(this.bytes, 0);
            this.h[0] = this.h[0] ^ Spec.IV[0];
            this.hasKey = true;
            return this;
        }

        public final Param setFanout(int fanout) {
            assert (fanout > 0) : Engine.Assert.assertFail("fanout", fanout, "'%s' %d is <= %d", 0);
            this.lazyInitBytes();
            this.bytes[2] = (byte)fanout;
            this.h[0] = Engine.LittleEndian.readLong(this.bytes, 0);
            this.h[0] = this.h[0] ^ Spec.IV[0];
            return this;
        }

        public final Param setDepth(int depth) {
            assert (depth > 0) : Engine.Assert.assertFail("depth", depth, "'%s' %d is <= %d", 0);
            this.lazyInitBytes();
            this.bytes[3] = (byte)depth;
            this.h[0] = Engine.LittleEndian.readLong(this.bytes, 0);
            this.h[0] = this.h[0] ^ Spec.IV[0];
            return this;
        }

        public final Param setLeafLength(int leaf_length) {
            assert (leaf_length >= 0) : Engine.Assert.assertFail("leaf_length", leaf_length, "'%s' %d is < %d", 0);
            this.lazyInitBytes();
            Engine.LittleEndian.writeInt(leaf_length, this.bytes, 4);
            this.h[0] = Engine.LittleEndian.readLong(this.bytes, 0);
            this.h[0] = this.h[0] ^ Spec.IV[0];
            return this;
        }

        public final Param setNodeOffset(long node_offset) {
            assert (node_offset >= 0L) : Engine.Assert.assertFail("node_offset", node_offset, "'%s' %d is < %d", 0);
            this.lazyInitBytes();
            Engine.LittleEndian.writeLong(node_offset, this.bytes, 8);
            this.h[1] = Engine.LittleEndian.readLong(this.bytes, 8);
            this.h[1] = this.h[1] ^ Spec.IV[1];
            return this;
        }

        public final Param setNodeDepth(int node_depth) {
            assert (node_depth >= 0) : Engine.Assert.assertFail("node_depth", node_depth, "'%s' %d is < %d", 0);
            this.lazyInitBytes();
            this.bytes[16] = (byte)node_depth;
            this.h[2] = Engine.LittleEndian.readLong(this.bytes, 16);
            this.h[2] = this.h[2] ^ Spec.IV[2];
            this.h[3] = Engine.LittleEndian.readLong(this.bytes, 24);
            this.h[3] = this.h[3] ^ Spec.IV[3];
            return this;
        }

        public final Param setInnerLength(int inner_length) {
            assert (inner_length >= 0) : Engine.Assert.assertFail("inner_length", inner_length, "'%s' %d is < %d", 0);
            this.lazyInitBytes();
            this.bytes[17] = (byte)inner_length;
            this.h[2] = Engine.LittleEndian.readLong(this.bytes, 16);
            this.h[2] = this.h[2] ^ Spec.IV[2];
            this.h[3] = Engine.LittleEndian.readLong(this.bytes, 24);
            this.h[3] = this.h[3] ^ Spec.IV[3];
            return this;
        }

        public final Param setSalt(byte[] salt) {
            assert (salt != null) : "salt is null";
            assert (salt.length <= 16) : Engine.Assert.assertFail("salt.length", salt.length, "'%s' %d is > %d", 16);
            this.lazyInitBytes();
            Arrays.fill(this.bytes, 32, 48, (byte)0);
            System.arraycopy(salt, 0, this.bytes, 32, salt.length);
            this.h[4] = Engine.LittleEndian.readLong(this.bytes, 32);
            this.h[4] = this.h[4] ^ Spec.IV[4];
            this.h[5] = Engine.LittleEndian.readLong(this.bytes, 40);
            this.h[5] = this.h[5] ^ Spec.IV[5];
            return this;
        }

        public final Param setPersonal(byte[] personal) {
            assert (personal != null) : "personal is null";
            assert (personal.length <= 16) : Engine.Assert.assertFail("personal.length", personal.length, "'%s' %d is > %d", 16);
            this.lazyInitBytes();
            Arrays.fill(this.bytes, 48, 64, (byte)0);
            System.arraycopy(personal, 0, this.bytes, 48, personal.length);
            this.h[6] = Engine.LittleEndian.readLong(this.bytes, 48);
            this.h[6] = this.h[6] ^ Spec.IV[6];
            this.h[7] = Engine.LittleEndian.readLong(this.bytes, 56);
            this.h[7] = this.h[7] ^ Spec.IV[7];
            return this;
        }

        static {
            Param.default_bytes[0] = 64;
            Param.default_bytes[1] = 0;
            Param.default_bytes[2] = 1;
            Param.default_bytes[3] = 1;
            Param.default_bytes[16] = 0;
            Param.default_bytes[17] = 0;
            default_h = new long[8];
            Param.default_h[0] = Engine.LittleEndian.readLong(default_bytes, 0);
            Param.default_h[1] = Engine.LittleEndian.readLong(default_bytes, 8);
            Param.default_h[2] = Engine.LittleEndian.readLong(default_bytes, 16);
            Param.default_h[3] = Engine.LittleEndian.readLong(default_bytes, 24);
            Param.default_h[4] = Engine.LittleEndian.readLong(default_bytes, 32);
            Param.default_h[5] = Engine.LittleEndian.readLong(default_bytes, 40);
            Param.default_h[6] = Engine.LittleEndian.readLong(default_bytes, 48);
            Param.default_h[7] = Engine.LittleEndian.readLong(default_bytes, 56);
            default_h[0] = default_h[0] ^ Spec.IV[0];
            default_h[1] = default_h[1] ^ Spec.IV[1];
            default_h[2] = default_h[2] ^ Spec.IV[2];
            default_h[3] = default_h[3] ^ Spec.IV[3];
            default_h[4] = default_h[4] ^ Spec.IV[4];
            default_h[5] = default_h[5] ^ Spec.IV[5];
            default_h[6] = default_h[6] ^ Spec.IV[6];
            default_h[7] = default_h[7] ^ Spec.IV[7];
        }

        public static interface Default {
            public static final byte digest_length = 64;
            public static final byte key_length = 0;
            public static final byte fanout = 1;
            public static final byte depth = 1;
            public static final int leaf_length = 0;
            public static final long node_offset = 0L;
            public static final byte node_depth = 0;
            public static final byte inner_length = 0;
        }

        static interface Xoff {
            public static final int digest_length = 0;
            public static final int key_length = 1;
            public static final int fanout = 2;
            public static final int depth = 3;
            public static final int leaf_length = 4;
            public static final int node_offset = 8;
            public static final int node_depth = 16;
            public static final int inner_length = 17;
            public static final int reserved = 18;
            public static final int salt = 32;
            public static final int personal = 48;
        }
    }

    public static class Engine
    implements Blake2b {
        private State state;
        private final Param param;
        private static byte[] zeropad = new byte[128];
        private final byte[] oneByte = new byte[1];

        Engine() {
            this(new Param());
        }

        Engine(State state, Param param) {
            assert (state != null) : "state is null";
            assert (param != null) : "param is null";
            this.state = state;
            this.param = param;
        }

        Engine(Param param) {
            assert (param != null) : "param is null";
            this.param = param;
            this.state = new State(param.getDigestLength(), this instanceof Mac);
            if (param.getDepth() > 1) {
                int ndepth = param.getNodeDepth();
                long nxoff = param.getNodeOffset();
                if (ndepth == param.getDepth() - 1) {
                    this.state.last_node = true;
                    assert (nxoff == 0L) : "root must have offset of zero";
                } else if (nxoff == (long)(param.getFanout() - 1)) {
                    this.state.last_node = true;
                }
            }
            this.initialize();
        }

        @Override
        public ResumeHandle state() {
            return this.state.toResumableForm();
        }

        private void initialize() {
            System.arraycopy(this.param.initialized_H(), 0, this.state.h, 0, 8);
            if (this.param.hasKey) {
                this.update(this.param.key_bytes, 0, 128);
            }
        }

        public static void main(String ... args) {
            Mac mac = Mac.newInstance("LOVE".getBytes());
            byte[] hash = mac.digest("Salaam!".getBytes());
        }

        @Override
        public final void reset() {
            this.state.buflen = 0;
            for (int i = 0; i < this.state.buffer.length; ++i) {
                ((State)this.state).buffer[i] = 0;
            }
            ((State)this.state).f[0] = 0L;
            ((State)this.state).f[1] = 0L;
            ((State)this.state).t[0] = 0L;
            ((State)this.state).t[1] = 0L;
            this.initialize();
        }

        @Override
        public final void update(byte[] b, int off, int len) {
            if (b == null) {
                throw new IllegalArgumentException("input buffer (b) is null");
            }
            long[] t = this.state.t;
            byte[] buffer = this.state.buffer;
            while (len > 0) {
                if (this.state.buflen == 0) {
                    while (len > 128) {
                        t[0] = t[0] + 128L;
                        t[1] = t[1] + (t[0] < 0L && (long)this.state.buflen > -t[0] ? 1L : 0L);
                        this.compress(b, off);
                        len -= 128;
                        off += 128;
                    }
                } else if (this.state.buflen == 128) {
                    t[0] = t[0] + 128L;
                    t[1] = t[1] + (t[0] == 0L ? 1L : 0L);
                    this.compress(buffer, 0);
                    this.state.buflen = 0;
                    continue;
                }
                if (len == 0) {
                    return;
                }
                int cap = 128 - this.state.buflen;
                int fill = len > cap ? cap : len;
                System.arraycopy(b, off, buffer, this.state.buflen, fill);
                State state = this.state;
                state.buflen = state.buflen + fill;
                len -= fill;
                off += fill;
            }
        }

        @Override
        public final void update(byte b) {
            this.oneByte[0] = b;
            this.update(this.oneByte, 0, 1);
        }

        @Override
        public final void update(byte[] input) {
            this.update(input, 0, input.length);
        }

        @Override
        public final void digest(byte[] output, int off, int len) {
            System.arraycopy(zeropad, 0, this.state.buffer, this.state.buflen, 128 - this.state.buflen);
            if (this.state.buflen > 0) {
                long[] lArray = this.state.t;
                lArray[0] = lArray[0] + (long)this.state.buflen;
                long[] lArray2 = this.state.t;
                lArray2[1] = lArray2[1] + (this.state.t[0] == 0L ? 1L : 0L);
            }
            ((State)this.state).f[0] = -1L;
            ((State)this.state).f[1] = this.state.last_node ? -1L : 0L;
            this.compress(this.state.buffer, 0);
            this.hashout(output, off, len);
            this.reset();
        }

        @Override
        public final byte[] digest() throws IllegalArgumentException {
            byte[] out = new byte[this.state.outlen];
            this.digest(out, 0, this.state.outlen);
            return out;
        }

        @Override
        public final byte[] digest(byte[] input) {
            this.update(input, 0, input.length);
            return this.digest();
        }

        private void hashout(byte[] out, int offset, int hashlen) {
            int lcnt = hashlen >>> 3;
            long v = 0L;
            int i = offset;
            long[] h = this.state.h;
            for (int w = 0; w < lcnt; ++w) {
                v = h[w];
                out[i] = (byte)v;
                out[i + 1] = (byte)(v >>>= 8);
                out[i + 2] = (byte)(v >>>= 8);
                out[i + 3] = (byte)(v >>>= 8);
                out[i + 4] = (byte)(v >>>= 8);
                out[i + 5] = (byte)(v >>>= 8);
                out[i + 6] = (byte)(v >>>= 8);
                out[i + 7] = (byte)(v >>>= 8);
                i += 8;
            }
            if (hashlen == 64) {
                return;
            }
            v = h[lcnt];
            for (i = lcnt << 3; i < hashlen; ++i) {
                out[offset + i] = (byte)v;
                v >>>= 8;
            }
        }

        private void compress(byte[] b, int offset) {
            long[] m = this.state.m;
            m[0] = LittleEndian.readLong(b, offset);
            m[1] = LittleEndian.readLong(b, offset + 8);
            m[2] = LittleEndian.readLong(b, offset + 16);
            m[3] = LittleEndian.readLong(b, offset + 24);
            m[4] = LittleEndian.readLong(b, offset + 32);
            m[5] = LittleEndian.readLong(b, offset + 40);
            m[6] = LittleEndian.readLong(b, offset + 48);
            m[7] = LittleEndian.readLong(b, offset + 56);
            m[8] = LittleEndian.readLong(b, offset + 64);
            m[9] = LittleEndian.readLong(b, offset + 72);
            m[10] = LittleEndian.readLong(b, offset + 80);
            m[11] = LittleEndian.readLong(b, offset + 88);
            m[12] = LittleEndian.readLong(b, offset + 96);
            m[13] = LittleEndian.readLong(b, offset + 104);
            m[14] = LittleEndian.readLong(b, offset + 112);
            m[15] = LittleEndian.readLong(b, offset + 120);
            long[] v = this.state.v;
            long[] h = this.state.h;
            long[] t = this.state.t;
            long[] f = this.state.f;
            v[0] = h[0];
            v[1] = h[1];
            v[2] = h[2];
            v[3] = h[3];
            v[4] = h[4];
            v[5] = h[5];
            v[6] = h[6];
            v[7] = h[7];
            v[8] = 7640891576956012808L;
            v[9] = -4942790177534073029L;
            v[10] = 4354685564936845355L;
            v[11] = -6534734903238641935L;
            v[12] = t[0] ^ 0x510E527FADE682D1L;
            v[13] = t[1] ^ 0x9B05688C2B3E6C1FL;
            v[14] = f[0] ^ 0x1F83D9ABFB41BD6BL;
            v[15] = f[1] ^ 0x5BE0CD19137E2179L;
            this.round_0(v, m);
            this.round_1(v, m);
            this.round_2(v, m);
            this.round_3(v, m);
            this.round_4(v, m);
            this.round_5(v, m);
            this.round_6(v, m);
            this.round_7(v, m);
            this.round_8(v, m);
            this.round_9(v, m);
            this.round_0(v, m);
            this.round_1(v, m);
            h[0] = h[0] ^ (v[0] ^ v[8]);
            h[1] = h[1] ^ (v[1] ^ v[9]);
            h[2] = h[2] ^ (v[2] ^ v[10]);
            h[3] = h[3] ^ (v[3] ^ v[11]);
            h[4] = h[4] ^ (v[4] ^ v[12]);
            h[5] = h[5] ^ (v[5] ^ v[13]);
            h[6] = h[6] ^ (v[6] ^ v[14]);
            h[7] = h[7] ^ (v[7] ^ v[15]);
        }

        private void round_0(long[] v, long[] m) {
            v[0] = v[0] + v[4] + m[0];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[0] = v[0] + v[4] + m[1];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] << 1 | v[4] >>> 63;
            v[1] = v[1] + v[5] + m[2];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[1] = v[1] + v[5] + m[3];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[2] = v[2] + v[6] + m[4];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[2] = v[2] + v[6] + m[5];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[3] = v[3] + v[7] + m[6];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[3] = v[3] + v[7] + m[7];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[0] = v[0] + v[5] + m[8];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[0] = v[0] + v[5] + m[9];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[1] = v[1] + v[6] + m[10];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[1] = v[1] + v[6] + m[11];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[2] = v[2] + v[7] + m[12];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[2] = v[2] + v[7] + m[13];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[3] = v[3] + v[4] + m[14];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[3] = v[3] + v[4] + m[15];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] << 1 | v[4] >>> 63;
        }

        private void round_1(long[] v, long[] m) {
            v[0] = v[0] + v[4] + m[14];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[0] = v[0] + v[4] + m[10];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] << 1 | v[4] >>> 63;
            v[1] = v[1] + v[5] + m[4];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[1] = v[1] + v[5] + m[8];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[2] = v[2] + v[6] + m[9];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[2] = v[2] + v[6] + m[15];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[3] = v[3] + v[7] + m[13];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[3] = v[3] + v[7] + m[6];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[0] = v[0] + v[5] + m[1];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[0] = v[0] + v[5] + m[12];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[1] = v[1] + v[6] + m[0];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[1] = v[1] + v[6] + m[2];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[2] = v[2] + v[7] + m[11];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[2] = v[2] + v[7] + m[7];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[3] = v[3] + v[4] + m[5];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[3] = v[3] + v[4] + m[3];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] << 1 | v[4] >>> 63;
        }

        private void round_2(long[] v, long[] m) {
            v[0] = v[0] + v[4] + m[11];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[0] = v[0] + v[4] + m[8];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] << 1 | v[4] >>> 63;
            v[1] = v[1] + v[5] + m[12];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[1] = v[1] + v[5] + m[0];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[2] = v[2] + v[6] + m[5];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[2] = v[2] + v[6] + m[2];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[3] = v[3] + v[7] + m[15];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[3] = v[3] + v[7] + m[13];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[0] = v[0] + v[5] + m[10];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[0] = v[0] + v[5] + m[14];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[1] = v[1] + v[6] + m[3];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[1] = v[1] + v[6] + m[6];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[2] = v[2] + v[7] + m[7];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[2] = v[2] + v[7] + m[1];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[3] = v[3] + v[4] + m[9];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[3] = v[3] + v[4] + m[4];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] << 1 | v[4] >>> 63;
        }

        private void round_3(long[] v, long[] m) {
            v[0] = v[0] + v[4] + m[7];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[0] = v[0] + v[4] + m[9];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] << 1 | v[4] >>> 63;
            v[1] = v[1] + v[5] + m[3];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[1] = v[1] + v[5] + m[1];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[2] = v[2] + v[6] + m[13];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[2] = v[2] + v[6] + m[12];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[3] = v[3] + v[7] + m[11];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[3] = v[3] + v[7] + m[14];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[0] = v[0] + v[5] + m[2];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[0] = v[0] + v[5] + m[6];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[1] = v[1] + v[6] + m[5];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[1] = v[1] + v[6] + m[10];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[2] = v[2] + v[7] + m[4];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[2] = v[2] + v[7] + m[0];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[3] = v[3] + v[4] + m[15];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[3] = v[3] + v[4] + m[8];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] << 1 | v[4] >>> 63;
        }

        private void round_4(long[] v, long[] m) {
            v[0] = v[0] + v[4] + m[9];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[0] = v[0] + v[4] + m[0];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] << 1 | v[4] >>> 63;
            v[1] = v[1] + v[5] + m[5];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[1] = v[1] + v[5] + m[7];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[2] = v[2] + v[6] + m[2];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[2] = v[2] + v[6] + m[4];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[3] = v[3] + v[7] + m[10];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[3] = v[3] + v[7] + m[15];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[0] = v[0] + v[5] + m[14];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[0] = v[0] + v[5] + m[1];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[1] = v[1] + v[6] + m[11];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[1] = v[1] + v[6] + m[12];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[2] = v[2] + v[7] + m[6];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[2] = v[2] + v[7] + m[8];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[3] = v[3] + v[4] + m[3];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[3] = v[3] + v[4] + m[13];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] << 1 | v[4] >>> 63;
        }

        private void round_5(long[] v, long[] m) {
            v[0] = v[0] + v[4] + m[2];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[0] = v[0] + v[4] + m[12];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] << 1 | v[4] >>> 63;
            v[1] = v[1] + v[5] + m[6];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[1] = v[1] + v[5] + m[10];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[2] = v[2] + v[6] + m[0];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[2] = v[2] + v[6] + m[11];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[3] = v[3] + v[7] + m[8];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[3] = v[3] + v[7] + m[3];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[0] = v[0] + v[5] + m[4];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[0] = v[0] + v[5] + m[13];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[1] = v[1] + v[6] + m[7];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[1] = v[1] + v[6] + m[5];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[2] = v[2] + v[7] + m[15];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[2] = v[2] + v[7] + m[14];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[3] = v[3] + v[4] + m[1];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[3] = v[3] + v[4] + m[9];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] << 1 | v[4] >>> 63;
        }

        private void round_6(long[] v, long[] m) {
            v[0] = v[0] + v[4] + m[12];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[0] = v[0] + v[4] + m[5];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] << 1 | v[4] >>> 63;
            v[1] = v[1] + v[5] + m[1];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[1] = v[1] + v[5] + m[15];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[2] = v[2] + v[6] + m[14];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[2] = v[2] + v[6] + m[13];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[3] = v[3] + v[7] + m[4];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[3] = v[3] + v[7] + m[10];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[0] = v[0] + v[5] + m[0];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[0] = v[0] + v[5] + m[7];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[1] = v[1] + v[6] + m[6];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[1] = v[1] + v[6] + m[3];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[2] = v[2] + v[7] + m[9];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[2] = v[2] + v[7] + m[2];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[3] = v[3] + v[4] + m[8];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[3] = v[3] + v[4] + m[11];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] << 1 | v[4] >>> 63;
        }

        private void round_7(long[] v, long[] m) {
            v[0] = v[0] + v[4] + m[13];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[0] = v[0] + v[4] + m[11];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] << 1 | v[4] >>> 63;
            v[1] = v[1] + v[5] + m[7];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[1] = v[1] + v[5] + m[14];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[2] = v[2] + v[6] + m[12];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[2] = v[2] + v[6] + m[1];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[3] = v[3] + v[7] + m[3];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[3] = v[3] + v[7] + m[9];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[0] = v[0] + v[5] + m[5];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[0] = v[0] + v[5] + m[0];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[1] = v[1] + v[6] + m[15];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[1] = v[1] + v[6] + m[4];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[2] = v[2] + v[7] + m[8];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[2] = v[2] + v[7] + m[6];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[3] = v[3] + v[4] + m[2];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[3] = v[3] + v[4] + m[10];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] << 1 | v[4] >>> 63;
        }

        private void round_8(long[] v, long[] m) {
            v[0] = v[0] + v[4] + m[6];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[0] = v[0] + v[4] + m[15];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] << 1 | v[4] >>> 63;
            v[1] = v[1] + v[5] + m[14];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[1] = v[1] + v[5] + m[9];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[2] = v[2] + v[6] + m[11];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[2] = v[2] + v[6] + m[3];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[3] = v[3] + v[7] + m[0];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[3] = v[3] + v[7] + m[8];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[0] = v[0] + v[5] + m[12];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[0] = v[0] + v[5] + m[2];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[1] = v[1] + v[6] + m[13];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[1] = v[1] + v[6] + m[7];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[2] = v[2] + v[7] + m[1];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[2] = v[2] + v[7] + m[4];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[3] = v[3] + v[4] + m[10];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[3] = v[3] + v[4] + m[5];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] << 1 | v[4] >>> 63;
        }

        private void round_9(long[] v, long[] m) {
            v[0] = v[0] + v[4] + m[10];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[0] = v[0] + v[4] + m[2];
            v[12] = v[12] ^ v[0];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[8] = v[8] + v[12];
            v[4] = v[4] ^ v[8];
            v[4] = v[4] << 1 | v[4] >>> 63;
            v[1] = v[1] + v[5] + m[8];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[1] = v[1] + v[5] + m[4];
            v[13] = v[13] ^ v[1];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[9] = v[9] + v[13];
            v[5] = v[5] ^ v[9];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[2] = v[2] + v[6] + m[7];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[2] = v[2] + v[6] + m[6];
            v[14] = v[14] ^ v[2];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[10] = v[10] + v[14];
            v[6] = v[6] ^ v[10];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[3] = v[3] + v[7] + m[1];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[3] = v[3] + v[7] + m[5];
            v[15] = v[15] ^ v[3];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[11] = v[11] + v[15];
            v[7] = v[7] ^ v[11];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[0] = v[0] + v[5] + m[15];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] << 32 | v[15] >>> 32;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] >>> 24 | v[5] << 40;
            v[0] = v[0] + v[5] + m[11];
            v[15] = v[15] ^ v[0];
            v[15] = v[15] >>> 16 | v[15] << 48;
            v[10] = v[10] + v[15];
            v[5] = v[5] ^ v[10];
            v[5] = v[5] << 1 | v[5] >>> 63;
            v[1] = v[1] + v[6] + m[9];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] << 32 | v[12] >>> 32;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] >>> 24 | v[6] << 40;
            v[1] = v[1] + v[6] + m[14];
            v[12] = v[12] ^ v[1];
            v[12] = v[12] >>> 16 | v[12] << 48;
            v[11] = v[11] + v[12];
            v[6] = v[6] ^ v[11];
            v[6] = v[6] << 1 | v[6] >>> 63;
            v[2] = v[2] + v[7] + m[3];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] << 32 | v[13] >>> 32;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] >>> 24 | v[7] << 40;
            v[2] = v[2] + v[7] + m[12];
            v[13] = v[13] ^ v[2];
            v[13] = v[13] >>> 16 | v[13] << 48;
            v[8] = v[8] + v[13];
            v[7] = v[7] ^ v[8];
            v[7] = v[7] << 1 | v[7] >>> 63;
            v[3] = v[3] + v[4] + m[13];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] << 32 | v[14] >>> 32;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] >>> 24 | v[4] << 40;
            v[3] = v[3] + v[4] + m[0];
            v[14] = v[14] ^ v[3];
            v[14] = v[14] >>> 16 | v[14] << 48;
            v[9] = v[9] + v[14];
            v[4] = v[4] ^ v[9];
            v[4] = v[4] << 1 | v[4] >>> 63;
        }

        public static class LittleEndian {
            private static final byte[] hex_digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
            private static final byte[] HEX_digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

            public static String toHexStr(byte[] b) {
                return LittleEndian.toHexStr(b, false);
            }

            public static String toHexStr(byte[] b, boolean upperCase) {
                int len = b.length;
                byte[] digits = new byte[len * 2];
                byte[] hex_rep = upperCase ? HEX_digits : hex_digits;
                for (int i = 0; i < len; ++i) {
                    digits[i * 2] = hex_rep[(byte)(b[i] >> 4 & 0xF)];
                    digits[i * 2 + 1] = hex_rep[(byte)(b[i] & 0xF)];
                }
                return new String(digits);
            }

            public static int readInt(byte[] b, int off) {
                int v0 = b[off] & 0xFF;
                v0 |= (b[off + 1] & 0xFF) << 8;
                return (v0 |= (b[off + 2] & 0xFF) << 16) | b[off + 3] << 24;
            }

            public static long readLong(byte[] b, int off) {
                long v0 = (long)b[off] & 0xFFL;
                v0 |= ((long)b[off + 1] & 0xFFL) << 8;
                v0 |= ((long)b[off + 2] & 0xFFL) << 16;
                v0 |= ((long)b[off + 3] & 0xFFL) << 24;
                v0 |= ((long)b[off + 4] & 0xFFL) << 32;
                v0 |= ((long)b[off + 5] & 0xFFL) << 40;
                return (v0 |= ((long)b[off + 6] & 0xFFL) << 48) | (long)b[off + 7] << 56;
            }

            public static void writeLong(long v, byte[] b, int off) {
                b[off] = (byte)v;
                b[off + 1] = (byte)(v >>>= 8);
                b[off + 2] = (byte)(v >>>= 8);
                b[off + 3] = (byte)(v >>>= 8);
                b[off + 4] = (byte)(v >>>= 8);
                b[off + 5] = (byte)(v >>>= 8);
                b[off + 6] = (byte)(v >>>= 8);
                b[off + 7] = (byte)(v >>>= 8);
            }

            public static void writeInt(int v, byte[] b, int off) {
                b[off] = (byte)v;
                b[off + 1] = (byte)(v >>>= 8);
                b[off + 2] = (byte)(v >>>= 8);
                b[off + 3] = (byte)(v >>>= 8);
            }
        }

        public static final class Assert {
            public static final String exclusiveUpperBound = "'%s' %d is >= %d";
            public static final String inclusiveUpperBound = "'%s' %d is > %d";
            public static final String exclusiveLowerBound = "'%s' %d is <= %d";
            public static final String inclusiveLowerBound = "'%s' %d is < %d";

            static <T extends Number> String assertFail(String name, T v, String err, T spec) {
                new Exception().printStackTrace();
                return String.format(err, name, v, spec);
            }
        }

        static interface flag {
            public static final int last_block = 0;
            public static final int last_node = 1;
        }

        static final class State {
            private final long[] h = new long[8];
            private final long[] t = new long[2];
            private final long[] f = new long[2];
            private boolean last_node = false;
            private final long[] m = new long[16];
            private final long[] v = new long[16];
            private final byte[] buffer = new byte[128];
            private int buflen;
            private final int outlen;
            private final int digestType;

            State(int digestLength, boolean isMac) {
                this.outlen = digestLength;
                this.digestType = isMac ? 1 : 2;
            }

            public ResumeHandle toResumableForm() {
                ResumeHandle state = new ResumeHandle();
                state.h = this.h;
                state.t = this.t;
                state.f = this.f;
                state.last_node = this.last_node;
                state.m = this.m;
                state.v = this.v;
                state.buffer = this.buffer;
                state.buflen = this.buflen;
                state.outlen = this.outlen;
                state.type = this.digestType;
                return state;
            }
        }
    }

    public static class Tree {
        final int depth;
        final int fanout;
        final int leaf_length;
        final int inner_length;
        final int digest_length;

        public Tree(int depth, int fanout, int leaf_length, int inner_length, int digest_length) {
            this.fanout = fanout;
            this.depth = depth;
            this.leaf_length = leaf_length;
            this.inner_length = inner_length;
            this.digest_length = digest_length;
        }

        private Param treeParam() {
            return new Param().setDepth(this.depth).setFanout(this.fanout).setLeafLength(this.leaf_length).setInnerLength(this.inner_length);
        }

        public final Digest getNode(int depth, int offset) {
            Param nodeParam = this.treeParam().setNodeDepth(depth).setNodeOffset(offset).setDigestLength(this.inner_length);
            return Digest.newInstance(nodeParam);
        }

        public final Digest getRoot() {
            int depth = this.depth - 1;
            Param rootParam = this.treeParam().setNodeDepth(depth).setNodeOffset(0L).setDigestLength(this.digest_length);
            return Digest.newInstance(rootParam);
        }
    }

    public static class Mac
    extends Engine
    implements Blake2b {
        private Mac(Param p, Engine.State state) {
            super(state, p);
        }

        private Mac(Param p) {
            super(p);
        }

        private Mac() {
        }

        public static Mac newInstance(byte[] key) {
            return new Mac(new Param().setKey(key));
        }

        public static Mac newInstance(byte[] key, int digestLength) {
            return new Mac(new Param().setKey(key).setDigestLength(digestLength));
        }

        public static Mac newInstance(Key key, int digestLength) {
            return new Mac(new Param().setKey(key).setDigestLength(digestLength));
        }

        public static Mac newInstance(Param p) {
            assert (p != null) : "Param (p) is null";
            assert (p.hasKey()) : "Param (p) not configured with a key";
            return new Mac(p);
        }
    }

    public static class Digest
    extends Engine
    implements Blake2b {
        private Digest(Param p) {
            super(p);
        }

        private Digest() {
        }

        private Digest(Param p, Engine.State state) {
            super(state, p);
        }

        public static Digest newInstance() {
            return new Digest();
        }

        public static Digest newInstance(int digestLength) {
            return new Digest(new Param().setDigestLength(digestLength));
        }

        public static Digest newInstance(Param p) {
            return new Digest(p);
        }

        public static Digest newInstance(Param p, Engine.State state) {
            return new Digest(p, state);
        }
    }

    public static final class ResumeHandle
    implements Serializable {
        public long[] h = new long[8];
        public long[] t = new long[2];
        public long[] f = new long[2];
        public boolean last_node = false;
        public long[] m = new long[16];
        public long[] v = new long[16];
        public byte[] buffer;
        public int buflen;
        public int outlen;
        public int type;
    }

    public static interface Spec {
        public static final int param_bytes = 64;
        public static final int block_bytes = 128;
        public static final int max_digest_bytes = 64;
        public static final int max_key_bytes = 64;
        public static final int max_salt_bytes = 16;
        public static final int max_personalization_bytes = 16;
        public static final int state_space_len = 8;
        public static final int max_tree_fantout = 255;
        public static final int max_tree_depth = 255;
        public static final int max_tree_leaf_length = -1;
        public static final long max_node_offset = -1L;
        public static final int max_tree_inner_length = 255;
        public static final long[] IV = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};
    }
}

