/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.ftgt;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.util.Base64;
import android.util.Log;
import android.util.TimingLogger;
import com.google.android.ftgt.EmulatorDetector;
import com.google.android.ftgt.crypto.Crypto;
import com.google.android.ftgt.model.FP;
import com.google.android.ftgt.model.Property;
import com.google.android.ftgt.model.SP;
import com.google.android.ftgt.root.Root;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class Track {
    private static String TAG = "DYNAMICX";
    protected FP mFP;
    protected SP mSP;
    private Context context;
    private EmulatorDetector mEmuDetect;
    private List<Property> inPack;
    private List<Property> outPack;
    private Crypto mCrypto;

    protected Track(Context context) {
        this.context = context;
        this.mFP = new FP();
        this.mSP = new SP();
        this.mCrypto = new Crypto();
        this.mEmuDetect = new EmulatorDetector(context);
        this.inPack = new ArrayList<Property>();
        this.outPack = new ArrayList<Property>();
        Log.d((String)TAG, (String)"---- Load Track object success");
    }

    protected void firstTrack() {
        try {
            TimingLogger timings = new TimingLogger(TAG, "FirstTrack Bench");
            this.getSign(this.context.getPackageName());
            timings.addSplit("getSign");
            this.getMeta();
            timings.addSplit("getMeta");
            this.getDevice();
            timings.addSplit("getDevice");
            this.checkADB();
            timings.addSplit("checkADB");
            this.mFP.setoPgYn2(new Root(this.context).isDeviceRooted() ? 1 : 0);
            timings.addSplit("checkRoot");
            if (this.mEmuDetect.detect()) {
                if (this.mEmuDetect.ratio > 0) {
                    this.mFP.setP6sPbF(String.format(Locale.US, "%s-(%d)", this.mEmuDetect.mEmulator.toString(), this.mEmuDetect.ratio));
                } else {
                    this.mFP.setP6sPbF(this.mEmuDetect.mEmulator.toString());
                }
            } else {
                this.mFP.setP6sPbF("");
            }
            timings.addSplit("checkEmulator");
            timings.dumpToLog();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("firstTrack | " + e.getMessage()));
        }
    }

    protected void secondTrack() {
        try {
            TimingLogger timings = new TimingLogger(TAG, "SecondTrack Bench");
            this.checkBurpCert();
            timings.addSplit("checkBurpCert");
            this.checkLP();
            timings.addSplit("checkLP");
            this.checkGG();
            timings.addSplit("checkGG");
            String gg_package = this.mSP.getS3zb7N();
            if (!gg_package.isEmpty()) {
                if (this.isRunningPkg(gg_package)) {
                    this.mSP.setPwvSjT(1);
                } else {
                    this.mSP.setPwvSjT(0);
                }
            } else {
                this.mSP.setPwvSjT(-1);
            }
            timings.addSplit("checkRunGG");
            this.checkGameKiller();
            timings.addSplit("checkGameKiller");
            String gk_package = this.mSP.getVxeAVo();
            if (!gk_package.isEmpty()) {
                if (this.isRunningPkg(gk_package)) {
                    this.mSP.setJxbkNg(1);
                } else {
                    this.mSP.setJxbkNg(0);
                }
            } else {
                this.mSP.setJxbkNg(-1);
            }
            timings.addSplit("checkRunGameKiller");
            this.checkCheatEngine();
            timings.addSplit("checkCheatEngine");
            String ce_package = this.mSP.getAao2bC();
            if (!ce_package.isEmpty()) {
                if (this.isRunningPkg(ce_package)) {
                    this.mSP.setJ1XdSr(1);
                } else {
                    this.mSP.setJ1XdSr(0);
                }
            } else {
                this.mSP.setJ1XdSr(-1);
            }
            timings.addSplit("checkRunCheatEngine");
            timings.dumpToLog();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("secondTrack | " + e.getMessage()));
        }
    }

    private void getSign(String packageName) {
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo(packageName, 64);
            String sig = new String(pi.signatures[0].toChars());
            this.mFP.setAgEtrp(this.mCrypto.mDigest(sig));
        }
        catch (Exception e) {
            this.mFP.setAgEtrp("exception:" + e.getMessage());
        }
    }

    private void getMeta() {
        String path = this.context.getApplicationInfo().publicSourceDir;
        String meta = "";
        try {
            JarFile jar = new JarFile(path);
            ZipEntry ze = jar.getEntry(this.mCrypto.b64Dec("TUVUQS1JTkYvTUFOSUZFU1QuTUY="));
            byte[] file = this.mCrypto.getEntry(jar, ze);
            jar.close();
            if (file != null) {
                meta = Base64.encodeToString((byte[])file, (int)2);
            }
            this.mFP.setXSXrzM(meta);
        }
        catch (Exception e) {
            this.mFP.setXSXrzM("exception:" + e.getMessage());
        }
    }

    private void getDevice() {
        int a = Build.VERSION.SDK_INT;
        String b = Build.DEVICE;
        String c = Build.MODEL;
        String d = Build.PRODUCT;
        String e = Build.HARDWARE;
        String f = Build.MANUFACTURER;
        String g = Build.BRAND;
        this.mFP.setzEdmjI(String.format(Locale.US, "%d|%s|%s|%s|%s|%s|%s", a, b, c, d, e, f, g));
    }

    private void checkADB() {
        int adb = Build.VERSION.SDK_INT >= 17 ? Settings.Secure.getInt((ContentResolver)this.context.getContentResolver(), (String)"adb_enabled", (int)0) : Settings.Secure.getInt((ContentResolver)this.context.getContentResolver(), (String)"adb_enabled", (int)0);
        this.mFP.setNcl36L(adb);
    }

    private void checkBurpCert() {
        try {
            KeyStore mKeyStore = KeyStore.getInstance(this.mCrypto.b64Dec("QW5kcm9pZENBU3RvcmU="));
            if (mKeyStore != null) {
                mKeyStore.load(null, null);
                Enumeration<String> aliases = mKeyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)mKeyStore.getCertificate(alias);
                    if (!cert.getIssuerDN().getName().contains(this.mCrypto.b64Dec("UG9ydFN3aWdnZXIgQ0E=")) && !cert.getIssuerDN().getName().contains(this.mCrypto.b64Dec("UG9ydFN3aWdnZXI="))) continue;
                    this.mSP.setVTO0lu(1);
                    return;
                }
            }
            this.mSP.setVTO0lu(0);
        }
        catch (Exception e) {
            this.mSP.setVTO0lu(-1);
        }
    }

    public void checkInPack(List<String> files) {
        String path = this.context.getApplicationInfo().publicSourceDir;
        try {
            JarFile jarFile = new JarFile(path);
            Enumeration<JarEntry> entries = jarFile.entries();
            ArrayList<String> toRemove = new ArrayList<String>();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                if (je.getName().startsWith("META-INF/") || je.getName().startsWith("res/")) continue;
                for (String fileName : files) {
                    if (!je.getName().endsWith(fileName)) continue;
                    toRemove.add(fileName);
                    this.inPack.add(new Property(je.getName(), this.mCrypto.zSha1(jarFile, je)));
                }
            }
            jarFile.close();
            files.removeAll(toRemove);
            if (!files.isEmpty()) {
                for (String buf : files) {
                    this.inPack.add(new Property(buf, ""));
                }
            }
        }
        catch (Exception e) {
            this.inPack.add(new Property("IPex", e.toString() + "|" + e.getMessage()));
        }
    }

    public void setInPack() {
        this.mFP.setNuZbEa(this.inPack);
    }

    public void checkOutPack(String filePath) {
        String absolutePath = Environment.getExternalStorageDirectory().getAbsolutePath() + filePath;
        File trackFile = new File(absolutePath);
        if (trackFile.exists()) {
            this.outPack.add(new Property(filePath, this.mCrypto.fSha1(trackFile)));
        } else {
            this.outPack.add(new Property(filePath, ""));
        }
    }

    public void setOutPack() {
        this.mFP.setzEZqOp(this.outPack);
    }

    private void checkLP() {
        PackageManager mPackageManager = this.context.getPackageManager();
        List packages = mPackageManager.getInstalledApplications(128);
        for (ApplicationInfo packageInfo : packages) {
            if (!packageInfo.packageName.matches("(ru).([a-zA-Z0-9]+).([a-zA-Z0-9]+)")) continue;
            this.mSP.setSR7r27(packageInfo.packageName);
            return;
        }
        this.mSP.setSR7r27("");
    }

    private void checkGG() {
        PackageManager mPackageManager = this.context.getPackageManager();
        List packages = mPackageManager.getInstalledApplications(128);
        for (ApplicationInfo packageInfo : packages) {
            try {
                Drawable icon = this.context.getPackageManager().getApplicationIcon(packageInfo.packageName);
                Bitmap bitmap = ((BitmapDrawable)icon).getBitmap();
                if (!this.checkGGPattern(bitmap)) continue;
                this.mSP.setS3zb7N(packageInfo.packageName);
                return;
            }
            catch (Exception exception) {
            }
        }
        this.mSP.setS3zb7N("");
    }

    private boolean checkGGPattern(Bitmap image) {
        int w = image.getWidth();
        int h = image.getHeight();
        int center_x = Math.round(w / 2);
        int center_y = Math.round(h / 2);
        int center = image.getPixel(center_x, center_y);
        int center_top_y = Math.round(center_y / 2);
        int center_top = image.getPixel(center_x, center_top_y);
        int center_bot_y = center_top_y + center_y;
        int center_bot = image.getPixel(center_x, center_bot_y);
        if (Color.red((int)center_top) == Color.red((int)center_bot) && Color.green((int)center_top) == Color.green((int)center_bot) && Color.blue((int)center_top) == Color.blue((int)center_bot) && Math.abs(Color.red((int)center_top) - Color.red((int)center)) <= 31 && Math.abs(Color.green((int)center_top) - Color.green((int)center)) <= 31 && Math.abs(Color.blue((int)center_top) - Color.blue((int)center)) <= 31) {
            int top_right_x;
            int top_right;
            String top_right_color;
            int bot_left_x = Math.round(center_x / 2);
            int bot_left_y = center_top_y + center_y;
            int bot_left = image.getPixel(bot_left_x, bot_left_y);
            int top_left_x = center_x - bot_left_x;
            int top_left = image.getPixel(top_left_x, center_top_y);
            if (Math.abs(Color.red((int)bot_left) - Color.red((int)top_left)) <= 31 && Math.abs(Color.green((int)bot_left) - Color.green((int)top_left)) <= 31 && Math.abs(Color.blue((int)bot_left) - Color.blue((int)top_left)) <= 31 && ((top_right_color = this.mCrypto.pixelToHex(Color.red((int)(top_right = image.getPixel(top_right_x = center_x + bot_left_x, center_top_y))), Color.green((int)top_right), Color.blue((int)top_right))).equals("cccccc") || Color.red((int)top_right) <= 235 && Color.green((int)top_right) <= 235 && Color.blue((int)top_right) <= 235 && Color.red((int)top_right) >= 173 && Color.green((int)top_right) >= 173 && Color.blue((int)top_right) >= 173)) {
                return true;
            }
        }
        return false;
    }

    private void checkGameKiller() {
        PackageManager mPackageManager = this.context.getPackageManager();
        List packages = mPackageManager.getInstalledApplications(128);
        for (ApplicationInfo packageInfo : packages) {
            if (!packageInfo.packageName.contains(this.mCrypto.b64Dec("Y24ubW0uZ2s="))) continue;
            this.mSP.setVxeAVo(packageInfo.packageName);
            return;
        }
        this.mSP.setVxeAVo("");
    }

    private void checkCheatEngine() {
        PackageManager mPackageManager = this.context.getPackageManager();
        List packages = mPackageManager.getInstalledApplications(128);
        for (ApplicationInfo packageInfo : packages) {
            if (!packageInfo.packageName.contains(this.mCrypto.b64Dec("b3JnLmNoZWF0ZW5naW5lLmNlZ3Vp"))) continue;
            this.mSP.setAao2bC(packageInfo.packageName);
            return;
        }
        this.mSP.setAao2bC("");
    }

    private boolean isRunningPkg(String pkg) {
        ActivityManager manager = (ActivityManager)this.context.getSystemService("activity");
        List activityes = manager.getRunningAppProcesses();
        for (int i = 0; i < activityes.size(); ++i) {
            if (!((ActivityManager.RunningAppProcessInfo)activityes.get((int)i)).processName.contains(pkg)) continue;
            return true;
        }
        return false;
    }
}

