/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.ftgt;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.google.android.ftgt.Emulator;
import com.google.android.ftgt.model.EmuPackage;
import com.google.android.ftgt.model.Property;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

class EmulatorDetector {
    private final String[] PHONE_NUMBERS = new String[]{"15555215554", "15555215556", "15555215558", "15555215560", "15555215562", "15555215564", "15555215566", "15555215568", "15555215570", "15555215572", "15555215574", "15555215576", "15555215578", "15555215580", "15555215582", "15555215584"};
    private final String[] DEVICE_IDS = new String[]{"000000000000000", "e21833235b6eef10", "012345678912345"};
    private final String[] IMSI_IDS = new String[]{"310260000000000"};
    private final String[] QEMU_DRIVERS = new String[]{"goldfish"};
    private final String IP = "10.0.2.15";
    private final String[] PIPES = new String[]{"/dev/socket/qemud", "/dev/qemu_pipe"};
    private final String[] X86_FILES = new String[]{"ueventd.android_x86.rc", "x86.prop", "ueventd.ttVM_x86.rc", "init.ttVM_x86.rc", "fstab.ttVM_x86", "fstab.vbox86", "init.vbox86.rc", "ueventd.vbox86.rc"};
    private final String[] GENY_FILES = new String[]{"/dev/socket/genyd", "/dev/socket/baseband_genyd", "/system/etc/init.genymotion.sh"};
    private final String[] ANDY_FILES = new String[]{"fstab.andy", "ueventd.andy.rc"};
    private final String[] LD_FILES = new String[]{"/system/bin/ldmountsf"};
    private final String[] NOX_FILES = new String[]{"/system/bin/noxd", "/system/bin/nox-prop", "/system/lib/libnoxd.so"};
    private final String[] DROID4X_FILES = new String[]{"/system/etc/init.droid4x.sh", "/system/droid4x"};
    private final Property[] GENERIC_PROPS = new Property[]{new Property("init.svc.qemud", null), new Property("init.svc.qemu-props", null), new Property("qemu.hw.mainkeys", null), new Property("qemu.sf.fake_camera", null), new Property("qemu.sf.lcd_density", null), new Property("ro.bootloader", "unknown"), new Property("ro.bootmode", "unknown"), new Property("ro.hardware", "goldfish"), new Property("ro.kernel.android.qemud", null), new Property("ro.kernel.qemu.gles", null), new Property("ro.kernel.qemu", "1"), new Property("ro.product.device", "generic"), new Property("ro.product.model", "sdk"), new Property("ro.product.name", "sdk"), new Property("ro.serialno", null)};
    private final Property[] DROID4X_PROPS = new Property[]{new Property("ro.product.name", "droid4x"), new Property("ro.product.device", "droid4x"), new Property("ro.build.product", "droid4x"), new Property("ro.build.display.id", "droid4x"), new Property("ro.build.host", "droid4x"), new Property("ro.build.description", "droid4x"), new Property("ro.product.model", "mi"), new Property("ro.droid4x.caps.bat", null), new Property("ro.droid4x.caps.gps", null), new Property("ro.droid4x.caps.acc", null), new Property("ro.droid4x.caps.cam", null), new Property("ro.droid4x.caps.scr", null), new Property("ro.droid4x.caps.rmt", null)};
    private final Property[] GENY_PROPS = new Property[]{new Property("ro.build.user", "genymotion"), new Property("ro.genymotion.device.version", null), new Property("ro.genyd.caps.bat", null), new Property("ro.genyd.caps.gps", null), new Property("ro.genyd.caps.net", null), new Property("ro.genyd.caps.baseband", null), new Property("ro.product.brand.geny-def", null), new Property("ro.product.board.geny-def", null), new Property("ro.product.name.geny-def", null), new Property("ro.build.tags.geny-def", null)};
    private final int MIN_PROPERTIES_THRESHOLD = 5;
    public int ratio = 0;
    public Emulator mEmulator;
    private Context mContext;
    private List<EmuPackage> mListEmuPackage;

    public EmulatorDetector(Context mContext) {
        this.mContext = mContext;
        this.mListEmuPackage = new ArrayList<EmuPackage>();
        this.mListEmuPackage.add(new EmuPackage("com.bluestacks", Emulator.BLUESTACK));
        this.mListEmuPackage.add(new EmuPackage("com.bluestacks.appmart", Emulator.BLUESTACK));
        this.mListEmuPackage.add(new EmuPackage("com.bignox.appcenter", Emulator.NOX));
        this.mListEmuPackage.add(new EmuPackage("com.vphone.launcher", Emulator.NOX));
        this.mListEmuPackage.add(new EmuPackage("com.bignox.app", Emulator.NOX));
        this.mListEmuPackage.add(new EmuPackage("com.android.ld.appstore", Emulator.LD));
        this.mListEmuPackage.add(new EmuPackage("com.ldmnq.launcher3", Emulator.LD));
        this.mListEmuPackage.add(new EmuPackage("com.microvirt.download", Emulator.MEMU));
        this.mListEmuPackage.add(new EmuPackage("com.microvirt.memuime", Emulator.MEMU));
        this.mListEmuPackage.add(new EmuPackage("com.microvirt.launcher2", Emulator.MEMU));
        this.mListEmuPackage.add(new EmuPackage("com.microvirt.guide", Emulator.MEMU));
        this.mListEmuPackage.add(new EmuPackage("me.haima.helpcenter", Emulator.DROID4X));
        this.mListEmuPackage.add(new EmuPackage("me.haima.androidassist", Emulator.DROID4X));
        this.mListEmuPackage.add(new EmuPackage("com.haimawan.push", Emulator.DROID4X));
    }

    public boolean detect() {
        boolean result;
        boolean a = this.checkBasic();
        boolean b = this.checkAdvanced();
        boolean c = this.checkPackageName(this.mListEmuPackage);
        boolean bl = result = a || b || c;
        if (!result) {
            return this.checkBS4();
        }
        return result;
    }

    private boolean checkBasic() {
        boolean result = false;
        if (Build.FINGERPRINT.startsWith("generic") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.HARDWARE.equals("goldfish") || Build.HARDWARE.equals("vbox86") || Build.PRODUCT.equals("sdk") || Build.PRODUCT.equals("google_sdk") || Build.PRODUCT.equals("sdk_x86") || Build.PRODUCT.equals("vbox86p")) {
            result = true;
            this.mEmulator = Emulator.UNKNOWN;
        } else if (Build.BOARD.toLowerCase().contains("nox") || Build.BOOTLOADER.toLowerCase().contains("nox") || Build.HARDWARE.toLowerCase().contains("nox") || Build.PRODUCT.toLowerCase().contains("nox") || Build.SERIAL.toLowerCase().contains("nox")) {
            result = true;
            this.mEmulator = Emulator.NOX;
        } else if (Build.MANUFACTURER.contains("Genymotion")) {
            result = true;
            this.mEmulator = Emulator.GENY;
        }
        return result;
    }

    private boolean checkAdvanced() {
        boolean unknown_type = this.checkTelephony() || this.checkIp() || this.checkFiles(this.PIPES, Emulator.UNKNOWN) || this.checkFiles(this.X86_FILES, Emulator.UNKNOWN) || this.checkPropValues(this.GENERIC_PROPS, Emulator.UNKNOWN);
        boolean known_type = this.checkQEmuDrivers() || this.checkFiles(this.NOX_FILES, Emulator.NOX) || this.checkFiles(this.LD_FILES, Emulator.LD) || this.checkFiles(this.GENY_FILES, Emulator.GENY) || this.checkFiles(this.ANDY_FILES, Emulator.ANDY) || this.checkFiles(this.DROID4X_FILES, Emulator.DROID4X) || this.checkPropValues(this.DROID4X_PROPS, Emulator.DROID4X) || this.checkPropValues(this.GENY_PROPS, Emulator.GENY);
        return unknown_type || known_type;
    }

    private boolean checkTelephony() {
        if (ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.READ_PHONE_STATE") == 0 && this.isSupportTelePhony()) {
            return this.checkPhoneNumber() || this.checkDeviceId() || this.checkImsi() || this.checkOperatorName();
        }
        return false;
    }

    private boolean checkPhoneNumber() {
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        if (ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.READ_SMS") == 0 && ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.READ_PHONE_NUMBERS") == 0 && ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.READ_PHONE_STATE") == 0) {
            String phoneNumber = telephonyManager.getLine1Number();
            for (String number : this.PHONE_NUMBERS) {
                if (!number.equalsIgnoreCase(phoneNumber)) continue;
                this.mEmulator = Emulator.UNKNOWN;
                return true;
            }
        }
        return false;
    }

    private boolean checkDeviceId() {
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        if (ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.READ_PHONE_STATE") == 0) {
            String deviceId = telephonyManager.getDeviceId();
            for (String known_deviceId : this.DEVICE_IDS) {
                if (!known_deviceId.equalsIgnoreCase(deviceId)) continue;
                this.mEmulator = Emulator.UNKNOWN;
                return true;
            }
        }
        return false;
    }

    private boolean checkImsi() {
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        if (ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.READ_PHONE_STATE") == 0) {
            String imsi = telephonyManager.getSubscriberId();
            for (String known_imsi : this.IMSI_IDS) {
                if (!known_imsi.equalsIgnoreCase(imsi)) continue;
                this.mEmulator = Emulator.UNKNOWN;
                return true;
            }
        }
        return false;
    }

    private boolean checkOperatorName() {
        String operatorName = ((TelephonyManager)this.mContext.getSystemService("phone")).getNetworkOperatorName();
        if (operatorName.equalsIgnoreCase("android")) {
            this.mEmulator = Emulator.UNKNOWN;
            return true;
        }
        return false;
    }

    private boolean checkQEmuDrivers() {
        for (File drivers_file : new File[]{new File("/proc/tty/drivers"), new File("/proc/cpuinfo")}) {
            if (!drivers_file.exists() || !drivers_file.canRead()) continue;
            byte[] data = new byte[1024];
            try {
                FileInputStream is = new FileInputStream(drivers_file);
                ((InputStream)is).read(data);
                ((InputStream)is).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String driver_data = new String(data);
            for (String known_qemu_driver : this.QEMU_DRIVERS) {
                if (!driver_data.contains(known_qemu_driver)) continue;
                this.mEmulator = Emulator.QEMU;
                return true;
            }
        }
        return false;
    }

    private boolean checkIp() {
        if (ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.INTERNET") == 0) {
            String[] args = new String[]{"/system/bin/netcfg"};
            StringBuilder stringBuilder = new StringBuilder();
            try {
                ProcessBuilder builder = new ProcessBuilder(args);
                builder.directory(new File("/system/bin/"));
                builder.redirectErrorStream(true);
                Process process = builder.start();
                InputStream in = process.getInputStream();
                byte[] re = new byte[1024];
                while (in.read(re) != -1) {
                    stringBuilder.append(new String(re));
                }
                in.close();
            }
            catch (Exception builder) {
                // empty catch block
            }
            String netData = stringBuilder.toString();
            if (!TextUtils.isEmpty((CharSequence)netData)) {
                String[] array;
                for (String lan : array = netData.split("\n")) {
                    if (!lan.contains("wlan0") && !lan.contains("tunl0") && !lan.contains("eth0") || !lan.contains("10.0.2.15")) continue;
                    this.mEmulator = Emulator.UNKNOWN;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkFiles(String[] targets, Emulator emu) {
        for (String pipe : targets) {
            File qemuFile = new File(pipe);
            if (!qemuFile.exists()) continue;
            this.mEmulator = emu;
            return true;
        }
        return false;
    }

    private boolean checkPropValues(Property[] props, Emulator emu) {
        int found_props = 0;
        for (Property property : props) {
            String property_value = this.getProp(this.mContext, property.name);
            if (property.seek_value == null && property_value != null && property_value.length() > 0) {
                ++found_props;
            }
            if (property.seek_value == null || !property_value.toLowerCase().contains(property.seek_value)) continue;
            ++found_props;
        }
        if (found_props >= 5) {
            this.mEmulator = emu;
            return true;
        }
        return false;
    }

    private String getProp(Context context, String property) {
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> systemProperties = classLoader.loadClass("android.os.SystemProperties");
            Method get = systemProperties.getMethod("get", String.class);
            Object[] params = new Object[]{property};
            return (String)get.invoke(systemProperties, params);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isSupportTelePhony() {
        PackageManager packageManager = this.mContext.getPackageManager();
        return packageManager.hasSystemFeature("android.hardware.telephony");
    }

    private boolean isPackageExisted(String targetPackage) {
        PackageManager mPackageManager = this.mContext.getPackageManager();
        try {
            mPackageManager.getPackageInfo(targetPackage, 128);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean checkPackageName(List<EmuPackage> mListEmuPackage) {
        if (mListEmuPackage.isEmpty()) {
            return false;
        }
        ArrayList<Emulator> emuDetected = new ArrayList<Emulator>();
        for (EmuPackage mEmuPackage : mListEmuPackage) {
            if (!this.isPackageExisted(mEmuPackage.name)) continue;
            emuDetected.add(mEmuPackage.emu);
        }
        if (!emuDetected.isEmpty()) {
            if (new HashSet(emuDetected).size() > 1) {
                this.mEmulator = Emulator.UNKNOWN;
            } else {
                this.mEmulator = (Emulator)((Object)emuDetected.get(0));
                int founded = Collections.frequency(emuDetected, (Object)this.mEmulator);
                int count = 0;
                for (EmuPackage mEmuPackage : mListEmuPackage) {
                    if (mEmuPackage.emu != this.mEmulator) continue;
                    ++count;
                }
                if (count > 0) {
                    this.ratio = Math.round(founded * (100 / count));
                }
            }
            return true;
        }
        return false;
    }

    private boolean checkBS4() {
        File bs4Dir = new File(Environment.getExternalStorageDirectory() + "/windows");
        if (bs4Dir.exists() && bs4Dir.isDirectory()) {
            ArrayList<EmuPackage> mListEmuPackage = new ArrayList<EmuPackage>();
            mListEmuPackage.add(new EmuPackage("com.skt.skaf.OA00018282", Emulator.BLUESTACK));
            mListEmuPackage.add(new EmuPackage("com.skt.skaf.A000Z00040", Emulator.BLUESTACK));
            if (this.checkPackageName(mListEmuPackage) && this.ratio > 60) {
                this.ratio = 50;
                bs4Dir = new File(Environment.getExternalStorageDirectory() + "/DCIM/SharedFolder");
                if (bs4Dir.exists() && bs4Dir.isDirectory()) {
                    this.ratio += 40;
                }
                return true;
            }
        }
        return false;
    }
}

