package com.mobgame.api;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Base64;

import com.mobgame.MobGameSDK;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.EncodedResponse;
import com.mobgame.model.ForceLogoutResponse;
import com.mobgame.model.Game;
import com.mobgame.model.LoginResponse;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.EncryptionUtils;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Utils;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.HashSet;
import java.util.Objects;

import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

class RestfulApi {

	private static final String API_BASE_URL = "https://a.smobgame.com";
	private static final String API_BASE_NOTI_TOKEN_URL = "https://interact-notify.platformjk.com";

	private static RestfulApi INSTANCE;
	
	private PlfRestService restService;
	private static Retrofit retrofit;
		
	public static RestfulApi getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new RestfulApi(false);
		}
		return INSTANCE;
	}
	public static RestfulApi getInstance(boolean isSendToken) {
		if (INSTANCE == null) {
			INSTANCE = new RestfulApi(isSendToken);
		}
		return INSTANCE;
	}
	public static void removeInstance(){
		if(INSTANCE != null){
			INSTANCE = null;
		}
	}
	
	private RestfulApi(boolean isSendToken) {
		try {
			OkHttpClient httpClient;
			if(isSendToken){
				httpClient = getCommonClientForSendTokenFCM();
			}else{
				httpClient = getCommonClient();
			}

			retrofit = new Retrofit.Builder()
				.baseUrl(isSendToken ? API_BASE_NOTI_TOKEN_URL : API_BASE_URL)
				.addConverterFactory(GsonConverterFactory.create())
				.client(httpClient)
				.build();

			restService = retrofit.create(PlfRestService.class);
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	static OkHttpClient getCommonClientForSendTokenFCM() {

		OkHttpClient httpClient = null;
		try {
			CookieManager cookieManager = new CookieManager();
			cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);

			httpClient = new OkHttpClient.Builder()
					.addInterceptor(new Interceptor() {
						@NonNull
						@Override
						public Response intercept(@NonNull Chain chain) throws IOException {
							Activity activity = MobGameSDK.activity;
							Context context = MobGameSDK.getApplicationContext();
							GameConfigManager config = GameConfigManager.getInstance();

							Request.Builder builder = chain.request()
									.newBuilder()
									.addHeader(Constants.DEVICE_NAME, DeviceUtils.getDevice())//TODO
									.addHeader(Constants.DEVICE_OS, DeviceUtils.getOSInfo())//TODO
									.addHeader(Constants.SDK_LOCALE , DeviceUtils.getLanguage())
									.addHeader(Constants.DEVICE_RESOLUTION, Objects.requireNonNull(DeviceUtils.getResolution(context)))//TODO
									.addHeader(Constants.VERSION, Utils.getSDKVersion(context))//TODO
									.addHeader(Constants.X_REQUEST, GameConfigManager.getInstance().getAppKey(activity))//TODO
									.addHeader(Constants.APP_VERSION, Utils.getGameVersion(context))//TODO
									.addHeader(Constants.NETWORK_TYPE, Utils.getNetwork(context))//TODO
									.addHeader(Constants.DEVICE_SCALE, DeviceUtils.getScreenOrientation(context) + "")//TODO
									.addHeader(Constants.ADVERTISING_ID , DeviceUtils.getAdvertisingID(context));//TODO

							if (config.getAccessToken() != null) {
								builder.addHeader(Constants.ACC_TOKEN, config.getAccessToken());//TODO
							}

							Request request = builder.build();
							return chain.proceed(request);
						}
					})
					.addInterceptor(new Interceptor() {
						@NonNull
						@Override
						public Response intercept(@NonNull Chain chain) throws IOException {
							Context c = MobGameSDK.getApplicationContext();
							Request.Builder builder = chain.request().newBuilder();
							HashSet<String> preferences = (HashSet<String>) Preference
									.getStringSet(c, Constants.SHARED_PREF_COOKIES,
											new HashSet<String>());
							for (String cookie : preferences) {
								builder.addHeader("Cookie", cookie);
							}
							return chain.proceed(builder.build());
						}
					})
					.addInterceptor(new Interceptor() {
						@NonNull
						@Override
						public Response intercept(@NonNull Chain chain) throws IOException {
							Response originalResponse = chain.proceed(chain.request());

							if (!originalResponse.headers("Set-Cookie").isEmpty()) {
								Context c = MobGameSDK.getApplicationContext();
								HashSet<String> cookies = new HashSet<String>();

								for (String header : originalResponse.headers("Set-Cookie")) {
									cookies.add(header);
								}

								Preference.save(c, Constants.SHARED_PREF_COOKIES, cookies);
							}

							return originalResponse;
						}
					})
					.build();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return httpClient;
	}
	
	static OkHttpClient getCommonClient() {

		OkHttpClient httpClient = null;
		try {
			CookieManager cookieManager = new CookieManager();
			cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);

			httpClient = new OkHttpClient.Builder()
				.addInterceptor(new Interceptor() {
					@NonNull
					@Override
					public Response intercept(@NonNull Chain chain) throws IOException {
						Activity activity = MobGameSDK.activity;
						Context context = MobGameSDK.getApplicationContext();
						GameConfigManager config = GameConfigManager.getInstance();

						Request.Builder builder = chain.request()
								.newBuilder()
								.addHeader(Constants.MOBGAME_DEVICE, (DeviceUtils.getDevice()!= null) ? DeviceUtils.getDevice() :"")
								.addHeader(Constants.MOBGAME_OS, (DeviceUtils.getOSInfo()!=null) ? DeviceUtils.getOSInfo(): "")
								.addHeader(Constants.MOBGAME_RESOLUTION,( Objects.requireNonNull(DeviceUtils.getResolution(context)) != null) ?Objects.requireNonNull(DeviceUtils.getResolution(context)):"")
								.addHeader(Constants.MOBGAME_SDK_VERSION, (Utils.getSDKVersion(context) !=null)? Utils.getSDKVersion(context) :"")
								.addHeader(Constants.MOBGAME_APPKEY, (GameConfigManager.getInstance().getAppKey(activity) !=null) ? GameConfigManager.getInstance().getAppKey(activity) :"")
								.addHeader(Constants.MOBGAME_APP_VERSION_CODE, Utils.getGameVersionCode(context) )
								.addHeader(Constants.MOBGAME_NETWORK, (Utils.getNetwork(context)!=null) ?Utils.getNetwork(context) :"")
								.addHeader(Constants.MOBGAME_ORIENTATION, DeviceUtils.getScreenOrientation(context) + "");


						builder.addHeader(Constants.MOBGAME_APP_VERSION, Utils.getGameVersion(context)!=null ?Utils.getGameVersion(context):"");
						builder.addHeader(Constants.MOBGAME_REFERRER, Utils.getReferrer(context)!=null ?Utils.getReferrer(context):"");
						builder.addHeader(Constants.MOBGAME_LANG, DeviceUtils.getLanguage()!=null ?DeviceUtils.getLanguage():"");
						builder.addHeader(Constants.MOBGAME_ADVERTISING_ID, DeviceUtils.getAdvertisingID(context)!=null ? DeviceUtils.getAdvertisingID(context):"");
						builder.addHeader(Constants.MOBGAME_TOKEN, (config.getAccessToken()!=null)?config.getAccessToken():"");
						builder.addHeader(Constants.MOBGAME_ROLEID, config.getCharacterInfo().getRoleId()!=null?config.getCharacterInfo().getRoleId():"");
						builder.addHeader(Constants.MOBGAME_AREAID, config.getCharacterInfo().getAreaId()!=null?config.getCharacterInfo().getAreaId():"");
						builder.addHeader(Constants.MOBGAME_ROLENAME, config.getCharacterInfo().getRoleName()!=null?config.getCharacterInfo().getRoleName():"");
						builder.addHeader(Constants.MOBGAME_AREANAME, config.getCharacterInfo().getAreaName()!=null? config.getCharacterInfo().getAreaName():"");
						builder.addHeader(Constants.MOBGAME_APPSFLYER_ID, FunTrackingUtil.getInstance().getAppsflyerId(context)!=null?FunTrackingUtil.getInstance().getAppsflyerId(context):"");

						Request request = builder.build();
						return chain.proceed(request);
					}
				})
				.addInterceptor(new Interceptor() {
					@NonNull
					@Override
					public Response intercept(@NonNull Chain chain) throws IOException {
						Context c = MobGameSDK.getApplicationContext();
						Request.Builder builder = chain.request().newBuilder();
						HashSet<String> preferences = (HashSet<String>) Preference
								.getStringSet(c, Constants.SHARED_PREF_COOKIES,
										new HashSet<String>());
						for (String cookie : preferences) {
							builder.addHeader("Cookie", cookie);
						}

						return chain.proceed(builder.build());
					}
				})
				.addInterceptor(new Interceptor() {
					@NonNull
					@Override
					public Response intercept(@NonNull Chain chain) throws IOException {
						Response originalResponse = chain.proceed(chain.request());

						if (!originalResponse.headers("Set-Cookie").isEmpty()) {
							Context c = MobGameSDK.getApplicationContext();
							HashSet<String> cookies = new HashSet<String>();

							for (String header : originalResponse.headers("Set-Cookie")) {
								cookies.add(header);
							}

							Preference.save(c, Constants.SHARED_PREF_COOKIES, cookies);
						}

						return originalResponse;
					}
				})
				.build();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return httpClient;
	}
	
	static String decode(String responseBody) {
		try {
			JSONObject objEncode = new JSONObject(responseBody);
			if (objEncode.has("data")) {
				String data = objEncode.getString("data");
				byte[] decodeFromBase64 = Base64.decode(data, Base64.DEFAULT);
				return EncryptionUtils.decryptionDataBlowfish(decodeFromBase64);
			}
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return null;
	}
	public Call<ResponseBody> saveEventClient(String data){
		return restService.saveEventClient(data);
	}
	public Call<EncodedResponse> getPayItem(String sign) {
		return restService.getPayItem(sign);
	}

	public Call<ForceLogoutResponse> getCheckForceLogout() {
		return restService.getCheckForceLogout();
	}

	public Call<EncodedResponse> getInfoBeforeAuthen(String sign) {
		return restService.getInfoBeforeAuthen(sign);
	}

	public Call<EncodedResponse> getInfoAfterAuthen(String sign) {
		return restService.getInfoAfterAuthen(sign);
	}
	
	public Call<ResponseBody> saveFCM(String userId , String regId) {
		return restService.saveFCM(userId , regId);
	}
	public Call<ResponseBody> saveFCMOld(String regId) {
		return restService.saveFCMOld(regId);
	}

	public Call<ResponseBody> saveCharacter(String roleId, String areaId, String roleName, String areaName) {
		return restService.saveCharacter(roleId, areaId, roleName, areaName);
	}
	
	public Call<ResponseBody> processGooglePayment(String receipt) {
		return restService.googleRetrieveReceipt(receipt);
	}

	public Call<ResponseBody> processPaypalPayment(String receipt, String areaId, String roleId) {
		return restService.paypalRetrieveReceipt(receipt, areaId, roleId);
	}
	
	public Call<LoginResponse> upgradeToFacebook(String token) {
		return restService.upgradeToFacebook(token, "true");
	}
	public Call<EncodedResponse> getIngameNotiList(int tablet) {
		return restService.getIngameNoti(tablet);
	}

	public Call<ResponseBody> saveRead() {
		return restService.saveRead();
	}

	private interface PlfRestService {

		@GET("/plf/users/check")
		Call<ForceLogoutResponse> getCheckForceLogout();

		@GET("/plf/Games/infocf.json")
		Call<EncodedResponse> getPayItem(
				@Query("sign") String sign
		);

		@FormUrlEncoded
		@POST("/plf/Oauthv3/saveEventClient.json")
		Call<ResponseBody> saveEventClient(
				@Field("data") String data
		);
		@GET("/plf/Oauthv3/getInfoBeforeAuthFor3.json")
		Call<EncodedResponse> getInfoBeforeAuthen(
			@Query("sign") String sign
		);

		@POST("/plf/Oauthv3/getInfoAfterAuthFor3.json")
		Call<EncodedResponse> getInfoAfterAuthen(
			@Query("sign") String sign
		);

		@FormUrlEncoded
		@POST("/sdk/device-tokens/fcm")
		Call<ResponseBody> saveFCM(
			@Field("user_id") String userId,
			@Field("regid") String regId
		);

		@FormUrlEncoded
		@POST("/plf/Oauthv2/saveFCM.json")
		Call<ResponseBody> saveFCMOld(
				@Field("regid") String regId
		);

		@FormUrlEncoded
		@POST("/plf/Oauthv2/saveCharacter.json")
		Call<ResponseBody> saveCharacter(
			@Field("roleid") String roleId, 
			@Field("areaid") String areaId,
			@Field("rolename") String roleName,
			@Field("areaname") String areaName
		);

		@FormUrlEncoded
		@POST("/plf/payments/googleRetrieveReceipt.json")
		Call<ResponseBody> googleRetrieveReceipt(
			@Field("transaction_receipt") String receipt
		);

		@FormUrlEncoded
		@POST("/plf/payments/paypalRetrieveReceipt.json")
		Call<ResponseBody> paypalRetrieveReceipt(
			@Field("transaction_receipt") String receipt,
			@Field("game_area_id") String areaId,
			@Field("game_role_id") String roleId
		);
		
		@FormUrlEncoded
		@POST("/plf/users/updateFromFacebookV2")
		Call<LoginResponse> upgradeToFacebook(
			@Field("token") String token,
			@Field("native") String isJson
		);
		@POST("/plf/Oauthv3/saveReaded.json")
		Call<ResponseBody> saveRead();

		@GET("/plf/games/push_ms.json")
		Call<EncodedResponse> getIngameNoti(
				@Query("tablet") int tablet
		);
	}

	
}
