/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.utils;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.google.gson.Gson;
import com.mobgame.model.giftimage.GifData;
import com.mobgame.model.giftimage.ImageData;
import com.mobgame.utils.Preference;
import java.util.ArrayList;
import java.util.Calendar;

public class GifHelper {
    private static final String TAG = "GifHelper";
    private static int index = 0;
    private static GifData gifDataGlobal;

    private static void saveGifData(Context context, GifData gifData) {
        Preference.remove(context, "shared_pref_gif");
        Preference.save(context, "shared_pref_gif", new Gson().toJson((Object)gifData));
    }

    public static GifData getGifData(Context context) {
        String gifDataString = Preference.getString(context, "shared_pref_gif");
        Log.d((String)"getGifData", (String)gifDataString);
        return (GifData)new Gson().fromJson(gifDataString, GifData.class);
    }

    public static void fetchFramesImage(final Context context, GifData gifData) {
        gifDataGlobal = null;
        gifData.fetchFrameImages(context, new GifData.FetchDataListener(){

            @Override
            public void fail(String message) {
                Log.d((String)GifHelper.TAG, (String)("Fetch image data error: " + message));
            }

            @Override
            public void done(GifData gifData) {
                Log.d((String)GifHelper.TAG, (String)"Fetch gif data done! Saving...");
                GifHelper.saveGifData(context, gifData);
                GifHelper.playGif(context);
            }
        });
    }

    public static void playGif(Context context) {
        if (gifDataGlobal == null) {
            gifDataGlobal = GifHelper.getGifData(context);
        }
        ArrayList<ImageData> imageDatas = gifDataGlobal.getImages();
        long now = Calendar.getInstance().getTimeInMillis();
        GifHelper.runGif(context, now, imageDatas);
    }

    private static void runGif(final Context context, final long now, final ArrayList<ImageData> imageDatas) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                long runningTime = Calendar.getInstance().getTimeInMillis();
                long totalRunningTime = runningTime - now;
                if (totalRunningTime >= (long)(gifDataGlobal.getSecondsToRun() * 1000)) {
                    GifHelper.resetGifImage(context, (ImageData)imageDatas.get(0), true);
                    return;
                }
                GifHelper.updateNotificationBanner(context, ((ImageData)imageDatas.get(index)).getUrl(), false);
                if (index < imageDatas.size() - 1) {
                    index++;
                } else {
                    index = 0;
                }
                GifHelper.runGif(context, now, imageDatas);
            }
        }, gifDataGlobal.getMilisecondsToRefesh());
    }

    private static void updateNotificationBanner(Context context, String frameImageUrl, boolean pause) {
        Log.d((String)TAG, (String)("frameImageUrl: " + frameImageUrl));
        if (pause) {
            return;
        }
    }

    private static void resetGifImage(Context context, ImageData imageData, boolean reset) {
        GifHelper.updateNotificationBanner(context, imageData.getUrl(), reset);
    }
}

