/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.api;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Base64;
import com.mobgame.MobGameSDK;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.EncodedResponse;
import com.mobgame.model.ForceLogoutResponse;
import com.mobgame.model.LoginResponse;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.EncryptionUtils;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Utils;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.HashSet;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

class RestfulApi {
    private static final String API_BASE_URL = "https://a.smobgame.com";
    private static final String API_BASE_NOTI_TOKEN_URL = "https://interact-notify.platformjk.com";
    private static RestfulApi INSTANCE;
    private PlfRestService restService;
    private static Retrofit retrofit;

    public static RestfulApi getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RestfulApi(false);
        }
        return INSTANCE;
    }

    public static RestfulApi getInstance(boolean isSendToken) {
        if (INSTANCE == null) {
            INSTANCE = new RestfulApi(isSendToken);
        }
        return INSTANCE;
    }

    public static void removeInstance() {
        if (INSTANCE != null) {
            INSTANCE = null;
        }
    }

    private RestfulApi(boolean isSendToken) {
        try {
            OkHttpClient httpClient = isSendToken ? RestfulApi.getCommonClientForSendTokenFCM() : RestfulApi.getCommonClient();
            retrofit = new Retrofit.Builder().baseUrl(isSendToken ? API_BASE_NOTI_TOKEN_URL : API_BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(httpClient).build();
            this.restService = (PlfRestService)retrofit.create(PlfRestService.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static OkHttpClient getCommonClientForSendTokenFCM() {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        OkHttpClient httpClient = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

            public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
                Activity activity = MobGameSDK.activity;
                Context context = MobGameSDK.getApplicationContext();
                GameConfigManager config = GameConfigManager.getInstance();
                Request.Builder builder = chain.request().newBuilder().addHeader("device-name", DeviceUtils.getDevice()).addHeader("device-os", DeviceUtils.getOSInfo()).addHeader("sdk-locale", DeviceUtils.getLanguage()).addHeader("device-resolution", Objects.requireNonNull(DeviceUtils.getResolution(context))).addHeader("sdk-version", Utils.getSDKVersion(context)).addHeader("X-Request", GameConfigManager.getInstance().getAppKey((Context)activity)).addHeader("app-version", Utils.getGameVersion(context)).addHeader("network-type", Utils.getNetwork(context)).addHeader("device-scale", DeviceUtils.getScreenOrientation(context) + "").addHeader("advertising-id", DeviceUtils.getAdvertisingID(context));
                if (config.getAccessToken() != null) {
                    builder.addHeader("access-token", config.getAccessToken());
                }
                Request request = builder.build();
                return chain.proceed(request);
            }
        }).addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Context c = MobGameSDK.getApplicationContext();
                Request.Builder builder = chain.request().newBuilder();
                HashSet preferences = (HashSet)Preference.getStringSet(c, "shared_pref_cookies", new HashSet<String>());
                for (String cookie : preferences) {
                    builder.addHeader("Cookie", cookie);
                }
                return chain.proceed(builder.build());
            }
        }).addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                if (!originalResponse.headers("Set-Cookie").isEmpty()) {
                    Context c = MobGameSDK.getApplicationContext();
                    HashSet<String> cookies = new HashSet<String>();
                    for (String header : originalResponse.headers("Set-Cookie")) {
                        cookies.add(header);
                    }
                    Preference.save(c, "shared_pref_cookies", cookies);
                }
                return originalResponse;
            }
        }).build();
        return httpClient;
    }

    static OkHttpClient getCommonClient() {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        OkHttpClient httpClient = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

            public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
                Activity activity = MobGameSDK.activity;
                Context context = MobGameSDK.getApplicationContext();
                GameConfigManager config = GameConfigManager.getInstance();
                Request.Builder builder = chain.request().newBuilder().addHeader("mobgame-device", DeviceUtils.getDevice()).addHeader("mobgame-os", DeviceUtils.getOSInfo()).addHeader("mobgame-resolution", Objects.requireNonNull(DeviceUtils.getResolution(context))).addHeader("mobgame-sdk-version", Utils.getSDKVersion(context)).addHeader("mobgame-appkey", GameConfigManager.getInstance().getAppKey((Context)activity)).addHeader("mobgame-app-version", Utils.getGameVersion(context)).addHeader("mobgame-app-version-code", Utils.getGameVersionCode(context)).addHeader("mobgame-network", Utils.getNetwork(context)).addHeader("mobgame-orientation", DeviceUtils.getScreenOrientation(context) + "").addHeader("mobgame-distributor", Utils.getReferrer(context)).addHeader("mobgame_lang", DeviceUtils.getLanguage()).addHeader("mobgame-advertising-id", DeviceUtils.getAdvertisingID(context)).addHeader("mobgame-appsflyer-id", DeviceUtils.getAppsflyerUID(context));
                if (config.getAccessToken() != null) {
                    builder.addHeader("mobgame-token", config.getAccessToken());
                }
                if (config.getCharacterInfo().getRoleId() != null) {
                    builder.addHeader("mobgame-role-id", config.getCharacterInfo().getRoleId());
                }
                if (config.getCharacterInfo().getAreaId() != null) {
                    builder.addHeader("mobgame-area-id", config.getCharacterInfo().getAreaId());
                }
                if (config.getCharacterInfo().getRoleName() != null) {
                    builder.addHeader("mobgame-role-name", config.getCharacterInfo().getRoleName());
                }
                if (config.getCharacterInfo().getAreaName() != null) {
                    builder.addHeader("mobgame-area-name", config.getCharacterInfo().getAreaName());
                }
                if (FunTrackingUtil.getInstance().getAppsflyerId(context) != null) {
                    builder.addHeader("mobgame-appsflyer-id", FunTrackingUtil.getInstance().getAppsflyerId(context));
                }
                Request request = builder.build();
                return chain.proceed(request);
            }
        }).addInterceptor(new Interceptor(){

            public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
                Context c = MobGameSDK.getApplicationContext();
                Request.Builder builder = chain.request().newBuilder();
                HashSet preferences = (HashSet)Preference.getStringSet(c, "shared_pref_cookies", new HashSet<String>());
                for (String cookie : preferences) {
                    builder.addHeader("Cookie", cookie);
                }
                return chain.proceed(builder.build());
            }
        }).addInterceptor(new Interceptor(){

            public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                if (!originalResponse.headers("Set-Cookie").isEmpty()) {
                    Context c = MobGameSDK.getApplicationContext();
                    HashSet<String> cookies = new HashSet<String>();
                    for (String header : originalResponse.headers("Set-Cookie")) {
                        cookies.add(header);
                    }
                    Preference.save(c, "shared_pref_cookies", cookies);
                }
                return originalResponse;
            }
        }).build();
        return httpClient;
    }

    static String decode(String responseBody) {
        try {
            JSONObject objEncode = new JSONObject(responseBody);
            if (objEncode.has("data")) {
                String data = objEncode.getString("data");
                byte[] decodeFromBase64 = Base64.decode((String)data, (int)0);
                return EncryptionUtils.decryptionDataBlowfish(decodeFromBase64);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Call<ResponseBody> saveEventClient(String data) {
        return this.restService.saveEventClient(data);
    }

    public Call<EncodedResponse> getPayItem(String sign) {
        return this.restService.getPayItem(sign);
    }

    public Call<ForceLogoutResponse> getCheckForceLogout() {
        return this.restService.getCheckForceLogout();
    }

    public Call<EncodedResponse> getInfoBeforeAuthen(String sign) {
        return this.restService.getInfoBeforeAuthen(sign);
    }

    public Call<EncodedResponse> getInfoAfterAuthen(String sign) {
        return this.restService.getInfoAfterAuthen(sign);
    }

    public Call<ResponseBody> saveFCM(String userId, String regId) {
        return this.restService.saveFCM(userId, regId);
    }

    public Call<ResponseBody> saveFCMOld(String regId) {
        return this.restService.saveFCMOld(regId);
    }

    public Call<ResponseBody> saveCharacter(String roleId, String areaId, String roleName, String areaName) {
        return this.restService.saveCharacter(roleId, areaId, roleName, areaName);
    }

    public Call<ResponseBody> processGooglePayment(String receipt) {
        return this.restService.googleRetrieveReceipt(receipt);
    }

    public Call<ResponseBody> processPaypalPayment(String receipt, String areaId, String roleId) {
        return this.restService.paypalRetrieveReceipt(receipt, areaId, roleId);
    }

    public Call<LoginResponse> upgradeToFacebook(String token) {
        return this.restService.upgradeToFacebook(token, "true");
    }

    public Call<EncodedResponse> getIngameNotiList(int tablet) {
        return this.restService.getIngameNoti(tablet);
    }

    public Call<ResponseBody> saveRead() {
        return this.restService.saveRead();
    }

    private static interface PlfRestService {
        @GET(value="/plf/users/check")
        public Call<ForceLogoutResponse> getCheckForceLogout();

        @GET(value="/plf/Games/infocf.json")
        public Call<EncodedResponse> getPayItem(@Query(value="sign") String var1);

        @FormUrlEncoded
        @POST(value="/plf/Oauthv3/saveEventClient.json")
        public Call<ResponseBody> saveEventClient(@Field(value="data") String var1);

        @GET(value="/plf/Oauthv3/getInfoBeforeAuthFor3.json")
        public Call<EncodedResponse> getInfoBeforeAuthen(@Query(value="sign") String var1);

        @POST(value="/plf/Oauthv3/getInfoAfterAuthFor3.json")
        public Call<EncodedResponse> getInfoAfterAuthen(@Query(value="sign") String var1);

        @FormUrlEncoded
        @POST(value="/sdk/device-tokens/fcm")
        public Call<ResponseBody> saveFCM(@Field(value="user_id") String var1, @Field(value="regid") String var2);

        @FormUrlEncoded
        @POST(value="/plf/Oauthv2/saveFCM.json")
        public Call<ResponseBody> saveFCMOld(@Field(value="regid") String var1);

        @FormUrlEncoded
        @POST(value="/plf/Oauthv2/saveCharacter.json")
        public Call<ResponseBody> saveCharacter(@Field(value="roleid") String var1, @Field(value="areaid") String var2, @Field(value="rolename") String var3, @Field(value="areaname") String var4);

        @FormUrlEncoded
        @POST(value="/plf/payments/googleRetrieveReceipt.json")
        public Call<ResponseBody> googleRetrieveReceipt(@Field(value="transaction_receipt") String var1);

        @FormUrlEncoded
        @POST(value="/plf/payments/paypalRetrieveReceipt.json")
        public Call<ResponseBody> paypalRetrieveReceipt(@Field(value="transaction_receipt") String var1, @Field(value="game_area_id") String var2, @Field(value="game_role_id") String var3);

        @FormUrlEncoded
        @POST(value="/plf/users/updateFromFacebookV2")
        public Call<LoginResponse> upgradeToFacebook(@Field(value="token") String var1, @Field(value="native") String var2);

        @POST(value="/plf/Oauthv3/saveReaded.json")
        public Call<ResponseBody> saveRead();

        @GET(value="/plf/games/push_ms.json")
        public Call<EncodedResponse> getIngameNoti(@Query(value="tablet") int var1);
    }
}

