package com.mobgame;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.AppOpsManager;
import android.app.Application.ActivityLifecycleCallbacks;
import android.app.Dialog;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.design.widget.Snackbar;
import android.support.v4.content.LocalBroadcastManager;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Animation.AnimationListener;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import android.webkit.CookieSyncManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.appsflyer.AFInAppEventParameterName;
import com.appsflyer.AFInAppEventType;
import com.appsflyer.AppsFlyerLib;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.widget.ShareDialog;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.gson.Gson;
import com.mobgame.api.GetCheckForceLogoutTask;
import com.mobgame.api.GetInfoAfterAuthenTask;
import com.mobgame.api.GetInfoBeforeAuthenTask;
import com.mobgame.api.GetIngameNotificationTask;
import com.mobgame.api.GetPayItemTask;
import com.mobgame.api.LogoutTask;
import com.mobgame.api.RegisterTokenAndTask;
import com.mobgame.api.SaveCharacterTask;
import com.mobgame.component.EventClientManager;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAuthManager;
import com.mobgame.gui.BannerDialogFragment;
import com.mobgame.gui.DialogInGameFragment;
import com.mobgame.gui.MobGameActivity;
import com.mobgame.gui.MobGameLoginActivity;
import com.mobgame.gui.dialog.MobGameDashboardNewDialog;
import com.mobgame.gui.dialog.MobGameDialogStartWebFragment;
import com.mobgame.gui.dialog.MobGameDialogWebviewFragment;
import com.mobgame.gui.dialog.MobGameHaveBackButtonFragment;
import com.mobgame.gui.dialog.MobGamePayDialogFragment;
import com.mobgame.js.CmdDashboard;
import com.mobgame.js.CmdPayment;
import com.mobgame.model.Game;
import com.mobgame.model.IngameNoti;
import com.mobgame.model.ItemDeepLink;
import com.mobgame.model.MItemPayment;
import com.mobgame.model.MUrl;
import com.mobgame.model.MobMenuItem;
import com.mobgame.model.NtfModel;
import com.mobgame.model.UserInfo;
import com.mobgame.model.giftimage.GifData;
import com.mobgame.notification.MobFirebaseMessagingService;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.GifHelper;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ExecutionException;

import funs.adds.android.sdk.component.callback.AdsFunListener;
import funs.adds.android.sdk.component.factory.RequestAdsFun;

import static com.mobgame.gui.MobGameWebFragment.HIDE_SWIPE;
import static com.mobgame.utils.Constants.DEEP_LINK_NOTIFICATION_BANNER;
import static com.mobgame.utils.Constants.DEEP_LINK_NOTIFICATION_DASHBOARD;
import static com.mobgame.utils.Constants.DEEP_LINK_NOTIFICATION_GIFTCODE;
import static com.mobgame.utils.Constants.DEEP_LINK_NOTIFICATION_URL;
import static com.mobgame.utils.Constants.DEEP_LINK_WEBVIEW;

@SuppressWarnings("deprecation")
public class MobGameSDK {

    private static final String TAG = MobGameSDK.class.getSimpleName();
    private static MobGameSDK INSTANCE;
    private static final int OVERLAY_PERMISSION_REQ_CODE = 222;

    public static Activity activity;
    public static Activity currentActivity;
    public static Context applicationContext;
    private Intent intentDeepLink;
    private SensorManager sensorManager;
    private Sensor accelerometerSensor;
    private boolean accelerometerPresent;
    private MobGameListener mListener;

    private boolean clickLogout = false;
    private boolean isLogout = false;
    private boolean canDraw;
    private AppOpsManager.OnOpChangedListener onOpChangedListener = null;

    private static boolean shouldShowFloatButton;
//    private static boolean shouldShowPopup;
    // private int countViberate = 0;

    private ArrayList<String> queuePopups = new ArrayList<String>();
    private static final String POPUP_HELLO = "popup_hello";
    //    private static final String POPUP_NTFS = "popup_ntfs";
    private static final String POPUP_LINK = "pop_link";
    //    private static final String POPUP_DEEP_LINK = "pop_deep_link";
    private static final String POPUP_FLOAT_BUTTON = "popup_float_button";
    private static final String POPUP_ADS = "popup_ads";
    private static final long TIMEOUT_DISMISS_FLOAT_BUTTON = 24 * 60 * 60 * 1000; // 24
    // hours
    private int menuId;
    private boolean isShowAds = false;
    private boolean isShowPopupLink = false;
    private boolean isPauseForHideFloatButton = false;

    private float mAccelCurrent = SensorManager.GRAVITY_EARTH;
    private float mAccel;
    private long startSession = 0;
    private int scrollAnimIndex = 0;
    private int scrollAnimRepeatCount = 0;
    public static String PACKAGE_NAME;
    private ArrayList<TextView> textViews;
    private boolean isScrollingText = false;
    private static View viewNotice;
    private ObjectAnimator scrollTextAnimation;
    private FrameLayout scrollTextLayout;
    private Timer scrollTextTimer;
    private static final long PERIOD_TO_SEND_REQUEST_GET_NOTI = 600000; //10 minitues 600000 milisec
    private static final long PERIOD_BETWEEN_TWO_NOTIFICATION = 5000;
    private long startPointOfOneScrollingTextNow = 0;
    private long durationOfOneScrollingTextNow = 0;
    private Game.Ex ex;

    //    private boolean isShaking = false;
    private SensorEventListener accelerometerListener = new SensorEventListener() {


        @Override
        public void onAccuracyChanged(Sensor event, int accuracy) {
        }

        @Override
        public void onSensorChanged(SensorEvent event) {
            try {

                // Shake detection
                float x = event.values[0];
                float y = event.values[1];
                float z = event.values[2];
                float mAccelLast = mAccelCurrent;
                mAccelCurrent = (float) Math.sqrt(x * x + y * y + z * z);
                float delta = mAccelCurrent - mAccelLast;
                mAccel = mAccel * 0.9f + delta;
                if (mAccel > 3f
                        && !Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_CONFIRM_DIALOG_HIDE_FLOAT, false)
                        && !Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_DASHBOARD, false)) {
                    Log.d(TAG, "VAO SENSOR");
                    Preference.remove(activity, Constants.SHARED_PREF_FLOAT_BUTTON_DISMISS_TIME);
                    Preference.remove(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON);
                    Preference.remove(activity, Constants.SHARED_PREF_SHOW_CONFIRM_DIALOG_HIDE_FLOAT);
                    Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);

                    Intent intent = new Intent(Constants.INTENT_FILTER);
                    intent.putExtra("category", "show_float_button");
                    LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private boolean loginProcessDone = false;
    private boolean isHaveDeepLink;

    private MobGameSDK() {
    }

    public static MobGameSDK getInstance() {
        if (INSTANCE == null) {
            synchronized (MobGameSDK.class) {
                if (INSTANCE == null) {
                    INSTANCE = new MobGameSDK();
                }
            }
        }
        return INSTANCE;

//        if (INSTANCE == null) {
//            INSTANCE = new MobGameSDK();
//        }
//        return INSTANCE;
    }

    @SuppressLint("MissingPermission")
    public void init(Activity activity, String appkey) {
        Log.i(TAG, "MobGameSDK");
        PACKAGE_NAME = getApplicationContext().getPackageName();
        MobGameSDK.activity = activity;
        applicationContext = activity.getApplicationContext();
        Preference.save(activity, Constants.SHARED_PREF_MAIN_ACTIVITY,
                activity.getClass().getName());
        MobGameHelper.doHideFloatButton = false;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            canDraw = Settings.canDrawOverlays(activity);
        }

//        long timeendSession = Preference.getLong(activity, Constants.END_SESSION, 0);
//        Log.i(TAG, "endSession" + timeendSession);
//        if (timeendSession != 0){
//            endSession(timeendSession - startSession);
//        }
        makeInstallReferrerClient(activity);
        if (mListener == null) {
            setMobGameListener(new MobGameListener() {

                @Override
                public void onPaySuccessful(String userId, String orderId,
                                            String orderProduct, String orderInfo,
                                            String orderTime, String platformPrice,
                                            String gamePrice, String state, String game_role_id,
                                            String game_area_id, String is_sandbox) {
                }

                @Override
                public void onLoginSuccessful(String userId , String accountID,
                                              String accessToken) {
                    try {
                        AppsFlyerLib.getInstance().setCustomerUserId(GameConfigManager.getInstance().getUserInfo().getUser().getUserId());
                        Log.d(TAG, "onLoginSuccessful: appsflyer UID: " + AppsFlyerLib.getInstance().getAppsFlyerUID(getApplicationContext()));

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onError(int errorCode, String message) {
                }

                @Override
                public void onLoginFormClose() {

                }

                @Override
                public void onLogoutSucessful(String roleId) {

                }
            });
        }

        try {
            GameConfigManager.getInstance().setAppKey(activity, appkey);
            EventClientManager.getInstance(activity).setMobgameAppkey(appkey);
            activity.getApplication().unregisterActivityLifecycleCallbacks(mActivityLifecycleCallbacks);
            activity.getApplication().registerActivityLifecycleCallbacks(mActivityLifecycleCallbacks);
            activity.getApplication().unregisterComponentCallbacks(mComponentCallbacks);
            activity.getApplication().registerComponentCallbacks(mComponentCallbacks);

            // activity.onCreate()
            LocalBroadcastManager.getInstance(activity.getApplicationContext())
                    .registerReceiver(mGlobalMessageReceiver, new IntentFilter(Constants.INTENT_FILTER));

            CookieSyncManager.createInstance(activity.getApplicationContext());

            sensorManager = (SensorManager) activity.getSystemService(Context.SENSOR_SERVICE);
            List<Sensor> sensorList = sensorManager.getSensorList(Sensor.TYPE_ACCELEROMETER);

            if (sensorList.size() > 0) {
                accelerometerPresent = true;
                accelerometerSensor = sensorList.get(0);
            } else {
                accelerometerPresent = false;
            }
            String firebaseToken = FirebaseInstanceId.getInstance().getToken();
            Log.e(TAG, "Firebase Token/regId: " + firebaseToken);
            if (appkey != null) {
                MobFirebaseMessagingService.getInstance().sendRegistrationToServer(firebaseToken);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }


        Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);
        loadPaymentItems();
        checkTimeText();
    }

    public void onDestroySDK(){
        long timeendSession = System.currentTimeMillis();
        Preference.save(activity ,Constants.END_SESSION , timeendSession);
        Log.d(TAG , "onDestroy Vao day");
        endSession(timeendSession - startSession);
    }

    InstallReferrerClient referrerClient;
    private void makeInstallReferrerClient(Activity activity){
        try {
            referrerClient = InstallReferrerClient.newBuilder(activity).build();
            referrerClient.startConnection(new InstallReferrerStateListener() {
                @Override
                public void onInstallReferrerSetupFinished(int responseCode) {
                    switch (responseCode) {
                        case InstallReferrerClient.InstallReferrerResponse.OK:
                            // Connection established.
                            try {
                                ReferrerDetails response = referrerClient.getInstallReferrer();
                                String referrer = response.getInstallReferrer();
                                Log.d(TAG , "referrer : " + referrer);
                                Utils.setReferrer(activity, referrer);
                                referrerClient.endConnection();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        case InstallReferrerClient.InstallReferrerResponse.FEATURE_NOT_SUPPORTED:
                            // API not available on the current Play Store app.
                            break;
                        case InstallReferrerClient.InstallReferrerResponse.SERVICE_UNAVAILABLE:
                            // Connection couldn't be established.
                            break;
                    }
                }

                @Override
                public void onInstallReferrerServiceDisconnected() {
                    // Try to restart the connection on the next request to
                    // Google Play by calling the startConnection() method.
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    CountDownTimer countDownTimer ;
    boolean checkTimeInited = false;
    private void checkTimeText() {
        try {
            checkTimeInited = true;
            countDownTimer = new CountDownTimer(60 * 10 * 1000, 1000) {

                public void onTick(long millisUntilFinished) {
                }

                public void onFinish() {

                    new GetIngameNotificationTask(MobGameSDK.activity, new GetIngameNotificationTask.Listener() {
                        @Override
                        public void onSuccess(ArrayList<IngameNoti> notiList) {
                            if (notiList.size() > 0) {
                                showTextScroll(notiList);
                            }
                        }

                        @Override
                        public void onFailure(Throwable t) {
//                            Log.e("List", t.getMessage());
                        }
                    }).execute();
                    checkTimeText();
                }
            }.start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkForceLogout() {
        new GetCheckForceLogoutTask(activity, new GetCheckForceLogoutTask.Listener() {
            @Override
            public void onSuccess(Boolean isAuth) {
                Log.i(TAG, "GO checkForceLogout");
                if (!isAuth) {
                    showDialog();
                }
            }

            @Override
            public void onFailure(Throwable t) {
                Log.i("TAG", "onFailureCheckForceLogoutTask :");
            }
        }).execute();
    }

    private void loadPaymentItems() {
        new GetPayItemTask(activity, new GetPayItemTask.Listener() {
            @Override
            public void onFailure(Throwable t) {

            }

            @Override
            public void onSuccess(ArrayList<MItemPayment> listItem) {
                // TODO Auto-generated method stub

            }
        }).execute();
    }

    public static Context getApplicationContext() {
        if (activity == null && applicationContext != null) {
            return applicationContext;
        }
        if (activity == null && currentActivity != null) {
            return currentActivity.getApplicationContext();
        }
        return activity.getApplicationContext();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Log.i(TAG, "onActivityResult:requestCode=" + requestCode
                + ";resultCode=" + resultCode);
        try {
            switch (requestCode) {
                case Constants.REQUEST_CODE_LOGIN_PLAY_SERVICES:
                    GoogleAuthManager.getInstance().onActivityResult(requestCode, resultCode, data);
                    break;
                case Constants.REQUEST_CODE_FACEBOOK_LOGIN:
                case Constants.REQUEST_CODE_FACEBOOK_SHARE:
                case Constants.REQUEST_CODE_FACEBOOK_INVITE:
                    FacebookManager.getInstance().onActivityResult(requestCode,
                            resultCode, data);
                    break;
                case Constants.REQUEST_CODE_FACEBOOK_INVITE_GAME:
                    FacebookManager.getInstance().onActivityResult(requestCode,
                            resultCode, data);
                    break;
                case Constants.REQUEST_CODE_GOOGLE_IN_APP_BILLING:
                    CmdPayment.getInstance().handleResult(activity, requestCode,
                            resultCode, data);
                    break;
                case Constants.REQUEST_OVERLAY_PERMISSION:
                    requestOverlayPermission(activity);
                    break;
                case Constants.REQUEST_CODE_PICKER:
                    CmdDashboard.getInstance().handleResult(activity, requestCode,
                            resultCode, data);
                    break;
                default:
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @TargetApi(19)
    public void onWindowFocusChanged(boolean hasFocus) {
        try {
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.KITKAT) {
                if (DeviceUtils.hasHardwareButtons()) {
                    if (hasFocus) {
                        activity.getWindow()
                                .getDecorView()
                                .setSystemUiVisibility(
                                        View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                                                | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                                                | View.SYSTEM_UI_FLAG_FULLSCREEN
                                                | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
                    }
                } else {
                    if (hasFocus) {
                        activity.getWindow()
                                .getDecorView()
                                .setSystemUiVisibility(
                                        View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                                                | View.SYSTEM_UI_FLAG_FULLSCREEN
                                                | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
                    }
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    private String deepLink;
    private void login(String deeplink){
        this.deepLink = deeplink;
        login();
    }
    public void login() {
        try {
            Log.i(TAG, "login");
            if (GameConfigManager.getInstance().getGameConfig() == null) {
                getGameInfoRemote();
                return;
            }
            if (isLoggedIn()) {
                return;
            }
            loginProcessDone = false;
            shouldShowFloatButton = false;
            if (!isLoggedIn() && activity != null) {
//                Intent intent = new Intent(activity, MobGameActivity.class);
//                intent.putExtra(MobGameActivity.KEY_DATA, "{'action':'" + Constants.URL_USER + "'}");
//                intent.putExtra(MobGameActivity.FORM, HIDE_SWIPE);
//                activity.startActivity(intent);

                Intent intent = new Intent(activity, MobGameLoginActivity.class);
                intent.putExtra(MobGameLoginActivity.KEY_DATA, "[{'action':'" + Constants.URL_USER + "'}]");
                intent.putExtra(MobGameLoginActivity.KEY_ENABLE_AUTOHIDE_HEADER_BAR, false);
                intent.putExtra(MobGameLoginActivity.KEY_ENABLE_SIDE_MENU, false);
                intent.putExtra(MobGameLoginActivity.KEY_IS_LOGIN_FORM, true);
                activity.startActivity(intent);
                try {
                    FunTrackingUtil.getInstance().trackOpenFormLogin(activity);
                    long timeOpenFormPayment = System.currentTimeMillis();
                    long startTime = Preference.getLong(activity, Constants.START_SESSION, 0);
                    long deltaTime = timeOpenFormPayment - startTime;
                    if (!isLogout) {
                        FunTrackingUtil.getInstance().trackLoadTime(activity, deltaTime);
                    }
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            EventClientManager.getInstance(activity).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, FunTrackingUtil.TRACK_FORM_LOGIN_OPENED, null);
                        }
                    }).start();
                } catch (Exception e) {
                    e.printStackTrace();
                }

            } else {
                handleLogin(false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void logout(boolean forceLogout) {
        logout();
    }

    boolean isLogoutClick = false;

    public void logout() {
        try {
            if (!loginProcessDone) {
                Log.d(TAG, "logout: login not done");
                return;
            }
            Log.i(TAG, "logout");
            new LogoutTask(new LogoutTask.OnLogoutSuccessfulListener() {
                @Override
                public void onLogoutSuccessfull(String roleId) {
                    if (mListener != null) {
                        try {
                            activity.runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    mListener.onLogoutSucessful(roleId);
                                    FunTrackingUtil.getInstance().trackLogoutSuccess(activity,roleId);

                                }
                            });
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).execute();
            queuePopups.clear();
            Preference.remove(activity, GameConfigManager.SHARED_PREF_MACCESS_TOKEN);
            Preference.remove(activity, Constants.SHARED_PREF_FLOAT_BUTTON_DISMISS_TIME);
            Preference.remove(currentActivity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON);
            FunTrackingUtil.getInstance().trackingLogout(currentActivity);
            isLogout = true;
            new Thread(new Runnable() {
                @Override
                public void run() {
                    EventClientManager.getInstance(activity).saveEventClient(EventClientManager.SAVE_EVENT_END_SESSION, FunTrackingUtil.TRACK_EVENT_LOGOUT, null);
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * This function is used to exit the game or immediately exit the app, but do not call logout so do not exit the SDK.
     */
    public static void onBackPressed() {
        try {
            long endSession = System.currentTimeMillis();
            long startSession = Preference.getLong(activity, Constants.START_SESSION, 0);
            Log.d(TAG, "onDestroy");
            Preference.remove(activity, Constants.START_SESSION);
            MobGameSDK.getInstance().endSession(endSession - startSession);
            Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);
            System.gc();
            System.exit(0);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    public void endSession(long deltaSession) {
        try {
            Log.i(TAG, "endSession");
            FunTrackingUtil.getInstance().trackSession(currentActivity, deltaSession);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void payment() {
        payment(null);
    }

    public void payment(String state) {
        try {
            Log.i(TAG, "payment:" + state);
            if (GameConfigManager.getInstance().getGameConfig() == null) {
                getGameInfoRemote();
                return;
            }
            if (isShowingHello) {
                Log.d(TAG, "showingHello");
                return;
            }
            if (!isLoggedIn()) {
                Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT).show();
            } else {
                String url = Constants.URL_PAYMENT;
                if (!TextUtils.isEmpty(state)) {
                    url += "?state=" + state;
                }
                Log.d(TAG, url);
                Intent intent = new Intent(activity, MobGameActivity.class);
                intent.putExtra(MobGameActivity.KEY_DATA, "[{'action':'" + url + "'}]");
                intent.putExtra(MobGameActivity.FORM, HIDE_SWIPE);
                activity.startActivity(intent);
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                    }
                }).start();

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paymentNative() {
        paymentNative(null);
    }

    public void paymentNative(String state) {
        Log.i(TAG, "payment:" + state);
        if (GameConfigManager.getInstance().getGameConfig() == null) {
            getGameInfoRemote();
            return;
        }
        if (!isLoggedIn()) {
            try {
                Toast.makeText(activity, "You must login first",
                        Toast.LENGTH_SHORT).show();
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                MobGameHelper.hideNotiFloatButton();
                FragmentManager fm = activity.getFragmentManager();
                MobGamePayDialogFragment dialogFragment = new MobGamePayDialogFragment();
                dialogFragment.show(fm, "dialog_payment");
                isShowSocialDialog = true;
                dialogFragment.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialogInterface) {
                        Log.d(TAG,
                                "alo alo 2 : "
                                        + Utils.isDashboardEnabled(activity));
                        boolean isNotHideFloatButton = Preference
                                .getBoolean(
                                        activity,
                                        Constants.SHARED_PREF_HIDE_FLOAT_BUTTON,
                                        true);
                        boolean isEnableDashboard = Utils
                                .isDashboardEnabled(activity);
                        Log.d(TAG, "isNotHideFloatButton: "
                                + isNotHideFloatButton);
                        Log.d(TAG, "isEnableDashboard: "
                                + isEnableDashboard);
                        isShowSocialDialog = false;
                        boolean isShowLogo = GameConfigManager.getInstance().getGameConfig().getEx().isShowLogo();
                        if (!isShowSocialDialog && isShowLogo)
                            MobGameHelper.showNotiFloatButton(ex);
                    }
                });
            } catch (Exception e) {
                e.printStackTrace();
            }

        }

    }

    public String[] funShow() {
        String[] funShow = new String[2];
        try {
            UserInfo.User users = GameConfigManager.getInstance().getUserInfo().getUser();
            if (users.getVip() != null) {
                funShow[0] = users.getVip();
            }
            if (users.getVipImage() != null) {
                funShow[1] = users.getVipImage();
            } else {
                funShow[0] = "";
                funShow[1] = "";
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return funShow;
    }

    public void customUrl(String url) {
        try {
            if (GameConfigManager.getInstance().getGameConfig() == null) {
                getGameInfoRemote();
                return;
            }
            if (!isLoggedIn()) {
                Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT).show();
            } else {
                MobGameDialogStartWebFragment dialogStartWebFragment = new MobGameDialogStartWebFragment(activity, "custom_url", url);
                dialogStartWebFragment.show(activity.getFragmentManager(), "dialog webview");
                isShowPopupLink = true;
                dialogStartWebFragment.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {
                        isShowPopupLink = false;
                        Intent intent = new Intent(Constants.INTENT_FILTER);
                        intent.putExtra("category", "float_button");
                        LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    }
                });
                hideNotiFloatButton();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean isShowSocialDialog = false;

    private void showFragmentHaveBackButton(String url, boolean isEncrypted) {
        try {
            if (url != null && !url.equals("")) {
                FragmentManager fm = activity.getFragmentManager();
                MobGameHaveBackButtonFragment fr = (MobGameHaveBackButtonFragment) fm
                        .findFragmentByTag(Constants.TAG_FRAGMENT2);

                isShowSocialDialog = true;
                if (fr == null) {
                    fr = new MobGameHaveBackButtonFragment(new MUrl(url, isEncrypted));
                    fr.setOnDismissListener(new DialogInterface.OnDismissListener() {

                        @Override
                        public void onDismiss(DialogInterface dialog) {
                            if (isShowSocialDialog
                                    && Preference
                                    .getBoolean(
                                            activity,
                                            Constants.SHARED_PREF_HIDE_FLOAT_BUTTON,
                                            true)
                                    && Utils.isDashboardEnabled(activity)) {
                                Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);
                            }
                            isShowSocialDialog = false;
                        }
                    });
                    FragmentTransaction fragmentTransaction = fm.beginTransaction();
                    fragmentTransaction.add(fr, Constants.TAG_FRAGMENT);
                    // fragmentTransaction.commit();
                    fragmentTransaction.commitAllowingStateLoss();
                } else {
                    try {
                        fr.loadUrlWithMobHeaders(new MUrl(url, isEncrypted));
                    } catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                Log.d(TAG, "url null");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeFormLogin() {
        if (mListener != null)
            mListener.onLoginFormClose();
        close();
    }

    public void close() {
        close(true);
    }

    private void close(boolean check) {
        try {
            Intent i = new Intent(Constants.INTENT_FILTER);
            i.putExtra("category", "dashboard_close");
            LocalBroadcastManager.getInstance(activity).sendBroadcast(i);
            if(!GameConfigManager.getInstance().getMobPopup().is_show() && !GameConfigManager.getInstance().getShow_qc())
                queuePopups.add(POPUP_FLOAT_BUTTON);

//            if (check) {
//                showPopup();
//            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUserConfig(String mAreaId, String mAreaName, String mRoleId, String mRoleName) {
        try {
            Log.i(TAG, "setUserConfig: area_id=" + mAreaId + ";role_id=" + mRoleId
                    + ";area_name=" + mAreaName + ";role_name=" + mRoleName);
            (new SaveCharacterTask(mAreaId, mAreaName, mRoleId, mRoleName))
                    .execute();
            EventClientManager.getInstance(activity).setMobgameRoleId(mRoleId);
            EventClientManager.getInstance(activity).setMobgameRoleName(mRoleName);
            EventClientManager.getInstance(activity).setMobgameAreaId(mAreaId);
            EventClientManager.getInstance(activity).setMobgameAreaName(mAreaName);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showSnackBar(View view){
        Snackbar snackbar = Snackbar
                .make(view, "Confirm detete?", Snackbar.LENGTH_LONG)
                .setAction("YESSSSSSSSSSSSSS", new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        Snackbar mSnackbar = Snackbar.make(view, "Message successfully deleted.", Snackbar.LENGTH_SHORT);
                        mSnackbar.show();
                    }
                });

        snackbar.show();
    }


    public boolean isLoggedIn() {
        return !TextUtils.isEmpty(GameConfigManager.getInstance()
                .getAccessToken());
    }

    private void handleLogin(final boolean autoLogin) {
        try {
            (new GetInfoAfterAuthenTask(new GetInfoAfterAuthenTask.Listener() {

                @Override
                public void onSuccess(UserInfo userInfo) {
                    try {
                        GameConfigManager.getInstance().setUserInfo(userInfo);

                        if (userInfo != null) {
                            String userId = GameConfigManager.getInstance().getUserInfo().getUser().getUserId();
                            String accountId = GameConfigManager.getInstance().getUserInfo().getUser().getAccountId();
                            String accessToken = GameConfigManager.getInstance().getAccessToken();
                            mListener.onLoginSuccessful(
                                    userId,
                                    accountId,
                                    accessToken);

                            if (userInfo.isEnableTimer()) {
                                FloatButtonTimerHelper.enableFloatButtonTimer(activity, userInfo.isEnableTimer());
                                FloatButtonTimerHelper.saveFloatButtonTimer(activity, new Gson().toJson(
                                        userInfo.getTimerData()));
                            }
                            clickLogout = false;
//                            initAds();
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void forceLogout() {
                    clickLogout = false;
                    isLogout = true;
                    if (android.os.Build.VERSION.SDK_INT <= 19) {
                        CmdDashboard.getInstance().removeGC();
                    } else {
                        CmdDashboard.getInstance().hideGiftCode();
                    }
                    queuePopups.clear();
                    isLogoutClick = true;

                    showDialog();
                }

                @Override
                public void onFailure(Throwable t) {
                    logout(true);
                    mListener.onError(MobGameListener.ERROR_LOGIN,
                            "Unable to login to MobGame server");
                }

            })).execute();
        } catch (Exception e) {
            e.printStackTrace();
        }
        clickLogout = false;
        isLogout = false;
        CmdDashboard.getInstance().removeGC();
    }

    public void showPopup() {
        if (queuePopups == null || queuePopups.isEmpty()) {
            return;
        }
        try {
            String popup = queuePopups.get(0);
            Log.d(TAG, "Show popup: " + popup);
            queuePopups.remove(0);
            switch (popup) {
                case POPUP_HELLO:
                    if (countShowHello < 2)
                        showHello(activity, 4000, new Runnable() {
                            public void run() {
                                loginProcessDone = true;
                                showPopup();
                                Log.d(TAG, "showHello 3:");
                            }
                        });
                    break;
                case POPUP_LINK:
                    //show Popup link
                    shouldShowFloatButton = true;
                    boolean saveRead = true;
                    MobGameDialogStartWebFragment dialogStartWebFragment = new MobGameDialogStartWebFragment(activity, true, saveRead);
                    dialogStartWebFragment.show(activity.getFragmentManager(), "dialog webview");
                    Preference.save(activity, "save_ads", true);
                    break;
                case POPUP_FLOAT_BUTTON:
                    shouldShowFloatButton = true;
                    Intent intent = new Intent(Constants.INTENT_FILTER);
                    intent.putExtra("category", "float_button");
                    LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
//                    showPopup();
                    break;
                case POPUP_ADS:
                    shouldShowFloatButton = true;

                    new Handler().postDelayed(new Runnable() {

                        @Override
                        public void run() {

                            Log.d(TAG , "Show popup: 4" + (adStatus) + " " + isLoggedIn());
//                            if (isLoggedIn() && adStatus == StatusAd.AD_LOADED) {
//                                Log.d(TAG , "Show popup: 5");
//                                requestAdsFun.showAds();
//                                adStatus = StatusAd.AD_SHOWED;
//                            }
                        }
                    }, 1000);
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    private enum StatusAd {
        AD_INIT, AD_LOADED, AD_CLOSED, AD_ERROR, AD_SHOWED
    }

    private StatusAd adStatus = StatusAd.AD_INIT;
    AdsFunListener adsFunListener =  new AdsFunListener() {
        @Override
        public void reQuestAdsSuccess(int code) {
            adStatus = StatusAd.AD_LOADED;
            Log.d(TAG , "AD_LOADED");
        }

        @Override
        public void isShowAds(boolean isShow) {
            adStatus = StatusAd.AD_SHOWED;
            Log.d(TAG , "AD_SHOWED");
            hideNotiFloatButton();
        }

        @Override
        public void isCloseAds(boolean isClose) {
            adStatus = StatusAd.AD_CLOSED;
            Log.d(TAG , "AD_CLOSED");
            requestAdsFun.requestAds();
            Game.Ex ex = GameConfigManager.getInstance().getGameConfig().getEx();
            showNotiFloatButton(ex);
        }

        @Override
        public void isLoadAdsError() {
            adStatus = StatusAd.AD_ERROR;
            Log.d(TAG , "AD_ERROR");
        }
    };
    public void showAds(){
        if (isLoggedIn() && adStatus == StatusAd.AD_LOADED) {
            Log.d(TAG , "Show popup: 5");
            requestAdsFun.showAds();
            adStatus = StatusAd.AD_SHOWED;
        }
    }

    RequestAdsFun requestAdsFun;
    private void initAds(Activity activity , AdsFunListener adsFunListener) {
        String apiKey = Preference.getString(activity , "FunAdsApikey");
        requestAdsFun = new RequestAdsFun.RequestAdsBuilder().addListener(adsFunListener)
//                .adsId("5eeb2d1ed44074001140e09d")
                .adsId(apiKey)
                .of(activity)
                .build();
        requestAdsFun.requestAds();
    }

    private int countShowHello = 0;

    public void setMobGameListener(MobGameListener listener) {
        final MobGameListener fl = listener;
        MobGameListener onLoginListener = new MobGameListener() {

            @Override
            public void onLoginSuccessful(String userId , String accID, String token) {
                try {
                    String refreshedToken = Preference.getString(applicationContext, Constants.SAVE_FCM_KEY);
                    if (!TextUtils.isEmpty(refreshedToken) && !TextUtils.isEmpty(userId)) {
                        (new RegisterTokenAndTask(userId ,refreshedToken)).execute();
                    }
                    try {
                        AppsFlyerLib.getInstance().setCustomerUserId(userId);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    countShowHello = 1;
                    if (userId != null) {
                        EventClientManager.getInstance(getApplicationContext()).setUserId(userId);
                    }
                    try {
                        FunTrackingUtil.getInstance().trackLoginSuccess(activity,userId);
                        new Thread(new Runnable() {
                            @Override
                            public void run() {
                                EventClientManager.getInstance(getApplicationContext()).saveEventClient(EventClientManager.SAVE_EVENT_START_SESSION, AFInAppEventType.LOGIN, null);
                            }
                        }).start();
                    } catch (Exception e) {
                        // TODO: handle exception
                        e.printStackTrace();

                    }

                    close(false);
                    Log.d(TAG , "isHaveDeeplink " + isHaveDeepLink
                            + " , GameConfigManager.getInstance().getShow_qc() : " +
                            GameConfigManager.getInstance().getShow_qc() +
                            " ,!GameConfigManager.getInstance().getMobPopup().is_show() :" +
                            !GameConfigManager.getInstance().getMobPopup().is_show());
                    queuePopups.clear();

                    queuePopups.add(POPUP_HELLO);
                    if(isHaveDeepLink){
                        new Handler().postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                setDeepLink(intentDeepLink);
                            }
                        } , 2000);
                    }else{
                        if (GameConfigManager.getInstance().getMobPopup().is_show()) {
                            queuePopups.add(POPUP_LINK);
                        }
//                        if (GameConfigManager.getInstance().getShow_qc() && !GameConfigManager.getInstance().getMobPopup().is_show()) {
//                            queuePopups.add(POPUP_ADS);
//                        }
                        if(!GameConfigManager.getInstance().getMobPopup().is_show() && !GameConfigManager.getInstance().getShow_qc())
                            queuePopups.add(POPUP_FLOAT_BUTTON);
                    }
                    showPopup();

                    fl.onLoginSuccessful(userId , accID, token);
                } catch (Exception e) {
                    e.printStackTrace();
                    fl.onError(-1, e.getMessage());
                }

            }

            @Override
            public void onPaySuccessful(String userId, String orderId,
                                        String orderProduct, String orderInfo, String orderTime,
                                        String platformPrice, String gamePrice, String state,
                                        String game_role_id, String game_area_id, String is_sandbox) {

                try {
                    double price = 0.01 * Double.parseDouble(platformPrice);
                    HashMap<String, Object> eventValue = new HashMap<String, Object>();
                    eventValue.put(AFInAppEventParameterName.REVENUE, price);
                    eventValue.put(AFInAppEventParameterName.CONTENT_TYPE,
                            "category_rev");
                    eventValue.put(AFInAppEventParameterName.CONTENT_ID,
                            "123456");
                    eventValue.put(AFInAppEventParameterName.CURRENCY, "USD");
                    eventValue.put(Constants.AF_ORDER_ID, orderId);
                    FunTrackingUtil.getInstance().trackPaymentSuccess(activity, eventValue);
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            EventClientManager.getInstance(activity).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, AFInAppEventType.PURCHASE, eventValue);
                        }
                    }).start();
                } catch (Exception e) {
                    e.printStackTrace();
                    // in case platformPrice cannot be parsed
                }

                fl.onPaySuccessful(userId, orderId, orderProduct, orderInfo,
                        orderTime, platformPrice, gamePrice, state,
                        game_role_id, game_area_id, is_sandbox);
                isShowAds = false;
            }

            @Override
            public void onError(int errorCode, String message) {
                try {
                    Log.d(TAG, "onError MobGameListener: " + message);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onLoginFormClose() {
                fl.onLoginFormClose();
            }

            @Override
            public void onLogoutSucessful(String roleId) {
                fl.onLogoutSucessful(roleId);
            }
        };
        mListener = onLoginListener;
    }


    /*
     * get time from Before Authen
     * */
    public long getTimeLiveSession() {
        Game game = GameConfigManager.getInstance().getGameConfig();
        long timeSession = game.getTimeSession() * 60 * 1000;
        if (timeSession == 0) {
            timeSession = 10 * 60 * 1000;
            return timeSession;
        } else {
            return timeSession;
        }
    }

    public void onRequestPermissionsResult(Activity gameActivity, int requestCode, String[] permissions, int[] grantResults) {
        CmdDashboard.getInstance().onRequestPermissionsResult(gameActivity, requestCode, permissions, grantResults);
    }

    public void setDeepLink(Intent intent) {
        Log.e("setupDeepLink", "setDeepLink");
        intentDeepLink = intent;
        try {
            String deepLink = Preference.getString(activity , "deep_link");
            if (TextUtils.isEmpty(deepLink)) {
                return;
            }
            isHaveDeepLink = true;
            if (GameConfigManager.getInstance().getGameConfig() == null) {
                getGameInfoRemote();
                return;
            }
            Log.d(TAG , "deepLink " + deepLink);
            if (!isLoggedIn()) {
                login(deepLink);
            } else {
                String[] arrayDeepLink = deepLink.split("\\?param=");
                String domainDeepLink = arrayDeepLink[0];
                String paramDeepLink = arrayDeepLink[1];
                Gson gson = new Gson();
                hideNotiFloatButton();
                ItemDeepLink itemDeepLink = gson.fromJson(paramDeepLink.replace("\\", ""), ItemDeepLink.class);
                switch (domainDeepLink) {
                    case DEEP_LINK_NOTIFICATION_DASHBOARD:
                        showDashboard(activity, Constants.BASE_URL_DOMAIN + itemDeepLink.getUrlDeepLink());
                        break;
                    case DEEP_LINK_NOTIFICATION_BANNER:
                        showBanner(activity, itemDeepLink.getUrlBanner(), itemDeepLink.getUrlDeepLink(), itemDeepLink.getTypeLink());
                        break;
                    case DEEP_LINK_NOTIFICATION_URL:
                        if (!TextUtils.isEmpty(itemDeepLink.getTypeLink()) && TextUtils.equals(itemDeepLink.getTypeLink(), DEEP_LINK_WEBVIEW)) {
                            customUrl(itemDeepLink.getUrlDeepLink());
                        } else {
                            activity.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(itemDeepLink.getUrlDeepLink())));
                            hideNotiFloatButton();
                            isShowPopupLink = false;
                        }
                        break;
                    case DEEP_LINK_NOTIFICATION_GIFTCODE:
                        openDashboardById(4);
                        break;
                }
                isHaveDeepLink = false;
                Preference.remove(activity , "deep_link");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showDashboard(Activity activity, String url_deep_link) {
        try {
            MobGameDialogWebviewFragment dialogWebviewFragment = new MobGameDialogWebviewFragment(activity, "", url_deep_link);
            dialogWebviewFragment.show(activity.getFragmentManager(), "dialog webview");
            isShowPopupLink = true;
            hideNotiFloatButton();
            dialogWebviewFragment.setOnDismissListener(new DialogInterface.OnDismissListener() {
                @Override
                public void onDismiss(DialogInterface dialogInterface) {
                    if (Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true)
                            && Utils.isDashboardEnabled(activity)) {
                        Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);
                        isShowPopupLink = false;
                        Intent intent = new Intent(Constants.INTENT_FILTER);
                        intent.putExtra("category", "float_button");
                        LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showBanner(Activity activity, String urlBanner, String urlDeepLink, String typeLink) {
        FragmentManager fm = activity.getFragmentManager();
        BannerDialogFragment dialog = BannerDialogFragment.newInstance(urlBanner, urlDeepLink, typeLink);
        dialog.show(fm, null);
        hideNotiFloatButton();
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialogInterface) {
                if (Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true)
                        && Utils.isDashboardEnabled(activity)) {
                    Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);
                }
                isShowPopupLink = false;
                Intent intent = new Intent(Constants.INTENT_FILTER);
                intent.putExtra("category", "float_button");
                LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
            }
        });
        isShowPopupLink = true;
    }

    public void setpackagename(String packagename){
        Log.d("TAG" , "setpackagename " + packagename);
        Preference.save(activity, Constants.SHARED_PREF_MAIN_ACTIVITY_PACKAGE, packagename);
    }

    public void dashboardNew() {
        if (!isLoggedIn()) {
            Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT).show();
        } else {
            isShowAds = false;
            try {
                MobGameDashboardNewDialog dialogDashboard = new MobGameDashboardNewDialog();
                FragmentManager fm = activity.getFragmentManager();
                Bundle bundle = new Bundle();
                ArrayList<MobMenuItem> listMenuItem = GameConfigManager.getInstance().getMobMenu().getMenuItems();
                String data = "";
                MobMenuItem menuItem = getItemByPriority(listMenuItem);
                if (menuItem != null) {
                    switch (menuItem.getId()) {
                        case 1:
                        case 4:
                        case 6:
                        case 8:
                            Gson gson = new Gson();
                            data = gson.toJson(menuItem.getSubMenu());
                            break;
                    }
                }
                Log.d(TAG, "data : " + data);
                bundle.putString(MobGameDashboardNewDialog.KEY_DATA, data);
                bundle.putString(MobGameDashboardNewDialog.KEY_ICON, menuItem.getIconActive());
                bundle.putInt(MobGameDashboardNewDialog.KEY_ID, menuItem.getId());
                bundle.putBoolean(MobGameDashboardNewDialog.KEY_SHOW, menuItem.isShow());
                bundle.putInt(MobGameDashboardNewDialog.ID_PRIORITY , -1);

                dialogDashboard.setArguments(bundle);
                fm.beginTransaction().addToBackStack("stack").commitAllowingStateLoss();
                dialogDashboard.show(fm, "Dashboard Fragment");

                dialogDashboard.setEventListener(new MobGameDashboardNewDialog.EventListener() {
                    @Override
                    public void onDismissDashboard() {
                        Intent intent = new Intent(Constants.INTENT_FILTER);
                        intent.putExtra("category", "float_button");
                        LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    }
                });

                MobGameSDK.getInstance().unRegisterSensor();
                Game game = GameConfigManager.getInstance().getGameConfig();
                boolean isShowLogo = MobGameHelper.isShowingNotiFloatButton();
                if (isShowLogo) {
                    hideNotiFloatButton();
                }
            } catch (Exception e) {
                Log.e(TAG, "onClick Error");
                e.printStackTrace();
            }
        }
    }

    public void openDashboardById(int id) {
        if (!isLoggedIn()) {
            Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT).show();
        } else {
            isShowAds = false;
            try {
                MobGameDashboardNewDialog dialogDashboard = new MobGameDashboardNewDialog();
                FragmentManager fm = activity.getFragmentManager();
                Bundle bundle = new Bundle();
                ArrayList<MobMenuItem> listMenuItem = GameConfigManager.getInstance().getMobMenu().getMenuItems();
                String data = "";
                MobMenuItem menuItem = new MobMenuItem();
                for(MobMenuItem item : listMenuItem){
                    if(item.getId() == 4){
                        menuItem = item;
                        Gson gson = new Gson();
                        data = gson.toJson(menuItem.getSubMenu());
                    }
                }
                if(data != null || !data.equals("")){
                    Log.d(TAG, "data : " + data);
                    bundle.putString(MobGameDashboardNewDialog.KEY_DATA, data);
                    bundle.putString(MobGameDashboardNewDialog.KEY_ICON, menuItem.getIconActive());
                    bundle.putInt(MobGameDashboardNewDialog.KEY_ID, menuItem.getId());
                    bundle.putBoolean(MobGameDashboardNewDialog.KEY_SHOW, menuItem.isShow());
                    bundle.putInt(MobGameDashboardNewDialog.ID_PRIORITY , id);

                    dialogDashboard.setArguments(bundle);
                    fm.beginTransaction().addToBackStack("stack").commitAllowingStateLoss();
                    dialogDashboard.show(fm, "Dashboard Fragment");
                    dialogDashboard.setEventListener(new MobGameDashboardNewDialog.EventListener() {
                        @Override
                        public void onDismissDashboard() {
                            Intent intent = new Intent(Constants.INTENT_FILTER);
                            intent.putExtra("category", "float_button");
                            LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                        }
                    });

                    MobGameSDK.getInstance().unRegisterSensor();
                    Game game = GameConfigManager.getInstance().getGameConfig();
                    boolean isShowLogo = MobGameHelper.isShowingNotiFloatButton();
                    if (isShowLogo) {
                        hideNotiFloatButton();
                    }
                }
            } catch (Exception e) {
                Log.e(TAG, "onClick Error");
                e.printStackTrace();
            }
        }
    }

    private MobMenuItem getItemByPriority(ArrayList<MobMenuItem> mobMenuItems) {
        try {
            int min = 0;
            MobMenuItem menuItem = new MobMenuItem();
            // khoi tao
            for (int i = 0; i < mobMenuItems.size(); i++) {
                if (mobMenuItems.get(i).isShow()) {
                    min = mobMenuItems.get(i).getPriority();
                    menuItem = mobMenuItems.get(i);
                    break;
                }
            }
            for (int i = 0; i < mobMenuItems.size(); i++) {
                if (mobMenuItems.get(i).isShow() && mobMenuItems.get(i).getPriority() < min) {
                    min = mobMenuItems.get(i).getPriority();
                    menuItem = mobMenuItems.get(i);
                }
            }
            return menuItem;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ActivityLifecycleCallbacks mActivityLifecycleCallbacks = new ActivityLifecycleCallbacks() {

        private final String TAG = ActivityLifecycleCallbacks.class
                .getSimpleName();

        int count = 0;

        @Override
        public void onActivityCreated(Activity a, Bundle b) {
            try {
                Log.i(TAG, "onActivityCreated:" + a.getClass().getSimpleName());
                currentActivity = a;
                if (a.equals(activity)) {
                    // Xu li deeplink o day!!!
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onActivityStarted(Activity a) {
            try {
                Log.i(TAG, "onActivityStarted:" + a.getClass().getSimpleName());
                currentActivity = a;
                if (a.equals(activity)) {

                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onActivityResumed(Activity a) {
            boolean isShowMobGame = Preference.getBoolean(getApplicationContext(), Constants.SHARED_PREF_SHOW_MOBGAMEACTIVITY, true);
            Log.d(TAG , "onActivityResumed " +
                    " , !isShowSocialDialog : " +  !isShowSocialDialog + " , isShowMobGame : " + isShowMobGame + ", "
                    + !a.getClass().getSimpleName().equals("MobGameActivity") + ", "
                    + !a.getClass().getSimpleName().equals("MobGameLoginActivity"));
            if (!a.getClass().getSimpleName().equals("MobGameActivity") || !a.getClass().getSimpleName().equals("MobGameLoginActivity") ){
                if (!isShowSocialDialog && isShowMobGame) {
                    if (isValidationMode) {
                        requestOverlayPermission(activity);
                    }
                }
            }
            if(!checkTimeInited && !isPhoneIsLockedOrNot(activity) &&
                    (!a.getClass().getSimpleName().equals("MobGameActivity") ||
                            !a.getClass().getSimpleName().equals("MobGameLoginActivity")
                            || !a.getClass().getSimpleName().equals("MobGameImageGaleryActivity")
                            || !a.getClass().getSimpleName().equals("FacebookActivity"))){
                checkTimeText();
            }
            try {
                currentActivity = a;
                isPauseForHideFloatButton = false;
                if (isScrollingText && scrollTextAnimation != null) {
                    long resumedPoint = System.currentTimeMillis() - startPointOfOneScrollingTextNow;
                    scrollTextAnimation.start();
                    if (resumedPoint < durationOfOneScrollingTextNow) {
                        scrollTextAnimation.setCurrentPlayTime(resumedPoint);
                    }
                }

                changeInForegroundStatus(true);
                if (a.equals(activity)) {
                    Log.d(TAG, "menu-id onActivityResumed:" + menuId);

                    Game gameConfig = GameConfigManager.getInstance().getGameConfig();
                    if (gameConfig == null) {
                        getGameInfoRemote();
                    }

                    LocalBroadcastManager.getInstance(getApplicationContext())
                            .registerReceiver(mMessageReceiver, new IntentFilter(Constants.INTENT_FILTER));

                    CookieSyncManager.getInstance().startSync();
                    if (!Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_DASHBOARD, false)
                            && adStatus  != StatusAd.AD_SHOWED && !isShowPopupLink) {
                        Intent intent = new Intent(Constants.INTENT_FILTER);
                        intent.putExtra("category", "float_button");
                        LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    }
                    if (!isLogout) {
                        CmdDashboard.getInstance().showGiftCode();
                    }
                    if (!Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, false)) {
                        MobGameSDK.getInstance().registerSensor();
                    }
                }
                Log.d(TAG , "token : " + GameConfigManager.getInstance().getAccessToken());
                if (!a.getClass().getSimpleName().equals("MobGameActivity")
                        && !a.getClass().getSimpleName().equals("MobGameLoginActivity")
                        && !a.getClass().getSimpleName().equals("MobGameImageGaleryActivity")
                        && GameConfigManager.getInstance().getAccessToken() != "") {
                    checkForceLogout();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onActivityPaused(Activity a) {
            try {
                Log.i(TAG, "onActivityPaused:" + a.getClass().getSimpleName());
                count++;
                currentActivity = a;

                if (scrollTextTimer != null) scrollTextTimer.cancel();
                scrollTextTimer = null;

                isPauseForHideFloatButton = true;

                changeInForegroundStatus(false);
                hideNotiFloatButton();
//                Log.d(TAG , "isPhoneLocked : " + isPhoneIsLockedOrNot(activity));
                if(isPhoneIsLockedOrNot(activity)){
                    removeViewNotice();
                    countDownTimer.cancel();
                    checkTimeInited = false;
                }

                if (a.equals(activity)) {
                    CmdDashboard.getInstance().hideGiftCode();
                    CookieSyncManager.getInstance().stopSync();

                    LocalBroadcastManager.getInstance(getApplicationContext())
                            .unregisterReceiver(mMessageReceiver);
                    if (!Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, false)) {
                        MobGameSDK.getInstance().unRegisterSensor();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }

        @Override
        public void onActivityStopped(Activity a) {
            try {
                Log.i(TAG, "onActivityStopped:" + a.getClass().getSimpleName());
                if (count != 0) {
                    Log.d(TAG, "onActivity Go here");
                    long timeFromBefore = getTimeLiveSession();

                    new CountDownTimer(timeFromBefore, timeFromBefore) {
                        @Override
                        public void onTick(long millisUntilFinished) {
                        }

                        @Override
                        public void onFinish() {
                            try {
                                long endSession = System.currentTimeMillis();
                                long startSession = Preference.getLong(a, Constants.START_SESSION, 0);
                                endSession(endSession - startSession);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onActivityDestroyed(Activity a) {
            try {
                Log.i(TAG, "onActivityDestroyed:" + a.getClass().getSimpleName());
                if (a.equals(activity)) {
                    if (isLoggedIn()) {
                        EventClientManager.getInstance(a).saveEventClient(EventClientManager.SAVE_EVENT_END_SESSION, null, null);
                    }
                    if (!a.getClass().getSimpleName().equals("MobGameActivity")
                            && !a.getClass().getSimpleName().equals("MobGameLoginActivity")
                            && !a.getClass().getSimpleName()
                            .equals("FacebookActivity") && !a.getClass().getSimpleName()
                            .equals("MobGameImageGaleryActivity")) {
                        isShowAds = true;
                    }
                    LocalBroadcastManager.getInstance(
                            getApplicationContext()).unregisterReceiver(
                            mGlobalMessageReceiver);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onActivitySaveInstanceState(Activity a, Bundle b) {
            try {
                if (a.equals(activity)) {

                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    };

    private boolean isPhoneIsLockedOrNot(Context context) {
        boolean isLocked = false;
        // First we check the locked state
        KeyguardManager keyguardManager = (KeyguardManager) context.getSystemService(Context.KEYGUARD_SERVICE);
        boolean inKeyguardRestrictedInputMode = keyguardManager.isKeyguardLocked();

        if (inKeyguardRestrictedInputMode) {
            isLocked = true;

        } else {
            PowerManager powerManager = (PowerManager)context.getSystemService(Context.POWER_SERVICE);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT_WATCH) {
                isLocked = !powerManager.isInteractive();
            } else {
                isLocked = !powerManager.isScreenOn();
            }
        }
        Log.d(TAG , "isLocked : " + isLocked);
        return isLocked;
    }
    public void registerSensor() {
        try {
            if (accelerometerPresent) {
                if (accelerometerPresent) {
                    sensorManager.registerListener(accelerometerListener,
                            accelerometerSensor, SensorManager.SENSOR_DELAY_NORMAL);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unRegisterSensor() {
        try {
            if (accelerometerPresent) {
                sensorManager.unregisterListener(accelerometerListener);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ComponentCallbacks mComponentCallbacks = new ComponentCallbacks() {

        @Override
        public void onConfigurationChanged(Configuration newConfig) {
            // Checks the orientation of the screen
            try {
                Log.d(TAG, "onConfigurationChanged");
                if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE
                        || newConfig.orientation == Configuration.ORIENTATION_PORTRAIT) {

                    Log.d(TAG, "onConfigurationChanged : " + newConfig.orientation
                            + " , " + !Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_DASHBOARD, false));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }

        @Override
        public void onLowMemory() {
        }

    };
    private BroadcastReceiver mMessageReceiver = new BroadcastReceiver() {

        @Override
        public void onReceive(Context context, Intent intent) {
            Log.d(TAG, "BroadcastReceiver::onReceive");
            try {
                String category = intent.getStringExtra("category");
                Log.e(TAG, "category:" + category);
                if (category != null) {
                    switch (category) {
                        case "forcelogout":
                            showDialog();
                            break;
                        case "gcm":
                            try {
                                Log.d(TAG, "khaitran " + !Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_DASHBOARD, false)
                                        + " , " + Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true));
                                if (GameConfigManager.getInstance().getGameConfig() != null
                                        && isLoggedIn()
                                        && Utils.isDashboardEnabled(activity)
                                        && !Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_DASHBOARD, false)
                                        && Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true)) {
                                    Log.d(TAG, "id gcm: " + intent.getStringExtra("id"));
                                    int id = Integer.parseInt(intent.getStringExtra("id"));
                                    String textTitle = intent.getStringExtra("title");
                                    boolean noti = Boolean.parseBoolean(intent.getStringExtra("noti"));

                                    ArrayList<NtfModel> listId = new ArrayList<>();
                                    NtfModel ntfModel = new NtfModel();
                                    ntfModel.setId(id);
                                    ntfModel.setTitle(textTitle);
                                    ntfModel.setNoti(noti);
                                    //check neu ko phai id = 2,3,5
                                    if (ntfModel.getTitle() != null)
                                        listId.add(ntfModel);
                                }

                                if (intent.getBooleanExtra("play_gif", false)) {
                                    GifHelper.playGif(activity);
                                }

                                if (intent.hasExtra("gif_data")) {
                                    String gifDataString = intent.getStringExtra("gif_data");
                                    GifHelper.fetchFramesImage(activity, GifData.parse(gifDataString));
                                    GifHelper.playGif(activity);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        case "mobOpenFanPage":
                            try {
                                String params = intent.getStringExtra("data");
                                CmdDashboard.getInstance().mobOpenFBFanpage(activity, params);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        case "mobOpenGroup":
                            try {
                                String params = intent.getStringExtra("data");
                                CmdDashboard.getInstance().mobOpenFBGroup(activity, params);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        case "mobOpenBrowser":
                            try {
                                String params = intent.getStringExtra("data");
                                CmdDashboard.getInstance().mobOpenBrowser(activity, params);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
//                        case "MobGameUpgradeDialog.btnUpgradeInfo":
//                            shouldShowPopup = true;
//                            break;
                        case "float_button":
                            // do Nothing
                            Game.Ex ex = GameConfigManager.getInstance().getGameConfig().getEx();
                            showNotiFloatButton(ex);
                            break;
                        case "hide_float_button":
                            MobGameHelper.doHideFloatButton = true;
                            break;
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private ArrayList<NtfModel> removeDuplicateWithOrder(ArrayList<NtfModel> arrList) {
        Set<Integer> set = new HashSet();
        List<NtfModel> newList = new ArrayList<>();
        for (Iterator<NtfModel> iter = arrList.iterator(); iter.hasNext(); ) {
            NtfModel element = iter.next();
            int id = element.getId();
            if (set.add(id))
                newList.add(element);
        }
        arrList.clear();
        arrList.addAll(newList);
        return arrList;
    }

    private BroadcastReceiver mGlobalMessageReceiver = new BroadcastReceiver() {

        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                String category = intent.getStringExtra("category");
                Log.d(TAG, "GlobalMessageReceiver::onReceive " + category);
                if (category != null) {
                    switch (category) {
                        case "login":
                            handleLogin(false);
                            break;
                        case "payment":
                            boolean success = intent.getBooleanExtra("status", false);
                            if (success) {
                                String userId = intent.getStringExtra("user_id");
                                String orderId = intent.getStringExtra("order_id");
                                String orderProduct = intent.getStringExtra("order_product");
                                String orderInfo = intent.getStringExtra("order_info");
                                String orderTime = intent.getStringExtra("order_time");
                                String platformPrice = intent.getStringExtra("platform_price");
                                String gamePrice = intent.getStringExtra("game_price");
                                String state = intent.getStringExtra("state");
                                String game_role_id = intent.getStringExtra("game_role_id");
                                String game_area_id = intent.getStringExtra("game_area_id");
                                String is_sandbox = intent.getStringExtra("is_sandbox");

                                mListener.onPaySuccessful(userId, orderId,
                                        orderProduct, orderInfo, orderTime,
                                        platformPrice, gamePrice, state, game_role_id,
                                        game_area_id, is_sandbox);
                            } else {
                                String message = intent.getStringExtra("message");
                                mListener.onError(MobGameListener.ERROR_PAYMENT,
                                        message);
                            }
                            break;
                        case "reload":
                            MobGameActivity.shouldReload = true;
                            break;
                        case "is_showads":
                            isShowAds = true;
                            break;
                        case "isShowPopupLink":
                            isShowPopupLink = true;
                            break;
                        case "hideShowPopupLink":
                            isShowPopupLink = false;
                            break;
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private GetInfoBeforeAuthenTask mGetInfoBeforeAuthenTask;
    public static boolean isValidationMode = false;

    private void getGameInfoRemote() {
        try {
            if (mGetInfoBeforeAuthenTask != null
                    && !mGetInfoBeforeAuthenTask.isCancelled())
                mGetInfoBeforeAuthenTask.cancel(true);

            mGetInfoBeforeAuthenTask = new GetInfoBeforeAuthenTask(
                    new GetInfoBeforeAuthenTask.Listener() {

                        @Override
                        public void onSuccess(Game gameConfig, boolean isNotificationOn) {
                            ex = gameConfig.getEx();
                            if (isNotificationOn) {
                                isValidationMode = true;
                                Log.e("THAM DINH CONFIG:", isNotificationOn + "");
                                requestOverlayPermission(activity);
                            }
                            if (gameConfig == null) {
                                onGetGameInfoRemoteFailed();
                            } else {
                                GameConfigManager.getInstance().setGameConfig(
                                        gameConfig);
                                initAds(activity , adsFunListener);
                                if (isLoggedIn()) {
                                    Log.d(TAG , "AutoLogin go here");
                                    handleLogin(true);
                                } else if (isHaveDeepLink) {
                                    login();
                                }
                            }
                        }

                        @Override
                        public void onFailure(Throwable t) {
                            t.printStackTrace();
                            onGetGameInfoRemoteFailed();
                        }
                    });
            mGetInfoBeforeAuthenTask.execute();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onGetGameInfoRemoteFailed() {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder(
                    Utils.getContextThemeWrapper(activity));
            builder.setCancelable(false);
            builder.setMessage(Res.string(activity, R.string.unable_to_connect));
            builder.setPositiveButton(Res.string(activity, R.string.retry),
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int which) {
                            getGameInfoRemote();
                        }
                    });
            builder.setNegativeButton(Res.string(activity, R.string.exit),
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int which) {
                            Intent intent = new Intent(Intent.ACTION_MAIN);
                            intent.addCategory(Intent.CATEGORY_HOME);
                            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                            activity.startActivity(intent);
                        }
                    });
            builder.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showTextScroll(ArrayList<IngameNoti> listNoti) {
        if (isShowingHello) {
            return;
        }
        if (this.listNoti.size() == 0) {
            this.listNoti = listNoti;
        } else {
            this.listNoti.addAll(listNoti);
        }
        showTextScroll(activity, listNoti.size() - 1, listNoti);
    }

    private ArrayList<IngameNoti> listNoti = new ArrayList<>();

    public void showTextScroll(final Activity activity, int repeatCount, ArrayList<IngameNoti> listNoti) {
        try {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
                    LayoutInflater inflater = LayoutInflater.from(activity);
                    if (viewNotice == null)
                        viewNotice = inflater.inflate(R.layout.layout_notice, null);
                    if (scrollTextLayout == null) {
                        scrollTextLayout = (FrameLayout) viewNotice.findViewById(R.id.layoutNotiIngame);
                        /*CHỈNH LAYOUT = 4/5 CHIỀU NGẮN CỦA MÀN HÌNH*/
                        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) scrollTextLayout.getLayoutParams();
                        layoutParams.width = rootView.getWidth() / 5 * 4;
                        Log.i("Layout Width", layoutParams.width + " | ScreenWidth: " + rootView.getWidth());
                    }
                    TextView scrollText = (TextView) viewNotice.findViewById(R.id.txt_notice);
                    Rect bounds = new Rect();
                    Paint textPaint = scrollText.getPaint();
                    long layoutWidth = rootView.getWidth() / 5 * 4;
                    if (isScrollingText) {
                        initScrollView(listNoti, textPaint, bounds, scrollTextLayout);
                    } else {
                        /* FIRST TIME SET UP ANIMATION */
                        textViews = new ArrayList<>();
                        scrollAnimIndex = 0;
                        scrollAnimRepeatCount = 0;
                        initScrollView(listNoti, textPaint, bounds, scrollTextLayout);
                        rootView.addView(viewNotice);
                        int startPoint = (rootView.getWidth() / 5 * 4) + rootView.getWidth() / 10;
                        startScrollingText(listNoti , textViews.get(scrollAnimIndex), layoutWidth, startPoint, repeatCount);
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeViewNotice(){
        try {
            ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
            if (viewNotice != null)
                rootView.removeView(viewNotice);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideTextScroll(final Activity activity, boolean isAnimated) {
        try {
            Log.e("HERE", " Hiding");
            ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
            if (isScrollingText) {
                if (isAnimated) {
                    activity.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            Animation animation = AnimationUtils.loadAnimation(
                                    activity, R.anim.top_out);
                            animation.setAnimationListener(new Animation.AnimationListener() {
                                @Override
                                public void onAnimationStart(Animation animation) {
                                }

                                @Override
                                public void onAnimationRepeat(Animation animation) {
                                }

                                @Override
                                public void onAnimationEnd(Animation animation) {

                                }
                            });
                            if (viewNotice != null) {
                                viewNotice.startAnimation(animation);
                                rootView.removeView(viewNotice);
                            }
                        }
                    });
                } else {
                    try {
                        if (viewNotice != null)
                            rootView.removeView(viewNotice);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                isScrollingText = false;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initScrollView(ArrayList<IngameNoti> listNoti, Paint textPaint, Rect bounds, FrameLayout layout) {
        try {
            for(int i = 0 ; i < listNoti.size() ; i++){
                Spanned text = Html.fromHtml(listNoti.get(i).getText());
                TextView textView = new TextView(activity);
                textPaint.getTextBounds(String.valueOf(text), 0, text.length(), bounds);
                float textLength = bounds.width();
                textView.setSingleLine(true);
                textView.setEllipsize(TextUtils.TruncateAt.MARQUEE);
                if(DeviceUtils.isTablet(activity)){
                    textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 17);
                }else{
                    textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 11);
                }
//                textView.setTextColor(Color.WHITE);
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT , ViewGroup.LayoutParams.WRAP_CONTENT);
                lp.gravity = Gravity.CENTER;
                textView.setLayoutParams(lp);
                textView.setText(text);
                final IngameNoti itemNoti = listNoti.get(i);
                if(listNoti.get(i).getText().contains("ffffff")){
                    textView.setTextColor(Color.WHITE);
                }
                switch (listNoti.get(i).getType()) {
                    case 1:
                        textView.setOnClickListener(new View.OnClickListener() {
                            @Override
                            public void onClick(View view) {
                                try {
                                    AlertDialog.Builder builder = new AlertDialog.Builder(activity);
                                    builder.setMessage(R.string.open_with_browser)
                                            .setPositiveButton(R.string.yes, new DialogInterface.OnClickListener() {
                                                @Override
                                                public void onClick(DialogInterface dialogInterface, int index) {
                                                    activity.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(itemNoti.getLink())));
                                                }

                                            })
                                            .setNegativeButton(R.string.no, new DialogInterface.OnClickListener() {
                                                @Override
                                                public void onClick(DialogInterface dialogInterface, int i) {
                                                    builder.create().dismiss();
                                                }

                                            });

                                    builder.setOnDismissListener(new DialogInterface.OnDismissListener() {
                                        @Override
                                        public void onDismiss(DialogInterface dialogInterface) {
                                        }
                                    });
                                    builder.create().show();
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        break;
                    case 2:
                        textView.setOnClickListener(new View.OnClickListener() {
                            @Override
                            public void onClick(View view) {
                                try {
                                    String url = itemNoti.getLink();
                                    if (isShowingHello) {
                                        Log.d(TAG, "showingHello");
                                        return;
                                    }
                                    if (url != null && !url.equals("")) {
                                        FragmentManager fm = activity.getFragmentManager();
                                        DialogInGameFragment fr = (DialogInGameFragment) fm
                                                .findFragmentByTag(Constants.TAG_FRAGMENT);

//                                    isShowSocialDialog = true;
                                        if (fr == null) {
                                            fr = new DialogInGameFragment(new MUrl(url, false));
                                            fr.setOnDismissListener(new DialogInterface.OnDismissListener() {
                                                @Override
                                                public void onDismiss(DialogInterface dialogInterface) {
                                                    if (/*isShowSocialDialog && */Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true)
                                                            && Utils.isDashboardEnabled(activity)) {
                                                        Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);
                                                    }
//                                                isShowSocialDialog = false;
                                                }
                                            });
                                            FragmentTransaction fragmentTransaction = fm.beginTransaction();
                                            fragmentTransaction.add(fr, Constants.TAG_FRAGMENT);
                                            fragmentTransaction.commitAllowingStateLoss();
                                        }
                                    } else {
                                        Log.d(TAG, "url null");
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        break;
                    case 3:
                        break;
                }
                textViews.add(textView);
                layout.addView(textView);
                textView.setVisibility(View.GONE);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startScrollingText(ArrayList<IngameNoti> listNoti , TextView textView, long layoutWidth, float startPoint, int repeatCount) {
        try {
            scrollAnimRepeatCount++;
            if (!isScrollingText)
                isScrollingText = true;
            textView.setVisibility(View.VISIBLE);
//            textView.setText(listNoti.get(scrollAnimRepeatCount).getText().toString());
            textView.setX(startPoint);
            float scale = 1;
            try {
                scale = 3 / (activity.getResources().getDisplayMetrics().density);
            } catch (Exception e) {
                e.printStackTrace();
            }
            long s = layoutWidth + textView.getLayoutParams().width;
            long textDuration = (long) (s * Constants.DEFAULT_SPEED * scale);
            durationOfOneScrollingTextNow = textDuration;

            scrollTextAnimation = ObjectAnimator.ofFloat(textView, "x", -textView.getLayoutParams().width);
            scrollTextAnimation.setDuration(textDuration);
            scrollTextAnimation.setInterpolator(new LinearInterpolator());
            scrollTextAnimation.addListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    try {
                        textView.setVisibility(View.GONE);
                        if (scrollAnimRepeatCount <= repeatCount) {
                            startScrollingText(listNoti , textViews.get(scrollAnimRepeatCount), layoutWidth, startPoint, repeatCount);
                            Log.e("Scroll", "1");
                        } else {
                            hideTextScroll(activity, true);
                            listNoti.removeAll(listNoti);
                            textViews.removeAll(textViews);
                            scrollAnimRepeatCount = 0;
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            startPointOfOneScrollingTextNow = System.currentTimeMillis();
            scrollTextAnimation.start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static View helloView;
    private static boolean isShowingHello;
    private static final int DEFAULT_HELLO_TIMEOUT = 3000;

    public void showHello(Activity activity) {
        showHello(activity, DEFAULT_HELLO_TIMEOUT, null);
    }

    public void showHello(final Activity activity, long duration,
                          final Runnable afterHideRunnable) {
        try {
            if (activity == null)
                return;
            if (isShowingHello)
                return;

            final String username = GameConfigManager.getInstance()
                    .getUserInfo().getUser().getUserName();
            Log.i(TAG, "showHello:" + username);
            activity.runOnUiThread(new Runnable() {

                @SuppressLint("InflateParams")
                @Override
                public void run() {
                    try {
                        Utils.hideLoading();
                        ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
                        LayoutInflater inflater = LayoutInflater.from(activity);
                        helloView = inflater.inflate(R.layout.layout_processing, null);

                        TextView tv = (TextView) helloView.findViewById(R.id.txt_status);
                        tv.setText(Res.string(activity, R.string.hello) + ", " + username);
                        rootView.addView(helloView);

                        helloView.startAnimation(AnimationUtils.loadAnimation(activity, R.anim.top_in));
                        isShowingHello = true;
                        countShowHello = countShowHello + 1;
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            new Handler().postDelayed(new Runnable() {

                @Override
                public void run() {
                    hideHello(activity, true);
                    if (afterHideRunnable != null) {
                        afterHideRunnable.run();
                    }
                }
            }, duration + 500);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideHello(final Activity activity, boolean isAnimated) {
        isShowingHello = false;
        countShowHello = countShowHello + 1;
        if (isAnimated) {
            try {
                activity.runOnUiThread(new Runnable() {
                    public void run() {
                        Animation animation = AnimationUtils.loadAnimation(
                                activity, R.anim.top_out);
                        animation.setAnimationListener(new AnimationListener() {
                            @Override
                            public void onAnimationStart(Animation animation) {
                            }

                            @Override
                            public void onAnimationRepeat(Animation animation) {
                            }

                            @Override
                            public void onAnimationEnd(Animation animation) {
                                ViewGroup rootView = (ViewGroup) activity
                                        .findViewById(android.R.id.content);
                                rootView.removeView(helloView);
                            }
                        });
                        helloView.startAnimation(animation);
                    }
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
                rootView.removeView(helloView);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void requestOverlayPermission(final Activity activity) {
        try {
            Log.i(TAG, "Khai Tran : requestOverlayPermission");
            if (activity != null) {
                if (isValidationMode) {
                    if (!isGrantedPermission(activity)) {
                        if (!MobGameHelper.didShowPermissionDialog) {
                            showDialogRequestOverlayPermission();
                            FunTrackingUtil.getInstance().trackStartPermisison(activity);
                        }
                    } else {
                        Log.i(TAG, "requestOverlayPermission " + isInForeground() + "," + !shouldShowFloatButton);
                        if (isInForeground() && !shouldShowFloatButton) {
                            Log.i(TAG, "Phongdc : requestOverlayPermission");
                            showNotiFloatButton(ex);
                        }
                        Intent intent = new Intent(Constants.INTENT_FILTER);
                        intent.putExtra("category", "float_button");
                        LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showDialogRequestOverlayPermission() {
        try {

            AlertDialog.Builder builder;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                builder = new AlertDialog.Builder(activity, android.R.style.Theme_Material_Light_Dialog_Alert);
            } else {
                builder = new AlertDialog.Builder(activity);
            }

            String appName = activity.getApplicationInfo().loadLabel(activity.getPackageManager()).toString();
            builder.setTitle(activity.getString(R.string.attention_overlay))
                    .setMessage(String.format(activity.getString(R.string.overlay_message), appName))
                    .setPositiveButton(android.R.string.yes, new DialogInterface.OnClickListener() {
                        @SuppressLint("NewApi")
                        public void onClick(DialogInterface dialog, int which) {
                            Log.d("permission","showdialog");
                            Intent intent = null;
                            canDraw = Settings.canDrawOverlays(activity);
                            FunTrackingUtil.getInstance().trackClickOverlayPermission(activity);
                            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                                AppOpsManager opsManager = (AppOpsManager) activity.getSystemService(Context.APP_OPS_SERVICE);
                                onOpChangedListener = new AppOpsManager.OnOpChangedListener() {
                                    @Override
                                    public void onOpChanged(String op, String packageName) {
                                        PackageManager packageManager = activity.getPackageManager();
                                        String myPackageName = activity.getPackageName();
                                        if (myPackageName.equals(packageName) && AppOpsManager.OPSTR_SYSTEM_ALERT_WINDOW.equals(op)) {
                                            canDraw = true;
                                        }
                                    }
                                };
                                opsManager.startWatchingMode(AppOpsManager.OPSTR_SYSTEM_ALERT_WINDOW, null, onOpChangedListener);
                            }

                            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M) {
                                intent = new Intent(Settings.ACTION_MANAGE_OVERLAY_PERMISSION,
                                        Uri.parse("package:" + activity.getPackageName()));
                            }
                            dialog.dismiss();
                            MobGameHelper.didShowPermissionDialog = false;
                            (activity).startActivityForResult(intent, Constants.REQUEST_OVERLAY_PERMISSION);
                        }
                    })
                    .setCancelable(false)
                    .setIcon(activity.getApplicationInfo().icon)
                    .show();
            MobGameHelper.didShowPermissionDialog = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void showNotiFloatButton(Game.Ex ex) {
        if (MobGameHelper.isShowingNotiFloatButton()){
            return;
        }
        boolean isShowLogo = ex.isShowLogo();
        if (isShowLogo) {
            MobGameHelper.showNotiFloatButton(ex);
        }
    }

    public void hideNotiFloatButton() {
//        if(MobGameHelper.isShowingNotiFloatButton())
        MobGameHelper.hideNotiFloatButton();
    }

    public boolean isGrantedPermission(Context context) {
        boolean isGrandted = false;
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            isGrandted = true;
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            isGrandted = canDraw;
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
            isGrandted = Settings.canDrawOverlays(context);
        }
        return isGrandted;
    }

    private void changeInForegroundStatus(boolean isInForeground) {
        Preference.save(activity, "isInForeground", isInForeground);
    }

    private boolean isInForeground() {
        try {
            return Preference.getBoolean(activity, "isInForeground", true);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void showDialog() {
        if (isLoggedIn()) {
            try {
                //ForceLogout
                loginProcessDone = true;
                hideNotiFloatButton();
                logout();
                Dialog dialog = new Dialog(MobGameSDK.activity);
                dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
                dialog.setContentView(R.layout.dialog_force_logout);
                dialog.setCancelable(false);
                TextView tvTitle = dialog.findViewById(R.id.tv_title);
                tvTitle.setText(Res.string(activity, R.string.title_force_logout));
                TextView btnOK = dialog.findViewById(R.id.btn_ok);
                btnOK.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        System.gc();
                        System.exit(0);
                    }
                });
                dialog.show();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    @SuppressLint("NewApi")
    public void shareImageFacebook(Activity activity , Bitmap image){

        try {
            String face = "com.facebook.katana";
            String face2 = "com.facebook.android";
            try {
                Intent openFB = getApplicationContext().getPackageManager().getLaunchIntentForPackage("com.facebook.katana");
                activity.startActivity(openFB);
                Log.i(TAG, "shareImageFacebook: " + openFB);
            } catch (Exception e) {

                try {
                    AlertDialog.Builder builder = new AlertDialog.Builder(activity);
                    builder.setTitle(R.string.notifi);
                    builder.setMessage(R.string.dialog_share_image_facebook)
                            .setPositiveButton(R.string.install, new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int index) {
                                    Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=com.facebook.katana"));
                                    activity.startActivity(intent);
                                }
                            })
                            .setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {
                                    builder.create().dismiss();
                                }
                            });

                    builder.setOnDismissListener(new DialogInterface.OnDismissListener() {
                        @Override
                        public void onDismiss(DialogInterface dialogInterface) {

                        }
                    });
                    builder.create().show();

                }catch (Exception e1){
                    e1.printStackTrace();
                }
            }

            ShareDialog shareDialog = new ShareDialog(activity);
            SharePhoto photo = new SharePhoto.Builder()
                    .setBitmap(image)
                    .build();
            SharePhotoContent content = new SharePhotoContent.Builder()
                    .addPhoto(photo)
                    .build();
            shareDialog.show(content);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

}