package com.mobgame;

import android.app.Activity;
import android.util.Log;

import com.mobgame.gui.float18button.NotiOverlayView;
import com.mobgame.model.Game;

public class MobGameHelper {

	private final static String TAG = MobGameHelper.class.getSimpleName();
	private static Activity activity = MobGameSDK.activity;

	 public static boolean didShowPermissionDialog = false;
	private static NotiOverlayView notiFloatButton;
	public static boolean doHideFloatButton = false;

	public static void showNotiFloatButton(Game.Ex ex) {
		if(!doHideFloatButton){
			if (notiFloatButton == null) notiFloatButton = new NotiOverlayView(activity, ex);
			notiFloatButton.show();
			Log.e("NotiButton","Showing");
		}
	}

	public static void hideNotiFloatButton() {
		if (notiFloatButton != null && activity!=null && notiFloatButton.isShowing()) {
			activity.runOnUiThread(new Runnable() {
				@Override
				public void run() {
					if (notiFloatButton != null) {
						notiFloatButton.hide();
					}
				}
			});
		}
		Log.e("NotiButton","Hiding");
	}

	public static boolean isShowingNotiFloatButton() {
		if (notiFloatButton != null) return notiFloatButton.isShowing();
		return false;
	}
}
