/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.utils;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.appsflyer.AppsFlyerLib;
import com.mobgame.MobGameSDK;
import com.mobgame.component.EventClientManager;
import com.mobgame.component.FirebaseAnalyticsManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FunTrackingUtil {
    private static FunTrackingUtil instance;
    private String appsflyerDevkey = "cfgYFoj97okaEbzqp8q5w5";
    private String gcmSenderId = "461098885975";
    private String TAG = "FunTrackingUtil";
    private Map<String, Object> conversionDataLoaded;
    private ArrayList<String> listTrackEventQueue = new ArrayList();
    Context context;
    private boolean initted;
    public static final String STR_EVENT_LAUNCHER = "ft_app_launch";
    public static final String FT_URL_STRING = "ft_url_string";
    public static final String FIREBASE_SCREEN_NAME = "firebase_screen_name";
    public static final String FIREBASE_SCREEN_CLASS = "firebase_screen_class";
    private static final String TRACK_FIRST_LAUNCH = "ft_first_launch";
    private static final String TRACK_FIRST_LAUNCH_XX = "ft_app_launch_";
    private static final String TRACK_OVERLAY_CLICK_PERMISSION = "ft_overlay_click_permission";
    private static final String TRACK_EXTRACT_STARTED = "ft_extract_started";
    private static final String TRACK_EXTRACT_FINISHED = "ft_extract_finished";
    private static final String TRACK_DOWNLOAD_RES_STARTED = "ft_resource_started";
    private static final String TRACK_DOWNLOAD_RES_FAILED = "ft_resource_failed";
    private static final String TRACK_DOWNLOAD_RES_FINISHED = "ft_resource_finished";
    private static final String TRACK_DOWNLOAD_RES_FIRST_BYTE = "ft_resource_first_byte";
    private static final String TRACK_DOWNLOAD_RES_PERCENT = "ft_resource_percent";
    private static final String TRACK_SHOW_START_GAME_SCREEN = "ft_show_startgame";
    private static final String FT_GAME_CALL_CREATE_CHARACTOR = "ft_game_call_create_charactor";
    private static final String FT_CHARACTER_CREATED_CALL = "ft_character_created_call";
    private static final String FT_CHARACTER_CREATED_CALL_SUCCESS = "ft_character_created_call_success";
    private static final String FT_CHARACTER_CREATED_CALL_FAIL = "ft_character_created_call_fail";
    private static final String TRACK_START_TUTORIAL = "af_tutorial_started";
    private static final String TRACK_FINISH_TUTORIAL = "af_tutorial_completion";
    private static final String TRACK_REACH_A_LEVEL = "af_level_achieved";
    private static final String FT_VIP_ACHIEVED = "ft_vip_achieved";
    private static final String TRACK_LEVEL_PLATFORM = "ft_level_platform";
    private static final String TRACK_LEVEL_ACHIEVED_ = "ft_level_achieved_";
    private static final String TRACK_LEVEL_ACHIEVED_A = "ft_level_achieved_A";
    private static final String TRACK_LEVEL_ACHIEVED_B = "ft_level_achieved_B";
    private static final String TRACK_LEVEL_ACHIEVED_C = "ft_level_achieved_C";
    private static final String TRACK_REGISTER_SUCCESS = "ft_register_success";
    public static final String TRACK_PAYMENT_CLICK = "ft_payment_clicked";
    public static final String TRACK_LOGIN_SUCCESS_AFTER_AUTH = "ft_login_success_after_auth";
    public static final String TRACK_PAYMENT_CLOSE = "ft_payment_closed";
    public static final String TRACK_FT_PAYMENT_SUCCESS = "ft_purchase";
    public static final String TRACK_FORM_LOGIN_OPENED = "ft_login_screen_opened";
    public static final String TRACK_LOGIN_FORM_CLICKED_BUTTON = "ft_login_form_clicked_button";
    public static final String TRACK_LOGIN_CLOSED = "ft_login_closed";
    public static final String TRACK_EVENT_LOGOUT = "ft_logout";
    public static final String FT_LOGIN_SCREEN_LOAD = "ft_login_screen_load";
    public static final String FT_LOGIN_SCREEN_LOAD_SUCCESS = "ft_login_screen_load_success";
    public static final String FT_LOGIN_SCREEN_LOAD_FAIL = "ft_login_screen_load_fail";
    public static final String SESSION_VALUE = "session_value";
    public static final String DELTA_LOAD_PAGE_UPDATE_INFO_START_GAME = "page_load";
    public static final String TRACK_LOGIN_SUCCESS = "ft_login_success";
    public static final String TRACK_LOGOUT_SUCCESS = "ft_logout_success";
    public static final String START_PERMISISON = "ft_start_permisison";
    public static final String END_PERMISISON = "ft_end_permission";
    public static final String TRACK_FT_SESSION = "ft_session";
    long applauncherTime;

    private FunTrackingUtil() {
    }

    public static synchronized FunTrackingUtil getInstance() {
        if (instance == null) {
            instance = new FunTrackingUtil();
        }
        return instance;
    }

    public void init(final Application context) {
        try {
            Log.i((String)this.TAG, (String)"initAppsFlyer");
            MobGameSDK.applicationContext = context;
            AppsFlyerLib.getInstance().setCollectIMEI(false);
            AppsFlyerLib.getInstance().setCollectAndroidID(false);
            AppsFlyerLib.getInstance().setDebugLog(true);
            AppsFlyerLib.getInstance().init(this.appsflyerDevkey, null, (Context)context);
            AppsFlyerLib.getInstance().startTracking((Context)context);
            this.trackAppLaunch((Context)context);
            this.trackFirstLaunch((Context)context);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (MobGameSDK.getInstance().isLoggedIn()) {
                        EventClientManager.getInstance((Context)context).saveEventClient("start", FunTrackingUtil.STR_EVENT_LAUNCHER, null);
                    } else {
                        EventClientManager.getInstance((Context)context).saveEventClient("normal", FunTrackingUtil.STR_EVENT_LAUNCHER, null);
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void trackAppLaunch(Context context) {
        this.applauncherTime = System.currentTimeMillis();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time_app_launcher", this.applauncherTime);
        this.trackEvent(context, STR_EVENT_LAUNCHER, map);
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, STR_EVENT_LAUNCHER, null);
    }

    private void trackFirstLaunch(Context context) {
        if (Preference.getBoolean(context, TRACK_FIRST_LAUNCH, true)) {
            Log.d((String)this.TAG, (String)"event name : ft_first_launch");
            this.applauncherTime = System.currentTimeMillis();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("time_first_launcher", this.applauncherTime);
            this.trackEvent(context, TRACK_FIRST_LAUNCH, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_FIRST_LAUNCH, null);
            Preference.save(context, TRACK_FIRST_LAUNCH, false);
        }
    }

    public void trackStartPermisison(Activity activity) {
        this.trackEvent((Context)activity, START_PERMISISON, null);
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, START_PERMISISON, null);
    }

    public void trackEndPermisison(Activity activity) {
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, END_PERMISISON, null);
        this.trackEvent((Context)activity, END_PERMISISON, null);
    }

    public void trackSession(Activity activity, long deltaSession) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(SESSION_VALUE, String.valueOf(deltaSession));
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_FT_SESSION, hashMap);
            this.trackEvent((Context)activity, TRACK_FT_SESSION, hashMap);
            if (Preference.getBoolean((Context)activity, TRACK_FT_SESSION, true)) {
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_FT_SESSION, null);
                Preference.save((Context)activity, TRACK_FT_SESSION, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackCreateCharacterRequest(Context context, String type) {
        switch (type) {
            case "call": {
                this.trackEvent(context, FT_CHARACTER_CREATED_CALL, null);
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, FT_CHARACTER_CREATED_CALL, null);
                break;
            }
            case "success": {
                this.trackEvent(context, FT_CHARACTER_CREATED_CALL_SUCCESS, null);
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, FT_CHARACTER_CREATED_CALL_SUCCESS, null);
                break;
            }
            case "fail": {
                this.trackEvent(context, FT_CHARACTER_CREATED_CALL_FAIL, null);
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, FT_CHARACTER_CREATED_CALL_FAIL, null);
            }
        }
    }

    public void trackClickOverlayPermission(Context context) {
        Log.d((String)this.TAG, (String)"event name : ft_overlay_click_permission");
        try {
            this.trackEvent(context, TRACK_OVERLAY_CLICK_PERMISSION, null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_OVERLAY_CLICK_PERMISSION, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startExtractData(Context context) {
        try {
            Log.d((String)this.TAG, (String)"event name : ft_extract_started");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_extract_start", currentTime);
            hashMap.put("delta_extract_start", delta);
            this.trackEvent(context, TRACK_EXTRACT_STARTED, hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_EXTRACT_STARTED, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finishExtractData(Context context) {
        try {
            Log.d((String)this.TAG, (String)"event name : ft_extract_finished");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_extract_finish", currentTime);
            hashMap.put("delta_extract_finish", delta);
            this.trackEvent(context, TRACK_EXTRACT_FINISHED, hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_EXTRACT_FINISHED, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void trackLoyalUser(Context context, String eventName) {
        try {
            Log.d((String)this.TAG, (String)("event name : " + eventName));
            AppsFlyerLib.getInstance().trackEvent(context, eventName, null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, eventName, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackEvent(Context context, String eventName, Map<String, Object> eventValues) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (eventValues != null) {
                map.putAll(eventValues);
            }
            AppsFlyerLib.getInstance().trackEvent(context, eventName, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackOpenFormLogin(Activity activity) {
        Log.d((String)this.TAG, (String)"event name : ft_login_screen_opened");
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_FORM_LOGIN_OPENED, null);
            this.trackEvent((Context)activity, TRACK_FORM_LOGIN_OPENED, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackFinishLoadWebView(Activity activity, String labelUrl, long delta) {
    }

    public void trackLoginscreenLoadSuccess(Activity activity, long delta) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("deltaTime", delta);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, FT_LOGIN_SCREEN_LOAD_SUCCESS, hashMap);
            this.trackEvent((Context)activity, FT_LOGIN_SCREEN_LOAD_SUCCESS, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackErrorLoadWebView(Activity activity, String labelUrl) {
    }

    public void trackLoginScreenFail(Activity activity) {
        try {
            Log.d((String)this.TAG, (String)"event name : ft_login_screen_load_fail");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, FT_LOGIN_SCREEN_LOAD_FAIL, hashMap);
            FunTrackingUtil.getInstance().trackEvent((Context)activity, FT_LOGIN_SCREEN_LOAD_FAIL, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoginSuccess(Activity activity, String userId) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_login_success", currentTime);
            hashMap.put("delta_login_success", delta);
            hashMap.put("user_id", userId);
            this.trackEvent((Context)activity, "af_login", hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, "af_login", hashMap);
            Log.d((String)this.TAG, (String)"af_login");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackRegisterSuccess(Activity activity, String typeRegister) {
        try {
            Log.d((String)this.TAG, (String)"event name : ft_register_success");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("type_register", typeRegister);
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_register_success", currentTime);
            hashMap.put("delta_register_success", delta);
            hashMap.put("VALUE", typeRegister);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_REGISTER_SUCCESS, hashMap);
            this.trackEvent((Context)activity, TRACK_REGISTER_SUCCESS, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoginSuccessFromWeb(Activity activity, String typeLogin) {
        try {
            Log.d((String)this.TAG, (String)"event name : ft_login_success");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_login_success_from_web", currentTime);
            hashMap.put("delta_login_success_from_web", delta);
            hashMap.put("VALUE", typeLogin);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_LOGIN_SUCCESS, hashMap);
            this.trackEvent((Context)activity, TRACK_LOGIN_SUCCESS, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLogoutSuccess(Activity activity, String typeLogin) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_logout_success", currentTime);
            hashMap.put("delta_logout_success", delta);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_LOGOUT_SUCCESS, hashMap);
            this.trackEvent((Context)activity, TRACK_LOGOUT_SUCCESS, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoginClick(Activity activity, String label, HashMap<String, Object> typeLoginClick) {
        try {
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            typeLoginClick.put("current_login_click", currentTime);
            typeLoginClick.put("delta_login_click", delta);
            this.trackEvent((Context)activity, label, typeLoginClick);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, label, typeLoginClick);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoginButtonClick(Activity activity, String name) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("TYPE_LOGIN", name);
            this.trackEvent((Context)activity, TRACK_LOGIN_FORM_CLICKED_BUTTON, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_LOGIN_FORM_CLICKED_BUTTON, map);
            String a = AppsFlyerLib.getInstance().getAttributionId(this.context);
            Log.e((String)this.TAG, (String)("trackLoginButtonClick: " + a));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackPayment_LoginFormClick(Activity activity, String label, String value) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("VALUE", value);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, label, map);
            AppsFlyerLib.getInstance().trackEvent((Context)activity, label, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackPaymentSuccess(Activity activity, HashMap<String, Object> eventValue) {
        try {
            AppsFlyerLib.getInstance().trackEvent((Context)activity, "af_purchase", eventValue);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_FT_PAYMENT_SUCCESS, eventValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackingLogout(Activity activity) {
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_EVENT_LOGOUT, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceStarted(Activity activity) {
        try {
            Log.d((String)this.TAG, (String)"event name : ft_resource_started");
            HashMap<String, Object> map = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            map.put("current_start_download_res", currentTime);
            map.put("delta_start_download_resource", delta);
            this.trackEvent((Context)activity, TRACK_DOWNLOAD_RES_STARTED, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_DOWNLOAD_RES_STARTED, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceFinished(Activity activity) {
        try {
            Log.d((String)this.TAG, (String)"event name : ft_resource_finished");
            HashMap<String, Object> map = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            map.put("current_finish_download_res", currentTime);
            map.put("delta_finish_download_resource", delta);
            this.trackEvent((Context)activity, TRACK_DOWNLOAD_RES_FINISHED, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_DOWNLOAD_RES_FINISHED, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceFailed(Context context) {
        String gameVersionName = Utils.getGameVersion(context);
        String gameVersionCode = Utils.getGameVersionCode(context);
        String versionsave = Preference.getString(context, "GAME_VERSION");
        if (!versionsave.equals(gameVersionCode)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("version name", gameVersionName);
            map.put("version code", gameVersionCode);
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            map.put("current_fails_download_res", currentTime);
            map.put("delta_fails_download_resource", delta);
            this.trackEvent(context, TRACK_DOWNLOAD_RES_FAILED, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_DOWNLOAD_RES_FAILED, map);
        } else {
            Log.d((String)this.TAG, (String)"trackDownloadResourceFailed dont call because it is same version");
        }
    }

    public void firstByteDownloadResource(Context context) {
        try {
            Log.d((String)this.TAG, (String)"event name : ft_resource_first_byte");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_download_res_first_byte", currentTime);
            hashMap.put("delta_download_res_first_byte", delta);
            this.trackEvent(context, TRACK_DOWNLOAD_RES_FIRST_BYTE, hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_DOWNLOAD_RES_FIRST_BYTE, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void downloadResourceByPercent(Context context, String percent) {
        try {
            Log.d((String)this.TAG, (String)("event name : ft_resource_percent_" + percent));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_download_res_first_byte", currentTime);
            hashMap.put("delta_download_res_first_byte", delta);
            hashMap.put("delta_download_res_percent", percent);
            this.trackEvent(context, ("ft_resource_percent_" + percent).toString(), hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, ("ft_resource_percent_" + percent).toString(), hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showStartGameScreen(Context context) {
        try {
            Log.d((String)this.TAG, (String)"event name : ft_show_startgame");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_start_game_screen", currentTime);
            hashMap.put("delta_start_game_screen", delta);
            this.trackEvent(context, TRACK_SHOW_START_GAME_SCREEN, hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_SHOW_START_GAME_SCREEN, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackStartTutorial(Activity activity) {
        try {
            Log.d((String)this.TAG, (String)"event name : af_tutorial_started");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_StartTutorial", currentTime);
            hashMap.put("delta_StartTutorial", delta);
            this.trackEvent((Context)activity, TRACK_START_TUTORIAL, hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_START_TUTORIAL, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackFinishTutorial(Activity activity) {
        try {
            Log.d((String)this.TAG, (String)"event name : af_tutorial_completion");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.applauncherTime;
            hashMap.put("current_FinishTutorial", currentTime);
            hashMap.put("delta_FinishTutorial", delta);
            this.trackEvent((Context)activity, TRACK_FINISH_TUTORIAL, hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_FINISH_TUTORIAL, hashMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackGameCallCreateCharactor(Activity activity, String roleID, String areaID) {
    }

    public void trackLoadPageUpdateInfoUser(Activity activity, long deltaLoadPage) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("delta_load_page", deltaLoadPage);
            this.trackEvent((Context)activity, DELTA_LOAD_PAGE_UPDATE_INFO_START_GAME, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, DELTA_LOAD_PAGE_UPDATE_INFO_START_GAME, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackVipLevel(Activity activity, String roleID, String areaID, String vipLevel) {
        Log.d((String)this.TAG, (String)"trackVipLevel: ");
        Log.d((String)this.TAG, (String)"event name : ft_vip_achieved");
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            map.put("vip_level", vipLevel);
            this.trackEvent((Context)activity, FT_VIP_ACHIEVED, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, FT_VIP_ACHIEVED, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackReachALevel(Activity activity, String roleID, String areaID, String level) {
        Log.d((String)this.TAG, (String)"trackReachALevel: ");
        Log.d((String)this.TAG, (String)"event name : af_level_achieved");
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            map.put("level", level);
            this.trackEvent((Context)activity, TRACK_REACH_A_LEVEL, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, TRACK_REACH_A_LEVEL, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String levelTracking = null;
        try {
            if (GameConfigManager.getInstance() != null && GameConfigManager.getInstance().getGameConfig() != null && GameConfigManager.getInstance().getGameConfig().getLevel() != null) {
                levelTracking = GameConfigManager.getInstance().getGameConfig().getLevel();
            }
            Log.d((String)this.TAG, (String)("trackLevelPlatform: " + levelTracking));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (levelTracking != null) {
            String[] arrLevel = levelTracking.split(",");
            for (int i = 0; i < arrLevel.length; ++i) {
                try {
                    String anLevel = arrLevel[i];
                    if (Preference.getBoolean((Context)activity, TRACK_LEVEL_PLATFORM + anLevel, false) || Integer.parseInt(level) < Integer.parseInt(anLevel)) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("LEVEL", anLevel + "");
                    String eventName = TRACK_LEVEL_ACHIEVED_ + anLevel;
                    this.trackEvent((Context)activity, eventName, map);
                    FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)activity, eventName, map);
                    map.clear();
                    Preference.save((Context)activity, TRACK_LEVEL_PLATFORM + anLevel, true);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getAppsflyerDevkey() {
        return this.appsflyerDevkey;
    }

    public void setAppsflyerDevkey(String appsflyerDevkey) {
        this.appsflyerDevkey = appsflyerDevkey;
    }

    public String getGcmSenderId() {
        return this.gcmSenderId;
    }

    public void setGcmSenderId(String gcmSenderId) {
        this.gcmSenderId = gcmSenderId;
    }

    public String getAppsflyerId(Context context) {
        return AppsFlyerLib.getInstance().getAppsFlyerUID(context);
    }

    public void startSession(Application application) {
        long startSession = System.currentTimeMillis();
        Preference.save((Context)application, "start_session", startSession);
    }

    public void trackLoadTime(Activity activity, long deltaTime) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("TIME_VALUE", String.valueOf(deltaTime));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackPaymentClose(Context context, String label) {
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, label, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

