/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.component;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.google.ads.conversiontracking.AdWordsAutomatedUsageReporter;
import com.mobgame.MobGameSDK;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GoogleAuthManager;
import com.mobgame.model.CharacterInfo;
import com.mobgame.model.Game;
import com.mobgame.model.MobMenu;
import com.mobgame.model.MobPopup;
import com.mobgame.model.UserInfo;
import com.mobgame.utils.Preference;

public final class GameConfigManager {
    private static final String TAG = GameConfigManager.class.getSimpleName();
    public static final String SHARED_PREF_MACCESS_TOKEN = "shared_pref_maccess_token";
    private static GameConfigManager INSTANCE;
    public static final String SHARED_PREF_APPKEY = "shared_pref_appkey";
    private String appkey;
    private Game gameConfig;
    private UserInfo userInfo;
    private CharacterInfo characterInfo;
    private MobMenu mobMenu;
    private MobPopup mobPopup;
    private boolean show_qc;
    private String accessToken;
    private boolean hasUnreadNotifications;

    public static GameConfigManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GameConfigManager();
        }
        return INSTANCE;
    }

    public String getAppKey(Context context) {
        if (this.appkey == null || this.appkey.isEmpty()) {
            try {
                this.appkey = Preference.getString(context, SHARED_PREF_APPKEY);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.appkey;
    }

    public void setAppKey(Context context, String appkey) {
        this.appkey = appkey;
        try {
            Preference.save(context, SHARED_PREF_APPKEY, appkey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Game getGameConfig() {
        return this.gameConfig;
    }

    public void setGameConfig(Game gameConfig) {
        try {
            this.gameConfig = gameConfig;
            try {
                this.initAds(gameConfig.getAdsConfig());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Log.d((String)TAG, (String)("currentLang 1 : " + gameConfig.getLang()));
                this.initLang(gameConfig.getLang());
                this.initGoogleAuth();
                this.initFacebook(gameConfig.getFacebookId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public void clearUserInfo() {
        this.userInfo = null;
    }

    public CharacterInfo getCharacterInfo() {
        if (this.characterInfo == null) {
            this.characterInfo = new CharacterInfo();
        }
        return this.characterInfo;
    }

    public void setCharacterInfo(CharacterInfo characterInfo) {
        this.characterInfo = characterInfo;
    }

    public void clearCharacterInfo() {
        this.characterInfo = null;
    }

    public String getAccessToken() {
        if (this.accessToken == null) {
            this.accessToken = "";
            try {
                Activity a = MobGameSDK.activity;
                this.accessToken = a != null ? Preference.getString((Context)a, SHARED_PREF_MACCESS_TOKEN) : Preference.getString(MobGameSDK.getApplicationContext(), SHARED_PREF_MACCESS_TOKEN);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        Activity a = MobGameSDK.activity;
        try {
            if (a != null) {
                Preference.save((Context)a, SHARED_PREF_MACCESS_TOKEN, accessToken);
            } else {
                Preference.save(MobGameSDK.getApplicationContext(), SHARED_PREF_MACCESS_TOKEN, accessToken);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.accessToken = accessToken;
    }

    public void clearAccessToken() {
        try {
            Activity a = MobGameSDK.activity;
            if (a != null) {
                Preference.remove((Context)a, SHARED_PREF_MACCESS_TOKEN);
            } else {
                Preference.remove(MobGameSDK.getApplicationContext(), SHARED_PREF_MACCESS_TOKEN);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.accessToken = null;
    }

    public MobMenu getMobMenu() {
        if (this.mobMenu == null) {
            this.mobMenu = new MobMenu();
        }
        return this.mobMenu;
    }

    public void setMobMenu(MobMenu mobMenu) {
        this.mobMenu = mobMenu;
    }

    public MobPopup getMobPopup() {
        if (this.mobPopup == null) {
            this.mobPopup = new MobPopup();
        }
        return this.mobPopup;
    }

    public void setMobPopup(MobPopup mobPopup) {
        this.mobPopup = mobPopup;
    }

    public void clearMobMenu() {
        this.mobMenu = null;
    }

    public void clearLogin() {
        this.clearMobMenu();
        this.clearUserInfo();
        this.clearCharacterInfo();
        this.clearAccessToken();
    }

    public boolean isHasUnreadNotifications() {
        return this.hasUnreadNotifications;
    }

    public void setHasUnreadNotifications(boolean hasUnreadNotifications) {
        this.hasUnreadNotifications = hasUnreadNotifications;
    }

    public void clearUnreadNotifications() {
        this.hasUnreadNotifications = false;
    }

    public String getFacebookId() {
        return this.gameConfig.getFacebookId();
    }

    private void initFacebook(String facebookAppId) {
        try {
            Log.i((String)TAG, (String)"initFacebook");
            Activity a = MobGameSDK.activity;
            FacebookManager.getInstance().init(a.getApplicationContext(), facebookAppId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initGoogleAuth() {
        try {
            Activity a = MobGameSDK.activity;
            GoogleAuthManager.getInstance().init(a);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initAdwords(Game.AdwordsConfig config) {
        try {
            Activity a = MobGameSDK.activity;
            String conversionId = config.getConversionId();
            if (a != null) {
                AdWordsAutomatedUsageReporter.enableAutomatedUsageReporting((Context)a.getApplicationContext(), (String)conversionId);
            } else {
                AdWordsAutomatedUsageReporter.enableAutomatedUsageReporting((Context)MobGameSDK.getApplicationContext(), (String)conversionId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initAds(Game.AdsConfig config) {
        try {
            Activity a = MobGameSDK.activity;
            Preference.save((Context)a, "FunAdsApikey", config.getApiKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getShow_qc() {
        return this.show_qc;
    }

    public void setShow_qc(boolean show_qc) {
        this.show_qc = show_qc;
    }

    private void initLang(String lang) {
        try {
            if ("vie".equalsIgnoreCase(lang) || "vi".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("vie");
            } else if ("eng".equalsIgnoreCase(lang) || "en".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("eng");
            } else if ("es_es".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("es_es");
            } else if ("zh".equalsIgnoreCase(lang) || "zh_cn".equalsIgnoreCase(lang) || "zh_tw".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("zh_cn");
            } else if ("th".equalsIgnoreCase(lang) || "tha".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("tha");
            } else if ("ind".equalsIgnoreCase(lang) || "id".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("ind");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

