/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.js;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.facebook.AccessToken;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.mobgame.R;
import com.mobgame.api.PostTask;
import com.mobgame.component.EventClientManager;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAuthManager;
import com.mobgame.gui.MobGameWebFragment2;
import com.mobgame.gui.dialog.MobGameDialogStartWebFragment;
import com.mobgame.gui.dialog.MobGameDialogWebviewFragment;
import com.mobgame.model.MobAccessToken;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
import java.util.HashMap;
import java.util.Set;
import org.json.JSONObject;

final class CmdLogin {
    private static final String TAG = CmdLogin.class.getSimpleName();
    private static CmdLogin INSTANCE;

    private CmdLogin() {
    }

    public static CmdLogin getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdLogin();
        }
        return INSTANCE;
    }

    void mobLoginSuccess(Activity activity, MobGameWebFragment2 webFragment, MobGameDialogWebviewFragment dialogWebviewFragment, String params) {
        try {
            Log.d((String)TAG, (String)("mobLoginSuccess : " + params));
            JSONObject json = new JSONObject(params);
            String user = json.getString("User");
            JSONObject jsonUser = new JSONObject(user);
            int is_register = -1;
            String register_name = "";
            if (jsonUser.has("is_register")) {
                is_register = jsonUser.getInt("is_register");
            }
            if (jsonUser.has("register_name")) {
                register_name = jsonUser.getString("register_name");
            }
            Log.i((String)TAG, (String)("mobLoginSuccess :" + is_register + " , " + register_name));
            if (is_register == 1) {
                FunTrackingUtil.getInstance().trackRegisterSuccess(activity, register_name);
            } else {
                FunTrackingUtil.getInstance().trackLoginSuccessFromWeb(activity, register_name);
            }
            Utils.hideLoading();
            MobAccessToken accessToken = MobAccessToken.parse(params);
            GameConfigManager.getInstance().setAccessToken(accessToken.getToken());
            EventClientManager.getInstance((Context)activity).setMobgameToken(accessToken.getToken());
            if (dialogWebviewFragment != null) {
                dialogWebviewFragment.dismiss();
            }
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "login");
            LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void mobLoginGuest(final Activity activity, MobGameWebFragment2 webFragment, String params) {
        Log.i((String)TAG, (String)"mobLoginGuest");
        Log.d((String)TAG, (String)"event name : Login PlayNow");
        FunTrackingUtil.getInstance().trackLoginButtonClick(activity, "Login PlayNow");
        try {
            Utils.showLoading(activity, Res.string((Context)activity, R.string.logging_in));
            String mac_address = DeviceUtils.getUniqueDeviceID((Context)activity);
            String key = Utils.getSHACheckSum(mac_address + "abc");
            HashMap<String, String> postParams = new HashMap<String, String>();
            postParams.put("mac_address", mac_address);
            postParams.put("key", key);
            webFragment.postUrlWithLibraryHeaders(Constants.URL_RECEIVE_MAC_ADDRESS, postParams, new PostTask.Callback(){

                @Override
                public void onSuccess(String response) {
                    Log.d((String)TAG, (String)("response guest : " + response));
                    Utils.hideLoading();
                }

                @Override
                public void onFailure(Throwable e) {
                    e.printStackTrace();
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
        }
    }

    void mobLoginFacebook(final Activity activity, final MobGameWebFragment2 webFragment, String params) {
        Log.i((String)TAG, (String)("mobLoginStartFb:" + params));
        Log.d((String)TAG, (String)"event name : Login FB");
        FunTrackingUtil.getInstance().trackLoginButtonClick(activity, "Login FB");
        Utils.showLoading(activity, "", Res.string((Context)activity, R.string.connecting_facebook), false);
        FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback(){

            @Override
            public void onSuccess(AccessToken accessToken, Set<String> recentlyGrantedPermissions, Set<String> recentlyDeniedPermissions) {
                Log.d((String)TAG, (String)("onSuccess response facebook : " + accessToken.getToken() + recentlyDeniedPermissions + recentlyGrantedPermissions));
                try {
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("access_token", accessToken.getToken());
                    Log.d((String)TAG, (String)("onSuccess: " + accessToken.getToken()));
                    webFragment.postUrlWithLibraryHeaders(Constants.URL_RECEIVE_ACCESS_TOKEN, postParams, new PostTask.Callback(){

                        @Override
                        public void onSuccess(String response) {
                            Log.d((String)TAG, (String)("response facebook : " + response));
                            Utils.hideLoading();
                        }

                        @Override
                        public void onFailure(Throwable e) {
                            Log.d((String)TAG, (String)("faile Facebook : " + e));
                            Utils.hideLoading();
                        }
                    });
                }
                catch (Exception e) {
                    Log.d((String)TAG, (String)(" Exception e" + e));
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                    Utils.hideLoading();
                }
            }

            @Override
            public void onCancel() {
                Log.d((String)TAG, (String)"Facebook Cancel ");
                Utils.hideLoading();
            }

            @Override
            public void onError(Throwable t) {
                Log.d((String)TAG, (String)("Facebook Error " + t));
                Utils.hideLoading();
                CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
            }
        });
    }

    void mobUpgradeFacebook(final Activity activity, final MobGameWebFragment2 webFragment, final MobGameDialogWebviewFragment webDialogFragment, final MobGameDialogStartWebFragment dialogStartWebFragment, String params) {
        Log.i((String)TAG, (String)("mobFacebookForUpdate:" + params + webFragment + (Object)((Object)webDialogFragment)));
        Utils.showLoading(activity, Res.string((Context)activity, R.string.connecting_facebook));
        FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback(){

            @Override
            public void onSuccess(AccessToken accessToken, Set<String> recentlyGrantedPermissions, Set<String> recentlyDeniedPermissions) {
                Utils.hideLoading();
                try {
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("token", accessToken.getToken());
                    if (webDialogFragment != null) {
                        webDialogFragment.postUrlWithMobHeaders(Constants.URL_UPDATE_FROM_FACEBOOK, postParams);
                    } else if (webFragment != null) {
                        webFragment.postUrlWithLibraryHeaders(Constants.URL_UPDATE_FROM_FACEBOOK, postParams);
                    } else if (dialogStartWebFragment != null) {
                        dialogStartWebFragment.postUrlWithMobHeaders(Constants.URL_UPDATE_FROM_FACEBOOK, postParams);
                    }
                }
                catch (Exception e) {
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                }
            }

            @Override
            public void onCancel() {
                Utils.hideLoading();
            }

            @Override
            public void onError(Throwable t) {
                Utils.hideLoading();
            }
        });
    }

    void mobLoginGooglePlay(final Activity activity, final MobGameWebFragment2 webFragment, final String params) {
        Log.i((String)TAG, (String)"mobLoginGooglePlay");
        Log.d((String)TAG, (String)"event name : ft_login_form_clicked_button");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TYPE_LOGIN", "Login GG");
        FunTrackingUtil.getInstance().trackLoginClick(activity, "ft_login_form_clicked_button", map);
        if (!Utils.isOnline((Context)activity)) {
            this.handleException(activity, Res.string((Context)activity, R.string.connection_lost));
            return;
        }
        if (!GoogleAuthManager.getInstance().isGoogleServiceAvailable(activity)) {
            Log.d((String)TAG, (String)"Google Play Service is out of date. Request update...");
            return;
        }
        Utils.showLoading(activity, "", Res.string((Context)activity, R.string.connecting_google_play), true);
        GoogleAuthManager.getInstance().login(activity, new GoogleAuthManager.GooglePlusResultCallback(){

            @Override
            public void onLoginSuccess(GoogleSignInAccount account, String mToken) {
                Log.d((String)TAG, (String)("Google Token: " + mToken));
                try {
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("id_token", mToken);
                    webFragment.postUrlWithLibraryHeaders(Constants.URL_LOGIN_GOOGLE_ACCOUNT, postParams, new PostTask.Callback(){

                        @Override
                        public void onSuccess(String response) {
                            Log.d((String)TAG, (String)"Google Login Success");
                            CmdLogin.this.getFullResponse(response);
                            Utils.hideLoading();
                        }

                        @Override
                        public void onFailure(Throwable e) {
                            Log.wtf((String)"onFailure", (String)e.getLocalizedMessage());
                            Utils.hideLoading();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                    e.printStackTrace();
                    Utils.hideLoading();
                }
                Log.wtf((String)"mobLoginGooglePlay", (String)("onLoginSuccess: Token: " + mToken + " Email: " + account.getEmail()));
            }

            @Override
            public void onLoginError(String mess, int code) {
                Log.e((String)TAG, (String)"Sign in google error");
                if (!TextUtils.isEmpty((CharSequence)mess) && code != 12502) {
                    CmdLogin.this.handleException(activity, mess);
                }
                Utils.hideLoading();
                if (code == 12502) {
                    CmdLogin.this.mobLoginGooglePlay2(activity, webFragment, params);
                }
            }
        });
    }

    void mobLoginGooglePlay2(final Activity activity, final MobGameWebFragment2 webFragment, final String params) {
        Log.i((String)TAG, (String)"mobLoginGooglePlay");
        if (!Utils.isOnline((Context)activity)) {
            this.handleException(activity, Res.string((Context)activity, R.string.connection_lost));
            return;
        }
        if (!GoogleAuthManager.getInstance().isGoogleServiceAvailable(activity)) {
            Log.d((String)TAG, (String)"Google Play Service is out of date. Request update...");
            return;
        }
        Utils.showLoading(activity, "", Res.string((Context)activity, R.string.connecting_google_play), true);
        GoogleAuthManager.getInstance().login(activity, new GoogleAuthManager.GooglePlusResultCallback(){

            @Override
            public void onLoginSuccess(GoogleSignInAccount account, String mToken) {
                Log.d((String)TAG, (String)("Google Token: " + mToken));
                try {
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("id_token", mToken);
                    webFragment.postUrlWithLibraryHeaders(Constants.URL_LOGIN_GOOGLE_ACCOUNT, postParams, new PostTask.Callback(){

                        @Override
                        public void onSuccess(String response) {
                            Log.d((String)TAG, (String)"Google Login Success");
                            CmdLogin.this.getFullResponse(response);
                            Utils.hideLoading();
                        }

                        @Override
                        public void onFailure(Throwable e) {
                            Log.wtf((String)"onFailure", (String)e.getLocalizedMessage());
                            Utils.hideLoading();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                    e.printStackTrace();
                    Utils.hideLoading();
                }
                Log.wtf((String)"mobLoginGooglePlay", (String)("onLoginSuccess: Token: " + mToken + " Email: " + account.getEmail()));
            }

            @Override
            public void onLoginError(String mess, int code) {
                Log.e((String)TAG, (String)"Sign in google error");
                if (!TextUtils.isEmpty((CharSequence)mess) && code != 12502) {
                    CmdLogin.this.handleException(activity, mess);
                }
                Utils.hideLoading();
                if (code == 12502) {
                    CmdLogin.this.mobLoginGooglePlay(activity, webFragment, params);
                }
            }
        });
    }

    private void getFullResponse(String sb) {
        try {
            if (sb.length() > 4000) {
                Log.wtf((String)"onResponse", (String)("sb.length = " + sb.length()));
                int chunkCount = sb.length() / 4000;
                for (int i = 0; i <= chunkCount; ++i) {
                    int max = 4000 * (i + 1);
                    if (max >= sb.length()) {
                        Log.wtf((String)"onResponse", (String)("chunk " + i + " of " + chunkCount + ":" + sb.substring(4000 * i)));
                        continue;
                    }
                    Log.wtf((String)"onResponse", (String)("chunk " + i + " of " + chunkCount + ":" + sb.substring(4000 * i, max)));
                }
            } else {
                Log.wtf((String)TAG, (String)sb.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void mobLoginGoogleAccount(Activity activity, MobGameWebFragment2 webFragment, String params) {
        Log.i((String)TAG, (String)"mobLoginGoogleAccount");
    }

    private void handleException(final Activity activity, final String message) {
        Utils.hideLoading();
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)activity, (CharSequence)message, (int)1).show();
            }
        });
    }
}

