/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.api;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import com.mobgame.MobGameSDK;
import com.mobgame.api.RestfulApi;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.EncodedResponse;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.EncryptionUtils;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.Utils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class PostTask
extends AsyncTask<Void, Void, Void> {
    private String url;
    private Map<String, String> postParams;
    private boolean isEncrypted;
    private Callback callback;
    private boolean isInviteFriend = false;
    private String accountId;
    private Activity mActivity;

    public PostTask(String url) {
        this.url = url;
    }

    public PostTask(String url, boolean isEncrypted) {
        this.url = url;
        this.isEncrypted = isEncrypted;
    }

    public PostTask(String url, Map<String, String> postParams, boolean isEncrypted) {
        this.url = url;
        this.postParams = postParams;
        this.isEncrypted = isEncrypted;
    }

    public PostTask(Activity activity, String url, Map<String, String> postParams, boolean isEncrypted, Callback callback) {
        this.mActivity = activity;
        this.url = url;
        this.postParams = postParams;
        this.isEncrypted = isEncrypted;
        this.callback = callback;
    }

    public PostTask(String url, Map<String, String> postParams, boolean isEncrypted, Callback callback) {
        this.url = url;
        this.postParams = postParams;
        this.isEncrypted = isEncrypted;
        this.callback = callback;
    }

    public PostTask(String url, Map<String, String> postParams, boolean isEncrypted, boolean isInviteFriend, String accountId, Callback callback) {
        this.url = url;
        this.postParams = postParams;
        this.isEncrypted = isEncrypted;
        this.callback = callback;
        this.isInviteFriend = isInviteFriend;
        this.accountId = accountId;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    protected Void doInBackground(Void ... params) {
        block15: {
            try {
                RequestBody formBody;
                Context c = MobGameSDK.getApplicationContext();
                OkHttpClient client = RestfulApi.getCommonClient();
                Log.d((String)"PostTask", (String)("doInBackground: " + c.toString() + client));
                if (this.postParams == null) {
                    formBody = RequestBody.create(null, (byte[])new byte[0]);
                    Log.d((String)"PostTask", (String)("doInBackground: 1 " + formBody));
                } else {
                    FormBody.Builder builder = new FormBody.Builder();
                    for (String key : this.postParams.keySet()) {
                        builder.add(key, Objects.requireNonNull(this.postParams.get(key)));
                    }
                    formBody = builder.build();
                    Log.d((String)"PostTask", (String)("doInBackground: 2 " + formBody));
                }
                GameConfigManager config = GameConfigManager.getInstance();
                Log.d((String)"PostTask", (String)("doInBackground: 3 " + this.isEncrypted));
                if (this.isEncrypted) {
                    Uri uri = Uri.parse((String)this.url);
                    if (uri.getQueryParameter("sign") == null) {
                        if (this.isInviteFriend) {
                            Log.d((String)"PostTask", (String)("doInBackground: 4 " + this.isInviteFriend));
                            this.url = uri.buildUpon().appendQueryParameter("sign", EncryptionUtils.getSignedString(c, this.accountId)).build().toString();
                        } else {
                            this.url = uri.buildUpon().appendQueryParameter("sign", EncryptionUtils.getSignedString(c)).build().toString();
                        }
                    }
                    Log.d((String)"PostTask", (String)("doInBackground: 5 " + uri.getQueryParameter("sign")));
                    Request request = new Request.Builder().url(this.url).method("POST", formBody).addHeader("mobgame-device", Utils.stringNormalize(DeviceUtils.getDevice())).addHeader("mobgame-os", Utils.stringNormalize(DeviceUtils.getOSInfo())).addHeader("mobgame-resolution", Utils.stringNormalize(DeviceUtils.getResolution((Context)this.mActivity))).addHeader("mobgame-sdk-version", Utils.stringNormalize(Utils.getSDKVersion((Context)this.mActivity))).addHeader("mobgame-appkey", Utils.stringNormalize(config.getAppKey(c))).addHeader("mobgame-app-version", Utils.stringNormalize(Utils.getGameVersion((Context)this.mActivity))).addHeader("mobgame-app-version-code", Utils.stringNormalize(Utils.getGameVersionCode((Context)this.mActivity))).addHeader("mobgame-network", Utils.stringNormalize(Utils.getNetwork((Context)this.mActivity))).addHeader("mobgame-token", Utils.stringNormalize(config.getAccessToken())).addHeader("mobgame-role-id", Utils.stringNormalize(config.getCharacterInfo().getRoleId())).addHeader("mobgame-area-id", Utils.stringNormalize(config.getCharacterInfo().getAreaId())).addHeader("mobgame-role-name", Utils.stringNormalize(config.getCharacterInfo().getRoleName())).addHeader("mobgame-area-name", Utils.stringNormalize(config.getCharacterInfo().getAreaName())).addHeader("mobgame-orientation", Utils.stringNormalize(DeviceUtils.getScreenOrientation((Context)this.mActivity) + "")).addHeader("mobgame_lang", Utils.stringNormalize(DeviceUtils.getLanguage())).addHeader("mobgame-distributor", Utils.stringNormalize(Utils.getReferrer((Context)this.mActivity))).addHeader("mobgame-advertising-id", Utils.stringNormalize(DeviceUtils.getAdvertisingID((Context)this.mActivity))).addHeader("mobgame-appsflyer-id", FunTrackingUtil.getInstance().getAppsflyerId((Context)this.mActivity)).build();
                    String result = Objects.requireNonNull(client.newCall(request).execute().body()).string();
                    if (this.isInviteFriend) {
                        if (this.callback != null) {
                            this.callback.onSuccess("success");
                            Log.d((String)"PostTask", (String)"doInBackground: 6 ");
                        }
                    } else {
                        EncodedResponse response = EncodedResponse.parse(result);
                        if (this.callback != null) {
                            this.callback.onSuccess(response.getDecodedData());
                            Log.d((String)"PostTask", (String)("doInBackground: 7 " + response.getDecodedData()));
                        }
                    }
                } else {
                    Request request = new Request.Builder().url(this.url).method("POST", formBody).addHeader("mobgame-device", Utils.stringNormalize(DeviceUtils.getDevice())).addHeader("mobgame-os", Utils.stringNormalize(DeviceUtils.getOSInfo())).addHeader("mobgame-resolution", Utils.stringNormalize(DeviceUtils.getResolution((Context)this.mActivity))).addHeader("mobgame-sdk-version", Utils.stringNormalize(Utils.getSDKVersion((Context)this.mActivity))).addHeader("mobgame-appkey", Utils.stringNormalize(config.getAppKey(c))).addHeader("mobgame-app-version", Utils.stringNormalize(Utils.getGameVersion((Context)this.mActivity))).addHeader("mobgame-app-version-code", Utils.stringNormalize(Utils.getGameVersionCode((Context)this.mActivity))).addHeader("mobgame-network", Utils.stringNormalize(Utils.getNetwork((Context)this.mActivity))).addHeader("mobgame-token", Utils.stringNormalize(config.getAccessToken())).addHeader("mobgame-role-id", Utils.stringNormalize(config.getCharacterInfo().getRoleId())).addHeader("mobgame-area-id", Utils.stringNormalize(config.getCharacterInfo().getAreaId())).addHeader("mobgame-role-name", Utils.stringNormalize(config.getCharacterInfo().getRoleName())).addHeader("mobgame-area-name", Utils.stringNormalize(config.getCharacterInfo().getAreaName())).addHeader("mobgame-orientation", Utils.stringNormalize(DeviceUtils.getScreenOrientation((Context)this.mActivity) + "")).addHeader("mobgame_lang", Utils.stringNormalize(DeviceUtils.getLanguage())).addHeader("mobgame-distributor", Utils.stringNormalize(Utils.getReferrer((Context)this.mActivity))).addHeader("mobgame-advertising-id", Utils.stringNormalize(DeviceUtils.getAdvertisingID((Context)this.mActivity))).addHeader("mobgame-appsflyer-id", FunTrackingUtil.getInstance().getAppsflyerId((Context)this.mActivity)).build();
                    String response = Objects.requireNonNull(client.newCall(request).execute().body()).string();
                    Log.d((String)"PostTask", (String)("doInBackground: 8 " + response + this.callback.toString()));
                    if (this.callback != null) {
                        this.callback.onSuccess(response);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.callback == null) break block15;
                this.callback.onFailure(e);
            }
        }
        return null;
    }

    public static interface Callback {
        public void onSuccess(String var1);

        public void onFailure(Throwable var1);
    }
}

