package com.mobgame.js;

import android.app.Activity;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;

import com.facebook.AccessToken;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.koushikdutta.async.http.socketio.ExceptionCallback;
import com.mobgame.MobGameHelper;
import com.mobgame.R;
import com.mobgame.api.PostTask;
import com.mobgame.api.PostTask.Callback;
import com.mobgame.component.EventClientManager;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAuthManager;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.gui.MobGameWebFragment2;
import com.mobgame.gui.dialog.MobGameDialogStartWebFragment;
import com.mobgame.gui.dialog.MobGameDialogWebviewFragment;
import com.mobgame.model.Game;
import com.mobgame.model.MobAccessToken;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.OperationSdkIndex;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Set;

import static com.google.android.gms.auth.api.signin.GoogleSignInStatusCodes.SIGN_IN_CURRENTLY_IN_PROGRESS;


final class CmdLogin {

	private static final String TAG = CmdLogin.class.getSimpleName();
	private static CmdLogin INSTANCE;

	private CmdLogin() {}

	public static CmdLogin getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new CmdLogin();
		}
		return INSTANCE;
	}

	void mobLoginSuccess(final Activity activity, MobGameWebFragment2 webFragment, MobGameDialogWebviewFragment dialogWebviewFragment, String params) {
		try{
			Log.d(TAG , "mobLoginSuccess : " + params);
			JSONObject json = new JSONObject(params);
			String user = json.getString("User");
			JSONObject jsonUser = new JSONObject(user);
			int is_register = -1;
			String register_name = "";
			if(jsonUser.has("is_register")){
				is_register = jsonUser.getInt("is_register");
			}
			if(jsonUser.has("register_name")){
				register_name = jsonUser.getString("register_name");
			}
			Log.i(TAG, "mobLoginSuccess :"  + is_register + " , "+ register_name);

			if(is_register == 1){
				FunTrackingUtil.getInstance().trackRegisterSuccess(activity , register_name);
			}else{
				FunTrackingUtil.getInstance().trackLoginSuccessFromWeb(activity , register_name);
			}
			Utils.hideLoading();
			MobAccessToken accessToken = MobAccessToken.parse(params);
			GameConfigManager.getInstance().setAccessToken(accessToken.getToken());
			EventClientManager.getInstance(activity).setMobgameToken(accessToken.getToken());
			if(dialogWebviewFragment!=null){
				dialogWebviewFragment.dismiss();
			}

			Intent intent = new Intent(Constants.INTENT_FILTER);
			intent.putExtra("category", "login");
			LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	void mobLoginGuest(final Activity activity, MobGameWebFragment2 webFragment, String params) {
		Log.i(TAG, "mobLoginGuest");
		Log.d(TAG, "event name : " + "Login PlayNow");
		FunTrackingUtil.getInstance().trackLoginButtonClick(activity ,"Login PlayNow");

		try {
			Utils.showLoading(activity, Res.string(activity, R.string.logging_in));
			String mac_address = DeviceUtils.getUniqueDeviceID(activity);
			String key = Utils.getSHACheckSum(mac_address + "abc");

			HashMap<String, String> postParams = new HashMap<String, String>();
			postParams.put("mac_address", mac_address);
			postParams.put("key", key);
			webFragment.postUrlWithLibraryHeaders(Constants.URL_RECEIVE_MAC_ADDRESS, postParams, new PostTask.Callback() {

				@Override
				public void onSuccess(String response) {
					Log.d(TAG , "response guest : " + response);
					Utils.hideLoading();
				}

				@Override
				public void onFailure(Throwable e) {
					e.printStackTrace();
					handleException(activity, Res.string(activity, R.string.something_went_wrong));
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
			handleException(activity, Res.string(activity, R.string.something_went_wrong));
		}
	}

	void mobLoginFacebook(final Activity activity, final MobGameWebFragment2 webFragment, String params) {
		Log.i(TAG, "mobLoginStartFb:" + params);
		Log.d(TAG, "event name : " + "Login FB");
		FunTrackingUtil.getInstance().trackLoginButtonClick(activity ,"Login FB");
		Utils.showLoading(activity, "", Res.string(activity, R.string.connecting_facebook), false);
		FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback() {

			@Override
			public void onSuccess(AccessToken accessToken,
					Set<String> recentlyGrantedPermissions,
					Set<String> recentlyDeniedPermissions) {
				Log.d(TAG , "onSuccess response facebook : " + accessToken.getToken() + recentlyDeniedPermissions + recentlyGrantedPermissions);
				try {

					HashMap<String, String> postParams = new HashMap<String, String>();
					postParams.put("access_token", accessToken.getToken());
					Log.d(TAG, "onSuccess: " + accessToken.getToken());
					webFragment.postUrlWithLibraryHeaders(Constants.URL_RECEIVE_ACCESS_TOKEN, postParams, new Callback() {

						@Override
						public void onSuccess(String response) {
							Log.d(TAG , "response facebook : " + response);
							Utils.hideLoading();
						}

						@Override
						public void onFailure(Throwable e) {
							Log.d(TAG , "faile Facebook : " + e);
							Utils.hideLoading();
						}
					});
				} catch (Exception e) {
					Log.d(TAG , " Exception e" + e);
					handleException(activity, Res.string(activity, R.string.something_went_wrong));
					Utils.hideLoading();
				}

			}

			@Override
			public void onCancel() {
				Log.d(TAG , "Facebook Cancel ");
				Utils.hideLoading();
			}

			@Override
			public void onError(Throwable t) {
				Log.d(TAG , "Facebook Error "+t);
				Utils.hideLoading();
				handleException(activity, Res.string(activity, R.string.something_went_wrong));
			}

		});
	}

	void mobUpgradeFacebook(final Activity activity, final MobGameWebFragment2 webFragment , final MobGameDialogWebviewFragment webDialogFragment, final MobGameDialogStartWebFragment dialogStartWebFragment, String params) {
		Log.i(TAG, "mobFacebookForUpdate:" + params + webFragment + webDialogFragment);
		Utils.showLoading(activity, Res.string(activity, R.string.connecting_facebook));

		FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback() {

			@Override
			public void onSuccess(AccessToken accessToken,
					Set<String> recentlyGrantedPermissions,
					Set<String> recentlyDeniedPermissions) {

				Utils.hideLoading();
				try {
					HashMap<String, String> postParams = new HashMap<String, String>();
					postParams.put("token", accessToken.getToken());
					if(webDialogFragment != null){
						webDialogFragment.postUrlWithMobHeaders(Constants.URL_UPDATE_FROM_FACEBOOK, postParams);
//						webDialogFragment.dismiss();
					}else if(webFragment != null){
						webFragment.postUrlWithLibraryHeaders(Constants.URL_UPDATE_FROM_FACEBOOK, postParams);
					} else if (dialogStartWebFragment != null){
						dialogStartWebFragment.postUrlWithMobHeaders(Constants.URL_UPDATE_FROM_FACEBOOK, postParams);
					}
				} catch (Exception e) {
					handleException(activity, Res.string(activity, R.string.something_went_wrong));
				} 
			
			}

			@Override
			public void onCancel() {
				Utils.hideLoading();
			}

			@Override
			public void onError(Throwable t) {
				Utils.hideLoading();
			}
			
		});
	}

    void mobLoginGooglePlay(final Activity activity, final MobGameWebFragment2 webFragment, String params) {
        Log.i(TAG, "mobLoginGooglePlay");
        Log.d(TAG, "event name : " + FunTrackingUtil.TRACK_LOGIN_FORM_CLICKED_BUTTON);
        HashMap<String, Object> map = new HashMap<>();
        map.put("TYPE_LOGIN", "Login GG");
        FunTrackingUtil.getInstance().trackLoginClick(activity, FunTrackingUtil.TRACK_LOGIN_FORM_CLICKED_BUTTON, map);
        if (!Utils.isOnline(activity)) {
            handleException(activity, Res.string(activity, R.string.connection_lost));
            return;
        }

        if (!GoogleAuthManager.getInstance().isGoogleServiceAvailable(activity)) {
            Log.d(TAG, "Google Play Service is out of date. Request update...");
            return;
        }
        Utils.showLoading(activity, "", Res.string(activity, R.string.connecting_google_play), true);

        GoogleAuthManager.getInstance().login(activity, new GoogleAuthManager.GooglePlusResultCallback() {


            @Override
            public void onLoginSuccess(GoogleSignInAccount account, String mToken) {
                Log.d(TAG, "Google Token: " + mToken);

                try {
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("id_token", mToken);
                    webFragment.postUrlWithLibraryHeaders(Constants.URL_LOGIN_GOOGLE_ACCOUNT,
                            postParams, new PostTask.Callback() {
                                @Override
                                public void onSuccess(String response) {
                                    Log.d(TAG, "Google Login Success");
                                    getFullResponse(response);
                                    Utils.hideLoading();
                                }

                                @Override
                                public void onFailure(Throwable e) {
                                    Log.wtf("onFailure", e.getLocalizedMessage());
                                    Utils.hideLoading();
                                }
                            });

                } catch (Exception e) {
                    e.printStackTrace();
                    handleException(activity, Res.string(activity, R.string.something_went_wrong));
                    e.printStackTrace();
                    Utils.hideLoading();
                }
                Log.wtf("mobLoginGooglePlay", "onLoginSuccess: Token: " + mToken + " Email: " + account.getEmail());
            }

            @Override
            public void onLoginError(String mess, int code) {
//				Log.wtf("mobLoginGooglePlay", "Error: " + mess);
                Log.e(TAG, "Sign in google error");
                if (!TextUtils.isEmpty(mess) && code != SIGN_IN_CURRENTLY_IN_PROGRESS) {
                    handleException(activity, mess);
                }

                Utils.hideLoading();
                if (code == SIGN_IN_CURRENTLY_IN_PROGRESS) {
                    mobLoginGooglePlay2(activity, webFragment, params);
                }

            }

        });

    }

    void mobLoginGooglePlay2(final Activity activity, final MobGameWebFragment2 webFragment, String params) {
        Log.i(TAG, "mobLoginGooglePlay");
        if (!Utils.isOnline(activity)) {
            handleException(activity, Res.string(activity, R.string.connection_lost));
            return;
        }

        if (!GoogleAuthManager.getInstance().isGoogleServiceAvailable(activity)) {
            Log.d(TAG, "Google Play Service is out of date. Request update...");
            return;
        }
        Utils.showLoading(activity, "", Res.string(activity, R.string.connecting_google_play), true);

        GoogleAuthManager.getInstance().login(activity, new GoogleAuthManager.GooglePlusResultCallback() {


            @Override
            public void onLoginSuccess(GoogleSignInAccount account, String mToken) {
                Log.d(TAG, "Google Token: " + mToken);

                try {
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("id_token", mToken);
                    webFragment.postUrlWithLibraryHeaders(Constants.URL_LOGIN_GOOGLE_ACCOUNT,
                            postParams, new PostTask.Callback() {
                                @Override
                                public void onSuccess(String response) {
                                    Log.d(TAG, "Google Login Success");
                                    getFullResponse(response);
                                    Utils.hideLoading();
                                }

                                @Override
                                public void onFailure(Throwable e) {
                                    Log.wtf("onFailure", e.getLocalizedMessage());
                                    Utils.hideLoading();
                                }
                            });

                } catch (Exception e) {
                    e.printStackTrace();
                    handleException(activity, Res.string(activity, R.string.something_went_wrong));
                    e.printStackTrace();
                    Utils.hideLoading();
                }
                Log.wtf("mobLoginGooglePlay", "onLoginSuccess: Token: " + mToken + " Email: " + account.getEmail());
            }

            @Override
            public void onLoginError(String mess, int code) {
//				Log.wtf("mobLoginGooglePlay", "Error: " + mess);
                Log.e(TAG, "Sign in google error");
                if (!TextUtils.isEmpty(mess) && code != SIGN_IN_CURRENTLY_IN_PROGRESS) {
                    handleException(activity, mess);
                }

                Utils.hideLoading();
                if (code == SIGN_IN_CURRENTLY_IN_PROGRESS) {
                    mobLoginGooglePlay(activity, webFragment, params);
                }
            }
        });
    }

    private void getFullResponse(String sb) {
        try {
            if (sb.length() > 4000) {
                Log.wtf("onResponse", "sb.length = " + sb.length());
                int chunkCount = sb.length() / 4000;     // integer division
                for (int i = 0; i <= chunkCount; i++) {
                    int max = 4000 * (i + 1);
                    if (max >= sb.length()) {
                        Log.wtf("onResponse", "chunk " + i + " of " + chunkCount + ":" + sb.substring(4000 * i));
                    } else {
                        Log.wtf("onResponse", "chunk " + i + " of " + chunkCount + ":" + sb.substring(4000 * i, max));
                    }
                }
            } else {
                Log.wtf(TAG, sb.toString());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    void mobLoginGoogleAccount(Activity activity, MobGameWebFragment2 webFragment, String params) {
        Log.i(TAG, "mobLoginGoogleAccount");
    }

    private void handleException(final Activity activity, final String message) {
        Utils.hideLoading();
        activity.runOnUiThread(new Runnable() {

            @Override
            public void run() {
                Toast.makeText(activity, message, Toast.LENGTH_LONG).show();
            }
        });

//		Intent intent = new Intent(Constants.INTENT_FILTER);
//		intent.putExtra("category", "login");
//		intent.putExtra("status", false);
//		intent.putExtra("message", message);
//		LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
    }

}
