/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.api;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.mobgame.MobGameSDK;
import com.mobgame.api.RestfulApi;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.CharacterInfo;
import com.mobgame.utils.FunTrackingUtil;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class SaveCharacterTask
extends AsyncTask<Void, Void, Void> {
    private String roleId;
    private String areaId;
    private String roleName;
    private String areaName;

    public SaveCharacterTask(String areaId, String areaName, String roleId, String roleName) {
        this.roleId = roleId;
        this.areaId = areaId;
        this.roleName = roleName;
        this.areaName = areaName;
    }

    protected Void doInBackground(Void ... params) {
        try {
            final Context c = MobGameSDK.getApplicationContext();
            CharacterInfo charInfo = new CharacterInfo();
            charInfo.setAreaId(this.areaId);
            charInfo.setAreaName(this.areaName);
            charInfo.setRoleId(this.roleId);
            charInfo.setRoleName(this.roleName);
            GameConfigManager.getInstance().setCharacterInfo(charInfo);
            if (!TextUtils.isEmpty((CharSequence)this.areaId) && !TextUtils.isEmpty((CharSequence)this.roleId)) {
                RestfulApi.removeInstance();
                FunTrackingUtil.getInstance().trackCreateCharacterRequest(c, "call");
                RestfulApi api = RestfulApi.getInstance();
                Call<ResponseBody> call = api.saveCharacter(this.roleId, this.areaId, this.roleName, this.areaName);
                call.enqueue((Callback)new Callback<ResponseBody>(){

                    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                        if (response.isSuccessful()) {
                            FunTrackingUtil.getInstance().trackCreateCharacterRequest(c, "success");
                        }
                    }

                    public void onFailure(Call<ResponseBody> call, Throwable t) {
                        FunTrackingUtil.getInstance().trackCreateCharacterRequest(c, "fail");
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

