/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.WindowManager;
import com.appsflyer.AppsFlyerLib;
import com.mobgame.utils.AdvertisingIdClient;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.UUID;

public final class DeviceUtils {
    private static final String TAG = DeviceUtils.class.getSimpleName();
    private static String uniqueID = null;
    private static final String PREF_UNIQUE_ID = "PREF_UNIQUE_ID";
    private static String tmpAdvertisingID;
    private static String language;

    public static boolean isTablet(Context context) {
        try {
            boolean xlarge = (context.getResources().getConfiguration().screenLayout & 0xF) == 4;
            boolean large = (context.getResources().getConfiguration().screenLayout & 0xF) == 3;
            return xlarge || large;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hasHardwareButtons() {
        try {
            boolean hasBackKey = KeyCharacterMap.deviceHasKey((int)4);
            boolean hasHomeKey = KeyCharacterMap.deviceHasKey((int)3);
            boolean hasHardwareButtons = hasBackKey && hasHomeKey;
            Log.d((String)TAG, (String)("hasHardwareButtons:" + hasHardwareButtons + " , hasBackKey: " + hasBackKey + " , " + hasHomeKey));
            return hasHardwareButtons;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public static float getDensity(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public static int getScreenWidthInPixels(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeightInPixels(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    @SuppressLint(value={"NewApi"})
    public static int getRealScreenWidthInPixels(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point size = new Point();
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealSize(size);
        } else if (Build.VERSION.SDK_INT >= 14) {
            try {
                size.x = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                size.y = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return size.x;
    }

    public static boolean isAppInstalled(Activity activity, String packageName) {
        PackageManager pm = activity.getPackageManager();
        boolean installed = false;
        try {
            pm.getPackageInfo(packageName, 1);
            installed = true;
        }
        catch (PackageManager.NameNotFoundException e) {
            installed = false;
        }
        return installed;
    }

    @SuppressLint(value={"NewApi"})
    public static int getRealScreenHeightInPixels(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point size = new Point();
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealSize(size);
        } else if (Build.VERSION.SDK_INT >= 14) {
            try {
                size.x = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                size.y = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return size.y;
    }

    public static int getStatusBarHeightInPixels(Context context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static int getNavigationBarHeightInPixels(Context context) {
        return DeviceUtils.getRealScreenHeightInPixels(context) - DeviceUtils.getScreenHeightInPixels(context);
    }

    public static int getScreenOrientation(Context context) {
        try {
            if (context.getResources().getConfiguration().orientation == 1) {
                return 1;
            }
            if (context.getResources().getConfiguration().orientation == 2) {
                return 2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @SuppressLint(value={"NewApi"})
    public static boolean isNavigationBarOnBottom(Context context) {
        Resources res = context.getResources();
        Configuration cfg = res.getConfiguration();
        DisplayMetrics dm = res.getDisplayMetrics();
        boolean canMove = dm.widthPixels != dm.heightPixels && cfg.smallestScreenWidthDp < 600;
        return !canMove || dm.widthPixels < dm.heightPixels;
    }

    public static String getResolution(Context c) {
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            ((WindowManager)c.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
            String wh = displayMetrics.widthPixels + "x" + displayMetrics.heightPixels;
            return wh;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getOSInfo() {
        return Build.MANUFACTURER + " " + Build.PRODUCT + " " + Build.VERSION.RELEASE + " " + Build.VERSION.SDK_INT;
    }

    public static String getDevice() {
        return Build.MODEL;
    }

    public static synchronized String getUniqueID(Context context) {
        if (uniqueID == null && (uniqueID = Preference.getString(context, PREF_UNIQUE_ID)) == null) {
            uniqueID = UUID.randomUUID().toString();
            Preference.save(context, PREF_UNIQUE_ID, uniqueID);
        }
        return uniqueID;
    }

    public static String getAndroidID(Context c) {
        return Settings.Secure.getString((ContentResolver)c.getContentResolver(), (String)"android_id");
    }

    public static String getUniqueDeviceID(Context c) {
        String id2 = DeviceUtils.getAndroidID(c);
        if (TextUtils.isEmpty((CharSequence)id2)) {
            id2 = DeviceUtils.getUniqueID(c);
        }
        Log.i((String)TAG, (String)("getUniqueDeviceID: " + id2));
        return Utils.getSHACheckSum(id2);
    }

    public static String getAppsflyerUID(Context context) {
        try {
            String appslyerId = AppsFlyerLib.getInstance().getAppsFlyerUID(context);
            return appslyerId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getAdvertisingID(Context context) {
        try {
            if (TextUtils.isEmpty((CharSequence)tmpAdvertisingID)) {
                try {
                    AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(context);
                    String adId = adInfo.getId();
                    Log.i((String)"Google Advertising id:", (String)("Advertising ID :" + adId));
                    tmpAdvertisingID = adId;
                    Preference.save(context, "advertisingId", adId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return "" + tmpAdvertisingID;
            }
            return "" + tmpAdvertisingID;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void setLanguage(String lang) {
        language = lang;
    }

    public static String getLanguage() {
        Log.e((String)TAG, (String)("language" + Locale.getDefault().getLanguage()));
        language = Locale.getDefault().getDisplayLanguage();
        if (language.equals("vi")) {
            return "vie";
        }
        if (language.equals("zh")) {
            return "zh-Hans";
        }
        if (language.equals("en")) {
            return "en";
        }
        return "vie";
    }

    static {
        language = "en";
    }
}

