package com.mobgame.utils;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.util.Log;

import com.appsflyer.AFInAppEventType;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerLib;
import com.mobgame.MobGameSDK;
import com.mobgame.component.EventClientManager;
import com.mobgame.component.FirebaseAnalyticsManager;
import com.mobgame.component.GameConfigManager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Pc 02 on 2/24/2018.
 */

public class FunTrackingUtil {

    private static FunTrackingUtil instance;
    private String appsflyerDevkey = "cfgYFoj97okaEbzqp8q5w5";
    private String gcmSenderId = "461098885975";
    private String TAG = "FunTrackingUtil";
    private Map<String, Object> conversionDataLoaded;
    private ArrayList<String> listTrackEventQueue = new ArrayList<>();
    private boolean initted;
    /*Tracking Appsflyer key*/
    public static final String STR_EVENT_LAUNCHER = "ft_app_launch";

    public static final String FT_URL_STRING = "ft_url_string";
    public static final String FIREBASE_SCREEN_NAME = "firebase_screen_name";
    public static final String FIREBASE_SCREEN_CLASS = "firebase_screen_class";

    private static final String TRACK_FIRST_LAUNCH = "ft_first_launch";
    private static final String TRACK_FIRST_LAUNCH_XX = "ft_app_launch_";
    private static final String TRACK_OVERLAY_CLICK_PERMISSION = "ft_overlay_click_permission";
    private static final String TRACK_EXTRACT_STARTED = "ft_extract_started";
    private static final String TRACK_EXTRACT_FINISHED = "ft_extract_finished";
    private static final String TRACK_DOWNLOAD_RES_STARTED = "ft_resource_started";
    private static final String TRACK_DOWNLOAD_RES_FAILED = "ft_resource_failed";
    private static final String TRACK_DOWNLOAD_RES_FINISHED = "ft_resource_finished";
    private static final String TRACK_DOWNLOAD_RES_FIRST_BYTE = "ft_resource_first_byte";
    private static final String TRACK_DOWNLOAD_RES_PERCENT = "ft_resource_percent";
    private static final String TRACK_SHOW_START_GAME_SCREEN = "ft_show_startgame";
    private static final String FT_GAME_CALL_CREATE_CHARACTOR = "ft_game_call_create_charactor";
    private static final String FT_CHARACTER_CREATED_CALL = "ft_character_created_call";
    private static final String FT_CHARACTER_CREATED_CALL_SUCCESS = "ft_character_created_call_success";
    private static final String FT_CHARACTER_CREATED_CALL_FAIL = "ft_character_created_call_fail";
    private static final String TRACK_START_TUTORIAL = "af_tutorial_started";
    private static final String TRACK_FINISH_TUTORIAL = "af_tutorial_completion";
    private static final String TRACK_REACH_A_LEVEL = "af_level_achieved";
    private static final String FT_VIP_ACHIEVED = "ft_vip_achieved";
    private static final String TRACK_LEVEL_PLATFORM = "ft_level_platform";
    private static final String TRACK_LEVEL_ACHIEVED_A = "ft_level_achieved_A";
    private static final String TRACK_LEVEL_ACHIEVED_B = "ft_level_achieved_B";
    private static final String TRACK_LEVEL_ACHIEVED_C = "ft_level_achieved_C";
    private static final String TRACK_REGISTER_SUCCESS = "ft_register_success";
    public static final String TRACK_PAYMENT_CLICK = "ft_payment_clicked";
    public static final String TRACK_LOGIN_SUCCESS_AFTER_AUTH = "ft_login_success_after_auth";

    public static final String TRACK_PAYMENT_CLOSE = "ft_payment_closed";
    public static final String TRACK_FT_PAYMENT_SUCCESS = "ft_purchase";


    public static final String TRACK_FORM_LOGIN_OPENED = "ft_login_screen_opened";
    public static final String TRACK_LOGIN_FORM_CLICKED_BUTTON = "ft_login_form_clicked_button";//TODO BÁO CORE BỔ SUNG SỬA LẠI TÊN CHO OPTION LOGIN EMAIL
    public static final String TRACK_LOGIN_FORM_CLICKED_BUTTON_EMAIL = "ft_login_form_clicked_button_email";//TODO BÁO CORE BỔ SUNG SỬA LẠI TÊN CHO OPTION LOGIN EMAIL
    public static final String TRACK_LOGIN_FORM_CLICKED_BUTTON_FB = "ft_login_form_clicked_button_fb";//TODO BÁO CORE BỔ SUNG SỬA LẠI TÊN CHO OPTION LOGIN EMAIL
    public static final String TRACK_LOGIN_FORM_CLICKED_BUTTON_GUEST = "ft_login_form_clicked_button_guest";//TODO BÁO CORE BỔ SUNG SỬA LẠI TÊN CHO OPTION LOGIN EMAIL
    public static final String TRACK_LOGIN_CLOSED = "ft_login_closed";
    public static final String TRACK_EVENT_LOGOUT = "ft_logout";
    public static final String FT_LOGIN_SCREEN_LOAD = "ft_login_screen_load";
    public static final String FT_LOGIN_SCREEN_LOAD_SUCCESS = "ft_login_screen_load_success";
    public static final String FT_LOGIN_SCREEN_LOAD_FAIL = "ft_login_screen_load_fail";

    public static final String SESSION_VALUE = "session_value";

    public static final String DELTA_LOAD_PAGE_UPDATE_INFO_START_GAME = "page_load";

    // tung
    public static final String TRACK_LOGIN_SUCCESS = "ft_login_success";
    public static final String TRACK_LOGIN_SUCCESS_WEB = "ft_login_success_web";
    public static final String TRACK_LOGIN_SUCCESS_GUEST = "ft_login_success_guest";
    public static final String TRACK_LOGIN_SUCCESS_FB = "ft_login_success_fb";
    public static final String TRACK_LOGOUT_SUCCESS = "ft_logout_success";
    public static final String START_PERMISISON = "ft_start_permisison";
    public static final String END_PERMISISON = "ft_end_permission";


    //TODO api request tracking


    long applauncherTime ;

    private FunTrackingUtil() {
    }

    public synchronized static FunTrackingUtil getInstance() {
        if (instance == null) {
            instance = new FunTrackingUtil();
        }
        return instance;
    }

    public void init(final Application context) {
        try {
            Log.i(TAG, "initAppsFlyer");
            AppsFlyerLib.getInstance().enableUninstallTracking(gcmSenderId);
            MobGameSDK.applicationContext = context;

            AppsFlyerLib.getInstance().setCollectIMEI(false);
            AppsFlyerLib.getInstance().setCollectAndroidID(false);
            AppsFlyerLib.getInstance().setDebugLog(true);
            AppsFlyerConversionListener conversionDataListener =
                    new AppsFlyerConversionListener() {
                        @Override
                        public void onInstallConversionDataLoaded(Map<String, String> conversionData) {
                            try {
                                Map<String, Object> map;
                                map = new HashMap<String, Object>(conversionData);
                                conversionDataLoaded = map;
                                if (!initted) {
                                    //send tracking app_launcher and first_launch
                                    applauncherTime = System.currentTimeMillis();
                                    map.put("time_app_launcher" , applauncherTime);
                                    trackEvent(context, STR_EVENT_LAUNCHER + "_" + Utils.getGameVersion(context), map);
                                    FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , STR_EVENT_LAUNCHER , null);
                                    /*int countLauncher = Preference.getInt(context , Constants.COUNT_LAUNCHER , 0);
                                    if(countLauncher < 30){
                                        countLauncher++;
                                        Preference.save(context , Constants.COUNT_LAUNCHER , countLauncher);
                                        trackLoyalUser(context ,TRACK_FIRST_LAUNCH_XX+"" +countLauncher);
                                    }*/
                                    initted = true;
                                }
                                for (String attrName : conversionData.keySet()) {
                                    Log.d(TAG, "onInstallConversionDataLoaded attribute: " + attrName + " = " + conversionData.get(attrName));
                                    if (attrName.equals("is_first_launch") && conversionData.get(attrName).equals("true")) {
                                        applauncherTime = System.currentTimeMillis();
                                        map.put("time_first_launcher" , applauncherTime);
                                        trackEvent(context, TRACK_FIRST_LAUNCH, map);
                                        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_FIRST_LAUNCH , null);
                                        if (Preference.getBoolean(context, TRACK_FIRST_LAUNCH, true)) {
                                            AppsFlyerLib.getInstance().trackEvent(context, TRACK_FIRST_LAUNCH + "_unique", map);
                                            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , TRACK_FIRST_LAUNCH + "_unique" , null);
                                            Preference.save(context, TRACK_FIRST_LAUNCH, false);
                                        }
                                    }
                                }
                                //send tracking queue:
                                if (listTrackEventQueue != null) {
                                    map.put("Resend", "when inited");
                                    for (String eventName : listTrackEventQueue) {
                                        trackEvent(context, eventName, map);
                                    }
                                    listTrackEventQueue.clear();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onInstallConversionFailure(String errorMessage) {
                            initted = false;
                            Log.d(TAG, " onInstallConversionFailure error getting conversion data: " + errorMessage);
                        }

                        @Override
                        public void onAppOpenAttribution(Map<String, String> conversionData) {
                            for (String attrName : conversionData.keySet()) {
                                Log.d(TAG, "onAppOpenAttribution attribute: " + attrName + " = " + conversionData.get(attrName));
                            }
                        }

                        @Override
                        public void onAttributionFailure(String errorMessage) {
                            Log.d(TAG, " onAttributionFailure error onAttributionFailure : " + errorMessage);
                        }
                    };
            AppsFlyerLib.getInstance().init(appsflyerDevkey, conversionDataListener, context);
            AppsFlyerLib.getInstance().startTracking(context);
            new Thread(new Runnable() {
                @Override
                public void run() {
                    if (MobGameSDK.getInstance().isLoggedIn()) {
                        EventClientManager.getInstance(context).saveEventClient(EventClientManager.SAVE_EVENT_START_SESSION, STR_EVENT_LAUNCHER, null);
                    } else {
                        EventClientManager.getInstance(context).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, STR_EVENT_LAUNCHER, null);
                    }
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startPermisison(Activity activity){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.START_PERMISISON , null);
        FunTrackingUtil.getInstance().trackLoginClick(activity , FunTrackingUtil.START_PERMISISON , null);
    }
    public void endPermisison(Activity activity){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.END_PERMISISON , null);
        FunTrackingUtil.getInstance().trackLoginClick(activity , FunTrackingUtil.END_PERMISISON , null);
    }


    public void trackCreateCharacterRequest(Context context , String type){
        switch (type){
            case "call":
                AppsFlyerLib.getInstance().trackEvent(context , FT_CHARACTER_CREATED_CALL   , null);
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , FT_CHARACTER_CREATED_CALL , null);
                break;
            case "success":
                AppsFlyerLib.getInstance().trackEvent(context , FT_CHARACTER_CREATED_CALL_SUCCESS   , null);
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , FT_CHARACTER_CREATED_CALL_SUCCESS , null);
                break;
            case "fail":
                AppsFlyerLib.getInstance().trackEvent(context , FT_CHARACTER_CREATED_CALL_FAIL   , null);
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , FT_CHARACTER_CREATED_CALL_FAIL , null);
                break;
        }
    }

    public void trackClickOverlayPermission(Context context){
        Log.d(TAG , "event name : " + TRACK_OVERLAY_CLICK_PERMISSION);
        try {
            AppsFlyerLib.getInstance().trackEvent(context , TRACK_OVERLAY_CLICK_PERMISSION , null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , TRACK_OVERLAY_CLICK_PERMISSION , null);
        }catch (Exception e){
            e.printStackTrace();
        }
    }
    public void startExtractData(Context context){
        try {
            Log.d(TAG , "event name : " + TRACK_EXTRACT_STARTED);
            HashMap<String , Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_extract_start" , currentTime);
            hashMap.put("delta_extract_start" , delta);
            AppsFlyerLib.getInstance().trackEvent(context , TRACK_EXTRACT_STARTED   , hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , TRACK_EXTRACT_STARTED , hashMap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void finishExtractData(Context context){
        try {
            Log.d(TAG , "event name : " + TRACK_EXTRACT_FINISHED);
            HashMap<String , Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_extract_finish" , currentTime);
            hashMap.put("delta_extract_finish" , delta);
            AppsFlyerLib.getInstance().trackEvent(context , TRACK_EXTRACT_FINISHED  , hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , TRACK_EXTRACT_FINISHED , hashMap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private void trackLoyalUser(Context context, String eventName) {
        try {
            Log.d(TAG , "event name : " + eventName);
            AppsFlyerLib.getInstance().trackEvent(context , eventName , null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , eventName , null);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackEvent(Context context, String eventName, Map<String, Object> eventValues) {
        try {
            if (initted) {
                HashMap<String, Object> map = new HashMap<>(conversionDataLoaded);
                if (eventValues != null)
                    map.putAll(eventValues);
                AppsFlyerLib.getInstance().trackEvent(context, eventName, map);
//                Log.d(TAG, "trackEvent: " + eventName + " eventValue: " + map);
//                if (Preference.getBoolean(context, eventName, true)) {
//                    AppsFlyerLib.getInstance().trackEvent(context, eventName + "_unique", map);
//                    FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , eventName + "_unique" , map);
//                    Preference.save(context, eventName, false);
//                }
            } else {
                Log.d(TAG, "trackEvent " + eventName + " fail cause of AppsflyerLib is not inited successful");
                listTrackEventQueue.add(eventName);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void trackOpenFormLogin(Activity activity){
        Log.d(TAG, "event name : "+TRACK_FORM_LOGIN_OPENED);
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_FORM_LOGIN_OPENED , null);
            FunTrackingUtil.getInstance().trackEvent(activity , FunTrackingUtil.TRACK_FORM_LOGIN_OPENED , null);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackFinishLoadWebView(Activity activity , String labelUrl , long delta){
        try {
            HashMap<String , Object> hashMap = new HashMap<>();
            hashMap.put("LabelUrl" , labelUrl);
            hashMap.put("deltaTime" , delta);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.FT_LOGIN_SCREEN_LOAD_SUCCESS , hashMap);
            FunTrackingUtil.getInstance().trackEvent(activity , FunTrackingUtil.FT_LOGIN_SCREEN_LOAD_SUCCESS , hashMap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }
    public void trackErrorLoadWebView(Activity activity , String labelUrl ){
        try {
            HashMap<String , Object> hashMap = new HashMap<>();
            hashMap.put("LabelUrl" , labelUrl);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.FT_LOGIN_SCREEN_LOAD_FAIL , hashMap);
            FunTrackingUtil.getInstance().trackEvent(activity , FunTrackingUtil.FT_LOGIN_SCREEN_LOAD_FAIL, hashMap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackLoginSuccess(Activity activity){
        try {
            HashMap<String , Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_login_success" , currentTime);
            hashMap.put("delta_login_success" , delta);
            AppsFlyerLib.getInstance().trackEvent(
                    activity,
                    AFInAppEventType.LOGIN , null);//TODO count from event appsflyer
            FunTrackingUtil.getInstance().trackEvent(activity , AFInAppEventType.LOGIN + "_sdk" , null);//todo count by sdk
            Log.d(TAG , "af_login");
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_LOGIN_SUCCESS_AFTER_AUTH , null);
//            if (Preference.getBoolean(activity, AFInAppEventType.LOGIN, true)) {
//                AppsFlyerLib.getInstance().trackEvent(activity, AFInAppEventType.LOGIN + "_unique", hashMap);
//                Preference.save(activity, AFInAppEventType.LOGIN, false);
//            }

            if (Preference.getBoolean(activity, FunTrackingUtil.TRACK_LOGIN_SUCCESS_AFTER_AUTH, true)) {
                FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_LOGIN_SUCCESS_AFTER_AUTH , hashMap);
                Preference.save(activity, FunTrackingUtil.TRACK_LOGIN_SUCCESS_AFTER_AUTH, false);
            }

        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackRegisterSuccess(Activity activity , String typeRegister){
        try {
            HashMap<String , Object> hashMap = new HashMap<>();
            hashMap.put("type_register" , typeRegister);
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_register_success" , currentTime);
            hashMap.put("delta_register_success" , delta);
            hashMap.put("VALUE" , typeRegister);
//            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_REGISTER_CLICK , hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_REGISTER_SUCCESS , hashMap);

//            AppsFlyerLib.getInstance().trackEvent(activity , FunTrackingUtil.TRACK_REGISTER_CLICK , hashMap);
            AppsFlyerLib.getInstance().trackEvent(activity , FunTrackingUtil.TRACK_REGISTER_SUCCESS , hashMap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackLoginSuccessFromWeb(Activity activity , String typeLogin){
        try {
            HashMap<String , Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_login_success_from_web" , currentTime);
            hashMap.put("delta_login_success_from_web" , delta);
            hashMap.put("VALUE" , typeLogin);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_LOGIN_SUCCESS , hashMap);
            AppsFlyerLib.getInstance().trackEvent(activity , FunTrackingUtil.TRACK_LOGIN_SUCCESS , hashMap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }
    public void trackLoginSuccessFromGuest(Activity activity , String typeLogin){
        try {
            HashMap<String , Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_login_success_from_guest" , currentTime);
            hashMap.put("delta_login_success_from_guest" , delta);
            hashMap.put("VALUE" , typeLogin);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_LOGIN_SUCCESS_GUEST , hashMap);
            AppsFlyerLib.getInstance().trackEvent(activity , FunTrackingUtil.TRACK_LOGIN_SUCCESS_GUEST , hashMap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }
    public void trackLoginSuccessFromFB(Activity activity , String typeLogin){
        try {
            HashMap<String , Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_login_success_from_fb" , currentTime);
            hashMap.put("delta_login_success_from_fb" , delta);
            hashMap.put("VALUE" , typeLogin);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_LOGIN_SUCCESS_FB , hashMap);
            AppsFlyerLib.getInstance().trackEvent(activity , FunTrackingUtil.TRACK_LOGIN_SUCCESS_FB , hashMap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }
    public void trackLogoutSuccess(Activity activity , String typeLogin){
        try {
            HashMap<String , Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_logout_success" , currentTime);
            hashMap.put("delta_logout_success" , delta);
            hashMap.put("VALUE" , typeLogin);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_LOGOUT_SUCCESS , hashMap);
            AppsFlyerLib.getInstance().trackEvent(activity , FunTrackingUtil.TRACK_LOGOUT_SUCCESS, hashMap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackLoginClick(Activity activity ,String label , HashMap<String , Object> typeLoginClick){
        try {
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            typeLoginClick.put("current_login_click" , currentTime);
            typeLoginClick.put("delta_login_click" , delta);
            AppsFlyerLib.getInstance().trackEvent(activity , label , typeLoginClick);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , label , typeLoginClick);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackPayment_LoginFormClick(Activity activity , String label , String value){
        try {
            HashMap<String , Object> map = new HashMap<>();
            map.put("VALUE" , value);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , label , map);
            AppsFlyerLib.getInstance().trackEvent(activity , label , map);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackPaymentSuccess(Activity activity , HashMap<String , Object> eventValue){
        try {
            AppsFlyerLib.getInstance().trackEvent(
                    activity,
                    AFInAppEventType.PURCHASE, eventValue);

            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_FT_PAYMENT_SUCCESS , eventValue);

//            if (Preference.getBoolean(activity, AFInAppEventType.PURCHASE, true)) {
//                AppsFlyerLib.getInstance().trackEvent(activity, AFInAppEventType.PURCHASE + "_unique", null);
//                Preference.save(activity, AFInAppEventType.PURCHASE, false);
//            }

//            if (Preference.getBoolean(activity, TRACK_FT_PAYMENT_SUCCESS, true)) {
//                FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_FT_PAYMENT_SUCCESS  + "_unique" , null);
//                Preference.save(activity, TRACK_FT_PAYMENT_SUCCESS, false);
//            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }


    public void trackingLogout(Activity activity){
        try{
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_EVENT_LOGOUT , null);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceStarted(Activity activity) {
        try {
            //bắt đầu download resource. Chỉ gọi 1 lần cho 1 app version ( = gọi mỗi lần update game)
            String gameVersionName = Utils.getGameVersion(activity);
            String gameVersionCode = Utils.getGameVersionCode(activity);
            String versionsave = Preference.getString(activity, "GAME_VERSION");
            if (!versionsave.equals(gameVersionCode)) {
                HashMap<String, Object> map = new HashMap<>();
                map.put("version name", gameVersionName);
                map.put("version code", gameVersionCode);
                long currentTime = System.currentTimeMillis();
                long delta = currentTime - applauncherTime;
                map.put("current_start_download_res" , currentTime);
                map.put("delta_start_download_resource" , delta);
                trackEvent(activity, TRACK_DOWNLOAD_RES_STARTED , map);

                FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_DOWNLOAD_RES_STARTED , map);
            } else Log.d(TAG, "trackDownloadResourceStarted dont call because it is same version");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceFinished(Activity activity) {
        //kết thúc download resource. Chỉ gọi 1 lần cho 1 app version ( = gọi mỗi lần update game)
        String gameVersionName = Utils.getGameVersion(activity);
        String gameVersionCode = Utils.getGameVersionCode(activity);
        String versionsave = Preference.getString(activity, "GAME_VERSION");
        if (!versionsave.equals(gameVersionCode)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("version name", gameVersionName);
            map.put("version code", gameVersionCode);
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            map.put("current_finish_download_res" , currentTime);
            map.put("delta_finish_download_resource" , delta);
            trackEvent(activity, TRACK_DOWNLOAD_RES_FINISHED, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_DOWNLOAD_RES_FINISHED , map);

        } else Log.d(TAG, "trackDownloadResourceFinished dont call because it is same version");
        Preference.save(activity, "GAME_VERSION", gameVersionCode);
    }

    public void trackDownloadResourceFailed(Context context) {
        //download resource thất bại. Chỉ gọi 1 lần cho 1 app version ( = gọi mỗi lần update game)
        String gameVersionName = Utils.getGameVersion(context);
        String gameVersionCode = Utils.getGameVersionCode(context);
        String versionsave = Preference.getString(context, "GAME_VERSION");
        if (!versionsave.equals(gameVersionCode)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("version name", gameVersionName);
            map.put("version code", gameVersionCode);
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            map.put("current_fails_download_res" , currentTime);
            map.put("delta_fails_download_resource" , delta);
            trackEvent(context, TRACK_DOWNLOAD_RES_FAILED  , map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , TRACK_DOWNLOAD_RES_FAILED , map);
        } else Log.d(TAG, "trackDownloadResourceFailed dont call because it is same version");
    }

    public void firstByteDownloadResource(Context context){
        try {
            Log.d(TAG , "event name : " + TRACK_DOWNLOAD_RES_FIRST_BYTE);
            HashMap<String , Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_download_res_first_byte" , currentTime);
            hashMap.put("delta_download_res_first_byte" , delta);
            AppsFlyerLib.getInstance().trackEvent(context , TRACK_DOWNLOAD_RES_FIRST_BYTE , hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , TRACK_DOWNLOAD_RES_FIRST_BYTE , hashMap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void downloadResourceByPercent(Context context , String percent){
        try {
            Log.d(TAG , "event name : " + TRACK_DOWNLOAD_RES_PERCENT + "_" + percent);
            HashMap<String , Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_download_res_first_byte" , currentTime);
            hashMap.put("delta_download_res_first_byte" , delta);
            hashMap.put("delta_download_res_percent" , percent);
            AppsFlyerLib.getInstance().trackEvent(context , (TRACK_DOWNLOAD_RES_PERCENT + "_" + percent).toString() , hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , (TRACK_DOWNLOAD_RES_PERCENT + "_" + percent).toString(), hashMap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void showStartGameScreen(Context context){
        try {
            Log.d(TAG , "event name : " + TRACK_SHOW_START_GAME_SCREEN);
            HashMap<String , Object> hashMap = new HashMap<>();
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - applauncherTime;
            hashMap.put("current_start_game_screen" , currentTime);
            hashMap.put("delta_start_game_screen" , delta);
            AppsFlyerLib.getInstance().trackEvent(context , TRACK_SHOW_START_GAME_SCREEN   , hashMap);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , TRACK_SHOW_START_GAME_SCREEN , hashMap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackStartTutorial(Activity activity) {
        HashMap<String , Object> hashMap = new HashMap<>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - applauncherTime;
        hashMap.put("current_StartTutorial" , currentTime);
        hashMap.put("delta_StartTutorial" , delta);
        trackEvent(activity, TRACK_START_TUTORIAL, hashMap);
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_START_TUTORIAL , hashMap);
    }

    public void trackFinishTutorial(Activity activity) {
        HashMap<String , Object> hashMap = new HashMap<>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - applauncherTime;
        hashMap.put("current_FinishTutorial" , currentTime);
        hashMap.put("delta_FinishTutorial" , delta);
        trackEvent(activity, TRACK_FINISH_TUTORIAL, hashMap);
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_FINISH_TUTORIAL , hashMap);
    }

    public void trackGameCallCreateCharactor(Activity activity, String roleID, String areaID) {
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            trackEvent(activity, FT_GAME_CALL_CREATE_CHARACTOR, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FT_GAME_CALL_CREATE_CHARACTOR , map);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackLoadPageUpdateInfoUser(Activity activity, long deltaLoadPage) {
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("delta_load_page" , deltaLoadPage);
            trackEvent(activity, DELTA_LOAD_PAGE_UPDATE_INFO_START_GAME, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , DELTA_LOAD_PAGE_UPDATE_INFO_START_GAME , map);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    public void trackVipLevel(Activity activity, String roleID, String areaID, String vipLevel) {
        Log.d(TAG, "trackVipLevel: ");
        Log.d(TAG , "event name : "+FT_VIP_ACHIEVED);
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            map.put("vip_level", vipLevel);
            trackEvent(activity, FT_VIP_ACHIEVED, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity, FT_VIP_ACHIEVED, map);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackReachALevel(Activity activity, String roleID, String areaID, String level) {
        Log.d(TAG, "trackReachALevel: ");
        Log.d(TAG , "event name : "+TRACK_REACH_A_LEVEL);
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            map.put("level", level);
            trackEvent(activity, TRACK_REACH_A_LEVEL, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_REACH_A_LEVEL , map);
        } catch (Exception e) {
            e.printStackTrace();
        }

        //tracking platform
        String levelTracking = null;
        try {
            if (GameConfigManager.getInstance() != null
                    && GameConfigManager.getInstance().getGameConfig() != null
                    && GameConfigManager.getInstance().getGameConfig().getLevel() != null)
                levelTracking = GameConfigManager.getInstance().getGameConfig().getLevel();
            Log.d(TAG, "trackLevelPlatform: " + levelTracking);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (levelTracking != null) {
            String[] arrLevel = levelTracking.split(",");
            for (int i = 0 ; i < arrLevel.length ; i ++) {
                try {
                    String anLevel = arrLevel[i];
                    if (!Preference.getBoolean(activity, TRACK_LEVEL_PLATFORM + anLevel, false)
                            && Integer.parseInt(level) >= Integer.parseInt(anLevel)) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("LEVEL", anLevel + "");
                        trackEvent(activity, TRACK_LEVEL_PLATFORM, map);
                        if(Integer.parseInt(level) >= Integer.parseInt(arrLevel[2])){
                            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_LEVEL_ACHIEVED_C , map);
                        }else if(Integer.parseInt(level) >= Integer.parseInt(arrLevel[1])){
                            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_LEVEL_ACHIEVED_B , map);
                        }else if(Integer.parseInt(level) >= Integer.parseInt(arrLevel[0])){
                            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_LEVEL_ACHIEVED_A , map);
                        }else{
                            Log.d(TAG , "Do something");
                        }
                        map.clear();
                        Preference.save(activity, TRACK_LEVEL_PLATFORM + anLevel, true);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getAppsflyerDevkey() {
        return appsflyerDevkey;
    }

    public void setAppsflyerDevkey(String appsflyerDevkey) {
        this.appsflyerDevkey = appsflyerDevkey;
    }

    public String getGcmSenderId() {
        return gcmSenderId;
    }

    public void setGcmSenderId(String gcmSenderId) {
        this.gcmSenderId = gcmSenderId;
    }

    public String getAppsflyerId(Context context){
        return AppsFlyerLib.getInstance().getAppsFlyerUID(context);
    }

    public void startSession(Application application) {
        long startSession = System.currentTimeMillis();
        Preference.save(application, Constants.START_SESSION , startSession);
    }

    public void trackLoadTime(Activity activity, long deltaTime) {
        try {
            HashMap<String , Object> map = new HashMap<>();
            map.put("TIME_VALUE" , String.valueOf(deltaTime));
        }catch (Exception e ){
            e.printStackTrace();
        }
    }

    public void trackPaymentClose(Context context, String label) {
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context ,label , null );
        }catch (Exception e){
            e.printStackTrace();
        }
    }
}