/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.js;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.text.Html;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import com.facebook.share.widget.GameRequestDialog;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.api.PostTask;
import com.mobgame.api.UploadListBitmapTask;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.MobGameImageGaleryActivity;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.gui.dialog.MobGameDialogWebviewFragment;
import com.mobgame.model.ListGiftCode;
import com.mobgame.utils.Constants;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.PermissionUtils;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public final class CmdDashboard {
    private static final String TAG = CmdDashboard.class.getSimpleName();
    private static CmdDashboard INSTANCE;
    private static View giftCodeView;
    private static View giftCodeViewAll;
    private WindowManager windowManager;
    private ViewGroup rootView;
    private boolean isNullGiftcode = true;
    private FirebaseAnalytics mFirebaseAnalytics;
    private HashMap<String, Object> reminderCache = new HashMap();
    ArrayList<ListGiftCode> listGiftCodes = new ArrayList();
    private MobGameDialogWebviewFragment webFragment;
    private HashMap<String, Bitmap> issuePhotos;

    private CmdDashboard() {
    }

    public static CmdDashboard getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdDashboard();
        }
        return INSTANCE;
    }

    public void handleResult(Activity activity, int requestCode, int resultCode, Intent data) {
        try {
            switch (requestCode) {
                case 20002: {
                    if (data.getStringExtra("data") == null) break;
                    String[] imagesPath = data.getStringExtra("data").split("\\|");
                    for (int i = 0; i < imagesPath.length; ++i) {
                        Log.d((String)TAG, (String)("handleResult: " + imagesPath[i]));
                        this.handleIssuePhoto(activity, imagesPath[i]);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleIssuePhoto(Activity activity, String imagePath) {
        try {
            Bitmap bitmap = this.getCompressedBitmapFromPath(activity, imagePath);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)byteArrayOutputStream);
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            String encoded = Base64.encodeToString((byte[])byteArray, (int)0);
            String key = "img" + Calendar.getInstance().getTimeInMillis();
            String jsFunction = String.format("getImageData('%s', '%s');", encoded, key);
            Log.d((String)TAG, (String)("js function: " + jsFunction));
            this.webFragment.invokeJavascript(jsFunction);
            if (this.issuePhotos == null) {
                this.issuePhotos = new HashMap();
            }
            this.issuePhotos.put(key, bitmap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Bitmap getCompressedBitmapFromPath(Activity activity, String imagePath) {
        Bitmap bitmap = null;
        try {
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            o.inSampleSize = 6;
            BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)o);
            int REQUIRED_SIZE = 75;
            int scale = 1;
            while (o.outWidth / scale / 2 >= 75 && o.outHeight / scale / 2 >= 75) {
                scale *= 2;
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)o2);
        }
        catch (Exception e) {
            e.printStackTrace();
            bitmap = Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.eraseColor(-1);
        }
        return bitmap;
    }

    void mobOpenContact(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobOpenContact:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String support_email = obj.getString("support_email");
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("mailto:" + support_email)));
            activity.startActivity(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void mobSendSMS(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobSendSMS:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String body = obj.getString("body");
            Intent smsVIntent = new Intent("android.intent.action.VIEW");
            smsVIntent.setType("vnd.android-dir/mms-sms");
            smsVIntent.putExtra("sms_body", body);
            activity.startActivity(smsVIntent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void mobSendEmail(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobSendEmail:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String subject = obj.getString("subject");
            String body = obj.getString("body");
            Intent email = new Intent("android.intent.action.SEND", Uri.parse((String)"mailto:"));
            email.setType("text/plain");
            email.putExtra("android.intent.extra.EMAIL", "");
            email.putExtra("android.intent.extra.SUBJECT", subject);
            email.putExtra("android.intent.extra.TEXT", (CharSequence)Html.fromHtml((String)body));
            activity.startActivity(Intent.createChooser((Intent)email, (CharSequence)"Choose an email client from..."));
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void mobAppInvite(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobAppInvite:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            final Activity a = activity;
            final String url = callbackUrl;
            FacebookManager.InviteContent content = new FacebookManager.InviteContent();
            if (obj.has("applinkurl")) {
                content.setApplinkUrl(obj.getString("applinkurl"));
            }
            if (obj.has("previewimageurl")) {
                content.setPreviewImageUrl(obj.getString("previewimageurl"));
            }
            FacebookManager.getInstance().invite(activity, content, new FacebookManager.InviteCallback(){

                @Override
                public void onSuccess(Bundle data) {
                    if (!TextUtils.isEmpty((CharSequence)url)) {
                        new PostTask(url, null, false, new PostTask.Callback(){

                            @Override
                            public void onSuccess(String response) {
                                Intent intent = new Intent("com.mobgame.broadcast");
                                intent.putExtra("category", "reload");
                                LocalBroadcastManager.getInstance((Context)a).sendBroadcast(intent);
                            }

                            @Override
                            public void onFailure(Throwable e) {
                            }
                        }).execute(new Void[0]);
                    }
                }

                @Override
                public void onError(Throwable t) {
                    Toast.makeText((Context)a, (CharSequence)Res.string((Context)a, R.string.something_went_wrong), (int)1).show();
                }

                @Override
                public void onCancel() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void mobAppShare(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobAppShare:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;
            boolean isSocial = false;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            if (obj.has("isSocial")) {
                isSocial = obj.getBoolean("isSocial");
            }
            final Activity a = activity;
            final String url = callbackUrl;
            FacebookManager.ShareContent shareContent = new FacebookManager.ShareContent();
            if (obj.has("url")) {
                shareContent.setContentUrl(obj.getString("url"));
            }
            if (obj.has("content_title")) {
                shareContent.setContentTitle(obj.getString("content_title"));
            }
            if (obj.has("content")) {
                shareContent.setContentDescription(obj.getString("content"));
            }
            final boolean hasSocial = isSocial;
            FacebookManager.getInstance().shareLink(activity, shareContent, new FacebookManager.ShareCallback(){

                @Override
                public void onSuccess(String postId) {
                    if (!TextUtils.isEmpty((CharSequence)url)) {
                        new PostTask(url, null, false, new PostTask.Callback(){

                            @Override
                            public void onSuccess(String response) {
                                if (!hasSocial) {
                                    Intent intent = new Intent("com.mobgame.broadcast");
                                    intent.putExtra("category", "reload");
                                    LocalBroadcastManager.getInstance((Context)a).sendBroadcast(intent);
                                }
                            }

                            @Override
                            public void onFailure(Throwable e) {
                            }
                        }).execute(new Void[0]);
                    }
                }

                @Override
                public void onError(Throwable t) {
                    Toast.makeText((Context)a, (CharSequence)Res.string((Context)a, R.string.something_went_wrong), (int)1).show();
                }

                @Override
                public void onCancel() {
                    Toast.makeText((Context)a, (CharSequence)"Cancel", (int)0).show();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void mobOpenBrowser(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobOpenBrowser:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String url = obj.getString("url");
            if (!url.contains("http://") || !url.contains("https://")) {
                url = "http://" + url;
            }
            this.mobOpenBrowser(activity, Uri.parse((String)url));
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void mobOpenDialogWebView(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobOpenDialogWebView:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String url = "";
            String title = "";
            if (obj.has("link")) {
                url = obj.getString("link");
            }
            if (obj.has("title")) {
                title = obj.getString("title");
            }
            MobGameDialogWebviewFragment dialogWebviewFragment = new MobGameDialogWebviewFragment(activity, title, url);
            dialogWebviewFragment.show(activity.getFragmentManager(), "dialog webview");
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("close_progress_bar", true);
            LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    private void mobOpenBrowser(Activity activity, Uri uri) {
        Log.i((String)TAG, (String)("mobOpenBrowser:" + uri));
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            activity.startActivity(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void mobRefreshBugForm(Activity activity, String params, MobGameDialogWebviewFragment dialogWebviewFragment) {
        Log.i((String)TAG, (String)("mobRefreshBugForm:" + params));
        try {
            dialogWebviewFragment.dismiss();
            if (Utils.isJSONValid(params)) {
                JSONObject jsonObject = new JSONObject(params);
                int isRefresh = 0;
                if (jsonObject.has("is_refresh")) {
                    isRefresh = jsonObject.getInt("is_refresh");
                }
                if (isRefresh == 1) {
                    Intent intent = new Intent("com.mobgame.broadcast");
                    intent.putExtra("category_from_bug", "refresh_from_bug");
                    LocalBroadcastManager.getInstance((Context)activity.getApplicationContext()).sendBroadcast(intent);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mobOpenFBFanpage(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobOpenFanPage:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String pageid = obj.getString("pageid");
            String callbackUrl = null;
            boolean isSocial = false;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            if (obj.has("isSocial")) {
                isSocial = obj.getBoolean("isSocial");
            }
            try {
                activity.getPackageManager().getPackageInfo("com.facebook.katana", 0);
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("fb://page/" + pageid)));
                activity.startActivity(intent);
            }
            catch (Exception e) {
                this.mobOpenBrowser(activity, Uri.parse((String)("https://m.facebook.com/profile.php?id=" + pageid)));
            }
            if (!TextUtils.isEmpty((CharSequence)callbackUrl)) {
                final Activity a = activity;
                if (!Utils.hasDomain(callbackUrl)) {
                    callbackUrl = Constants.BASE_URL_DOMAIN + callbackUrl;
                }
                final boolean hasSocial = isSocial;
                new PostTask(callbackUrl, null, false, new PostTask.Callback(){

                    @Override
                    public void onSuccess(String response) {
                        if (!hasSocial) {
                            Intent intent = new Intent("com.mobgame.broadcast");
                            intent.putExtra("category", "reload");
                            LocalBroadcastManager.getInstance((Context)a).sendBroadcast(intent);
                        }
                    }

                    @Override
                    public void onFailure(Throwable e) {
                    }
                }).execute(new Void[0]);
            }
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void mobOpenFBGroup(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobOpenGroup:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String groupid = obj.getString("groupid");
            try {
                activity.getPackageManager().getPackageInfo("com.facebook.katana", 0);
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("fb://group/" + groupid)));
                activity.startActivity(intent);
            }
            catch (Exception e) {
                this.mobOpenBrowser(activity, Uri.parse((String)("https://facebook.com/groups/" + groupid)));
            }
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void mobOpenModal(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobOpenModal:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "dashboard");
            intent.putExtra("urls", "[{'action':'" + obj.getString("url") + "'}]");
            LocalBroadcastManager.getInstance((Context)activity.getApplicationContext()).sendBroadcast(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void mobMakePhoneCall(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobMakePhoneCall:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            Intent intent = new Intent("android.intent.action.DIAL");
            intent.setData(Uri.parse((String)("tel:" + obj.getString("number"))));
            activity.startActivity(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void showFormGiftCode(final Activity activity, final String params) {
        try {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        JSONObject json = new JSONObject(params);
                        String data = json.getString("value");
                        Log.d((String)TAG, (String)("value :" + data + " , " + params));
                        if (Build.VERSION.SDK_INT <= 19) {
                            CmdDashboard.this.ShowGiftcode(activity, data);
                        } else {
                            CmdDashboard.this.ShowGiftcodeAllActivity(activity, data);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ShowGiftcode(final Activity activity, final String code) {
        this.rootView = (ViewGroup)activity.findViewById(0x1020002);
        if (giftCodeView != null && this.isNullGiftcode) {
            this.rootView.removeView(giftCodeView);
        }
        giftCodeView = LayoutInflater.from((Context)activity).inflate(R.layout.layout_show_giftcode, null);
        giftCodeView.startAnimation(AnimationUtils.loadAnimation((Context)activity, (int)R.anim.top_in));
        TextView txt_giftcode = (TextView)giftCodeView.findViewById(R.id.txt_giftcode);
        Button btnHide = (Button)giftCodeView.findViewById(R.id.btn_close_giftcode);
        Button btnCopy = (Button)giftCodeView.findViewById(R.id.btn_copy_giftcode);
        btnHide.setText((CharSequence)Res.string((Context)activity, R.string.close));
        btnCopy.setText((CharSequence)Res.string((Context)activity, R.string.copy));
        txt_giftcode.setText((CharSequence)("Code : " + code));
        btnCopy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    JSONObject object = new JSONObject();
                    object.put("data", (Object)code);
                    CmdDashboard.mobCopyToClipboard(activity, object.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
        btnHide.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    CmdDashboard.this.isNullGiftcode = false;
                    if (Build.VERSION.SDK_INT <= 19) {
                        if (giftCodeView != null) {
                            CmdDashboard.this.rootView.removeView(giftCodeView);
                        } else {
                            CmdDashboard.this.isNullGiftcode = true;
                        }
                    } else if (giftCodeViewAll != null) {
                        CmdDashboard.this.windowManager.removeView(giftCodeViewAll);
                    } else {
                        CmdDashboard.this.isNullGiftcode = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.isNullGiftcode = true;
        this.rootView.addView(giftCodeView);
    }

    public void ShowGiftcodeAllActivity(final Activity activity, final String code) {
        this.windowManager = (WindowManager)activity.getSystemService("window");
        if (Build.VERSION.SDK_INT >= 26) {
            WindowManager.LayoutParams params = new WindowManager.LayoutParams(-2, -2, 2038, 8, -3);
            params.gravity = 48;
            if (giftCodeViewAll != null && this.isNullGiftcode) {
                this.windowManager.removeView(giftCodeViewAll);
            }
            giftCodeViewAll = LayoutInflater.from((Context)activity).inflate(R.layout.layout_show_giftcode, null);
            giftCodeViewAll.startAnimation(AnimationUtils.loadAnimation((Context)activity, (int)R.anim.top_in));
            giftCodeViewAll.requestLayout();
            TextView txt_giftcode = (TextView)giftCodeViewAll.findViewById(R.id.txt_giftcode);
            Button btnHide = (Button)giftCodeViewAll.findViewById(R.id.btn_close_giftcode);
            Button btnCopy = (Button)giftCodeViewAll.findViewById(R.id.btn_copy_giftcode);
            btnHide.setText((CharSequence)Res.string((Context)activity, R.string.close));
            btnCopy.setText((CharSequence)Res.string((Context)activity, R.string.copy));
            txt_giftcode.setText((CharSequence)("Code : " + code));
            btnCopy.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        JSONObject object = new JSONObject();
                        object.put("data", (Object)code);
                        CmdDashboard.mobCopyToClipboard(activity, object.toString());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
            btnHide.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        CmdDashboard.this.isNullGiftcode = false;
                        if (Build.VERSION.SDK_INT <= 19) {
                            if (giftCodeView != null) {
                                CmdDashboard.this.rootView.removeView(giftCodeView);
                            } else {
                                CmdDashboard.this.isNullGiftcode = true;
                            }
                        } else if (giftCodeViewAll != null) {
                            CmdDashboard.this.windowManager.removeView(giftCodeViewAll);
                        } else {
                            CmdDashboard.this.isNullGiftcode = true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.isNullGiftcode = true;
            this.windowManager.addView(giftCodeViewAll, (ViewGroup.LayoutParams)params);
        } else {
            WindowManager.LayoutParams params = new WindowManager.LayoutParams(-2, -2, 2002, 8, -3);
            params.gravity = 48;
            if (giftCodeViewAll != null && this.isNullGiftcode) {
                this.windowManager.removeView(giftCodeViewAll);
            }
            giftCodeViewAll = LayoutInflater.from((Context)activity).inflate(R.layout.layout_show_giftcode, null);
            giftCodeViewAll.startAnimation(AnimationUtils.loadAnimation((Context)activity, (int)R.anim.top_in));
            giftCodeViewAll.requestLayout();
            TextView txt_giftcode = (TextView)giftCodeViewAll.findViewById(R.id.txt_giftcode);
            Button btnHide = (Button)giftCodeViewAll.findViewById(R.id.btn_close_giftcode);
            Button btnCopy = (Button)giftCodeViewAll.findViewById(R.id.btn_copy_giftcode);
            btnHide.setText((CharSequence)Res.string((Context)activity, R.string.close));
            btnCopy.setText((CharSequence)Res.string((Context)activity, R.string.copy));
            txt_giftcode.setText((CharSequence)("Code : " + code));
            btnCopy.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        JSONObject object = new JSONObject();
                        object.put("data", (Object)code);
                        CmdDashboard.mobCopyToClipboard(activity, object.toString());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
            btnHide.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        CmdDashboard.this.isNullGiftcode = false;
                        if (Build.VERSION.SDK_INT <= 19) {
                            if (giftCodeView != null) {
                                CmdDashboard.this.rootView.removeView(giftCodeView);
                            } else {
                                CmdDashboard.this.isNullGiftcode = true;
                            }
                        } else if (giftCodeViewAll != null) {
                            CmdDashboard.this.windowManager.removeView(giftCodeViewAll);
                        } else {
                            CmdDashboard.this.isNullGiftcode = true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.isNullGiftcode = true;
            this.windowManager.addView(giftCodeViewAll, (ViewGroup.LayoutParams)params);
        }
    }

    public void showGiftCode() {
        if (giftCodeView != null) {
            giftCodeView.setVisibility(0);
        }
        if (giftCodeViewAll != null) {
            giftCodeViewAll.setVisibility(0);
        }
    }

    public void hideGiftCode() {
        if (giftCodeView != null) {
            giftCodeView.setVisibility(8);
        }
        if (giftCodeViewAll != null) {
            giftCodeViewAll.setVisibility(8);
        }
    }

    public void removeGC() {
        if (giftCodeView != null) {
            this.rootView.removeView(giftCodeView);
            this.isNullGiftcode = false;
        }
        if (giftCodeViewAll != null) {
            this.windowManager.removeView(giftCodeViewAll);
            this.isNullGiftcode = false;
        }
        if (this.listGiftCodes.size() != 0) {
            Log.e((String)"listGiftCodes.size()", (String)("" + this.listGiftCodes.size()));
            this.listGiftCodes.clear();
        }
    }

    public static void mobCopyToClipboard(Activity activity, String params) {
        try {
            int sdk = Build.VERSION.SDK_INT;
            JSONObject obj = new JSONObject(params);
            String data = obj.getString("data").trim();
            if (sdk < 11) {
                android.text.ClipboardManager clipboard = (android.text.ClipboardManager)activity.getSystemService("clipboard");
                clipboard.setText((CharSequence)data);
            } else {
                ClipboardManager clipboard = (ClipboardManager)activity.getSystemService("clipboard");
                ClipData clip = ClipData.newPlainText((CharSequence)"clipboard", (CharSequence)data);
                clipboard.setPrimaryClip(clip);
            }
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.copied), (int)1).show();
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void mobGetIssue(Activity activity, MobGameDialogWebviewFragment webFragment, String params) {
        Log.i((String)TAG, (String)("mobGetIssue:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            long issueId = Long.parseLong(obj.getString("id"));
            if (issueId != 0L) {
                if (this.issuePhotos != null) {
                    ArrayList<Bitmap> listBitmap = new ArrayList<Bitmap>();
                    for (Map.Entry<String, Bitmap> entry : this.issuePhotos.entrySet()) {
                        String key = entry.getKey();
                        Bitmap bitmap = entry.getValue();
                        listBitmap.add(bitmap);
                    }
                    if (listBitmap.size() > 0) {
                        new UploadListBitmapTask(activity, Constants.URL_UPLOAD_ISSUE_IMAGE + "?id=" + issueId, listBitmap).execute(new Void[0]);
                    }
                }
                this.issuePhotos = null;
            }
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void deleteImageData(Activity activity, MobGameWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)("deleteImageData:" + params));
        if (this.issuePhotos == null) {
            return;
        }
        if (this.issuePhotos.isEmpty()) {
            return;
        }
        try {
            JSONObject obj = new JSONObject(params);
            String index = obj.optString("index");
            if (this.issuePhotos.containsKey(index)) {
                this.issuePhotos.remove(index);
            }
            Log.d((String)TAG, (String)("issue photo size:" + this.issuePhotos.size()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void clearImageData(Activity activity) {
        Log.d((String)TAG, (String)"clearImageData");
        if (this.issuePhotos == null) {
            return;
        }
        if (this.issuePhotos.isEmpty()) {
            return;
        }
        this.issuePhotos.clear();
    }

    public void mobSelectImage(Activity activity, MobGameDialogWebviewFragment webFragment, String params) {
        try {
            Log.d((String)TAG, (String)("mobSelectImage: " + params));
            if (this.issuePhotos != null && this.issuePhotos.size() > 2) {
                AlertDialog.Builder alert = new AlertDialog.Builder((Context)activity);
                alert.setMessage((CharSequence)Res.string((Context)activity, R.string.alert_image_validate));
                alert.setNegativeButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                AlertDialog dialog = alert.create();
                dialog.setCancelable(false);
                dialog.show();
                return;
            }
            this.webFragment = webFragment;
            boolean grantedReadStorage = PermissionUtils.hasPermission("android.permission.READ_EXTERNAL_STORAGE");
            if (!grantedReadStorage) {
                PermissionUtils.requestPermission(MobGameSDK.currentActivity, "android.permission.READ_EXTERNAL_STORAGE");
            }
            if (grantedReadStorage) {
                Intent intent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                intent.setType("image/*");
                activity.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Choose photo"), 20002);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mobSelectImage2(Activity activity, MobGameDialogWebviewFragment webFragment, String params) {
        try {
            Log.d((String)TAG, (String)("mobSelectImage 2: " + params));
            if (this.issuePhotos != null && this.issuePhotos.size() > 3) {
                AlertDialog.Builder alert = new AlertDialog.Builder((Context)activity);
                alert.setMessage((CharSequence)Res.string((Context)activity, R.string.alert_image_validate));
                alert.setNegativeButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                AlertDialog dialog = alert.create();
                dialog.setCancelable(false);
                dialog.show();
                return;
            }
            this.webFragment = webFragment;
            boolean grantedReadStorage = PermissionUtils.hasPermission("android.permission.READ_EXTERNAL_STORAGE");
            if (!grantedReadStorage) {
                PermissionUtils.requestPermission(MobGameSDK.currentActivity, "android.permission.READ_EXTERNAL_STORAGE");
            }
            if (grantedReadStorage) {
                Bundle bundle = new Bundle();
                int limit = 3;
                if (this.issuePhotos != null) {
                    limit = 3 - this.issuePhotos.size();
                }
                bundle.putInt("limit", limit);
                Intent intent = new Intent((Context)activity, MobGameImageGaleryActivity.class);
                intent.putExtra("bundle", bundle);
                activity.startActivityForResult(intent, 20002);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mobChooseFriend(Activity activity, String params) {
        try {
            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            final String url = callbackUrl;
            FacebookManager.InviteGameContent parameter = new FacebookManager.InviteGameContent();
            parameter.setTitle("Invite friend play game");
            parameter.setMessage("Play game with me");
            FacebookManager.getInstance().inviteGameRequest(activity, parameter, new FacebookManager.InviteGameCallback(){

                @Override
                public void onSuccess(GameRequestDialog.Result data) {
                    Log.i((String)TAG, (String)"invite onSuccess");
                    List list = data.getRequestRecipients();
                    HashMap<String, String> maps = new HashMap<String, String>();
                    String str = "";
                    for (int i = 0; i < list.size(); ++i) {
                        str = str + (String)list.get(i) + ",";
                    }
                    Log.d((String)"STR", (String)("str:" + str));
                    String id2 = GameConfigManager.getInstance().getUserInfo().getUser().getAccountId();
                    maps.put("account_id", id2);
                    maps.put("fbid_friends", str);
                    new PostTask(url, maps, true, true, id2, new PostTask.Callback(){

                        @Override
                        public void onSuccess(String response) {
                        }

                        @Override
                        public void onFailure(Throwable e) {
                        }
                    }).execute(new Void[0]);
                }

                @Override
                public void onError(Throwable t) {
                    Log.i((String)TAG, (String)"invite onError");
                }

                @Override
                public void onCancel() {
                    Log.i((String)TAG, (String)"invite onCancel");
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trackingDetailWeb(Activity activity, String params) {
        try {
            Log.d((String)TAG, (String)("params : " + params));
            this.mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)activity);
            JSONObject json = new JSONObject(params);
            String typeEvent = json.getString("type");
            String title = json.getString("title");
            Bundle bundle = new Bundle();
            bundle.putString("type", typeEvent);
            bundle.putString("title", title);
            this.mFirebaseAnalytics.logEvent("event_track_detail_web", bundle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackingFromWeb(Activity activity, String params) {
        try {
            Log.d((String)TAG, (String)("label : params - " + params));
            JSONObject json = new JSONObject(params);
            String label = json.getString("label");
            String value = json.getString("value");
            JSONObject jsonChild = new JSONObject(value);
            String name = jsonChild.getString("name");
            Log.d((String)TAG, (String)("label :" + label + " , name : " + name));
            FunTrackingUtil.getInstance().trackPayment_LoginFormClick(activity, label, name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onRequestPermissionsResult(Activity activity, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (grantResults.length > 0 && grantResults[0] == 0) {
            switch (requestCode) {
                case 992: {
                    try {
                        JSONObject jsonObject = new JSONObject();
                        String startDate = Utils.convertLongToDate((Long)this.reminderCache.get("eventStartTimeInMiliSec"));
                        jsonObject.put("start_date", (Object)startDate);
                        String endDate = Utils.convertLongToDate((Long)this.reminderCache.get("eventEndTimeInMiliSec"));
                        jsonObject.put("end_date", (Object)endDate);
                        jsonObject.put("event_title", (Object)String.valueOf(this.reminderCache.get("eventTitle")));
                        jsonObject.put("description", (Object)String.valueOf(this.reminderCache.get("desc")));
                        jsonObject.put("deeplink", (Object)String.valueOf(this.reminderCache.get("deeplink")));
                        this.setUpReminder(activity, jsonObject.toString());
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            Toast.makeText((Context)activity, (CharSequence)activity.getResources().getString(R.string.noti_after_user_deny_permission), (int)0).show();
        }
    }

    public void setUpReminder(Activity activity, String params) {
        try {
            long eventEndTimeInMiliSec = 0L;
            long eventStartTimeInMiliSec = 0L;
            String eventTitle = "";
            String desc = "";
            String deeplink = "";
            Log.d((String)TAG, (String)("eventEndTime 2: " + params));
            JSONObject jsonObject = new JSONObject(params);
            if (jsonObject.has("start_date")) {
                eventStartTimeInMiliSec = Long.parseLong(jsonObject.getString("start_date"));
            }
            if (jsonObject.has("end_date")) {
                eventEndTimeInMiliSec = Long.parseLong(jsonObject.getString("end_date"));
            }
            if (jsonObject.has("event_title")) {
                eventTitle = jsonObject.getString("event_title");
            }
            if (jsonObject.has("deeplink")) {
                deeplink = jsonObject.getString("deeplink");
            }
            if (jsonObject.has("description")) {
                desc = jsonObject.getString("description");
            }
            Log.d((String)TAG, (String)("eventEndTime : " + eventEndTimeInMiliSec + " , currentTime : " + System.currentTimeMillis()));
            if (eventEndTimeInMiliSec <= System.currentTimeMillis()) {
                Toast.makeText((Context)activity, (CharSequence)activity.getResources().getString(R.string.event_end), (int)0).show();
                return;
            }
            if (ActivityCompat.checkSelfPermission((Context)activity, (String)"android.permission.WRITE_CALENDAR") != 0) {
                ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.WRITE_CALENDAR", "android.permission.READ_CALENDAR"}, (int)992);
                if (this.reminderCache != null) {
                    this.reminderCache.clear();
                    this.reminderCache = new HashMap();
                    this.reminderCache.put("eventTitle", eventTitle);
                    this.reminderCache.put("eventStartTimeInMiliSec", eventStartTimeInMiliSec);
                    this.reminderCache.put("eventEndTimeInMiliSec", eventEndTimeInMiliSec);
                    this.reminderCache.put("desc", desc);
                    this.reminderCache.put("deeplink", deeplink);
                }
                return;
            }
            String eventUriString = "content://com.android.calendar/events";
            ContentValues eventValues = new ContentValues();
            eventValues.put("calendar_id", Integer.valueOf(1));
            eventValues.put("title", eventTitle);
            if (desc != null) {
                eventValues.put("description", desc + " Open link from browser: " + deeplink);
            } else {
                eventValues.put("description", "Open link from browser: " + deeplink);
            }
            eventValues.put("eventLocation", Utils.getApplicationName((Context)activity));
            eventValues.put("dtstart", Long.valueOf(eventStartTimeInMiliSec));
            eventValues.put("dtend", Long.valueOf(eventEndTimeInMiliSec));
            Calendar cal = Calendar.getInstance();
            TimeZone tz = cal.getTimeZone();
            eventValues.put("eventTimezone", tz.getDisplayName());
            eventValues.put("hasAlarm", Integer.valueOf(1));
            Uri eventUri = activity.getApplicationContext().getContentResolver().insert(Uri.parse((String)eventUriString), eventValues);
            assert (eventUri != null);
            long eventID = Long.parseLong(eventUri.getLastPathSegment());
            String reminderUriString = "content://com.android.calendar/reminders";
            ContentValues reminderValues = new ContentValues();
            reminderValues.put("event_id", Long.valueOf(eventID));
            reminderValues.put("minutes", Integer.valueOf(5));
            reminderValues.put("method", Integer.valueOf(1));
            activity.getApplicationContext().getContentResolver().insert(Uri.parse((String)reminderUriString), reminderValues);
            Toast.makeText((Context)activity, (CharSequence)activity.getResources().getString(R.string.event_scheduled), (int)0).show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Toast.makeText((Context)activity, (CharSequence)activity.getResources().getString(R.string.calendar_not_found), (int)0).show();
        }
    }
}

