package com.mobgame.utils;

import android.content.Context;

import com.mobgame.component.FirebaseAnalyticsManager;

public class OperationSdkIndex {
    private static OperationSdkIndex INSTANCE;

    private String OP_OPEN_FORM_LOGIN = "op_open_form_login";
    private String OP_OPEN_LOAD_FORM_LOGIN_SUCCESS = "op_load_form_login_success";
    private String OP_OPEN_LOAD_FORM_LOGIN_FAILS = "op_load_form_login_fails";
    private String OP_CLICK_FB_LOGIN = "op_click_fb_login";
    private String OP_POST_TOKEN_FB_LOGIN_SUCCESS = "op_post_token_fb_login_success";
    private String OP_POST_TOKEN_FB_LOGIN_FAILS = "op_post_token_fb_login_fail";
    private String OP_CLICK_GUEST_LOGIN = "op_click_guest_login";
    private String OP_POST_DEVICEID_GUEST_LOGIN_SUCCESS = "op_post_deviceid_guest_login_success";
    private String OP_POST_DEVICEID_GUEST_LOGIN_FAILS = "op_post_deviceid_guest_login_fails";
    private String OP_CLICK_EMAIL_LOGIN = "op_click_email_login";
    private String OP_LOAD_FORM_EMAIL_LOGIN_SUCCESS = "op_load_form_email_login_success";
    private String OP_CLICK_BUTTON_EMAIL_LOGIN = "op_click_button_email_login";
    private String OP_SUBMIT_FORM_SUCCESS = "op_submit_form_success";
    private String OP_SUBMIT_FORM_FAILS = "op_submit_form_fails";
    private String OP_LOAD_FORM_REGISTER_SUCCESS = "op_load_form_register_success";
    private String OP_CLICK_BUTTON_REGISTER = "op_click_button_register";
    private String OP_SUBMIT_FORM_REGISTER_SUCCESS = "op_submit_form_register_success";
    private String OP_SUBMIT_FORM_REGISTER_FAILS = "op_submit_form_register_fails";
    private String OP_LOAD_FORM_REGISTER_FAILS = "op_load_form_register_fail";
    private String OP_LOAD_FORM_EMAIL_LOGIN_FAIL = "op_load_form_email_login_fail";
    private String OP_LOAD_FORM_LOGIN_FAIL = "op_load_form_login_fails";
    private String OP_OPEN_FORM_LOGIN_FAILS = "op_open_form_login_fails";

    public static OperationSdkIndex getInstance(){
        if(INSTANCE == null){
            INSTANCE = new OperationSdkIndex();
        }
        return INSTANCE;
    }

    /*
    * 1.Login
    * */
    public void openFormLogin(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_OPEN_FORM_LOGIN , null);
    }

    public void opLoadFormLoginSucess(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_OPEN_LOAD_FORM_LOGIN_SUCCESS , null);
    }

    public void opClickFbLogin(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_CLICK_FB_LOGIN , null);
    }

    public void opPostTokenFbLoginSuccess(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_POST_TOKEN_FB_LOGIN_SUCCESS , null);
    }

    public void opPostTokenFbLoginFails(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_POST_TOKEN_FB_LOGIN_FAILS , null);
    }

    public void opClickGuestLogin(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_CLICK_GUEST_LOGIN , null);
    }

    public void opPostDeviceIdGuestLoginSuccess(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_POST_DEVICEID_GUEST_LOGIN_SUCCESS , null);
    }

    public void opPostDeviceIdGuestLoginFails(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_POST_DEVICEID_GUEST_LOGIN_FAILS , null);
    }

    public void opClickEmailLogin(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_CLICK_EMAIL_LOGIN , null);
    }

    public void opLoadFormEmailLoginSuccess(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_LOAD_FORM_EMAIL_LOGIN_SUCCESS , null);
    }

    public void opClickButtonEmailLogin(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_CLICK_BUTTON_EMAIL_LOGIN , null);
    }

    public void opSubmitFormSuccess(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_SUBMIT_FORM_SUCCESS , null);
    }

    public void opSubmitFormFails(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_SUBMIT_FORM_FAILS , null);
    }

    public void opLoadFormRegisterSuccess(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_LOAD_FORM_REGISTER_SUCCESS , null);
    }

    public void opClickButtonRegister(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_CLICK_BUTTON_REGISTER , null);
    }

    public void opSubmitFormRegisterSuccess(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_SUBMIT_FORM_REGISTER_SUCCESS , null);
    }

    public void opSubmitFormRegisterFails(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_SUBMIT_FORM_REGISTER_FAILS , null);
    }

    public void opLoadFormRegisterFails(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_LOAD_FORM_REGISTER_FAILS , null);
    }

    public void opLoadFormEmailLoginFails(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_LOAD_FORM_EMAIL_LOGIN_FAIL , null);
    }

    public void opLoadFormLoginFails(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_LOAD_FORM_LOGIN_FAIL , null);
    }

    public void opOpenFormLoginFails(Context context){
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , OP_OPEN_FORM_LOGIN_FAILS , null);
    }

}
