/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.api;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import com.mobgame.MobGameSDK;
import com.mobgame.api.RestfulApi;
import com.mobgame.model.EncodedResponse;
import com.mobgame.utils.EncryptionUtils;
import java.io.IOException;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class PostTask
extends AsyncTask<Void, Void, Void> {
    private String url;
    private Map<String, String> postParams;
    private boolean isEncrypted;
    private Callback callback;
    private boolean isInviteFriend = false;
    private String accountId;
    private Activity mActivity;

    public PostTask(String url) {
        this.url = url;
    }

    public PostTask(String url, boolean isEncrypted) {
        this.url = url;
        this.isEncrypted = isEncrypted;
    }

    public PostTask(String url, Map<String, String> postParams, boolean isEncrypted) {
        this.url = url;
        this.postParams = postParams;
        this.isEncrypted = isEncrypted;
    }

    public PostTask(Activity activity, String url, Map<String, String> postParams, boolean isEncrypted, Callback callback) {
        this.mActivity = activity;
        this.url = url;
        this.postParams = postParams;
        this.isEncrypted = isEncrypted;
        this.callback = callback;
    }

    public PostTask(String url, Map<String, String> postParams, boolean isEncrypted, Callback callback) {
        this.url = url;
        this.postParams = postParams;
        this.isEncrypted = isEncrypted;
        this.callback = callback;
    }

    public PostTask(String url, Map<String, String> postParams, boolean isEncrypted, boolean isInviteFriend, String accountId, Callback callback) {
        this.url = url;
        this.postParams = postParams;
        this.isEncrypted = isEncrypted;
        this.callback = callback;
        this.isInviteFriend = isInviteFriend;
        this.accountId = accountId;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    protected Void doInBackground(Void ... params) {
        block13: {
            try {
                RequestBody formBody;
                Context c = MobGameSDK.getApplicationContext();
                OkHttpClient client = RestfulApi.getCommonClient();
                if (this.postParams == null) {
                    formBody = RequestBody.create(null, (byte[])new byte[0]);
                } else {
                    FormBody.Builder builder = new FormBody.Builder();
                    for (String key : this.postParams.keySet()) {
                        builder.add(key, this.postParams.get(key));
                    }
                    formBody = builder.build();
                }
                if (this.isEncrypted) {
                    Uri uri = Uri.parse((String)this.url);
                    if (uri.getQueryParameter("sign") == null) {
                        this.url = this.isInviteFriend ? uri.buildUpon().appendQueryParameter("sign", EncryptionUtils.getSignedString(c, this.accountId)).build().toString() : uri.buildUpon().appendQueryParameter("sign", EncryptionUtils.getSignedString(c)).build().toString();
                    }
                    Request request = new Request.Builder().url(this.url).method("POST", formBody).build();
                    String result = client.newCall(request).execute().body().string();
                    if (this.isInviteFriend) {
                        if (this.callback != null) {
                            this.callback.onSuccess("success");
                        }
                    } else {
                        EncodedResponse response = EncodedResponse.parse(result);
                        if (this.callback != null) {
                            this.callback.onSuccess(response.getDecodedData());
                        }
                    }
                } else {
                    Request request = new Request.Builder().url(this.url).method("POST", formBody).build();
                    String response = client.newCall(request).execute().body().string();
                    if (this.callback != null) {
                        this.callback.onSuccess(response);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.callback == null) break block13;
                this.callback.onFailure(e);
            }
        }
        return null;
    }

    public static interface Callback {
        public void onSuccess(String var1);

        public void onFailure(Throwable var1);
    }
}

