/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.api;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.mobgame.MobGameSDK;
import com.mobgame.api.RestfulApi;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.EncodedResponse;
import com.mobgame.model.MobMenu;
import com.mobgame.model.MobPopup;
import com.mobgame.model.NtfModel;
import com.mobgame.model.TimerData;
import com.mobgame.model.UserInfo;
import com.mobgame.utils.EncryptionUtils;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class GetInfoAfterAuthenTask
extends AsyncTask<Void, Void, Void> {
    private static final String TAG = GetInfoAfterAuthenTask.class.getName();
    private Listener callback;

    public GetInfoAfterAuthenTask(Listener callback) {
        this.callback = callback;
    }

    protected Void doInBackground(Void ... params) {
        final Context c = MobGameSDK.getApplicationContext();
        String sign = EncryptionUtils.getSignedString(c);
        RestfulApi.removeInstance();
        FunTrackingUtil.getInstance().trackAfterAuthenCall(c, "call");
        RestfulApi api = RestfulApi.getInstance();
        Call<EncodedResponse> call = api.getInfoAfterAuthen(sign);
        call.enqueue((Callback)new Callback<EncodedResponse>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onResponse(Call<EncodedResponse> call, Response<EncodedResponse> response) {
                try {
                    Context c2 = MobGameSDK.getApplicationContext();
                    UserInfo userInfo = null;
                    Log.d((String)"TAG", (String)("code : " + response.code()));
                    if (response.code() == 200 && response.body() != null) {
                        block25: {
                            String responseBody = ((EncodedResponse)response.body()).getDecodedData();
                            try {
                                String saveLogin;
                                JSONObject json = new JSONObject(responseBody);
                                Log.d((String)TAG, (String)("onResponse: " + json));
                                if (!json.has("saveLogin") || !(saveLogin = json.getString("saveLogin")).equals("true") && !saveLogin.equals("1")) break block25;
                                if (json.has("userInfo")) {
                                    String userInfoStr = json.getString("userInfo");
                                    userInfo = UserInfo.parse(userInfoStr);
                                }
                                if (json.has("ntf")) {
                                    String ntf = json.getString("ntf");
                                    JSONArray ntfs = new JSONArray(ntf);
                                    ArrayList<Object> listNtfs = new ArrayList();
                                    for (int i = 0; i < ntfs.length(); ++i) {
                                        JSONObject ntfObj = ntfs.getJSONObject(i);
                                        if (!ntfObj.has("id") || !ntfObj.has("noti") || !ntfObj.getBoolean("noti")) continue;
                                        NtfModel ntfModel = new NtfModel();
                                        ntfModel.setId(ntfObj.getInt("id"));
                                        ntfModel.setTitle(ntfObj.getString("title"));
                                        ntfModel.setNoti(ntfObj.getBoolean("noti"));
                                        listNtfs.add(ntfModel);
                                        NotificationUtils.addNtf(c2, ntfModel);
                                        GameConfigManager.getInstance().setHasUnreadNotifications(true);
                                    }
                                    listNtfs = NotificationUtils.getNtfs(c2);
                                    if (listNtfs.size() > 0) {
                                        GameConfigManager.getInstance().setHasUnreadNotifications(true);
                                    }
                                    NotificationUtils.setListNtfFromAfterAuth(listNtfs);
                                }
                                if (json.has("menu")) {
                                    String menu = json.getString("menu");
                                    MobMenu mobMenu = MobMenu.parse(menu);
                                    GameConfigManager.getInstance().setMobMenu(mobMenu);
                                } else {
                                    GameConfigManager.getInstance().clearMobMenu();
                                }
                                if (json.has("enable_dashboard")) {
                                    boolean value = json.getBoolean("enable_dashboard");
                                    Preference.save(c2, "shared_pref_db_enabled", value);
                                } else {
                                    Preference.remove(c2, "shared_pref_db_enabled");
                                }
                                if (json.has("show_qc")) {
                                    boolean showAds = json.getInt("show_qc") != 0;
                                    Preference.save(c2, "shared_pref_show_ads", showAds);
                                    GameConfigManager.getInstance().setShow_qc(showAds);
                                } else {
                                    Preference.remove(c2, "shared_pref_show_ads");
                                }
                                if (json.has("enable_timer")) {
                                    boolean enableTimer = json.optBoolean("enable_timer");
                                    userInfo.setEnableTimer(enableTimer);
                                    if (enableTimer) {
                                        TimerData timerData = TimerData.parse(json.optJSONArray("timer"));
                                        userInfo.setTimerData(timerData);
                                    }
                                }
                                if (json.has("pop")) {
                                    try {
                                        JSONObject pop = json.getJSONObject("pop");
                                        boolean is_show_link = pop.getBoolean("is_show");
                                        String link = pop.getString("link");
                                        Log.d((String)TAG, (String)("is_show: " + is_show_link));
                                        Log.d((String)TAG, (String)("link: " + link));
                                        MobPopup mobPopup = new MobPopup(link, is_show_link);
                                        GameConfigManager.getInstance().setMobPopup(mobPopup);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        MobPopup mobPopup = new MobPopup("", false);
                                        GameConfigManager.getInstance().setMobPopup(mobPopup);
                                    }
                                }
                                if (json.has("timer")) {
                                    // empty if block
                                }
                                if (!json.has("error_link")) {
                                    // empty if block
                                }
                            }
                            catch (JSONException e) {
                                if (GetInfoAfterAuthenTask.this.callback == null) break block25;
                                GetInfoAfterAuthenTask.this.callback.onFailure(e);
                            }
                        }
                        if (GetInfoAfterAuthenTask.this.callback != null) {
                            GetInfoAfterAuthenTask.this.callback.onSuccess(userInfo);
                        }
                        FunTrackingUtil.getInstance().trackAfterAuthenCall(c2, "success");
                        return;
                    }
                    if (response.code() == 403 && response.body() != null) {
                        if (GetInfoAfterAuthenTask.this.callback == null) return;
                        GetInfoAfterAuthenTask.this.callback.forceLogout();
                        return;
                    }
                    if (GetInfoAfterAuthenTask.this.callback == null) return;
                    Log.d((String)TAG, (String)("ERROR when " + response.code()));
                    GetInfoAfterAuthenTask.this.callback.onFailure(new Exception());
                    FunTrackingUtil.getInstance().trackAfterAuthenCall(c2, "fail");
                    return;
                }
                catch (Exception e) {
                    if (GetInfoAfterAuthenTask.this.callback != null) {
                        GetInfoAfterAuthenTask.this.callback.onFailure(e);
                        FunTrackingUtil.getInstance().trackAfterAuthenCall(c, "fail");
                    }
                    e.printStackTrace();
                }
            }

            public void onFailure(Call<EncodedResponse> call, Throwable t) {
                if (GetInfoAfterAuthenTask.this.callback != null) {
                    GetInfoAfterAuthenTask.this.callback.onFailure(t);
                    FunTrackingUtil.getInstance().trackAfterAuthenCall(c, "fail");
                }
            }
        });
        return null;
    }

    public static interface Listener {
        public void onSuccess(UserInfo var1);

        public void forceLogout();

        public void onFailure(Throwable var1);
    }
}

