/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.api;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.mobgame.MobGameSDK;
import com.mobgame.api.RestfulApi;
import com.mobgame.model.EncodedResponse;
import com.mobgame.model.Game;
import com.mobgame.utils.EncryptionUtils;
import com.mobgame.utils.FunTrackingUtil;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class GetInfoBeforeAuthenTask
extends AsyncTask<Void, Void, Void> {
    private Listener callback;

    public GetInfoBeforeAuthenTask(Listener callback) {
        Log.d((String)"TAG", (String)"GO HERE");
        this.callback = callback;
    }

    protected Void doInBackground(Void ... params) {
        final Context c = MobGameSDK.getApplicationContext();
        FunTrackingUtil.getInstance().trackBeforeAuthenCall(c, "call");
        String sign = EncryptionUtils.getSignedString(c);
        RestfulApi.removeInstance();
        RestfulApi api = RestfulApi.getInstance();
        Call<EncodedResponse> call = api.getInfoBeforeAuthen(sign);
        call.enqueue((Callback)new Callback<EncodedResponse>(){

            public void onResponse(Call<EncodedResponse> call, Response<EncodedResponse> response) {
                block7: {
                    try {
                        Log.d((String)"TAG", (String)("response:" + response.body()));
                        if (response.isSuccessful()) {
                            String responseBody = ((EncodedResponse)response.body()).getDecodedData();
                            Game game = Game.parse(responseBody);
                            boolean isValidationMode = false;
                            if (game.getEx().isShowLogo()) {
                                isValidationMode = game.getEx().isShowLogo();
                            }
                            if (GetInfoBeforeAuthenTask.this.callback != null) {
                                GetInfoBeforeAuthenTask.this.callback.onSuccess(game, isValidationMode);
                            }
                            FunTrackingUtil.getInstance().trackBeforeAuthenCall(c, "success");
                        } else if (GetInfoBeforeAuthenTask.this.callback != null) {
                            GetInfoBeforeAuthenTask.this.callback.onFailure(new Exception());
                            FunTrackingUtil.getInstance().trackBeforeAuthenCall(c, "fail");
                        }
                    }
                    catch (Exception e) {
                        if (GetInfoBeforeAuthenTask.this.callback == null) break block7;
                        GetInfoBeforeAuthenTask.this.callback.onFailure(e);
                        FunTrackingUtil.getInstance().trackBeforeAuthenCall(c, "fail");
                    }
                }
            }

            public void onFailure(Call<EncodedResponse> call, Throwable t) {
                if (GetInfoBeforeAuthenTask.this.callback != null) {
                    GetInfoBeforeAuthenTask.this.callback.onFailure(t);
                    FunTrackingUtil.getInstance().trackBeforeAuthenCall(c, "fail");
                }
            }
        });
        return null;
    }

    public static interface Listener {
        public void onSuccess(Game var1, boolean var2);

        public void onFailure(Throwable var1);
    }
}

