package com.mobgame.gui;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.Toast;

import com.mobgame.MobGameHelper;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.component.EventClientManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.Game;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Utils;

import org.json.JSONArray;
import org.json.JSONObject;

public class MobGameActivity extends AppCompatActivity {

    private static String TAG = MobGameActivity.class.getSimpleName();
    public static String KEY_DATA = "data";
    public static String FORM = "is_form";
    public static boolean shouldReload = false;
    public String isHide = "notHide";
    private boolean isFormLogin = false;

    private DrawerLayout layoutRoot;
    private View layoutMain, layoutContent;
    private ImageButton btnBack, btnClose;
    private ProgressBar prgBar;

    private MobGameWebFragment fragmentWeb;

    private float density;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_mob);
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,WindowManager.LayoutParams.FLAG_FULLSCREEN);
        Preference.save(getApplicationContext(),Constants.SHARED_PREF_SHOW_MOBGAMEACTIVITY,true);
        layoutRoot = (DrawerLayout) findViewById(R.id.layout_root);
        layoutMain = findViewById(R.id.layout_main);
        layoutContent = findViewById(R.id.layout_content);

        prgBar = (ProgressBar) findViewById(R.id.progress_bar);
        btnBack = (ImageButton) findViewById(R.id.btn_back);
        btnClose = (ImageButton) findViewById(R.id.btn_close);

        initComponentTop();
        try {
            density = DeviceUtils.getDensity(this);
            // lay du lieu deeplink de bung tin tuc
            // CONTENT

            String data = "";
            String url = "";
            isFormLogin = false;
            try {
                data = getIntent().getExtras().getString(KEY_DATA);
                try {
                    isHide = getIntent().getExtras().getString(FORM);
                } catch (Exception e) {
                }
                //************* isPayment = "payment" : url payment

                if (data.contains("[")) {
                    JSONArray item = new JSONArray(data);
                    JSONObject chilItem = new JSONObject();
                    chilItem = item.getJSONObject(0);
                    url = chilItem.getString("action");
                } else {
                    JSONObject chilItem = new JSONObject(data);
                    url = chilItem.getString("action");
                    isFormLogin = true;
                }
                Log.d(TAG, "url : " + url);
            } catch (Exception e) {
                e.printStackTrace();
            }

            fragmentWeb = new MobGameWebFragment(url, isHide);
            fragmentWeb.setEventListener(mWebEventListener);

            FragmentManager fm = getFragmentManager();
            FragmentTransaction ft = fm.beginTransaction();
            ft.add(layoutContent.getId(), fragmentWeb, TAG_FRAGMENT);
            ft.commit();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Preference.save(getApplicationContext(),Constants.SHARED_PREF_SHOW_MOBGAMEACTIVITY,false);
        Log.d(TAG, "onDestroy123: ");
    }

    private void initComponentTop() {
        try {
            btnClose.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (isFormLogin) {
                        //form login
                        MobGameSDK.getInstance().closeFormLogin();
                        FunTrackingUtil.getInstance().trackEvent(getApplicationContext() , FunTrackingUtil.TRACK_LOGIN_CLOSED , null);
                        new Thread(new Runnable() {
                            @Override
                            public void run() {
                                EventClientManager.getInstance(MobGameActivity.this).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, FunTrackingUtil.TRACK_LOGIN_CLOSED, null);
                            }
                        }).start();
                    } else {
                        //form payment
                        FunTrackingUtil.getInstance().trackEvent(getApplicationContext() , FunTrackingUtil.TRACK_PAYMENT_CLOSE , null);
                        FunTrackingUtil.getInstance().trackPaymentClose(getApplicationContext() , FunTrackingUtil.TRACK_PAYMENT_CLOSE);
                        new Thread(new Runnable() {
                            @Override
                            public void run() {
                                EventClientManager.getInstance(MobGameActivity.this).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, FunTrackingUtil.TRACK_PAYMENT_CLOSE, null);
                            }
                        }).start();
                        MobGameSDK.getInstance().close();
                    }
                }
            });
            btnBack.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onBackPressed();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        Preference.save(getApplicationContext(),Constants.SHARED_PREF_SHOW_MOBGAMEACTIVITY,true);
        boolean abc = Preference.getBoolean(getApplicationContext(),Constants.SHARED_PREF_SHOW_MOBGAMEACTIVITY,false);
        Log.d(TAG, "onResumewtf co vao day kjomh: "+abc);

        try {
            LocalBroadcastManager.getInstance(this).registerReceiver(
                    mBroadcastReceiver, new IntentFilter(Constants.INTENT_FILTER));
            Intent intent = new Intent(Constants.INTENT_FILTER);
            intent.putExtra("category", "float_button");
            intent.putExtra("message", "hide");
            LocalBroadcastManager.getInstance(this).sendBroadcast(intent);
            if (shouldReload) {
                reload();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onPause() {
        try {
            LocalBroadcastManager.getInstance(this).unregisterReceiver(
                    mBroadcastReceiver);
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onPause();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            MobGameSDK.getInstance().onActivityResult(requestCode, resultCode, data);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @TargetApi(19)
    public void onWindowFocusChanged(boolean hasFocus) {
        try {
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.KITKAT) {
                if (hasFocus) {
                    getWindow().getDecorView().setSystemUiVisibility(
                            View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onBackPressed() {
        try {
            Log.i(TAG, "onBackPressed:");
            MobGameWebFragment fragWeb = fragmentWeb;
            if (fragWeb.canGoBack()) {
                fragWeb.goBack();
            } else {
                if (isFormLogin) {
                    //form login
                    MobGameSDK.getInstance().closeFormLogin();
                    FunTrackingUtil.getInstance().trackEvent(getApplicationContext() , FunTrackingUtil.TRACK_LOGIN_CLOSED , null);
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            EventClientManager.getInstance(MobGameActivity.this).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, FunTrackingUtil.TRACK_LOGIN_CLOSED, null);
                        }
                    }).start();
                } else {
                    //form payment
                    FunTrackingUtil.getInstance().trackEvent(getApplicationContext() , FunTrackingUtil.TRACK_PAYMENT_CLOSE , null);
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            EventClientManager.getInstance(MobGameActivity.this).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, FunTrackingUtil.TRACK_PAYMENT_CLOSE, null);
                        }
                    }).start();
                    MobGameSDK.getInstance().close();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String TAG_FRAGMENT = "fragment_web";

    private void reload() {
        try {
            shouldReload = false;
            fragmentWeb.reload();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MobGameWebFragment.EventListener mWebEventListener = new MobGameWebFragment.EventListener() {

        @SuppressLint("JavascriptInterface")
        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            try {
                view.addJavascriptInterface(MobGameActivity.this, "android");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onProgressChanged(WebView view, int progress) {
            try {
                updateHeaderBar();
                progress = Math.max(1, progress);
                prgBar.setProgress(progress);
                if (progress == 100) {
                    hideProgressBar();
                } else {
                    showProgressBar();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            try {
                updateHeaderBar();
                hideProgressBar();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onScrollChanged(WebView view, int l, int t, int oldl,
                                    int oldt) {

        }

        @Override
        public void onSizeChanged(WebView view, int w, int h, int oldw, int oldh) {
        }

    };

    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver() {

        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                String category = intent.getStringExtra("category");
                Log.d(TAG, "mBroadcastReceiver category: " + category);
                if ("dashboard".equalsIgnoreCase(category)) {
                    // dashboard
                } else if ("dashboard_close".equalsIgnoreCase(category)) {
                    finish();
                } else if ("reload".equalsIgnoreCase(category)) {
                    reload();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private void updateHeaderBar() {
        try {
            final MobGameWebFragment fragWeb = fragmentWeb;
            if (fragWeb != null && fragWeb.isAdded()) {
                this.runOnUiThread(new Runnable() {

                    @Override
                    public void run() {
                        String title = fragWeb.getTitle();
                        if (title.contains(Constants.DOMAIN_NAME)
                                || title.equalsIgnoreCase("about:blank")
                                || title.equalsIgnoreCase("website not available")
                                || title.contains("data:text/html")
                                || title.startsWith("http://")
                                || title.startsWith("https://")) {
                            title = "";
                        }
                        if (!Utils.isOnline(getApplicationContext())) {
                            title = "Website not available";
                        }
                        Log.d(TAG, "title : " + title);
                        if (fragWeb.canGoBack()) {
                            btnBack.setVisibility(View.VISIBLE);
                        } else {
                            btnBack.setVisibility(View.GONE);
                        }
                    }
                });

                String inject = ""
                        + "if (typeof getShareUrl === 'function') {							"
                        + "	try {															"
                        + "		window.android.onGetShareUrl(getShareUrl());				"
                        + "	} catch (err) {													"
                        + "		window.android.onGetShareUrl('');							"
                        + "		console.log(err);											"
                        + "	}																" + "} else {															"
                        + "	window.android.onGetShareUrl('');								"
                        + "}																	";
                fragWeb.invokeJavascript(inject);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showProgressBar() {
        try {
            MobGameActivity.this.runOnUiThread(new Runnable() {

                @Override
                public void run() {
                    try {
                        prgBar.setVisibility(View.VISIBLE);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideProgressBar() {
        try {
            new Handler().postDelayed(new Runnable() {

                @Override
                public void run() {
                    MobGameActivity.this.runOnUiThread(new Runnable() {

                        @Override
                        public void run() {
                            try {
                                prgBar.setVisibility(View.GONE);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }, 500);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
