/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.dialog;

import android.annotation.SuppressLint;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v13.app.FragmentPagerAdapter;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.webkit.WebView;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.google.gson.Gson;
import com.mobgame.MobGameHelper;
import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.MobGamePagerFragment;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.gui.dialog.MobGameSocialDialogFragment;
import com.mobgame.gui.view.adapter.DashboardMenuAdapter;
import com.mobgame.listener.RecyclerItemClickListener;
import com.mobgame.model.Game;
import com.mobgame.model.ItemMenuDashboard;
import com.mobgame.model.MUrl;
import com.mobgame.model.MobMenuItem;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MobGameDashboardDialog
extends DialogFragment {
    public static final String TAG = MobGameDashboardDialog.class.getSimpleName();
    public static final String CLOSE_PROGRESS_BAR = "close_progress_bar";
    public static String KEY_DATA = "data";
    public static String KEY_ID = "parent_id";
    public static String KEY_ICON = "icon";
    public static String KEY_TIMER = "key_timer";
    public static String KEY_SHOW = "key_show";
    public static boolean isDashBoard = true;
    EventListener eventListener;
    private ImageButton btnClose;
    private RecyclerView mRecycleView;
    private RecyclerView.LayoutManager layoutManager;
    private TextView txtTitle;
    private ProgressBar circleProgressBar;
    private View rootView;
    private View layoutMain;
    private View layoutItemLeft;
    private View layoutChildContent;
    private View layoutTmp;
    private MobGamePagerFragment fragContent;
    private MobPagerAdapter adapter;
    private DashboardMenuAdapter menuAdapter;
    private int currentPage;
    private List<ItemMenuDashboard> listItemMenuDashboard = new ArrayList<ItemMenuDashboard>();
    private float density;
    private final String TAG_FRAGMENT = "fragment_webview";
    private String data;
    private String urlIcon;
    private int id;
    private boolean isShow;
    private MobGameWebFragment.EventListener mWebEventListener = new MobGameWebFragment.EventListener(){

        @Override
        @SuppressLint(value={"JavascriptInterface"})
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            try {
                MobGameDashboardDialog.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MobGameWebFragment fragWeb = MobGameDashboardDialog.this.adapter.getItem(MobGameDashboardDialog.this.currentPage);
                        Log.i((String)TAG, (String)("fragContent.countTabs(): " + MobGameDashboardDialog.this.fragContent.countTabs()));
                        if (Utils.isOnline((Context)MobGameDashboardDialog.this.getActivity())) {
                            if (MobGameDashboardDialog.this.fragContent.countTabs() > 1 && !fragWeb.canGoBack()) {
                                MobGameDashboardDialog.this.fragContent.showTabs(false);
                                new Handler().postDelayed(new Runnable(){

                                    @Override
                                    public void run() {
                                    }
                                }, 1000L);
                            } else {
                                MobGameDashboardDialog.this.fragContent.hideTabs(true);
                            }
                        } else if (MobGameDashboardDialog.this.fragContent.countTabs() > 1) {
                            MobGameDashboardDialog.this.fragContent.showTabs(false);
                        } else {
                            MobGameDashboardDialog.this.fragContent.hideTabs(false);
                        }
                    }
                });
                view.addJavascriptInterface((Object)MobGameDashboardDialog.this.getActivity(), "android");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onProgressChanged(WebView view, int progress) {
            int pos = Integer.parseInt((String)view.getTag());
            if (pos == MobGameDashboardDialog.this.currentPage) {
                progress = Math.max(1, progress);
                MobGameDashboardDialog.this.circleProgressBar.setProgress(progress);
                if (progress == 100) {
                    MobGameDashboardDialog.this.hideProgressBar();
                } else {
                    MobGameDashboardDialog.this.showProgressBar();
                }
            }
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            int pos = Integer.parseInt((String)view.getTag());
            if (pos == MobGameDashboardDialog.this.currentPage) {
                MobGameDashboardDialog.this.hideProgressBar();
            }
        }

        @Override
        public void onScrollChanged(WebView view, int l, int t, int oldl, int oldt) {
        }

        @Override
        public void onSizeChanged(WebView view, int w, int h, int oldw, int oldh) {
        }
    };
    private ViewPager.SimpleOnPageChangeListener mOnPageChangeListener = new ViewPager.SimpleOnPageChangeListener(){

        public void onPageSelected(int position) {
            if (position != MobGameDashboardDialog.this.currentPage) {
                MobGameDashboardDialog.this.currentPage = position;
                MobGameWebFragment fragWeb = MobGameDashboardDialog.this.adapter.getItem(MobGameDashboardDialog.this.currentPage);
                fragWeb.loadUrlToLoadIfHave();
                MobGameDashboardDialog.this.mWebEventListener.onScrollChanged(fragWeb.getWebView(), fragWeb.getScrollX(), fragWeb.getScrollY(), fragWeb.getScrollX(), fragWeb.getScrollY());
            }
            int itemId = (int)MobGameDashboardDialog.this.adapter.getItemId(position);
            if (NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), itemId)) {
                MobGameDashboardDialog.this.hideNtf(itemId);
                MobGameDashboardDialog.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MobGameDashboardDialog.this.fragContent.notifiTabsChanged();
                    }
                });
            }
        }
    };
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                String category = intent.getStringExtra("category");
                if ("gcm".equalsIgnoreCase(category)) {
                    String strId = intent.getStringExtra("id");
                    Log.d((String)TAG, (String)("funtap :" + strId));
                    if (strId != null) {
                        MobGameDashboardDialog.this.fragContent.notifiTabsChanged();
                    }
                    int id2 = Integer.parseInt(strId);
                    MobGameDashboardDialog.this.showNtf(id2);
                } else if ("swipe_refresh".equalsIgnoreCase(category)) {
                    String strId = intent.getStringExtra("id");
                    int id3 = Integer.parseInt(strId);
                    MobGameDashboardDialog.this.hideNtf(id3);
                    MobGameDashboardDialog.this.fragContent.notifiTabsChanged();
                }
                if (intent.hasExtra(MobGameDashboardDialog.CLOSE_PROGRESS_BAR)) {
                    MobGameDashboardDialog.this.circleProgressBar.setVisibility(8);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private FirebaseAnalytics mFirebaseAnalytics;

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.eventListener != null) {
            this.eventListener.onDismissDashboard();
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootView = inflater.inflate(R.layout.dialog_dashboard, container, false);
        try {
            int dialogSize = DeviceUtils.getScreenHeightInPixels(this.rootView.getContext()) > DeviceUtils.getScreenWidthInPixels(this.rootView.getContext()) ? DeviceUtils.getScreenWidthInPixels(this.rootView.getContext()) : DeviceUtils.getScreenHeightInPixels(this.rootView.getContext());
            if (DeviceUtils.getScreenOrientation(this.rootView.getContext()) == 2) {
                LinearLayout leftDrawerLayout = (LinearLayout)this.rootView.findViewById(R.id.left_drawer);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(dialogSize, -1);
                leftDrawerLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
            } else {
                LinearLayout leftDrawerLayout = (LinearLayout)this.rootView.findViewById(R.id.left_drawer);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, dialogSize);
                leftDrawerLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getDialog().getWindow().setFlags(1024, 1024);
        this.getDialog().requestWindowFeature(1);
        isDashBoard = true;
        this.getDialog().getWindow().setWindowAnimations(R.style.DialogAnimationLeftIn);
        this.density = DeviceUtils.getDensity((Context)this.getActivity());
        long endTime = this.getArguments().getLong(KEY_TIMER);
        this.initViewLayout(endTime);
        this.initFragment();
        return this.rootView;
    }

    private List<ItemMenuDashboard> getDataItemDashboard(ArrayList<MobMenuItem> listMenuItems, Long endTimer) {
        ArrayList<ItemMenuDashboard> listMenuDashboard = new ArrayList<ItemMenuDashboard>();
        for (int i = listMenuItems.size() - 1; i >= 0; --i) {
            ItemMenuDashboard itemMenuDashboard = new ItemMenuDashboard();
            int idMenu = listMenuItems.get(i).getId();
            if (idMenu == 1) {
                itemMenuDashboard.setEndTimer(endTimer);
            }
            itemMenuDashboard.setId_menu(idMenu);
            ArrayList<MobMenuItem.SubMenu> SubIdMenus = listMenuItems.get(i).getSubMenu();
            itemMenuDashboard.setSubId_menu(SubIdMenus);
            int priority = listMenuItems.get(i).getPriority();
            itemMenuDashboard.setPriority(priority);
            String urlIcon = listMenuItems.get(i).getIcon();
            itemMenuDashboard.setUrlIcon(urlIcon);
            String urlIconActive = listMenuItems.get(i).getIconActive();
            itemMenuDashboard.setUrlIconActive(urlIconActive);
            boolean isShow = listMenuItems.get(i).isShow();
            itemMenuDashboard.setShow(isShow);
            itemMenuDashboard.setOpenLink(listMenuItems.get(i).getOpenLink());
            itemMenuDashboard.setOpenType(listMenuItems.get(i).getOpenType());
            if ((NotificationUtils.hasNtf((Context)this.getActivity(), 2) || NotificationUtils.hasNtf((Context)this.getActivity(), 3)) && idMenu == 1) {
                itemMenuDashboard.setHasNtf(true);
            }
            if ((NotificationUtils.hasNtf((Context)this.getActivity(), 5) || NotificationUtils.hasNtf((Context)this.getActivity(), 4)) && idMenu == 4) {
                itemMenuDashboard.setHasNtf(true);
            }
            if ((NotificationUtils.hasNtf((Context)this.getActivity(), 7) || NotificationUtils.hasNtf((Context)this.getActivity(), 6)) && idMenu == 6) {
                itemMenuDashboard.setHasNtf(true);
            }
            if (!isShow) continue;
            listMenuDashboard.add(itemMenuDashboard);
        }
        return listMenuDashboard;
    }

    private void initLeftLayout(ArrayList<MobMenuItem> listMenuItems) {
        try {
            ArrayList listSubMenu = new ArrayList();
            if (listSubMenu == null) {
                Log.d((String)TAG, (String)"SubMenu null");
                return;
            }
            this.txtTitle.setVisibility(8);
            JSONArray items = null;
            this.data = new Gson().toJson(listSubMenu).toString();
            Log.d((String)TAG, (String)("data news:" + this.data));
            items = new JSONArray(this.data);
            this.loadUrls(items);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void initFragment() {
        try {
            this.fragContent = new MobGamePagerFragment(this.getActivity());
            this.fragContent.addOnPageChangeListener(this.mOnPageChangeListener);
            this.fragContent.setWebEventListener(this.mWebEventListener);
            this.getChildFragmentManager().beginTransaction().add(this.layoutChildContent.getId(), (Fragment)this.fragContent, "fragment_webview").commit();
            try {
                this.data = this.getArguments().getString(KEY_DATA);
                this.id = this.getArguments().getInt(KEY_ID);
                this.urlIcon = this.getArguments().getString(KEY_ICON);
                this.isShow = this.getArguments().getBoolean(KEY_SHOW);
                Log.d((String)TAG, (String)("data : " + this.data));
                JSONArray items = new JSONArray(this.data);
                this.loadUrls(items);
            }
            catch (Exception e) {
                try {
                    this.performOnItemClick(0);
                }
                catch (IndexOutOfBoundsException | NullPointerException e2) {
                    this.performOnItemClick(0);
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initViewLayout(long endTimer) {
        try {
            int i;
            ArrayList<MobMenuItem> listMenuItems = GameConfigManager.getInstance().getMobMenu().getMenuItems();
            this.layoutTmp = this.rootView.findViewById(R.id.layout_tmp);
            this.layoutMain = this.rootView.findViewById(R.id.layout_main_dashboard);
            this.layoutItemLeft = this.rootView.findViewById(R.id.layout_item_left);
            this.layoutChildContent = this.rootView.findViewById(R.id.layout_child_content);
            this.txtTitle = (TextView)this.rootView.findViewById(R.id.title_item);
            this.btnClose = (ImageButton)this.rootView.findViewById(R.id.btn_close_dashboard);
            this.mRecycleView = (RecyclerView)this.rootView.findViewById(R.id.recycleview_menu);
            this.layoutManager = new LinearLayoutManager((Context)this.getActivity());
            this.mRecycleView.setLayoutManager(this.layoutManager);
            this.listItemMenuDashboard = this.getDataItemDashboard(listMenuItems, endTimer);
            ItemMenuDashboard smallest = this.listItemMenuDashboard.get(0);
            for (i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                if (this.listItemMenuDashboard.get(i).getPriority() >= smallest.getPriority()) continue;
                smallest = this.listItemMenuDashboard.get(i);
            }
            for (i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                if (smallest.getPriority() != this.listItemMenuDashboard.get(i).getPriority()) continue;
                this.listItemMenuDashboard.get(i).setClick(true);
                if (smallest.getId_menu() != 1) continue;
                this.txtTitle.setVisibility(8);
            }
            this.menuAdapter = new DashboardMenuAdapter(this.listItemMenuDashboard, this.getActivity());
            this.mRecycleView.setAdapter((RecyclerView.Adapter)this.menuAdapter);
            this.circleProgressBar = (ProgressBar)this.rootView.findViewById(R.id.circle_progress_bar);
            this.btnClose.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    isDashBoard = false;
                    Log.d((String)TAG, (String)"Close button clicked");
                    MobGameDashboardDialog.this.dismiss();
                    Game game = GameConfigManager.getInstance().getGameConfig();
                    boolean isShowLogo = game.getEx().isShowLogo();
                    if (isShowLogo) {
                        MobGameHelper.showNotiFloatButton(game.getEx());
                    }
                    Preference.remove((Context)MobGameDashboardDialog.this.getActivity(), "shared_pref_show_dashboard");
                    MobGameHelper.showFloatButton();
                }
            });
            this.layoutTmp.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    try {
                        Log.d((String)TAG, (String)"tmp clicked");
                        MobGameDashboardDialog.this.dismiss();
                        Game game = GameConfigManager.getInstance().getGameConfig();
                        boolean isShowLogo = game.getEx().isShowLogo();
                        if (isShowLogo) {
                            MobGameHelper.showNotiFloatButton(game.getEx());
                        }
                        Preference.remove((Context)MobGameDashboardDialog.this.getActivity(), "shared_pref_show_dashboard");
                        Intent intent = new Intent("com.mobgame.broadcast");
                        intent.putExtra("category", "float_button");
                        LocalBroadcastManager.getInstance((Context)MobGameDashboardDialog.this.getActivity()).sendBroadcast(intent);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            Animation animationTmp = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.fade_in);
            this.layoutTmp.setAnimation(animationTmp);
            this.getDialog().setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface dialogInterface, int keyCode, KeyEvent event) {
                    if (event != null && keyCode == 4 && event.getAction() == 1) {
                        MobGameDashboardDialog.this.dismiss();
                        Game game = GameConfigManager.getInstance().getGameConfig();
                        boolean isShowLogo = game.getEx().isShowLogo();
                        if (isShowLogo) {
                            MobGameHelper.showNotiFloatButton(game.getEx());
                        }
                        Preference.remove((Context)MobGameDashboardDialog.this.getActivity(), "shared_pref_show_dashboard");
                        MobGameHelper.showFloatButton();
                        return true;
                    }
                    return false;
                }
            });
            Preference.save((Context)this.getActivity(), "shared_pref_show_dashboard", true);
            this.mRecycleView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new RecyclerItemClickListener((Context)this.getActivity(), this.mRecycleView, new RecyclerItemClickListener.OnItemClickListener(){

                @Override
                public void onItemClick(View view, int position) {
                    ItemMenuDashboard itemMenuDashboard = (ItemMenuDashboard)MobGameDashboardDialog.this.listItemMenuDashboard.get(position);
                    switch (itemMenuDashboard.getOpenType()) {
                        case 0: {
                            for (int i = 0; i < MobGameDashboardDialog.this.listItemMenuDashboard.size(); ++i) {
                                if (i == position) {
                                    ((ItemMenuDashboard)MobGameDashboardDialog.this.listItemMenuDashboard.get(i)).setClick(true);
                                    continue;
                                }
                                ((ItemMenuDashboard)MobGameDashboardDialog.this.listItemMenuDashboard.get(i)).setClick(false);
                            }
                            MobGameDashboardDialog.this.menuAdapter.notifyDataSetChanged();
                            String data = "";
                            try {
                                if (((ItemMenuDashboard)MobGameDashboardDialog.this.listItemMenuDashboard.get(position)).getSubId_menu() == null) {
                                    Log.d((String)TAG, (String)"SubMenu null");
                                    return;
                                }
                                MobGameDashboardDialog.this.txtTitle.setVisibility(0);
                                JSONArray items = null;
                                data = new Gson().toJson(((ItemMenuDashboard)MobGameDashboardDialog.this.listItemMenuDashboard.get(position)).getSubId_menu()).toString();
                                Log.d((String)TAG, (String)("data report bug :" + data));
                                items = new JSONArray(data);
                                MobGameDashboardDialog.this.loadUrls(items);
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                            switch (itemMenuDashboard.getId_menu()) {
                                case 1: {
                                    MobGameDashboardDialog.this.txtTitle.setVisibility(8);
                                    if (!NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), 2) && !NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), 3)) {
                                        itemMenuDashboard.setHasNtf(false);
                                    }
                                    Log.d((String)TAG, (String)"addOnItemTouchListener : 1");
                                    MobGameDashboardDialog.this.handleNewEvent();
                                    MobGameDashboardDialog.this.menuAdapter.notifyDataSetChanged();
                                    break;
                                }
                                case 4: {
                                    itemMenuDashboard.setHasNtf(false);
                                    MobGameDashboardDialog.this.menuAdapter.notifyDataSetChanged();
                                    Log.d((String)TAG, (String)"addOnItemTouchListener : 4");
                                    MobGameDashboardDialog.this.handleGiftcode();
                                    break;
                                }
                                case 6: {
                                    itemMenuDashboard.setHasNtf(false);
                                    MobGameDashboardDialog.this.menuAdapter.notifyDataSetChanged();
                                    Log.d((String)TAG, (String)"addOnItemTouchListener : 6");
                                    MobGameDashboardDialog.this.handleBug();
                                    break;
                                }
                                case 8: {
                                    Log.d((String)TAG, (String)"addOnItemTouchListener : 8");
                                    MobGameDashboardDialog.this.handleOther();
                                    break;
                                }
                                case 10: {
                                    Toast.makeText((Context)MobGameDashboardDialog.this.getActivity(), (CharSequence)"id : 10", (int)0).show();
                                }
                            }
                            break;
                        }
                        case 2: {
                            MobGameDashboardDialog.this.showFragment(itemMenuDashboard.getOpenLink(), itemMenuDashboard.getOpenType(), false);
                            break;
                        }
                        case 3: {
                            MobGameDashboardDialog.this.showFragment(itemMenuDashboard.getOpenLink(), itemMenuDashboard.getOpenType(), false);
                        }
                    }
                }

                @Override
                public void onItemLongClick(View view, int position) {
                }
            }));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleOther() {
        this.hideTabs();
        isDashBoard = false;
    }

    private void handleBug() {
        if (NotificationUtils.hasNtf((Context)this.getActivity(), 7)) {
            NotificationUtils.removeNtf((Context)this.getActivity(), 7);
        }
        if (NotificationUtils.hasNtf((Context)this.getActivity(), 6)) {
            NotificationUtils.removeNtf((Context)this.getActivity(), 6);
        }
        this.hideTabs();
        isDashBoard = false;
        this.trackEventFromButton("event_report_bugs", "root_report_bugs");
    }

    private void handleGiftcode() {
        if (NotificationUtils.hasNtf((Context)this.getActivity(), 5)) {
            NotificationUtils.removeNtf((Context)this.getActivity(), 5);
        }
        if (NotificationUtils.hasNtf((Context)this.getActivity(), 4)) {
            NotificationUtils.removeNtf((Context)this.getActivity(), 4);
        }
        this.hideTabs();
        isDashBoard = false;
        this.trackEventFromButton("event_giftcode", "root_giftcode");
    }

    private void handleNewEvent() {
        this.showTabs();
        isDashBoard = true;
        this.trackEventFromButton("event_news_event", "root_news_event");
    }

    private void showTabs() {
        try {
            if (this.fragContent != null) {
                this.fragContent.showTabs(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideTabs() {
        try {
            if (this.fragContent != null) {
                this.fragContent.hideTabs(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        this.setStyle(1, 0x1030010);
        super.onCreate(savedInstanceState);
    }

    private void performOnItemClick(int position) {
    }

    public void loadUrls(JSONArray items) {
        JSONObject item;
        int i;
        Log.e((String)TAG, (String)("item:" + items.toString()));
        if (this.adapter == null) {
            this.adapter = new MobPagerAdapter(this.getChildFragmentManager());
        }
        this.currentPage = 0;
        JSONArray revItems = new JSONArray();
        for (i = 0; i < items.length(); ++i) {
            try {
                item = items.getJSONObject(i);
                revItems.put((Object)item);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (i = items.length() - 1; i >= 0; --i) {
            try {
                item = revItems.getJSONObject(i);
                if (item.getInt("priority") >= revItems.getJSONObject(this.currentPage).getInt("priority")) continue;
                this.currentPage = i;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.adapter.setItems(revItems);
            this.fragContent.setAdapter(this.adapter, this.currentPage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void show(FragmentManager manager, String tag) {
        try {
            FragmentTransaction ft = manager.beginTransaction();
            ft.add((Fragment)this, tag);
            ft.commitAllowingStateLoss();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void onPause() {
        super.onPause();
        try {
            LocalBroadcastManager.getInstance((Context)this.getActivity()).unregisterReceiver(this.mBroadcastReceiver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onResume() {
        super.onResume();
        try {
            LocalBroadcastManager.getInstance((Context)this.getActivity()).registerReceiver(this.mBroadcastReceiver, new IntentFilter("com.mobgame.broadcast"));
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "float_button");
            intent.putExtra("message", "hide");
            LocalBroadcastManager.getInstance((Context)this.getActivity()).sendBroadcast(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showNtf(int id2) {
        if (NotificationUtils.hasNtf((Context)this.getActivity(), id2)) {
            block0 : switch (id2) {
                case 2: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 1) continue;
                        this.listItemMenuDashboard.get(i).setHasNtf(true);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 1) continue;
                        this.listItemMenuDashboard.get(i).setHasNtf(true);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 4) continue;
                        this.listItemMenuDashboard.get(i).setHasNtf(true);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 4) continue;
                        this.listItemMenuDashboard.get(i).setHasNtf(true);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
                case 6: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 6) continue;
                        this.listItemMenuDashboard.get(i).setHasNtf(true);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
                case 7: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 6) continue;
                        this.listItemMenuDashboard.get(i).setHasNtf(true);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
            }
        }
    }

    private void hideNtf(int id2) {
        if (NotificationUtils.hasNtf((Context)this.getActivity(), id2)) {
            block0 : switch (id2) {
                case 2: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 1) continue;
                        NotificationUtils.removeNtf((Context)this.getActivity(), id2);
                        this.listItemMenuDashboard.get(i).setHasNtf(false);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 1) continue;
                        NotificationUtils.removeNtf((Context)this.getActivity(), id2);
                        this.listItemMenuDashboard.get(i).setHasNtf(false);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 4) continue;
                        NotificationUtils.removeNtf((Context)this.getActivity(), id2);
                        this.listItemMenuDashboard.get(i).setHasNtf(false);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 4) continue;
                        NotificationUtils.removeNtf((Context)this.getActivity(), id2);
                        this.listItemMenuDashboard.get(i).setHasNtf(false);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
                case 6: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 6) continue;
                        NotificationUtils.removeNtf((Context)this.getActivity(), id2);
                        this.listItemMenuDashboard.get(i).setHasNtf(false);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
                case 7: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 6) continue;
                        NotificationUtils.removeNtf((Context)this.getActivity(), id2);
                        this.listItemMenuDashboard.get(i).setHasNtf(false);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
            }
        }
    }

    private void hideProgressBar() {
        try {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MobGameDashboardDialog.this.circleProgressBar.setVisibility(8);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showProgressBar() {
        try {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MobGameDashboardDialog.this.circleProgressBar.setVisibility(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void trackEventFromButton(String eventName, String data) {
        try {
            Log.d((String)TAG, (String)("event : " + eventName + " , data : " + data));
            this.mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)this.getActivity());
            Bundle bundle = new Bundle();
            bundle.putString("data", data);
            this.mFirebaseAnalytics.logEvent(eventName, bundle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    private void showFragment(String url, int openType, boolean isEncrypted) {
        try {
            if (url != null && !url.equals("")) {
                FragmentManager fm = this.getActivity().getFragmentManager();
                MobGameSocialDialogFragment fr = (MobGameSocialDialogFragment)fm.findFragmentByTag("tag_fragment");
                if (fr == null) {
                    fr = new MobGameSocialDialogFragment(new MUrl(url, isEncrypted));
                    FragmentTransaction fragmentTransaction = fm.beginTransaction();
                    fragmentTransaction.add((Fragment)fr, "tag_fragment");
                    fr.setOnDismissListener(new DialogInterface.OnDismissListener(){

                        public void onDismiss(DialogInterface dialogInterface) {
                            if (isDashBoard) {
                                Preference.save((Context)MobGameDashboardDialog.this.getActivity(), "shared_pref_show_dashboard", true);
                            } else {
                                Game game = GameConfigManager.getInstance().getGameConfig();
                                boolean isShowLogo = game.getEx().isShowLogo();
                                if (isShowLogo) {
                                    MobGameHelper.showNotiFloatButton(game.getEx());
                                }
                                Preference.remove((Context)MobGameDashboardDialog.this.getActivity(), "shared_pref_show_dashboard");
                            }
                        }
                    });
                    fragmentTransaction.commitAllowingStateLoss();
                } else {
                    try {
                        fr.loadUrlWithMobHeaders(new MUrl(url, isEncrypted));
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                Log.d((String)TAG, (String)"url null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface EventListener {
        public void onDismissDashboard();
    }

    private class MobPagerAdapter
    extends FragmentPagerAdapter {
        private ArrayList<MobGameWebFragment> fragments;
        private FragmentManager fragmentManager;
        private JSONArray items;

        public MobPagerAdapter(FragmentManager fm) {
            super(fm);
            this.fragments = new ArrayList();
            this.fragmentManager = fm;
        }

        public void setItems(JSONArray items) {
            this.releaseFragments();
            this.items = items;
            this.fragments = new ArrayList();
            for (int i = 0; i < items.length(); ++i) {
                try {
                    JSONObject item = items.getJSONObject(i);
                    String url = item.getString("action");
                    int id2 = item.getInt("id");
                    MobGameWebFragment frag = i == MobGameDashboardDialog.this.currentPage ? new MobGameWebFragment(url, id2) : new MobGameWebFragment(url, true, id2);
                    frag.setEventListener(MobGameDashboardDialog.this.mWebEventListener);
                    frag.setWebViewTag(i + "");
                    this.fragments.add(frag);
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }

        public MobGameWebFragment getItem(int position) {
            try {
                return this.fragments.get(position);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getCount() {
            try {
                return this.fragments.size();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public long getItemId(int position) {
            try {
                return this.items.getJSONObject(position).getInt("id");
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1L;
            }
        }

        public int getItemPosition(Object object) {
            return -2;
        }

        public CharSequence getPageTitle(int position) {
            try {
                JSONObject item = this.items.getJSONObject(position);
                int id2 = item.getInt("id");
                if (item.has("title")) {
                    String title = item.getString("title");
                    MobGameDashboardDialog.this.txtTitle.setText((CharSequence)title.toString());
                    if (NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), id2)) {
                        Drawable image = Res.drawable((Context)MobGameDashboardDialog.this.getActivity(), R.drawable.ic_notification_tab_strip);
                        image.setBounds(0, 0, image.getIntrinsicWidth(), image.getIntrinsicHeight());
                        SpannableString sb = new SpannableString((CharSequence)(title + "  "));
                        ImageSpan imageSpan = new ImageSpan(image, 1);
                        sb.setSpan((Object)imageSpan, title.length() + 1, title.length() + 2, 18);
                        return sb;
                    }
                    return title;
                }
                return "Tab " + position;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "Tab " + position;
            }
        }

        private void releaseFragments() {
            try {
                if (this.fragments != null) {
                    for (MobGameWebFragment frag : this.fragments) {
                        frag.stopLoading();
                        this.fragmentManager.beginTransaction().remove((Fragment)frag).commit();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

