/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.a;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketPermission;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Connection;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.Internal;
import okhttp3.internal.Platform;
import okhttp3.internal.Util;
import okhttp3.internal.Version;
import okhttp3.internal.a;
import okhttp3.internal.c;
import okhttp3.internal.http.HttpDate;
import okhttp3.internal.http.HttpEngine;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.OkHeaders;
import okhttp3.internal.http.RequestException;
import okhttp3.internal.http.RetryableSink;
import okhttp3.internal.http.RouteException;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http.StreamAllocation;
import okio.BufferedSink;
import okio.Sink;

public class b
extends HttpURLConnection {
    private static final Set<String> e = new LinkedHashSet<String>(Arrays.asList("OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "PATCH"));
    private static final RequestBody f = RequestBody.create(null, (byte[])new byte[0]);
    OkHttpClient a;
    private Headers.Builder g = new Headers.Builder();
    private long h = -1L;
    private int i;
    protected IOException b;
    protected HttpEngine c;
    private Headers j;
    private Route k;
    Handshake d;
    private c l;

    public b(URL uRL, OkHttpClient okHttpClient) {
        super(uRL);
        this.a = okHttpClient;
    }

    public b(URL uRL, OkHttpClient okHttpClient, c c2) {
        this(uRL, okHttpClient);
        this.l = c2;
    }

    @Override
    public final void connect() throws IOException {
        boolean bl;
        this.b();
        while (!(bl = this.a(false))) {
        }
    }

    @Override
    public final void disconnect() {
        if (this.c == null) {
            return;
        }
        this.c.cancel();
    }

    @Override
    public final InputStream getErrorStream() {
        try {
            HttpEngine httpEngine = this.d();
            if (HttpEngine.hasBody((Response)httpEngine.getResponse()) && httpEngine.getResponse().code() >= 400) {
                return httpEngine.getResponse().body().byteStream();
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Headers a() throws IOException {
        if (this.j == null) {
            Response response = this.d().getResponse();
            Headers headers = response.headers();
            this.j = headers.newBuilder().add(OkHeaders.SELECTED_PROTOCOL, response.protocol().toString()).add(OkHeaders.RESPONSE_SOURCE, okhttp3.internal.a.b.a(response)).build();
        }
        return this.j;
    }

    private static String a(Response response) {
        if (response.networkResponse() == null) {
            if (response.cacheResponse() == null) {
                return "NONE";
            }
            return "CACHE " + response.code();
        }
        if (response.cacheResponse() == null) {
            return "NETWORK " + response.code();
        }
        return "CONDITIONAL_CACHE " + response.networkResponse().code();
    }

    @Override
    public final String getHeaderField(int position) {
        try {
            Headers headers = this.a();
            if (position < 0 || position >= headers.size()) {
                return null;
            }
            return headers.value(position);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public final String getHeaderField(String fieldName) {
        try {
            return fieldName == null ? StatusLine.get((Response)this.d().getResponse()).toString() : this.a().get(fieldName);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public final String getHeaderFieldKey(int position) {
        try {
            Headers headers = this.a();
            if (position < 0 || position >= headers.size()) {
                return null;
            }
            return headers.name(position);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public final Map<String, List<String>> getHeaderFields() {
        try {
            return okhttp3.internal.a.a(this.a(), StatusLine.get((Response)this.d().getResponse()).toString());
        }
        catch (IOException iOException) {
            return Collections.emptyMap();
        }
    }

    @Override
    public final Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Cannot access request header fields after connection is set");
        }
        return okhttp3.internal.a.a(this.g.build(), null);
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("This protocol does not support input");
        }
        HttpEngine httpEngine = this.d();
        if (this.getResponseCode() >= 400) {
            throw new FileNotFoundException(this.url.toString());
        }
        return httpEngine.getResponse().body().byteStream();
    }

    @Override
    public final OutputStream getOutputStream() throws IOException {
        this.connect();
        BufferedSink bufferedSink = this.c.getBufferedRequestBody();
        if (bufferedSink == null) {
            throw new ProtocolException("method does not support a request body: " + this.method);
        }
        if (this.c.hasResponse()) {
            throw new ProtocolException("cannot write request body after response has been read");
        }
        return bufferedSink.outputStream();
    }

    @Override
    public final Permission getPermission() throws IOException {
        int n2;
        URL uRL = this.getURL();
        String string = uRL.getHost();
        int n3 = n2 = uRL.getPort() != -1 ? uRL.getPort() : HttpUrl.defaultPort((String)uRL.getProtocol());
        if (this.usingProxy()) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.a.proxy().address();
            string = inetSocketAddress.getHostName();
            n2 = inetSocketAddress.getPort();
        }
        return new SocketPermission(string + ":" + n2, "connect, resolve");
    }

    @Override
    public final String getRequestProperty(String field) {
        if (field == null) {
            return null;
        }
        return this.g.get(field);
    }

    @Override
    public void setConnectTimeout(int timeoutMillis) {
        this.a = this.a.newBuilder().connectTimeout((long)timeoutMillis, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.a = this.a.newBuilder().followRedirects(followRedirects).build();
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.a.followRedirects();
    }

    @Override
    public int getConnectTimeout() {
        return this.a.connectTimeoutMillis();
    }

    @Override
    public void setReadTimeout(int timeoutMillis) {
        this.a = this.a.newBuilder().readTimeout((long)timeoutMillis, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public int getReadTimeout() {
        return this.a.readTimeoutMillis();
    }

    private void b() throws IOException {
        if (this.b != null) {
            throw this.b;
        }
        if (this.c != null) {
            return;
        }
        this.connected = true;
        try {
            if (this.doOutput) {
                if (this.method.equals("GET")) {
                    this.method = "POST";
                } else if (!HttpMethod.permitsRequestBody((String)this.method)) {
                    throw new ProtocolException(this.method + " does not support writing");
                }
            }
            this.c = this.a(this.method, null, null, null);
        }
        catch (IOException iOException) {
            this.b = iOException;
            throw iOException;
        }
    }

    private HttpEngine a(String string, StreamAllocation streamAllocation, RetryableSink retryableSink, Response response) throws MalformedURLException, UnknownHostException {
        int n2;
        RequestBody requestBody = HttpMethod.requiresRequestBody((String)string) ? f : null;
        URL uRL = this.getURL();
        HttpUrl httpUrl = Internal.instance.getHttpUrlChecked(uRL.toString());
        Request.Builder builder = new Request.Builder().url(httpUrl).method(string, requestBody);
        Headers headers = this.g.build();
        int n3 = headers.size();
        for (n2 = 0; n2 < n3; n2 += 1) {
            builder.addHeader(headers.name(n2), headers.value(n2));
        }
        n2 = 0;
        if (HttpMethod.permitsRequestBody((String)string)) {
            if (this.h != -1L) {
                builder.header("Content-Length", Long.toString(this.h));
            } else if (this.chunkLength > 0) {
                builder.header("Transfer-Encoding", "chunked");
            } else {
                n2 = 1;
            }
            if (headers.get("Content-Type") == null) {
                builder.header("Content-Type", "application/x-www-form-urlencoded");
            }
        }
        if (headers.get("User-Agent") == null) {
            builder.header("User-Agent", this.c());
        }
        Request request = builder.build();
        OkHttpClient okHttpClient = this.a;
        if (Internal.instance.internalCache(okHttpClient) != null && !this.getUseCaches()) {
            okHttpClient = this.a.newBuilder().cache(null).build();
        }
        return new HttpEngine(okHttpClient, request, n2 != 0, true, false, streamAllocation, retryableSink, response);
    }

    private String c() {
        String string = System.getProperty("http.agent");
        return string != null ? Util.toHumanReadableAscii((String)string) : Version.userAgent();
    }

    private HttpEngine d() throws IOException {
        this.b();
        if (this.c.hasResponse()) {
            return this.c;
        }
        while (true) {
            if (!this.a(true)) {
                continue;
            }
            Response response = this.c.getResponse();
            Request request = this.c.followUpRequest();
            if (request == null) {
                this.c.releaseStreamAllocation();
                return this.c;
            }
            if (++this.i > 20) {
                throw new ProtocolException("Too many follow-up requests: " + this.i);
            }
            this.url = request.url().url();
            this.g = request.headers().newBuilder();
            Sink sink = this.c.getRequestBody();
            if (!request.method().equals(this.method)) {
                sink = null;
            }
            if (sink != null && !(sink instanceof RetryableSink)) {
                throw new HttpRetryException("Cannot retry streamed HTTP body", this.responseCode);
            }
            StreamAllocation streamAllocation = this.c.close();
            if (!this.c.sameConnection(request.url())) {
                streamAllocation.release();
                streamAllocation = null;
            }
            this.c = this.a(request.method(), streamAllocation, (RetryableSink)sink, response);
        }
    }

    private boolean a(boolean bl) throws IOException {
        boolean bl2 = true;
        if (this.l != null) {
            this.l.a(this.c.getRequest().url().url());
        }
        try {
            this.c.sendRequest();
            Connection connection = this.c.getConnection();
            if (connection != null) {
                this.k = connection.route();
                this.d = connection.handshake();
            } else {
                this.k = null;
                this.d = null;
            }
            if (bl) {
                this.c.readResponse();
            }
            bl2 = false;
            boolean bl3 = true;
            return bl3;
        }
        catch (RequestException requestException) {
            IOException iOException;
            this.b = iOException = requestException.getCause();
            throw iOException;
        }
        catch (RouteException routeException) {
            IOException iOException;
            HttpEngine httpEngine = this.c.recover(routeException.getLastConnectException(), true);
            if (httpEngine != null) {
                bl2 = false;
                this.c = httpEngine;
                boolean bl4 = false;
                return bl4;
            }
            this.b = iOException = routeException.getLastConnectException();
            throw iOException;
        }
        catch (IOException iOException) {
            HttpEngine httpEngine = this.c.recover(iOException, false);
            if (httpEngine != null) {
                bl2 = false;
                this.c = httpEngine;
                boolean bl5 = false;
                return bl5;
            }
            this.b = iOException;
            throw iOException;
        }
        finally {
            if (bl2) {
                StreamAllocation streamAllocation = this.c.close();
                streamAllocation.release();
            }
        }
    }

    @Override
    public final boolean usingProxy() {
        Proxy proxy = this.k != null ? this.k.proxy() : this.a.proxy();
        return proxy != null && proxy.type() != Proxy.Type.DIRECT;
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.d().getResponse().message();
    }

    @Override
    public final int getResponseCode() throws IOException {
        return this.d().getResponse().code();
    }

    @Override
    public final void setRequestProperty(String field, String newValue) {
        if (this.connected) {
            throw new IllegalStateException("Cannot set request property after connection is made");
        }
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        if (newValue == null) {
            Platform.get().log(5, "Ignoring header " + field + " because its value was null.", null);
            return;
        }
        if ("X-Android-Transports".equals(field) || "X-Android-Protocols".equals(field)) {
            this.a(newValue, false);
        } else {
            this.g.set(field, newValue);
        }
    }

    @Override
    public void setIfModifiedSince(long newValue) {
        super.setIfModifiedSince(newValue);
        if (this.ifModifiedSince != 0L) {
            this.g.set("If-Modified-Since", HttpDate.format((Date)new Date(this.ifModifiedSince)));
        } else {
            this.g.removeAll("If-Modified-Since");
        }
    }

    @Override
    public final void addRequestProperty(String field, String value) {
        if (this.connected) {
            throw new IllegalStateException("Cannot add request property after connection is made");
        }
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        if (value == null) {
            Platform.get().log(5, "Ignoring header " + field + " because its value was null.", null);
            return;
        }
        if ("X-Android-Transports".equals(field) || "X-Android-Protocols".equals(field)) {
            this.a(value, true);
        } else {
            this.g.add(field, value);
        }
    }

    private void a(String string, boolean bl) {
        ArrayList<Protocol> arrayList = new ArrayList<Protocol>();
        if (bl) {
            arrayList.addAll(this.a.protocols());
        }
        for (String string2 : string.split(",", -1)) {
            try {
                arrayList.add(Protocol.get((String)string2));
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        this.a = this.a.newBuilder().protocols(arrayList).build();
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        if (!e.contains(method)) {
            throw new ProtocolException("Expected one of " + e + " but was " + method);
        }
        this.method = method;
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        this.setFixedLengthStreamingMode((long)contentLength);
    }

    @Override
    public void setFixedLengthStreamingMode(long contentLength) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (this.chunkLength > 0) {
            throw new IllegalStateException("Already in chunked mode");
        }
        if (contentLength < 0L) {
            throw new IllegalArgumentException("contentLength < 0");
        }
        this.h = contentLength;
        this.fixedContentLength = (int)Math.min(contentLength, Integer.MAX_VALUE);
    }
}

