package com.mobgame.gui.view.adapter;

import android.app.Activity;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.Toast;

import com.bumptech.glide.Glide;
import com.mobgame.R;
import com.mobgame.gui.CountdownChronometer;
import com.mobgame.model.ItemMenuDashboard;

import java.util.Calendar;
import java.util.List;

public class DashboardMenuAdapter extends RecyclerView.Adapter<DashboardMenuAdapter.ViewHolder>{

    private static final String TAG = DashboardMenuAdapter.class.getSimpleName();

    private List<ItemMenuDashboard> listItemMenuDashboard;
    private Activity activity;
    public DashboardMenuAdapter(List<ItemMenuDashboard> listItemMenuDashboards , Activity activity){
        this.listItemMenuDashboard = listItemMenuDashboards;
        this.activity = activity;
    }
    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_menu_dashboard , parent , false);
        return new ViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        ItemMenuDashboard itemMenuDashboard = listItemMenuDashboard.get(position);
        Log.e(TAG , "position : " + position + " , isShow : " + itemMenuDashboard.getUrlIconActive());
        if(itemMenuDashboard.isShow()){
            if (itemMenuDashboard.isClick()) {
                holder.countdownTimerItem.setTextColor(Color.parseColor("#f14308"));
                Glide.with(activity).load(itemMenuDashboard.getUrlIconActive()).into(holder.btnImageCenter);
            } else {
                holder.countdownTimerItem.setTextColor(Color.parseColor("#7a7a7a"));
                Glide.with(activity).load(itemMenuDashboard.getUrlIcon()).into(holder.btnImageCenter);
            }
            if(itemMenuDashboard.isHasNtf()){
                holder.imgNtfItem.setVisibility(View.VISIBLE);
            }else{
                holder.imgNtfItem.setVisibility(View.GONE);
            }
            setTimerDashboard(itemMenuDashboard.getEndTimer() , holder);
        }else{
            holder.btnImageCenter.setVisibility(View.GONE);
            holder.imgNtfItem.setVisibility(View.GONE);
            holder.countdownTimerItem.setVisibility(View.GONE);
        }


    }

    private void setTimerDashboard(long endTimer , ViewHolder holder) {
        try {
            long countDownTimer = endTimer - Calendar.getInstance().getTimeInMillis();
            if (countDownTimer > 0) {
                holder.countdownTimerItem.setVisibility(View.VISIBLE);
            } else {
                holder.countdownTimerItem.setVisibility(View.GONE);
            }
            holder.countdownTimerItem.setBase(Calendar.getInstance().getTime().getTime() + countDownTimer);
            holder.countdownTimerItem.setCountdownListener(new CountdownChronometer.CountdownListener() {
                @Override
                public void done() {
                    if (holder.countdownTimerItem != null) {
                        holder.countdownTimerItem.setVisibility(View.GONE);
                    }
                    Log.e(TAG, "Vao cmn day roi");
                }

            });
            holder.countdownTimerItem.start();
            holder.countdownTimerItem.setTextSize(9);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return listItemMenuDashboard.size();
    }

    //View holder customise
    public class ViewHolder extends RecyclerView.ViewHolder{
        private ImageButton btnImageCenter;
        private ImageView imgNtfItem;
        private CountdownChronometer countdownTimerItem;
        public ViewHolder(View itemView) {
            super(itemView);
            btnImageCenter = (ImageButton) itemView.findViewById(R.id.btn_image_center);
            imgNtfItem = (ImageView) itemView.findViewById(R.id.img_ntf_item);
            countdownTimerItem = (CountdownChronometer) itemView.findViewById(R.id.countdown_timer_new_item);
        }
    }
}
