/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.view.adapter;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.mobgame.R;
import com.mobgame.gui.CountdownChronometer;
import com.mobgame.model.ItemMenuDashboard;
import java.util.Calendar;
import java.util.List;

public class DashboardMenuAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final String TAG = DashboardMenuAdapter.class.getSimpleName();
    private List<ItemMenuDashboard> listItemMenuDashboard;
    private Activity activity;

    public DashboardMenuAdapter(List<ItemMenuDashboard> listItemMenuDashboards, Activity activity) {
        this.listItemMenuDashboard = listItemMenuDashboards;
        this.activity = activity;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_menu_dashboard, parent, false);
        return new ViewHolder(itemView);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        ItemMenuDashboard itemMenuDashboard = this.listItemMenuDashboard.get(position);
        Log.e((String)TAG, (String)("position : " + position + " , isShow : " + itemMenuDashboard.getUrlIconActive()));
        if (itemMenuDashboard.isShow()) {
            if (itemMenuDashboard.isClick()) {
                holder.countdownTimerItem.setTextColor(Color.parseColor((String)"#f14308"));
                Glide.with((Activity)this.activity).load(itemMenuDashboard.getUrlIconActive()).into((ImageView)holder.btnImageCenter);
            } else {
                holder.countdownTimerItem.setTextColor(Color.parseColor((String)"#7a7a7a"));
                Glide.with((Activity)this.activity).load(itemMenuDashboard.getUrlIcon()).into((ImageView)holder.btnImageCenter);
            }
            if (itemMenuDashboard.isHasNtf()) {
                holder.imgNtfItem.setVisibility(0);
            } else {
                holder.imgNtfItem.setVisibility(8);
            }
            this.setTimerDashboard(itemMenuDashboard.getEndTimer(), holder);
        } else {
            holder.btnImageCenter.setVisibility(8);
            holder.imgNtfItem.setVisibility(8);
            holder.countdownTimerItem.setVisibility(8);
        }
    }

    private void setTimerDashboard(long endTimer, final ViewHolder holder) {
        try {
            long countDownTimer = endTimer - Calendar.getInstance().getTimeInMillis();
            if (countDownTimer > 0L) {
                holder.countdownTimerItem.setVisibility(0);
            } else {
                holder.countdownTimerItem.setVisibility(8);
            }
            holder.countdownTimerItem.setBase(Calendar.getInstance().getTime().getTime() + countDownTimer);
            holder.countdownTimerItem.setCountdownListener(new CountdownChronometer.CountdownListener(){

                @Override
                public void done() {
                    if (holder.countdownTimerItem != null) {
                        holder.countdownTimerItem.setVisibility(8);
                    }
                    Log.e((String)TAG, (String)"Vao cmn day roi");
                }
            });
            holder.countdownTimerItem.start();
            holder.countdownTimerItem.setTextSize(9.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.listItemMenuDashboard.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageButton btnImageCenter;
        private ImageView imgNtfItem;
        private CountdownChronometer countdownTimerItem;

        public ViewHolder(View itemView) {
            super(itemView);
            this.btnImageCenter = (ImageButton)itemView.findViewById(R.id.btn_image_center);
            this.imgNtfItem = (ImageView)itemView.findViewById(R.id.img_ntf_item);
            this.countdownTimerItem = (CountdownChronometer)itemView.findViewById(R.id.countdown_timer_new_item);
        }
    }
}

