package com.mobgame.gui.dialog;

import android.app.Activity;
import android.app.DialogFragment;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.mobgame.MobGameHelper;
import com.mobgame.R;
import com.mobgame.api.GetPayItemTask;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.MobGameActivity;
import com.mobgame.js.CmdPayment;
import com.mobgame.model.MItemPayment;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Utils;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MobGamePayDialogFragment extends DialogFragment {
    private static final String TAG = MobGamePayDialogFragment.class
            .getSimpleName();
    private ImageButton btn_close;
    private Button btnReload;
    private GridView gridView;
    private View viewConnectionLost;
    private DialogInterface.OnDismissListener mOnDismissListener;
    ArrayList<MItemPayment> listItemPay = new ArrayList<>();
    int col, row;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.payment_dialog_fragment,
                container, false);
        getDialog().getWindow().setFlags(
                WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        btn_close = (ImageButton) rootView.findViewById(R.id.btn_close_pay);
        gridView = (GridView) rootView.findViewById(R.id.grid_view_pay);
        viewConnectionLost = rootView.findViewById(R.id.layout_connection_lost);
        btnReload = (Button) rootView.findViewById(R.id.btn_reload);

        String columnGrid = GameConfigManager.getInstance().getGameConfig().getPayForm()
                .getPaymentDesign().getCol();
        col = Integer.parseInt(columnGrid);
        String rowGrid = GameConfigManager.getInstance().getGameConfig()
                .getPayForm()
                .getPaymentDesign().getRow();
        row = Integer.parseInt(rowGrid);
        int orientation = getResources().getConfiguration().orientation;
        Log.e(TAG, "col : " + col + " , row : " + row);
        if (orientation == Configuration.ORIENTATION_PORTRAIT) {
            gridView.setNumColumns(col);
            initFormPayment(col , row);
        }
        if (orientation == Configuration.ORIENTATION_LANDSCAPE) {
            gridView.setNumColumns(col);
            initFormPayment(col , row);
        }
        btn_close.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                closePayment();
            }
        });
        return rootView;
    }

    private void initFormPayment(final int col , final int row) {
        try {
            if (Utils.isOnline(getActivity())) {
                viewConnectionLost.setVisibility(View.GONE);
                FunTrackingUtil.getInstance().trackEvent(getActivity(), FunTrackingUtil.TRACK_PAYMENT_OPEN, null);
                new GetPayItemTask(
                        getActivity(), new GetPayItemTask.Listener() {
                    @Override
                    public void onSuccess(
                            ArrayList<MItemPayment> listItem) {
                        listItemPay = listItem;

                        PayGridViewItem adapter = new PayGridViewItem(
                                getActivity(), listItemPay, col , row);
                        gridView.setAdapter(adapter);
                    }

                    @Override
                    public void onFailure(Throwable t) {

                    }
                }).execute();
            } else {
                viewConnectionLost.setVisibility(View.VISIBLE);
                btnReload.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        int orientation = getResources().getConfiguration().orientation;
                        if (orientation == Configuration.ORIENTATION_PORTRAIT) {
                            initFormPayment(col , row);
                        }
                        if (orientation == Configuration.ORIENTATION_LANDSCAPE) {
                            initFormPayment(col , row);
                        }
                    }
                });
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }

    }

    public void closePayment(){
        dismiss();
        FunTrackingUtil.getInstance().trackEvent(getActivity(), FunTrackingUtil.TRACK_PAYMENT_CLOSE, null);
        boolean isNotHideFloatButton = Preference.getBoolean(
                MobGamePayDialogFragment.this.getActivity(),
                Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true);
        boolean isEnableDashboard = Utils
                .isDashboardEnabled(MobGamePayDialogFragment.this
                        .getActivity());
        Log.d(TAG, "isNotHideFloatButton: " + isNotHideFloatButton);
        Log.d(TAG, "isEnableDashboard: " + isEnableDashboard);
        if (isNotHideFloatButton && isEnableDashboard) {
            MobGameHelper.showFloatButton();
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setStyle(STYLE_NO_TITLE, android.R.style.Theme_Translucent_NoTitleBar);
    }

    @Override
    public void onResume() {
        // TODO Auto-generated method stub
        super.onResume();
        MobGameHelper.hideFloatButton();
        LocalBroadcastManager.getInstance(
                getActivity().getApplicationContext()).registerReceiver(
                receiver,
                new IntentFilter(Constants.INTENT_CLOSE_PAYMENT));

    }
    @Override
    public void onPause() {
        // TODO Auto-generated method stub
        super.onPause();
        LocalBroadcastManager.getInstance(
                getActivity().getApplicationContext()).unregisterReceiver(receiver);

    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (mOnDismissListener != null) {
            mOnDismissListener.onDismiss(dialog);
        }
    }

    public void setOnDismissListener(
            DialogInterface.OnDismissListener onDismissListener) {
        mOnDismissListener = onDismissListener;
    }

    class PayGridViewItem extends BaseAdapter {
        private Activity mActivity;
        private ArrayList<MItemPayment> listItemPayment;
        private int col , row;
        int widthItem, heghtItem, width , height;

        public PayGridViewItem(Activity activity,
                               ArrayList<MItemPayment> listItemPayment, int col , int row) {
            this.mActivity = activity;
            this.listItemPayment = listItemPayment;
            this.col = col;
            width = getScreenWidthInPixel(mActivity);
            height = getScreenHeightInPixel(mActivity);
            widthItem = ((int) (width / col));
            heghtItem = (int) (height / row);
        }

        @Override
        public int getCount() {
            return listItemPayment.size();
        }

        @Override
        public Object getItem(int position) {
            return listItemPayment.get(position);
        }

        @Override
        public long getItemId(int position) {
            return 0;
        }

        @Override
        public View getView(final int position, View convertView,
                            ViewGroup parent) {
            LayoutInflater inflater = (LayoutInflater) mActivity
                    .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            View view;
            if (convertView == null) {
                view = new View(mActivity);
                view = inflater.inflate(R.layout.item_payment, null);
                ImageView imgView = (ImageView) view
                        .findViewById(R.id.img_item_pay);

                Log.d(TAG, "width : " + widthItem + " , heght: " + heghtItem);
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(
                        widthItem, heghtItem);
                imgView.setLayoutParams(params);

                RequestOptions fitOptions = new RequestOptions().centerCrop().diskCacheStrategy(DiskCacheStrategy.ALL);
                Glide.with(mActivity).asBitmap()
                        .load(listItemPayment.get(position).getUrlPng())
                        .apply(fitOptions)
                        .into(imgView);
                boolean isSubmit = GameConfigManager
                        .getInstance().getGameConfig().isSubm();
                if (isSubmit == true) {
                    if (listItemPayment.get(position).getCategoryItem()
                            .equals("xx02")) {
                        imgView.setVisibility(View.GONE);
                    }
                }
                imgView.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        // iab payment
                        if (listItemPayment.get(position).getCategoryItem()
                                .equals("xx01")) {
                            try {
                                JSONObject json = new JSONObject();
                                json.put("product_id",
                                        listItemPayment.get(position)
                                                .getProductId());
                                Log.d(TAG, "json:" + json);
                                CmdPayment.getInstance().mobPaymentStartIAP(
                                        mActivity, json.toString());
                                Map<String, Object> eventValue = new HashMap<>();
                                eventValue.put("product_id",listItemPayment.get(position).getProductId() );
                                FunTrackingUtil.getInstance().trackEvent(getActivity(), FunTrackingUtil.TRACK_PAYMENT_CLICK, eventValue);

                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                        // local payment
                        if (listItemPayment.get(position).getCategoryItem()
                                .equals("xx02")) {
                            //xx02 ko gg
                            MobGameHelper.hideFloatButton();
                            String url = Constants.URL_PAYMENT;
                            Log.d(TAG, url);
                            Intent intent = new Intent(mActivity,
                                    MobGameActivity.class);
                            intent.putExtra(MobGameActivity.KEY_DATA,
                                    "[{'action':'" + url + "'}]");
                            intent.putExtra(MobGameActivity.FORM,
                                    "payment");
                            mActivity.startActivity(intent);
                            getDialog().dismiss();
                        }
                    }
                });

            } else {
                view = (View) convertView;
            }
            return view;
        }

        public int getScreenWidthInPixel(Context context) {
            return context.getResources().getDisplayMetrics().widthPixels;
        }
        public int getScreenHeightInPixel(Context context) {
            return context.getResources().getDisplayMetrics().heightPixels - (int)(50 * DeviceUtils.getDensity(mActivity));
        }
    }

    BroadcastReceiver receiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            // TODO Auto-generated method stub
            try{
                boolean isClosePayment = intent.getBooleanExtra(Constants.INTENT_EXTRA_CLOSE_PAYMENT, false);
                if(isClosePayment) closePayment();
            } catch (Exception e) {
                // TODO: handle exception
                e.printStackTrace();
            }
        }

    };
}
