/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.component;

import android.content.Context;
import android.content.res.Resources;
import android.util.Log;
import com.appsflyer.AppsFlyerLib;
import com.mobgame.api.SaveEventClientTask;
import com.mobgame.component.GameConfigManager;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.TimeUtils;
import com.mobgame.utils.Utils;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class EventClientManager {
    private static EventClientManager INSTANCE;
    private static final String TAG;
    public static final String SAVE_EVENT_START_SESSION = "start";
    public static final String SAVE_EVENT_END_SESSION = "end";
    public static final String SAVE_EVENT_NORMAL = "normal";
    private static String userId;
    private static Date startSessionTime;
    private String mobgameAppkey;
    private String mobgameToken;
    private String mobgameOs;
    private String mobgameResolution;
    private String mobgameAppVersion;
    private String mobgameAppVersionCode;
    private String mobgameNetwork;
    private String mobgameDevice;
    private String mobgameSdkVersion;
    private String mobgameRoleId;
    private String mobgameAreaId;
    private String mobgameRoleName;
    private String mobgameAreaName;
    private String mobgameAdvertisingId;
    private String mobgameOrientation;
    private String mobgameDistributor;
    private String mobgameLang;
    private String mobgameAppsflyerId;

    public EventClientManager(Context context) {
        try {
            Log.d((String)TAG, (String)("initHeaderRequest: DeviceUtils.getDevice():" + DeviceUtils.getDevice()));
            this.setMobgameDevice(DeviceUtils.getDevice());
            Log.d((String)TAG, (String)("initHeaderRequest: DeviceUtils.getOSInfo():" + DeviceUtils.getOSInfo()));
            this.setMobgameOs(DeviceUtils.getOSInfo());
            Log.d((String)TAG, (String)("initHeaderRequest: DeviceUtils.getResolution(context):" + DeviceUtils.getResolution(context)));
            this.setMobgameResolution(DeviceUtils.getResolution(context));
            Log.d((String)TAG, (String)("initHeaderRequest: Utils.getSDKVersion(context):" + Utils.getSDKVersion(context)));
            this.setMobgameSdkVersion(Utils.getSDKVersion(context));
            Log.d((String)TAG, (String)("initHeaderRequest: GameConfigManager.getInstance().getAppKey():" + GameConfigManager.getInstance().getAppKey(context)));
            this.setMobgameAppkey(GameConfigManager.getInstance().getAppKey(context));
            Log.d((String)TAG, (String)("initHeaderRequest: Utils.getGameVersion(context):" + Utils.getGameVersion(context)));
            this.setMobgameAppVersion(Utils.getGameVersion(context));
            Log.d((String)TAG, (String)("initHeaderRequest: Utils.getGameVersionCode(context):" + Utils.getGameVersionCode(context)));
            this.setMobgameAppVersionCode(Utils.getGameVersionCode(context));
            Log.d((String)TAG, (String)("initHeaderRequest: Utils.getNetwork(context):" + Utils.getNetwork(context)));
            this.setMobgameNetwork(Utils.getNetwork(context));
            Log.d((String)TAG, (String)("initHeaderRequest: DeviceUtils.getScreenOrientation(context):" + DeviceUtils.getScreenOrientation(context)));
            this.setMobgameOrientation(DeviceUtils.getScreenOrientation(context) + "");
            Log.d((String)TAG, (String)("initHeaderRequest: Utils.getReferrer(context):" + Utils.getReferrer(context)));
            this.setMobgameRefererDistributor(Utils.getReferrer(context));
            Log.d((String)TAG, (String)("initHeaderRequest: DeviceUtils.getLanguage():" + DeviceUtils.getLanguage()));
            this.setMobgameLang(DeviceUtils.getLanguage());
            Log.d((String)TAG, (String)("initHeaderRequest: DeviceUtils.getAdvertisingID(context):" + DeviceUtils.getAdvertisingID(context)));
            this.setMobgameAdvertisingId(DeviceUtils.getAdvertisingID(context));
            Log.d((String)TAG, (String)("EventClientManager: GameConfigManager.getInstance().getAccessToken()" + Preference.getString(context, "shared_pref_maccess_token")));
            this.setMobgameToken(Preference.getString(context, "shared_pref_maccess_token"));
            Log.d((String)TAG, (String)("initHeaderRequest: AppsFlyerLib.getInstance().getAppsFlyerUID(context):" + AppsFlyerLib.getInstance().getAppsFlyerUID(context)));
            this.setMobgameAppsflyerId(AppsFlyerLib.getInstance().getAppsFlyerUID(context));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveEventClient(String type, String eventName, HashMap<String, Object> eventValue) {
        String data = "{}";
        JSONObject objData = new JSONObject();
        try {
            long timeStamp;
            objData.put("user_id", (Object)userId);
            JSONObject objSession = new JSONObject();
            JSONObject objSubSession = new JSONObject();
            String eventType = "";
            if (type.equalsIgnoreCase(SAVE_EVENT_START_SESSION)) {
                EventClientManager.setStartSessionTime(new Date());
                eventType = "_session.start";
                timeStamp = startSessionTime.getTime() / 1000L;
                objSubSession.put("id", (Object)("" + userId + timeStamp));
                objSubSession.put("startTimestamp", (Object)TimeUtils.getTimeIso(startSessionTime));
            } else if (type.equalsIgnoreCase(SAVE_EVENT_END_SESSION)) {
                eventType = "_session.stop";
                timeStamp = new Date().getTime() / 1000L;
                Date endSessionTime = new Date();
                long startTime = startSessionTime.getTime() / 1000L;
                objSubSession.put("id", (Object)("" + userId + timeStamp));
                objSubSession.put("startTimestamp", (Object)TimeUtils.getTimeIso(startSessionTime));
                objSubSession.put("stopTimestamp", (Object)TimeUtils.getTimeIso(endSessionTime));
                objSubSession.put("duration", (Object)("" + (timeStamp - startTime)));
            }
            objSession.put("eventType", (Object)eventType);
            objSession.put("timestamp", (Object)TimeUtils.getTimeIso(new Date()));
            objSession.put("session", (Object)objSubSession);
            objData.put("session", (Object)objSession);
            JSONObject objEvent = new JSONObject();
            if (eventName != null && !eventName.isEmpty()) {
                objEvent.put("eventName", (Object)eventName);
                if (eventValue != null) {
                    objEvent.put("attributes", (Object)new JSONObject(eventValue));
                }
            }
            objData.put("event", (Object)objEvent);
            objData.put("header", (Object)new JSONObject(this.toStringJsonRequestHeader()));
            data = objData.toString();
            Log.d((String)TAG, (String)("saveEventClient: data:" + data));
            if (this.getMobgameAppkey() != null && !this.getMobgameAppkey().isEmpty()) {
                new SaveEventClientTask(data).execute(new Void[0]);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static EventClientManager getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new EventClientManager(context);
        }
        return INSTANCE;
    }

    public String toStringJsonRequestHeader() {
        JSONObject jsonObject = new JSONObject();
        Locale defaultLocale = Resources.getSystem().getConfiguration().locale;
        try {
            jsonObject.put("mobgame-appkey", (Object)this.getMobgameAppkey());
            jsonObject.put("mobgame-token", (Object)this.getMobgameToken());
            jsonObject.put("mobgame-os", (Object)this.getMobgameOs());
            jsonObject.put("mobgame-resolution", (Object)this.getMobgameResolution());
            jsonObject.put("mobgame-app-version", (Object)this.getMobgameAppVersion());
            jsonObject.put("mobgame-app-version-code", (Object)this.getMobgameAppVersionCode());
            jsonObject.put("mobgame-network", (Object)this.getMobgameNetwork());
            jsonObject.put("mobgame-device", (Object)this.getMobgameDevice());
            jsonObject.put("mobgame-sdk-version", (Object)this.getMobgameSdkVersion());
            jsonObject.put("mobgame-role-id", (Object)this.getMobgameRoleId());
            jsonObject.put("mobgame-area-id", (Object)this.getMobgameAreaId());
            jsonObject.put("mobgame-role-name", (Object)this.getMobgameRoleName());
            jsonObject.put("mobgame-area-name", (Object)this.getMobgameAreaName());
            jsonObject.put("mobgame-advertising-id", (Object)this.getMobgameAdvertisingId());
            jsonObject.put("mobgame-orientation", (Object)this.getMobgameOrientation());
            jsonObject.put("mobgame-distributor", (Object)this.getMobgameRefererDistributor());
            jsonObject.put("mobgame_lang", (Object)this.getMobgameLang());
            jsonObject.put("mobgame-appsflyer-id", (Object)this.getMobgameAppsflyerId());
            return jsonObject.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getMobgameAppkey() {
        return this.mobgameAppkey;
    }

    public void setMobgameAppkey(String mobgameAppkey) {
        this.mobgameAppkey = mobgameAppkey;
    }

    public String getMobgameToken() {
        return this.mobgameToken;
    }

    public void setMobgameToken(String mobgameToken) {
        this.mobgameToken = mobgameToken;
    }

    public String getMobgameOs() {
        return this.mobgameOs;
    }

    public void setMobgameOs(String mobgameOs) {
        this.mobgameOs = mobgameOs;
    }

    public String getMobgameResolution() {
        return this.mobgameResolution;
    }

    public void setMobgameResolution(String mobgameResolution) {
        this.mobgameResolution = mobgameResolution;
    }

    public String getMobgameAppVersion() {
        return this.mobgameAppVersion;
    }

    public void setMobgameAppVersion(String mobgameAppVersion) {
        this.mobgameAppVersion = mobgameAppVersion;
    }

    public String getMobgameAppVersionCode() {
        return this.mobgameAppVersionCode;
    }

    public void setMobgameAppVersionCode(String mobgameAppVersionCode) {
        this.mobgameAppVersionCode = mobgameAppVersionCode;
    }

    public String getMobgameNetwork() {
        return this.mobgameNetwork;
    }

    public void setMobgameNetwork(String mobgameNetwork) {
        this.mobgameNetwork = mobgameNetwork;
    }

    public String getMobgameDevice() {
        return this.mobgameDevice;
    }

    public void setMobgameDevice(String mobgameDevice) {
        this.mobgameDevice = mobgameDevice;
    }

    public String getMobgameSdkVersion() {
        return this.mobgameSdkVersion;
    }

    public void setMobgameSdkVersion(String mobgameSdkVersion) {
        this.mobgameSdkVersion = mobgameSdkVersion;
    }

    public String getMobgameRoleId() {
        return this.mobgameRoleId;
    }

    public void setMobgameRoleId(String mobgameRoleId) {
        this.mobgameRoleId = mobgameRoleId;
    }

    public String getMobgameAreaId() {
        return this.mobgameAreaId;
    }

    public void setMobgameAreaId(String mobgameAreaId) {
        this.mobgameAreaId = mobgameAreaId;
    }

    public String getMobgameRoleName() {
        return this.mobgameRoleName;
    }

    public void setMobgameRoleName(String mobgameRoleName) {
        this.mobgameRoleName = mobgameRoleName;
    }

    public String getMobgameAreaName() {
        return this.mobgameAreaName;
    }

    public void setMobgameAreaName(String mobgameAreaName) {
        this.mobgameAreaName = mobgameAreaName;
    }

    public String getMobgameAdvertisingId() {
        return this.mobgameAdvertisingId;
    }

    public void setMobgameAdvertisingId(String mobgameAdvertisingId) {
        this.mobgameAdvertisingId = mobgameAdvertisingId;
    }

    public String getMobgameOrientation() {
        return this.mobgameOrientation;
    }

    public void setMobgameOrientation(String mobgameOrientation) {
        this.mobgameOrientation = mobgameOrientation;
    }

    public String getMobgameRefererDistributor() {
        return this.mobgameDistributor;
    }

    public void setMobgameRefererDistributor(String mobgameDistributor) {
        this.mobgameDistributor = mobgameDistributor;
    }

    public String getMobgameLang() {
        return this.mobgameLang;
    }

    public void setMobgameLang(String mobgameLang) {
        this.mobgameLang = mobgameLang;
    }

    public String getMobgameAppsflyerId() {
        return this.mobgameAppsflyerId;
    }

    public void setMobgameAppsflyerId(String mobgameAppsflyerId) {
        this.mobgameAppsflyerId = mobgameAppsflyerId;
    }

    public static String getUserId() {
        return userId;
    }

    public static void setUserId(String userId) {
        EventClientManager.userId = userId;
    }

    public static Date getStartSessionTime() {
        return startSessionTime;
    }

    public static void setStartSessionTime(Date startSessionTime) {
        EventClientManager.startSessionTime = startSessionTime;
    }

    static {
        TAG = EventClientManager.class.getSimpleName();
    }
}

