package com.mobgame.api;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.mobgame.MobGameSDK;
import com.mobgame.model.EncodedResponse;
import com.mobgame.model.MItemPayment;
import com.mobgame.utils.EncryptionUtils;

import java.util.ArrayList;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by khaitran on 5/26/17.
 */

public class GetPayItemTask extends AsyncTask<Void , Void , Void>{
    private Listener callback;
    private Activity mActivity;

    public GetPayItemTask(Activity activity , Listener callback) {
        this.callback = callback;
        this.mActivity = activity;
    }

    @Override
    protected Void doInBackground(Void... params) {
        Context c = MobGameSDK.getApplicationContext();
        String sign = EncryptionUtils.getSignedString(c);
        RestfulApi api = RestfulApi.getInstance();
        Call<EncodedResponse> call = api.getPayItem(sign);
        call.enqueue(new Callback<EncodedResponse>() {
            @Override
            public void onResponse(Call<EncodedResponse> call, Response<EncodedResponse> response) {
                try {
                    Log.d("TAG" , "response :" + response.body() );
                    if(response.isSuccessful()){
                        String responseBody = response.body().getDecodedData();
                        ArrayList<MItemPayment> listItemPay = new ArrayList<MItemPayment>();
                        listItemPay = MItemPayment.parse(responseBody);
                        listItemPay = MItemPayment.parse(responseBody);
                        if (listItemPay != null)
                            for (int i = 0; i < listItemPay.size(); i++) {
                                RequestOptions fitOptions = new RequestOptions().centerCrop().diskCacheStrategy(DiskCacheStrategy.ALL);
                                Glide.with(mActivity).asBitmap()
                                        .load(listItemPay.get(i)
                                        .getUrlPng())
                                        .apply(fitOptions)
                                        .into(100 , 100);
                            }
                        if(callback != null){
                            callback.onSuccess(listItemPay);
                        }
                    }else{
                        if(callback != null){
                            callback.onFailure(new Exception());
                        }
                    }
                }catch (Exception e){
                    if(callback != null){
                        callback.onFailure(e);
                    }
                }
            }

            @Override
            public void onFailure(Call<EncodedResponse> call, Throwable t) {
                if(callback != null){
                    callback.onFailure(t);
                }
            }
        });

        return null;
    }

    public interface Listener{
        public void onSuccess(ArrayList<MItemPayment> listItem);
        public void onFailure(Throwable t);
    }
}