package com.mobgame;

import android.Manifest;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.AppOpsManager;
import android.app.Application.ActivityLifecycleCallbacks;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.BroadcastReceiver;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.provider.Settings;
import android.support.v4.content.LocalBroadcastManager;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Animation.AnimationListener;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import android.webkit.CookieSyncManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.appsflyer.AFInAppEventParameterName;
import com.appsflyer.AFInAppEventType;
import com.appsflyer.AppsFlyerLib;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.gson.Gson;
import com.mobgame.ads.AdListener;
import com.mobgame.ads.AdsManager;
import com.mobgame.ads.OfferWallFragment;
import com.mobgame.ads.PopupAd;
import com.mobgame.ads.utils.LogUtils;
import com.mobgame.api.GetInfoAfterAuthenTask;
import com.mobgame.api.GetInfoBeforeAuthenTask;
import com.mobgame.api.GetIngameNotificationTask;
import com.mobgame.api.GetPayItemTask;
import com.mobgame.api.LogoutTask;
import com.mobgame.api.SaveCharacterTask;
import com.mobgame.component.EventClientManager;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAuthManager;
import com.mobgame.gui.DialogInGameFragment;
import com.mobgame.gui.MobGameActivity;
import com.mobgame.gui.MobTimerTask;
import com.mobgame.gui.dialog.MobGameConfirmDialog;
import com.mobgame.gui.dialog.MobGameConfirmDialogWithPopup;
import com.mobgame.gui.dialog.MobGameDialogWebviewFragment;
import com.mobgame.gui.dialog.MobGameHaveBackButtonFragment;
import com.mobgame.gui.dialog.MobGamePayDialogFragment;
import com.mobgame.gui.dialog.MobGameSocialDialogFragment;
import com.mobgame.js.CmdDashboard;
import com.mobgame.js.CmdPayment;
import com.mobgame.model.Game;
import com.mobgame.model.IngameNoti;
import com.mobgame.model.MItemPayment;
import com.mobgame.model.MUrl;
import com.mobgame.model.NtfModel;
import com.mobgame.model.UserInfo;
import com.mobgame.model.giftimage.GifData;
import com.mobgame.notification.MobFirebaseInstanceIDService;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.GifHelper;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.PermissionUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ExecutionException;

@SuppressWarnings("deprecation")
public class MobGameSDK {

    private static final String TAG = MobGameSDK.class.getSimpleName();
    private static MobGameSDK INSTANCE;
    private static final int OVERLAY_PERMISSION_REQ_CODE = 222;

    public static Activity activity;
    public static Activity currentActivity;
    public static Context applicationContext;

    private SensorManager sensorManager;
    private Sensor accelerometerSensor;
    private boolean accelerometerPresent;
    private MobGameListener mListener;

    private boolean clickLogout = false;
    private boolean isLogout = false;
    private PopupAd popupAd;
    //	private OfferWall offerWall;
    private OfferWallFragment offerWall;
    private boolean canDraw;
    private AppOpsManager.OnOpChangedListener onOpChangedListener = null;

    private static boolean shouldShowFloatButton;
    private static boolean shouldShowPopup;
    // private int countViberate = 0;

    private ArrayList<String> queuePopups = new ArrayList<String>();
    private static final String POPUP_HELLO = "popup_hello";
    private static final String POPUP_NTFS = "popup_ntfs";
    private static final String POPUP_LINK = "pop_link";
    private static final String POPUP_FLOAT_BUTTON = "popup_float_button";
    private static final String POPUP_ADS = "popup_ads";
    private static final long TIMEOUT_DISMISS_FLOAT_BUTTON = 24 * 60 * 60 * 1000; // 24
    // hours
    private int menuId;
    private boolean isShowAds = true;
    private boolean isShowingLogoutPopup = false;
    private boolean saveRead = false;

    private float mAccelCurrent = SensorManager.GRAVITY_EARTH;
    private float mAccel;

    private int scrollAnimIndex = 0;
    private int scrollAnimRepeatCount = 0;
    private ArrayList<TextView> textViews;
    private boolean isScrollingText = false;
    private static View viewNotice;
    private ObjectAnimator scrollTextAnimation;
    private FrameLayout scrollTextLayout;
    private MobTimerTask scrollTextTimerTask;
    private Timer scrollTextTimer;
    private static final long PERIOD_TO_SEND_REQUEST_GET_NOTI = 600000; //10 minitues 600000 milisec
    private static final long PERIOD_BETWEEN_TWO_NOTIFICATION = 5000;
    private long startPointOfOneScrollingTextNow = 0;
    private long durationOfOneScrollingTextNow = 0;

    //    private boolean isShaking = false;
    private SensorEventListener accelerometerListener = new SensorEventListener() {


        @Override
        public void onAccuracyChanged(Sensor event, int accuracy) {
        }

        @Override
        public void onSensorChanged(SensorEvent event) {
            try {

                // Shake detection
                float x = event.values[0];
                float y = event.values[1];
                float z = event.values[2];
                float mAccelLast = mAccelCurrent;
                mAccelCurrent = (float) Math.sqrt(x * x + y * y + z * z);
                float delta = mAccelCurrent - mAccelLast;
                mAccel = mAccel * 0.9f + delta;
                if (mAccel > 3f
                        && !Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_CONFIRM_DIALOG_HIDE_FLOAT, false)
                        && !Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_DASHBOARD, false)) {
                    Log.d(TAG, "VAO SENSOR");
                    Preference.remove(activity, Constants.SHARED_PREF_FLOAT_BUTTON_DISMISS_TIME);
                    Preference.remove(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON);
                    Preference.remove(activity, Constants.SHARED_PREF_SHOW_CONFIRM_DIALOG_HIDE_FLOAT);
                    Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);

                    Intent intent = new Intent(Constants.INTENT_FILTER);
                    intent.putExtra("category", "show_float_button");
                    LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private boolean loginProcessDone = false;

    private MobGameSDK() {
    }

    public static MobGameSDK getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MobGameSDK();
        }
        return INSTANCE;
    }

    @SuppressLint("MissingPermission")
    public void init(Activity activity, String appkey) {
        Log.i(TAG, "MobGameSDK");
        MobGameSDK.activity = activity;
        applicationContext = activity.getApplicationContext();
        Preference.save(activity, Constants.SHARED_PREF_MAIN_ACTIVITY,
                activity.getClass().getName());

        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.M){
            canDraw = Settings.canDrawOverlays(activity);
        }

        if (mListener == null) {
            setMobGameListener(new MobGameListener() {

                @Override
                public void onPaySuccessful(String userId, String orderId,
                                            String orderProduct, String orderInfo,
                                            String orderTime, String platformPrice,
                                            String gamePrice, String state, String game_role_id,
                                            String game_area_id, String is_sandbox) {
                }

                @Override
                public void onLoginSuccessful(String accountID,
                                              String accessToken) {
                    try {
                        AppsFlyerLib.getInstance().setCustomerUserId(GameConfigManager.getInstance().getUserInfo().getUser().getUserId());
                        Log.d(TAG, "onLoginSuccessful: appsflyer UID: " + AppsFlyerLib.getInstance().getAppsFlyerUID(getApplicationContext()));

                        runTimerCheckNotificationInGame();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onError(int errorCode, String message) {
                }

                @Override
                public void onLoginFormClose() {

                }

                @Override
                public void onLogoutSucessful(String roleId) {

                }
            });
        }

        try {
            GameConfigManager.getInstance().setAppKey(activity, appkey);
            EventClientManager.getInstance(activity).setMobgameAppkey(appkey);
            activity.getApplication().unregisterActivityLifecycleCallbacks(mActivityLifecycleCallbacks);
            activity.getApplication().registerActivityLifecycleCallbacks(mActivityLifecycleCallbacks);
            activity.getApplication().unregisterComponentCallbacks(mComponentCallbacks);
            activity.getApplication().registerComponentCallbacks(mComponentCallbacks);

            // activity.onCreate()
            LocalBroadcastManager.getInstance(activity.getApplicationContext())
                    .registerReceiver(mGlobalMessageReceiver, new IntentFilter(Constants.INTENT_FILTER));

            CookieSyncManager.createInstance(activity.getApplicationContext());

            sensorManager = (SensorManager) activity.getSystemService(Context.SENSOR_SERVICE);
            List<Sensor> sensorList = sensorManager.getSensorList(Sensor.TYPE_ACCELEROMETER);

            if (sensorList.size() > 0) {
                accelerometerPresent = true;
                accelerometerSensor = sensorList.get(0);
            } else {
                accelerometerPresent = false;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);
        loadPaymentItems();

    }

    public void loadPaymentItems() {
        new GetPayItemTask(activity, new GetPayItemTask.Listener() {
            @Override
            public void onFailure(Throwable t) {

            }

            @Override
            public void onSuccess(ArrayList<MItemPayment> listItem) {
                // TODO Auto-generated method stub

            }
        }).execute();
    }

    public static Context getApplicationContext() {
        if (activity == null && applicationContext != null) {
            return applicationContext;
        }
        if (activity == null && currentActivity != null) {
            return currentActivity.getApplicationContext();
        }
        return activity.getApplicationContext();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Log.i(TAG, "onActivityResult:requestCode=" + requestCode
                + ";resultCode=" + resultCode);
        try {
            switch (requestCode) {
                case Constants.REQUEST_CODE_LOGIN_PLAY_SERVICES:
                    GoogleAuthManager.getInstance().onActivityResult(requestCode, resultCode, data);
                    break;
                case Constants.REQUEST_CODE_FACEBOOK_LOGIN:
                case Constants.REQUEST_CODE_FACEBOOK_SHARE:
                case Constants.REQUEST_CODE_FACEBOOK_INVITE:
                    FacebookManager.getInstance().onActivityResult(requestCode,
                            resultCode, data);
                    break;
                case Constants.REQUEST_CODE_FACEBOOK_INVITE_GAME:
                    FacebookManager.getInstance().onActivityResult(requestCode,
                            resultCode, data);
                    break;
                case Constants.REQUEST_CODE_GOOGLE_IN_APP_BILLING:
                    // case Constants.REQUEST_CODE_PAYPAL_PAYMENT:
                    // case Constants.REQUEST_CODE_PAYPAL_FUTURE_PAYMENT:
                    // case Constants.REQUEST_CODE_PAYPAL_PROFILE_SHARING:
                    CmdPayment.getInstance().handleResult(activity, requestCode,
                            resultCode, data);
                    break;
                case Constants.REQUEST_OVERLAY_PERMISSION:
                    requestOverlayPermission(activity);
                    break;
                case Constants.REQUEST_CODE_PICKER:
                    CmdDashboard.getInstance().handleResult(activity, requestCode,
                            resultCode, data);
                    break;
                default:
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @TargetApi(19)
    public void onWindowFocusChanged(boolean hasFocus) {
        try {
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.KITKAT) {
                if (DeviceUtils.hasHardwareButtons()) {
                    if (hasFocus) {
                        activity.getWindow()
                                .getDecorView()
                                .setSystemUiVisibility(
                                        View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                                                | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                                                | View.SYSTEM_UI_FLAG_FULLSCREEN
                                                | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
                    }
                } else {
                    if (hasFocus) {
                        activity.getWindow()
                                .getDecorView()
                                .setSystemUiVisibility(
                                        View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                                                | View.SYSTEM_UI_FLAG_FULLSCREEN
                                                | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
                    }
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void login() {
        try {
            Log.i(TAG, "login");
            if (GameConfigManager.getInstance().getGameConfig() == null) {
                getGameInfoRemote();
                return;
            }
            if (isLoggedIn()) {
                return;
            }
            loginProcessDone = false;
            shouldShowFloatButton = false;
            MobGameHelper.hideFloatButton();
            if (!isLoggedIn() && activity != null) {
                Intent intent = new Intent(activity, MobGameActivity.class);
                intent.putExtra(MobGameActivity.KEY_DATA, "{'action':'" + Constants.URL_USER + "'}");
                activity.startActivity(intent);
                try {
                    FunTrackingUtil.getInstance().trackOpenFormLogin(activity);
                    long timeOpenFormPayment = System.currentTimeMillis();
                    long startTime = Preference.getLong(activity, Constants.START_SESSION, 0);
                    long deltaTime = timeOpenFormPayment - startTime;
                    if(!isLogout) {
                        FunTrackingUtil.getInstance().trackLoadTime(activity, deltaTime);
                    }
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            EventClientManager.getInstance(currentActivity.getApplicationContext()).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, FunTrackingUtil.TRACK_FORM_LOGIN_OPENED, null);
                        }
                    }).start();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                if (offerWall.isShowing()) offerWall.close();
            } else {
                handleLogin();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void logout(boolean forceLogout) {
        loginProcessDone = true;
        logout();
    }

    boolean isLogoutClick = false;
    public void logout() {
        try {
            if(!loginProcessDone){
                Log.d(TAG, "logout: login not done");
                return;
            }
            Log.i(TAG, "logout");
            new LogoutTask(new LogoutTask.OnLogoutSuccessfulListener() {
                @Override
                public void onLogoutSuccessfull(String roleId) {
                    if (mListener != null) {
                        try {
                            activity.runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    mListener.onLogoutSucessful(roleId);
                                }
                            });
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).execute();
            MobGameHelper.hideFloatButton();
            queuePopups.clear();
            Preference.remove(activity, Constants.SHARED_PREF_FLOAT_BUTTON_DISMISS_TIME);
            Preference.remove(currentActivity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON);
            FunTrackingUtil.getInstance().trackingLogout(currentActivity);
            isLogout = true;
            new Thread(new Runnable() {
                @Override
                public void run() {
                    EventClientManager.getInstance(activity).saveEventClient(EventClientManager.SAVE_EVENT_END_SESSION, FunTrackingUtil.TRACK_EVENT_LOGOUT, null);
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showDialogOnPressBack() {
        try {
            boolean flag = false;
            String url = "", urlBanner = "", urlPlayStore = "";
            try {
                Game.LogoutBt mLogoutBt = GameConfigManager.getInstance().getGameConfig().getLogoutBt();
                url = mLogoutBt.getUrlBeforeLogout();
                urlBanner = mLogoutBt.getUrlBannerImage();
                urlPlayStore = GameConfigManager.getInstance().getGameConfig().getAppstoreLink();
                if (url.isEmpty()) {
                    url = urlPlayStore;
                }
                flag = mLogoutBt.isFlag();
            } catch (Exception e) {
                e.printStackTrace();
            }
            MobGameHelper.hideFloatButton();
            if (flag) {
                MobGameConfirmDialogWithPopup dialogWithPopup = new MobGameConfirmDialogWithPopup(activity, urlBanner, url,
                        Res.string(activity, R.string.message_exit),
                        activity.getResources().getString(R.string.ok),
                        Res.string(activity, R.string.cancel), new MobGameConfirmDialogWithPopup.EventListener() {
                    @Override
                    public void onCancelClick(View v) {
                        Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);
                        Intent intent = new Intent(Constants.INTENT_FILTER);
                        intent.putExtra("category", "float_button");
                        LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    }

                    @Override
                    public void onConfirmClick(View v) {
                        long endSession = System.currentTimeMillis();
                        long startSession = Preference.getLong(activity, Constants.START_SESSION, 0);
                        Log.d(TAG , "onDestroy");
                        MobGameSDK.getInstance().endSession(endSession - startSession);
                        Preference.remove(activity , Constants.START_SESSION);

                        Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);
                        System.gc();
                        System.exit(0);

                    }
                });
                dialogWithPopup.show(activity.getFragmentManager(), "tag_fragment_confirm");
            } else {
                DialogFragment dialog = new MobGameConfirmDialog(activity,
                        Res.string(activity, R.string.message_exit),
                        activity.getString(R.string.ok),
                        Res.string(activity, R.string.cancel)
                        , new MobGameConfirmDialog.EventListener() {

                    @Override
                    public void onConfirmClick(View v) {
                        long endSession = System.currentTimeMillis();
                        long startSession = Preference.getLong(activity, Constants.START_SESSION, 0);
                        Log.d(TAG , "onDestroy");
                        MobGameSDK.getInstance().endSession(endSession - startSession);
                        Preference.remove(activity , Constants.START_SESSION);

                        System.gc();
                        System.exit(0);
                        Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);

                    }

                    @Override
                    public void onCancelClick(View v) {
                        Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);
                        Intent intent = new Intent(Constants.INTENT_FILTER);
                        intent.putExtra("category", "float_button");
                        LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    }

                });
                dialog.show(activity.getFragmentManager(), "tag_fragment_confirm");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void payment() {
        payment(null);
    }

    public void payment(String state) {
        try {
            Log.i(TAG, "payment:" + state);
            if (MobGameHelper.isShowingDashboard()) {
                Log.d(TAG, "payment: MobGameHelper.isShowingDashboard()=true, not allow show payment");
                return;
            }
            if (GameConfigManager.getInstance().getGameConfig() == null) {
                getGameInfoRemote();
                return;
            }
            if (isShowingHello) {
                Log.d(TAG, "showingHello");
                return;
            }
            if (!isLoggedIn()) {
                Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT).show();
            } else {
                MobGameHelper.hideFloatButton();
                String url = Constants.URL_PAYMENT;
                if (!TextUtils.isEmpty(state)) {
                    url += "?state=" + state;
                }
                Log.d(TAG, url);
                Intent intent = new Intent(activity, MobGameActivity.class);
                intent.putExtra(MobGameActivity.KEY_DATA, "[{'action':'" + url + "'}]");
                activity.startActivity(intent);
                FunTrackingUtil.getInstance().trackOpenFormPayment(currentActivity);
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        EventClientManager.getInstance(activity).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, FunTrackingUtil.TRACK_PAYMENT_OPEN, null);
                    }
                }).start();
                if (offerWall.isShowing()) offerWall.close();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paymentNative() {
        paymentNative(null);
    }

    public void paymentNative(String state) {
        Log.i(TAG, "payment:" + state);
        if (GameConfigManager.getInstance().getGameConfig() == null) {
            getGameInfoRemote();
            return;
        }
        if (!isLoggedIn()) {
            try {
                Toast.makeText(activity, "You must login first",
                        Toast.LENGTH_SHORT).show();
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                MobGameHelper.hideFloatButton();
                MobGameHelper.hideNotiFloatButton();
                FragmentManager fm = activity.getFragmentManager();
                MobGamePayDialogFragment dialogFragment = new MobGamePayDialogFragment();
                dialogFragment.show(fm, "dialog_payment");
                isShowSocialDialog = true;
                dialogFragment
                        .setOnDismissListener(new DialogInterface.OnDismissListener() {
                            @Override
                            public void onDismiss(DialogInterface dialog) {
                                Log.d(TAG,
                                        "alo alo 2 : "
                                                + Utils.isDashboardEnabled(activity));
                                boolean isNotHideFloatButton = Preference
                                        .getBoolean(
                                                activity,
                                                Constants.SHARED_PREF_HIDE_FLOAT_BUTTON,
                                                true);
                                boolean isEnableDashboard = Utils
                                        .isDashboardEnabled(activity);
                                Log.d(TAG, "isNotHideFloatButton: "
                                        + isNotHideFloatButton);
                                Log.d(TAG, "isEnableDashboard: "
                                        + isEnableDashboard);
                                isShowSocialDialog = false;
                                if (!isShowSocialDialog && isNotHideFloatButton
                                        && isEnableDashboard) {
                                    MobGameHelper.showFloatButton();
                                }
                                boolean isShowLogo = GameConfigManager.getInstance().getGameConfig().getEx().isShowLogo();
                                if (!isShowSocialDialog && isShowLogo)
                                    MobGameHelper.showNotiFloatButton();
                            }
                        });
            } catch (Exception e) {
                e.printStackTrace();
            }

        }

    }

    public String[] funShow() {
        String[] funShow = new String[2];
        try {
            UserInfo.User users = GameConfigManager.getInstance().getUserInfo().getUser();
            if (users.getVip() != null) {
                funShow[0] = users.getVip();
            }
            if (users.getVipImage() != null) {
                funShow[1] = users.getVipImage();
            } else {
                funShow[0] = "";
                funShow[1] = "";
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return funShow;
    }

    public void topRankUrl(String url) {
        try {
            if (MobGameHelper.isShowingDashboard()) {
                Log.d(TAG, "payment: MobGameHelper.isShowingDashboard()=true, not allow show toprank");
                return;
            }
            if (GameConfigManager.getInstance().getGameConfig() == null) {
                getGameInfoRemote();
                return;
            }
            if (isShowingHello) {
                Log.d(TAG, "showingHello");
                return;
            }
            if (!isLoggedIn()) {
                Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT).show();
            } else {
                showFragmentHaveBackButton(url, false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void customUrl(String url) {
        try {
            if (MobGameHelper.isShowingDashboard()) {
                Log.d(TAG, "payment: MobGameHelper.isShowingDashboard()=true, not allow show customUrl social funvip");
                return;
            }
            if (GameConfigManager.getInstance().getGameConfig() == null) {
                getGameInfoRemote();
                return;
            }
            if (!isLoggedIn()) {
                Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT).show();
            } else {
                showFragment(url, false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean isShowSocialDialog = false;

    private void showFragment(String url, boolean isEncrypted) {
        try {
            if (isShowingHello) {
                Log.d(TAG, "showingHello");
                return;
            }
            if (url != null && !url.equals("")) {
                FragmentManager fm = activity.getFragmentManager();
                MobGameSocialDialogFragment fr = (MobGameSocialDialogFragment) fm
                        .findFragmentByTag(Constants.TAG_FRAGMENT);
                MobGameHelper.hideFloatButton();

                isShowSocialDialog = true;
                if (fr == null) {
                    fr = new MobGameSocialDialogFragment(new MUrl(url, isEncrypted));
                    fr.setOnDismissListener(new DialogInterface.OnDismissListener() {

                        @Override
                        public void onDismiss(DialogInterface dialog) {
                            if (isShowSocialDialog && Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true)
                                    && Utils.isDashboardEnabled(activity)) {
                                MobGameHelper.showFloatButton();
                                Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);
                            }
                            isShowSocialDialog = false;
                        }
                    });
                    FragmentTransaction fragmentTransaction = fm.beginTransaction();
                    fragmentTransaction.add(fr, Constants.TAG_FRAGMENT);
                    // fragmentTransaction.commit();
                    fragmentTransaction.commitAllowingStateLoss();
                } else {
                    try {
                        fr.loadUrlWithMobHeaders(new MUrl(url, isEncrypted));
                    } catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                Log.d(TAG, "url null");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showFragmentHaveBackButton(String url, boolean isEncrypted) {
        try {
            if (url != null && !url.equals("")) {
                FragmentManager fm = activity.getFragmentManager();
                MobGameHaveBackButtonFragment fr = (MobGameHaveBackButtonFragment) fm
                        .findFragmentByTag(Constants.TAG_FRAGMENT2);
                MobGameHelper.hideFloatButton();

                isShowSocialDialog = true;
                if (fr == null) {
                    fr = new MobGameHaveBackButtonFragment(new MUrl(url, isEncrypted));
                    fr.setOnDismissListener(new DialogInterface.OnDismissListener() {

                        @Override
                        public void onDismiss(DialogInterface dialog) {
                            if (isShowSocialDialog
                                    && Preference
                                    .getBoolean(
                                            activity,
                                            Constants.SHARED_PREF_HIDE_FLOAT_BUTTON,
                                            true)
                                    && Utils.isDashboardEnabled(activity)) {
                                MobGameHelper.showFloatButton();
                                Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);
                            }
                            isShowSocialDialog = false;
                        }
                    });
                    FragmentTransaction fragmentTransaction = fm.beginTransaction();
                    fragmentTransaction.add(fr, Constants.TAG_FRAGMENT);
                    // fragmentTransaction.commit();
                    fragmentTransaction.commitAllowingStateLoss();
                } else {
                    try {
                        fr.loadUrlWithMobHeaders(new MUrl(url, isEncrypted));
                    } catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                Log.d(TAG, "url null");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeFormLogin() {
        if (mListener != null)
            mListener.onLoginFormClose();
        close();
    }

    public void close() {
        close(true);
    }

    private void close(boolean check) {
        try {
            Intent i = new Intent(Constants.INTENT_FILTER);
            i.putExtra("category", "dashboard_close");
            LocalBroadcastManager.getInstance(activity).sendBroadcast(i);

            queuePopups.add(POPUP_FLOAT_BUTTON);

            if (check) {
                showPopup();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUserConfig(String mAreaId, String mAreaName, String mRoleId, String mRoleName) {
        try {
            Log.i(TAG, "setUserConfig: area_id=" + mAreaId + ";role_id=" + mRoleId
                    + ";area_name=" + mAreaName + ";role_name=" + mRoleName);
            (new SaveCharacterTask(mAreaId, mAreaName, mRoleId, mRoleName))
                    .execute();
            EventClientManager.getInstance(activity).setMobgameRoleId(mRoleId);
            EventClientManager.getInstance(activity).setMobgameRoleName(mRoleName);
            EventClientManager.getInstance(activity).setMobgameAreaId(mAreaId);
            EventClientManager.getInstance(activity).setMobgameAreaName(mAreaName);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isLoggedIn() {
        return !TextUtils.isEmpty(GameConfigManager.getInstance()
                .getAccessToken());
    }

    private void showOfferWall() {
        try {
            if (!Utils.isOnline(activity)) {
                Toast.makeText(activity,
                        activity.getResources().getString(R.string.error_network),
                        Toast.LENGTH_LONG).show();
                return;
            }
            if (offerWall == null) {
                offerWall = new OfferWallFragment(activity);
            }
            // hiendv(26/03/2017) : send extras to mobgameactivity to load offerwall
            if (GameConfigManager.getInstance().getGameConfig() == null) {
                getGameInfoRemote();
                return;
            }
            if (!Utils.isDashboardEnabled(activity)) {
                Log.i(TAG, "Dashboard is disabled");
                return;
            }
            if (!isLoggedIn()) {
                Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT)
                        .show();
            } else {
                // show dashboard(MobGameActivity).
                MobGameHelper.hideFloatButton();
                Intent intent = new Intent(activity, MobGameActivity.class);
                intent.putExtra(MobGameActivity.KEY_DATA, "offerwall");
                activity.startActivity(intent);

                if (offerWall.isShowing())
                    offerWall.close();
            }
            // TODO if (popupAd != null && popupAd.isShowing()) popupAd.close();
            offerWall.setAdListener(new AdListener() {

                @Override
                public void onAdOpened() {
                    MobGameHelper.hideFloatButton();
                }

                @Override
                public void onAdLoadedError(int errorCode, String msg) {
                }

                @Override
                public void onAdLoaded() {
                }

                @Override
                public void onAdClosed() {
                    Intent intent = new Intent(Constants.INTENT_FILTER);
                    intent.putExtra("category", "float_button");
                    LocalBroadcastManager.getInstance(activity).sendBroadcast(
                            intent);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleLogin() {
        try {
            (new GetInfoAfterAuthenTask(new GetInfoAfterAuthenTask.Listener() {

                @Override
                public void onSuccess(UserInfo userInfo) {
                    try {
                        GameConfigManager.getInstance().setUserInfo(userInfo);

                        if (userInfo != null) {

                            String accountId = GameConfigManager.getInstance().getUserInfo().getUser().getAccountId();
                            String accessToken = GameConfigManager.getInstance().getAccessToken();
                            mListener.onLoginSuccessful(
                                    accountId,
                                    accessToken);

                            String firebaseToken = FirebaseInstanceId.getInstance().getToken();
                            Log.d(TAG, "Firebase Token/regId: " + firebaseToken);
                            MobFirebaseInstanceIDService.getInstance().sendRegistrationToServer(firebaseToken);

                            if (userInfo.isEnableTimer()) {
                                FloatButtonTimerHelper.enableFloatButtonTimer(activity, userInfo.isEnableTimer());
                                FloatButtonTimerHelper.saveFloatButtonTimer(activity, new Gson().toJson(
                                        userInfo.getTimerData()));
                            }
                            clickLogout = false;
                            return;
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void forceLogout() {
                    clickLogout = false;
                    isLogout = true;
                    if (android.os.Build.VERSION.SDK_INT <= 19) {
                        CmdDashboard.getInstance().removeGC();
                    } else {
                        CmdDashboard.getInstance().hideGiftCode();
                    }
                    queuePopups.clear();
                    isLogoutClick = true;
                    new LogoutTask(new LogoutTask.OnLogoutSuccessfulListener() {
                        @Override
                        public void onLogoutSuccessfull(String roleId) {
                            if (mListener != null) {
                                try {
                                    activity.runOnUiThread(new Runnable() {
                                        @Override
                                        public void run() {
                                            mListener.onLogoutSucessful(roleId);
                                        }
                                    });
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }).execute();
                }

                @Override
                public void onFailure(Throwable t) {
                    logout(true);
                    mListener.onError(MobGameListener.ERROR_LOGIN,
                            "Unable to login to MobGame server");
                }

            })).execute();
        } catch (Exception e) {
            e.printStackTrace();
        }
        clickLogout = false;
        isLogout = false;
        CmdDashboard.getInstance().removeGC();
    }

    public void showPopup() {
        if (queuePopups == null || queuePopups.isEmpty()) {
            return;
        }
        if (isShowingHello) {
            return;
        }
        try {
            String popup = queuePopups.get(0);
            Log.d(TAG, "Show popup: " + popup);
            queuePopups.remove(0);
            if (POPUP_HELLO.equalsIgnoreCase(popup)) {
                if (countShowHello < 2)
                    showHello(activity, 4000, new Runnable() {
                        public void run() {
                            loginProcessDone = true;
                            showPopup();
                            Log.d(TAG, "showHello 3:");
                        }
                    });
            } else if (POPUP_LINK.equals(popup)) {
                //show Popup link
                saveRead = true;
                MobGameDialogWebviewFragment dialogWebviewFragment = new MobGameDialogWebviewFragment(activity, true, saveRead);
                dialogWebviewFragment.show(activity.getFragmentManager(), "dialog webview");
                Preference.save(activity, "save_ads", true);
            } else if (POPUP_NTFS.equalsIgnoreCase(popup)) {
                Log.d(TAG, "showHello 3 go here ");
                showPopup();
            } else if (POPUP_FLOAT_BUTTON.equalsIgnoreCase(popup)) {
                shouldShowFloatButton = true;
                Intent intent = new Intent(Constants.INTENT_FILTER);
                intent.putExtra("category", "float_button");
                LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                showPopup();

            } else if (POPUP_ADS.equalsIgnoreCase(popup)) {
                Log.d(TAG, "go inside POPUP_ADS");
                shouldShowFloatButton = true;
                if (popupAd == null) {
                    popupAd = new PopupAd(activity);
                    if (adStatus != StatusAd.AD_LOADING || adStatus != StatusAd.AD_OPENED) {
                        popupAd.loadAd();
                    }
                }
                new Handler().postDelayed(new Runnable() {

                    @Override
                    public void run() {
                        Log.d(TAG, "showPopup Ads");
                        if (!Utils.canDrawOverApp(activity)) {
                            queuePopups.add(POPUP_ADS);
                            return;
                        }
                        if (isLoggedIn() && adStatus == StatusAd.AD_LOADED) {
                            if (!offerWall.isShowing()) {
                                if (!isShowSocialDialog) {
                                    adStatus = StatusAd.AD_SHOWING;
                                    popupAd.show();
                                } else {
                                    queuePopups.add(POPUP_ADS);
                                }
                            } else {
                                queuePopups.add(POPUP_ADS);
                            }
                        }
                    }
                }, 1000);

                showPopup();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private int countShowHello = 0;

    public void setMobGameListener(MobGameListener listener) {
        final MobGameListener fl = listener;
        MobGameListener onLoginListener = new MobGameListener() {

            @Override
            public void onLoginSuccessful(String accID, String token) {
                try {
                    String userId = GameConfigManager.getInstance().getUserInfo().getUser().getUserId();
                    try {
                        AppsFlyerLib.getInstance().setCustomerUserId(userId);
                        Log.d(TAG, "onLoginSuccessful: appsflyer UID: " + AppsFlyerLib.getInstance().getAppsFlyerUID(getApplicationContext()));
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    countShowHello = 1;
                    Log.i(TAG, "OnLoginListener::onLoginSuccessful");
                    Log.i(TAG, "accountID = " + accID + "; accessToken = " + token);
                    if (userId != null) {
                        AdsManager.setUserId(userId);
                        EventClientManager.getInstance(getApplicationContext()).setUserId(userId);
                    }

                    runTimerCheckNotificationInGame();

                    close(false);
                    MobGameHelper.hideFloatButton();

                    queuePopups.clear();

                    queuePopups.add(POPUP_HELLO);
                    Log.i(TAG , "is_show :  " +  GameConfigManager.getInstance().getMobAds().is_show());
                    if (GameConfigManager.getInstance().getMobAds().is_show()) {
                        queuePopups.add(POPUP_LINK);
                    }
                    if (NotificationUtils.hasNtf(activity)) {
                        queuePopups.add(POPUP_NTFS);
                    }

                    queuePopups.add(POPUP_FLOAT_BUTTON);
                    if (!GameConfigManager.getInstance().getMobAds().is_show()) {
                        doLoadPopupAds();
                    }
                    showPopup();

                    try {
                        FunTrackingUtil.getInstance().trackLoginSuccess(activity);
                        new Thread(new Runnable() {
                            @Override
                            public void run() {
                                EventClientManager.getInstance(getApplicationContext()).saveEventClient(EventClientManager.SAVE_EVENT_START_SESSION, AFInAppEventType.LOGIN, null);
                            }
                        }).start();
                    } catch (Exception e) {
                        // TODO: handle exception
                    }
                    fl.onLoginSuccessful(accID, token);
                } catch (Exception e) {
                    e.printStackTrace();
                    fl.onError(-1, e.getMessage());
                }

            }

            @Override
            public void onPaySuccessful(String userId, String orderId,
                                        String orderProduct, String orderInfo, String orderTime,
                                        String platformPrice, String gamePrice, String state,
                                        String game_role_id, String game_area_id, String is_sandbox) {

                try {
                    double price = 0.01 * Double.parseDouble(platformPrice);
                    HashMap<String, Object> eventValue = new HashMap<String, Object>();
                    eventValue.put(AFInAppEventParameterName.REVENUE, price);
                    eventValue.put(AFInAppEventParameterName.CONTENT_TYPE,
                            "category_rev");
                    eventValue.put(AFInAppEventParameterName.CONTENT_ID,
                            "123456");
                    eventValue.put(AFInAppEventParameterName.CURRENCY, "USD");
                    eventValue.put(Constants.AF_ORDER_ID, orderId);
                    FunTrackingUtil.getInstance().trackPaymentSuccess(activity , eventValue);
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            EventClientManager.getInstance(activity).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, AFInAppEventType.PURCHASE, eventValue);
                        }
                    }).start();
                } catch (Exception e) {
                    e.printStackTrace();
                    // in case platformPrice cannot be parsed
                }

                fl.onPaySuccessful(userId, orderId, orderProduct, orderInfo,
                        orderTime, platformPrice, gamePrice, state,
                        game_role_id, game_area_id, is_sandbox);
                isShowAds = false;
            }

            @Override
            public void onError(int errorCode, String message) {
                try {
                    Log.d(TAG, "onError MobGameListener: " + message);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onLoginFormClose() {
                fl.onLoginFormClose();
            }

            @Override
            public void onLogoutSucessful(String roleId) {
                fl.onLogoutSucessful(roleId);
            }
        };
        mListener = onLoginListener;
    }

    public void endSession(long deltaSession) {
        Log.i(TAG , "endSession");
        FunTrackingUtil.getInstance().trackSession(currentActivity, deltaSession);
    }

    /*
    * get time from Before Authen
    * */
    public long getTimeLiveSession() {
        Game game = GameConfigManager.getInstance().getGameConfig();
        long timeSession = game.getTimeSession() * 60 * 1000;
        if (timeSession == 0) {
            timeSession = 10 * 60 * 1000;
            return timeSession;
        } else {
            return timeSession;
        }
    }

    private enum StatusAd {
        AD_INIT, AD_LOADING, AD_OPENED, AD_LOADED, AD_CLOSED, AD_ERROR, AD_SHOWING
    }

    private StatusAd adStatus = StatusAd.AD_INIT;

    private void doLoadPopupAds() {
        try {
            boolean showAds = Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_ADS, false);
            if (!showAds) {
                return;
            }
            if (popupAd == null) {
                return;
            }
            if (adStatus != StatusAd.AD_LOADING && adStatus != StatusAd.AD_OPENED
                    && adStatus != StatusAd.AD_SHOWING && adStatus != StatusAd.AD_LOADED) {
                popupAd.loadAd();
                adStatus = StatusAd.AD_LOADING;
                Log.d(TAG, "Ads loading....");
                popupAd.setAdListener(new AdListener() {
                    @Override
                    public void onAdOpened() {
                        Log.d(TAG, "onAdOpened ");
                        adStatus = StatusAd.AD_OPENED;
                    }

                    @Override
                    public void onAdLoadedError(int arg0, String errorMessage) {
                        Log.d(TAG, "Load ad error: " + errorMessage);
                        adStatus = StatusAd.AD_ERROR;
                    }

                    @Override
                    public void onAdLoaded() {
                        Log.d(TAG, "Ads loaded!");
                        adStatus = StatusAd.AD_LOADED;
                        queuePopups.add(POPUP_ADS);
                        showPopup();
                    }

                    @Override
                    public void onAdClosed() {
                        Log.d(TAG, "onAdClosed");
                        adStatus = StatusAd.AD_CLOSED;
                    }
                });
            } else {
                showPopup();
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ActivityLifecycleCallbacks mActivityLifecycleCallbacks = new ActivityLifecycleCallbacks() {

        private final String TAG = ActivityLifecycleCallbacks.class
                .getSimpleName();

        int count = 0;
        @Override
        public void onActivityCreated(Activity a, Bundle b) {
            try {
                Log.i(TAG, "onActivityCreated:" + a.getClass().getSimpleName());
                currentActivity = a;
                if (a.equals(activity)) {
                    // Xu li deeplink o day!!!
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onActivityStarted(Activity a) {
            try {
                Log.i(TAG, "onActivityStarted:" + a.getClass().getSimpleName());
                currentActivity = a;
                if (a.equals(activity)) {

                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onActivityResumed(Activity a) {
            try {
                Log.i(TAG, "onActivityResumed:" + a.getClass().getSimpleName());
                currentActivity = a;

                if (isScrollingText && scrollTextAnimation != null) {
                    long resumedPoint = System.currentTimeMillis() - startPointOfOneScrollingTextNow;
                    scrollTextAnimation.start();
                    if (resumedPoint < durationOfOneScrollingTextNow) {
                        scrollTextAnimation.setCurrentPlayTime(resumedPoint);
                    }
                }

                changeInForegroundStatus(true);
                if (a.equals(activity)) {
                    Log.d(TAG, "menu-id onActivityResumed:" + menuId);

                    Game gameConfig = GameConfigManager.getInstance().getGameConfig();
                    if (gameConfig == null) {
                        getGameInfoRemote();
                    }

                    if(isValidationMode){
                        requestOverlayPermission(activity);
                    }

                    LocalBroadcastManager.getInstance(getApplicationContext())
                            .registerReceiver(mMessageReceiver, new IntentFilter(Constants.INTENT_FILTER));

                    CookieSyncManager.getInstance().startSync();
                    if (!Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_DASHBOARD, false)) {
                        Intent intent = new Intent(Constants.INTENT_FILTER);
                        intent.putExtra("category", "float_button");
                        LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    }
                    Log.d(TAG, "shouldShowPopup:" + shouldShowPopup);
                    if (shouldShowPopup) {
                        showPopup();
                        shouldShowPopup = false;
                    }
                    Log.e(TAG, "isShowAds: " + isShowAds + " , " + Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, false));
                    if (isLoggedIn() && isShowAds && !GameConfigManager.getInstance().getMobAds().is_show()) {
                        Log.e(TAG, "Go inside :" + isShowAds);
                        doLoadPopupAds();
                    }
                    if (!isLogout) {
                        CmdDashboard.getInstance().showGiftCode();
                    }
                    if (!Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, false)) {
                        MobGameSDK.getInstance().registerSensor();
                    }
                    if (isShowingLogoutPopup) {
                        Intent intent = new Intent(Constants.INTENT_FILTER);
                        intent.putExtra("category", "float_button");
                        LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    }

//                    if(isLoggedIn()){
//                        runTimerCheckNotificationInGame();
//                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @SuppressLint("InlinedApi")
        private void requestReadExternalPermission() {
            boolean grantedReadStorage = PermissionUtils
                    .hasPermission(Manifest.permission.READ_EXTERNAL_STORAGE);

            if (!grantedReadStorage) {
                PermissionUtils.requestPermission(activity,
                        Manifest.permission.READ_EXTERNAL_STORAGE);
            }
        }

        @Override
        public void onActivityPaused(Activity a) {
            try {
                Log.i(TAG, "onActivityPaused:" + a.getClass().getSimpleName());
                count++;
                currentActivity = a;

                if (scrollTextTimer !=null) scrollTextTimer.cancel();
                scrollTextTimer =null;
                if (scrollTextTimerTask !=null) scrollTextTimerTask.cancel();

                changeInForegroundStatus(false);
                hideNotiFloatButton();
                if (a.equals(activity)) {
                    CmdDashboard.getInstance().hideGiftCode();
                    MobGameHelper.hideFloatButton();
                    CookieSyncManager.getInstance().stopSync();

                    LocalBroadcastManager.getInstance(getApplicationContext())
                            .unregisterReceiver(mMessageReceiver);
                    if (!Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, false)) {
                        MobGameSDK.getInstance().unRegisterSensor();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }

        @Override
        public void onActivityStopped(Activity a) {
            try {
                Log.i(TAG, "onActivityStopped:" + a.getClass().getSimpleName());
                if (a.equals(activity)) {
                    MobGameHelper.hideFloatButton();
//                    CmdDashboard.getInstance().hideGiftCode();
                }
                if (count != 0) {
                    Log.d(TAG, "onActivity Go here");
                    long timeFromBefore = getTimeLiveSession();

                    new CountDownTimer(timeFromBefore, timeFromBefore) {

                        @Override
                        public void onTick(long millisUntilFinished) {

                        }

                        @Override
                        public void onFinish() {
                            long endSession = System.currentTimeMillis();
                            long startSession = Preference.getLong(a, Constants.START_SESSION, 0);
                            endSession(endSession - startSession);
                        }
                    }.start();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onActivityDestroyed(Activity a) {
            try {
                Log.i(TAG, "onActivityDestroyed:" + a.getClass().getSimpleName());
                if (a.equals(activity)) {
                    if (isLoggedIn()) {
                        EventClientManager.getInstance(a).saveEventClient(EventClientManager.SAVE_EVENT_END_SESSION, null, null);
                    }
                    if (!a.getClass().getSimpleName().equals("MobGameActivity")
                            && !a.getClass().getSimpleName()
                            .equals("FacebookActivity")) {
                        isShowAds = true;
                    }
                    Log.i(TAG, "removeAllCookie");

//                    MobGameGCMIntentService.destroy(activity);

                    LocalBroadcastManager.getInstance(
                            getApplicationContext()).unregisterReceiver(
                            mGlobalMessageReceiver);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onActivitySaveInstanceState(Activity a, Bundle b) {
            try {
                if (a.equals(activity)) {

                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    };

    public void registerSensor() {
        try {
            Log.d(TAG, "isShowAds " + accelerometerPresent + " , " + accelerometerPresent);
            if (accelerometerPresent) {
                if (accelerometerPresent) {
                    sensorManager.registerListener(accelerometerListener,
                            accelerometerSensor, SensorManager.SENSOR_DELAY_NORMAL);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unRegisterSensor() {
        try {
            if (accelerometerPresent) {
                sensorManager.unregisterListener(accelerometerListener);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ComponentCallbacks mComponentCallbacks = new ComponentCallbacks() {

        @Override
        public void onConfigurationChanged(Configuration newConfig) {
            // Checks the orientation of the screen
            try {
                Log.d(TAG, "onConfigurationChanged");
                if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE
                        || newConfig.orientation == Configuration.ORIENTATION_PORTRAIT) {

                    Log.d(TAG, "onConfigurationChanged : " + newConfig.orientation
                            + " , " + !Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_DASHBOARD, false));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }

        @Override
        public void onLowMemory() {
        }

    };

    private BroadcastReceiver mMessageReceiver = new BroadcastReceiver() {

        @Override
        public void onReceive(Context context, Intent intent) {
            Log.d(TAG, "BroadcastReceiver::onReceive");
            try {
                String category = intent.getStringExtra("category");
                Log.e(TAG, "category:" + category);
                if (category != null) {
                    if ("float_button".equalsIgnoreCase(category)) {
                        try {
                            String msg = intent.getStringExtra("message");
                            Log.d(TAG, "message:" + msg);
                            if ("hide".equalsIgnoreCase(msg)) {
                                MobGameHelper.hideFloatButton();
                            } else {
                                Log.d(TAG, "alo alo : " + !Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_DASHBOARD, false));
                                if (GameConfigManager.getInstance().getGameConfig() != null
                                        && isLoggedIn()
                                        && !offerWall.isShowing()
                                        && Utils.isDashboardEnabled(activity)
                                        && shouldShowFloatButton
                                        && !isShowSocialDialog) {
                                    Log.d(TAG, "vao day : " + GameConfigManager.getInstance().isHasUnreadNotifications() +
                                            " , " + Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true)
                                            + " , " + !Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_DASHBOARD, false));
                                    if (GameConfigManager.getInstance().isHasUnreadNotifications()
                                            && Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true)
                                            && !Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_DASHBOARD, false)) {
                                        ArrayList<NtfModel> listNtf = new ArrayList<>();
                                        ArrayList<NtfModel> _listNtfModels = new ArrayList<>();
                                        _listNtfModels = NotificationUtils.getNtfs(activity);
                                        ArrayList<NtfModel> listNtfModels = new ArrayList<>();
                                        listNtfModels = removeDuplicateWithOrder(_listNtfModels);

                                        for (int i = 0; i < listNtfModels.size(); i++) {
                                            NtfModel ntfModel = new NtfModel();
                                            ntfModel.setId(listNtfModels.get(i).getId());
                                            ntfModel.setTitle(listNtfModels.get(i).getTitle());
                                            ntfModel.setNoti(listNtfModels.get(i).getNoti());

                                            if (ntfModel.getTitle() != null)
                                                listNtf.add(ntfModel);
                                        }
                                        Log.d(TAG, "notify floatbutton " + listNtf.size());
                                        MobGameHelper.notifyFloatButton(listNtf, false);
                                    }

                                    long currentTimeMilisecond = Calendar.getInstance().getTimeInMillis();
                                    long dismissTime = Preference.getLong(activity,
                                            Constants.SHARED_PREF_FLOAT_BUTTON_DISMISS_TIME,
                                            -1L);
                                    Log.d(TAG, "dismissTime : " + dismissTime);
                                    if (dismissTime < 0) {
                                        Log.d(TAG, "Xin chao ");
                                        MobGameHelper.showFloatButton();
                                        return;
                                    }

                                    long totalTime = currentTimeMilisecond - dismissTime;
                                    LogUtils.log(activity, TAG, String.format("total time float button dismissed: %s hours", (totalTime / 60 * 60 * 1000)));
                                    if (totalTime >= TIMEOUT_DISMISS_FLOAT_BUTTON) {
                                        Log.d(TAG, "Xin chao 1 ");
                                        MobGameHelper.showFloatButton();
                                        Preference.remove(activity, Constants.SHARED_PREF_FLOAT_BUTTON_DISMISS_TIME);
                                        Preference.remove(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON);
                                    }
                                    if (Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true)) {
                                        Log.d(TAG, "vao day hooo");
                                        MobGameHelper.showFloatButton();
                                    }
                                    if (!Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, false)) {
                                        MobGameSDK.getInstance().registerSensor();
                                    }
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if ("show_float_button".equalsIgnoreCase(category)) {
                        try {
                            String msg = intent.getStringExtra("message");
                            Log.d(TAG, "message:" + msg);
                            if ("hide".equalsIgnoreCase(msg)) {
                                MobGameHelper.hideFloatButton();
                            } else {
                                Log.d(TAG, "vl : " + Utils.isDashboardEnabled(activity));
                                if (GameConfigManager.getInstance().getGameConfig() != null
                                        && isLoggedIn()
                                        && !offerWall.isShowing()
                                        && Utils.isDashboardEnabled(activity)
                                        && shouldShowFloatButton
//                                        && !isShowingLogoutPopup
                                        && !isShowSocialDialog
                                        ) {
                                    MobGameHelper.showFloatButtonCenter();
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if ("gcm".equalsIgnoreCase(category)) {
                        try {
                            Log.d(TAG, "khaitran " + !Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_DASHBOARD, false)
                                    + " , " + Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true));
                            if (GameConfigManager.getInstance().getGameConfig() != null
                                    && isLoggedIn()
                                    && !offerWall.isShowing()
                                    && Utils.isDashboardEnabled(activity)
                                    && !Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_DASHBOARD, false)
                                    && Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true)) {
                                Log.d(TAG, "id gcm: " + intent.getStringExtra("id"));
                                int id = Integer.parseInt(intent.getStringExtra("id"));
                                String textTitle = intent.getStringExtra("title");
                                boolean noti = Boolean.parseBoolean(intent.getStringExtra("noti"));

                                ArrayList<NtfModel> listId = new ArrayList<>();
                                NtfModel ntfModel = new NtfModel();
                                ntfModel.setId(id);
                                ntfModel.setTitle(textTitle);
                                ntfModel.setNoti(noti);
                                //check neu ko phai id = 2,3,5
                                if (ntfModel.getTitle() != null)
                                    listId.add(ntfModel);
                                MobGameHelper.notifyFloatButton(listId, true);
                            }

                            if (intent.getBooleanExtra("show-timer", false)) {
                                MobGameHelper.showTimer();
                            }

                            if (intent.getBooleanExtra("play_gif", false)) {
                                GifHelper.playGif(activity);
                            }

                            if (intent.hasExtra("gif_data")) {
                                String gifDataString = intent.getStringExtra("gif_data");
                                GifHelper.fetchFramesImage(activity, GifData.parse(gifDataString));
                                GifHelper.playGif(activity);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if ("mobOpenOfferWall".equalsIgnoreCase(category)) {
                        showOfferWall();
                    } else if ("mobOpenFanPage".equalsIgnoreCase(category)) {
                        try {
                            String params = intent.getStringExtra("data");
                            CmdDashboard.getInstance().mobOpenFBFanpage(activity, params);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if ("mobOpenGroup".equalsIgnoreCase(category)) {
                        try {
                            String params = intent.getStringExtra("data");
                            CmdDashboard.getInstance().mobOpenFBGroup(activity, params);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if ("mobOpenBrowser".equalsIgnoreCase(category)) {
                        try {
                            String params = intent.getStringExtra("data");
                            CmdDashboard.getInstance().mobOpenBrowser(activity, params);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if ("MobGameUpgradeDialog.btnUpgradeInfo".equalsIgnoreCase(category)) {
                        shouldShowPopup = true;
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private ArrayList<NtfModel> removeDuplicateWithOrder(ArrayList<NtfModel> arrList) {
        Set<Integer> set = new HashSet();
        List<NtfModel> newList = new ArrayList<>();
        for (Iterator<NtfModel> iter = arrList.iterator(); iter.hasNext(); ) {
            NtfModel element = iter.next();
            int id = element.getId();
            if (set.add(id))
                newList.add(element);
        }
        arrList.clear();
        arrList.addAll(newList);
        return arrList;
    }

    private BroadcastReceiver mGlobalMessageReceiver = new BroadcastReceiver() {

        @Override
        public void onReceive(Context context, Intent intent) {
            Log.d(TAG, "GlobalMessageReceiver::onReceive");
            try {
                String category = intent.getStringExtra("category");
                Log.d(TAG, "GlobalMessageReceiver::onReceive " + category);
                if (category != null) {
                    if ("login".equalsIgnoreCase(category)) {
                        handleLogin();
                    } else if ("payment".equalsIgnoreCase(category)) {

                        boolean success = intent.getBooleanExtra("status", false);
                        if (success) {
                            String userId = intent.getStringExtra("user_id");
                            String orderId = intent.getStringExtra("order_id");
                            String orderProduct = intent.getStringExtra("order_product");
                            String orderInfo = intent.getStringExtra("order_info");
                            String orderTime = intent.getStringExtra("order_time");
                            String platformPrice = intent.getStringExtra("platform_price");
                            String gamePrice = intent.getStringExtra("game_price");
                            String state = intent.getStringExtra("state");
                            String game_role_id = intent.getStringExtra("game_role_id");
                            String game_area_id = intent.getStringExtra("game_area_id");
                            String is_sandbox = intent.getStringExtra("is_sandbox");

                            mListener.onPaySuccessful(userId, orderId,
                                    orderProduct, orderInfo, orderTime,
                                    platformPrice, gamePrice, state, game_role_id,
                                    game_area_id, is_sandbox);
                        } else {
                            String message = intent.getStringExtra("message");
                            mListener.onError(MobGameListener.ERROR_PAYMENT,
                                    message);
                        }
                    } else if ("reload".equalsIgnoreCase(category)) {
                        MobGameActivity.shouldReload = true;
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private GetInfoBeforeAuthenTask mGetInfoBeforeAuthenTask;
    public static boolean isValidationMode = false;

    private void getGameInfoRemote() {
        try {
            if (mGetInfoBeforeAuthenTask != null
                    && !mGetInfoBeforeAuthenTask.isCancelled())
                mGetInfoBeforeAuthenTask.cancel(true);

            mGetInfoBeforeAuthenTask = new GetInfoBeforeAuthenTask(
                    new GetInfoBeforeAuthenTask.Listener() {

                        @Override
                        public void onSuccess(Game gameConfig, boolean isNotificationOn) {
                            if (isNotificationOn) {
                                isValidationMode = true;
                                Log.e("THAM DINH CONFIG:", isNotificationOn + "");
                                requestOverlayPermission(activity);
                            }
                            if (gameConfig == null) {

                                onGetGameInfoRemoteFailed();
                            } else {
                                GameConfigManager.getInstance().setGameConfig(
                                        gameConfig);

                                offerWall = new OfferWallFragment(activity);

                                popupAd = new PopupAd(activity);

                                if (isLoggedIn()) {
                                    handleLogin();
                                }
                            }
                        }

                        @Override
                        public void onFailure(Throwable t) {
                            t.printStackTrace();
                            onGetGameInfoRemoteFailed();
                        }
                    });
            mGetInfoBeforeAuthenTask.execute();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onGetGameInfoRemoteFailed() {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder(
                    Utils.getContextThemeWrapper(activity));
            builder.setCancelable(false);
            builder.setMessage(Res.string(activity, R.string.unable_to_connect));
            builder.setPositiveButton(Res.string(activity, R.string.retry),
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int which) {
                            getGameInfoRemote();
                        }
                    });
            builder.setNegativeButton(Res.string(activity, R.string.exit),
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int which) {
                            Intent intent = new Intent(Intent.ACTION_MAIN);
                            intent.addCategory(Intent.CATEGORY_HOME);
                            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                            activity.startActivity(intent);
                        }
                    });
            builder.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showTextScroll(ArrayList<IngameNoti> listNoti) {
        if (isShowingHello) {
            return;
        }
        if (this.listNoti.size() == 0) {
            this.listNoti = listNoti;
        } else {
            this.listNoti.addAll(listNoti);
        }
        showTextScroll(activity, 1, null, listNoti.get(0));
    }

    private ArrayList<IngameNoti> listNoti = new ArrayList<>();

    private void runTimerCheckNotificationInGame() {
        try {
            if(scrollTextTimer != null) {
                scrollTextTimer.cancel();
                scrollTextTimer = null;
            }
            scrollTextTimer = new Timer();
            if (scrollTextTimerTask == null) {
                scrollTextTimerTask = new MobTimerTask(activity, new Runnable() {
                    @Override
                    public void run() {
                        if (isLoggedIn()) {
                            new GetIngameNotificationTask(activity, new GetIngameNotificationTask.Listener() {
                                @Override
                                public void onSuccess(ArrayList<IngameNoti> listItem) {
//                                    Log.e("Running", listItem.size() + "");
                                    if (listItem.size() == 0) return;
                                    listNoti.addAll(listItem);
                                    showTextScroll(activity, 1, null, listNoti.get(0));
                                }

                                @Override
                                public void onFailure(Throwable t) {
                                    t.printStackTrace();
                                }
                            }).execute();
                        }
                    }
                });
            }
            ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
            if (viewNotice != null)
                rootView.removeView(viewNotice);
            scrollTextTimer.schedule(scrollTextTimerTask, PERIOD_TO_SEND_REQUEST_GET_NOTI, PERIOD_TO_SEND_REQUEST_GET_NOTI);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    public void showTextScroll(final Activity activity, int repeatCount,
                               final Runnable afterHideRunnable , IngameNoti message){
        try {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
                    LayoutInflater inflater = LayoutInflater.from(activity);
                    if (viewNotice == null) viewNotice = inflater.inflate(R.layout.layout_notice, null);
                    if (scrollTextLayout == null) {
                        scrollTextLayout = (FrameLayout) viewNotice.findViewById(R.id.layoutNotiIngame);
                        /*CHỈNH LAYOUT = 4/5 CHIỀU NGẮN CỦA MÀN HÌNH*/
                        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) scrollTextLayout.getLayoutParams();
                        layoutParams.width = rootView.getWidth()/5*4;
                        Log.i("Layout Width", layoutParams.width + " | ScreenWidth: " + rootView.getWidth());
                    }
                    TextView scrollText = (TextView) viewNotice.findViewById(R.id.txt_notice);
                    Rect bounds = new Rect();
                    Paint textPaint = scrollText.getPaint();
                    long layoutWidth = rootView.getWidth()/5*4;
                    if (isScrollingText) {
                        initScrollView(message,textPaint,bounds,scrollTextLayout);
                    } else {
                        /* FIRST TIME SET UP ANIMATION */
                        textViews = new ArrayList<>();
                        scrollAnimIndex =0; scrollAnimRepeatCount = 0;
                        initScrollView(message,textPaint,bounds,scrollTextLayout);
                        rootView.addView(viewNotice);
                        int startPoint = (rootView.getWidth()/5*4) + rootView.getWidth()/10;
                        startScrollingText(textViews.get(scrollAnimIndex),layoutWidth, startPoint, afterHideRunnable, repeatCount);
                    }
                }
            });
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void hideTextScroll(final Activity activity, boolean isAnimated) {
        try {
            Log.e("HERE","Hiding ");
            ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
            if (isScrollingText) {
                if (isAnimated) {
                    activity.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            Animation animation = AnimationUtils.loadAnimation(
                                    activity, R.anim.top_out);
                            animation.setAnimationListener(new Animation.AnimationListener() {
                                @Override
                                public void onAnimationStart(Animation animation) {
                                }

                                @Override
                                public void onAnimationRepeat(Animation animation) {
                                }

                                @Override
                                public void onAnimationEnd(Animation animation) {

                                }
                            });
                            if (viewNotice !=null ) {
                                viewNotice.startAnimation(animation);
                                rootView.removeView(viewNotice);
                            }
                        }
                    });
                }else {
                    try {
                        if (viewNotice !=null )
                            rootView.removeView(viewNotice);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                isScrollingText = false;
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private void initScrollView(IngameNoti listNoti, Paint textPaint, Rect bounds, FrameLayout layout) {
        try {
            Spanned text = Html.fromHtml(listNoti.getText());
            //test
            TextView textView = new TextView(activity);
            textPaint.getTextBounds(String.valueOf(text),0, text.length(),bounds);
            float textLength = bounds.width();
            textView.setSingleLine(true);
            textView.setEllipsize(TextUtils.TruncateAt.MARQUEE);
            textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 16);
            textView.setTextColor(Color.WHITE);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams((int) textLength, ViewGroup.LayoutParams.WRAP_CONTENT);
            textView.setLayoutParams(lp);
            textView.setText(text);
            switch (listNoti.getType()) {
                case 1:
                    textView.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            try {
                                MobGameHelper.hideFloatButton();
                                AlertDialog.Builder builder = new AlertDialog.Builder(activity);
                                builder.setMessage(R.string.open_with_browser)
                                        .setPositiveButton(R.string.yes, new DialogInterface.OnClickListener() {
                                            public void onClick(DialogInterface dialog, int id) {
                                                // FIRE ZE MISSILES!
                                                activity.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(listNoti.getLink())));
                                            }
                                        })
                                        .setNegativeButton(R.string.no, new DialogInterface.OnClickListener() {
                                            public void onClick(DialogInterface dialog, int id) {
                                                // User cancelled the dialog
                                                dialog.dismiss();
                                            }
                                        });

                                builder.setOnDismissListener(new DialogInterface.OnDismissListener() {
                                    @Override
                                    public void onDismiss(DialogInterface dialog) {
                                        MobGameHelper.showFloatButton();
                                    }
                                });
                                // Create the AlertDialog object and return it
                                builder.create().show();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    break;
                case 2:
                    textView.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            FragmentManager fm = activity.getFragmentManager();
                            DialogInGameFragment dialogIngame = new DialogInGameFragment(listNoti.getLink());
                            dialogIngame.show(fm,"Show Dialog Ingame");
                        }
                    });
                    break;
            }
            textViews.add(textView);
            layout.addView(textView);
            textView.setVisibility(View.GONE);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startScrollingText(TextView textView, long layoutWidth, float startPoint, Runnable afterHideRunnable, int repeatCount) {
        try {
            scrollAnimRepeatCount++;
            if (!isScrollingText)
                isScrollingText = true;
            textView.setVisibility(View.VISIBLE);
            textView.setX(startPoint);
            float scale = 1;
            try {
                scale = 3 / (activity.getResources().getDisplayMetrics().density);
            }catch (Exception e){
                e.printStackTrace();
            }
            long s = layoutWidth + textView.getLayoutParams().width;
            long textDuration = (long) (s* Constants.DEFAULT_SPEED * scale);
            durationOfOneScrollingTextNow = textDuration;

            Log.i("ScrollText Infor", "Text: " + textView.getText().toString()
            );
            scrollTextAnimation = ObjectAnimator.ofFloat(textView,"x",-textView.getLayoutParams().width);
            scrollTextAnimation.setDuration(textDuration);
            scrollTextAnimation.setInterpolator(new LinearInterpolator());
            scrollTextAnimation.addListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    try {
                        textView.setVisibility(View.GONE);
                        if (scrollAnimRepeatCount <= repeatCount) {
                            startScrollingText(textViews.get(scrollAnimIndex),layoutWidth, startPoint, afterHideRunnable, repeatCount);
                                                    Log.e("Scroll","1");
                        } else {
                            hideTextScroll(activity, true);
                            listNoti.remove(scrollAnimIndex);
                            textViews.remove(scrollAnimIndex);
                            scrollAnimRepeatCount = 0;
                            if (listNoti.size()>0) {
                                                            Log.e("Scroll","2");
                                new Handler().postDelayed(new Runnable() {
                                    @Override
                                    public void run() {
                                        if(listNoti!=null && listNoti.size()>0){
                                            showTextScroll(activity,1,null, listNoti.get(scrollAnimIndex));
                                        }
                                    }
                                },PERIOD_BETWEEN_TWO_NOTIFICATION);
                            } else {
                                                            Log.e("Scroll","3");
                                hideTextScroll(activity, true);
                                if (afterHideRunnable != null) {
                                    afterHideRunnable.run();
                                }
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            startPointOfOneScrollingTextNow = System.currentTimeMillis();
            scrollTextAnimation.start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static View helloView;
    private static boolean isShowingHello;
    private static final int DEFAULT_HELLO_TIMEOUT = 3000;

    public void showHello(Activity activity) {
        showHello(activity, DEFAULT_HELLO_TIMEOUT, null);
    }

    public void showHello(final Activity activity, long duration,
                          final Runnable afterHideRunnable) {
        try {
            if (activity == null)
                return;
            if (isShowingHello)
                return;

            final String username = GameConfigManager.getInstance()
                    .getUserInfo().getUser().getUserName();
            Log.i(TAG, "showHello:" + username);
            activity.runOnUiThread(new Runnable() {

                @SuppressLint("InflateParams")
                @Override
                public void run() {
                    try {
                        Utils.hideLoading();
                        ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
                        LayoutInflater inflater = LayoutInflater.from(activity);
                        helloView = inflater.inflate(R.layout.layout_processing, null);

                        TextView tv = (TextView) helloView.findViewById(R.id.txt_status);
                        tv.setText(Res.string(activity, R.string.hello) + ", " + username);
                        try {
                            UserInfo userInfo = GameConfigManager
                                    .getInstance().getUserInfo();
                            String title = userInfo.getTitle();
                            int coin = userInfo.getCoin();

                            if (coin > 0) {
                                View layoutMobCoin = helloView
                                        .findViewById(R.id.layout_mobcoin);
                                layoutMobCoin.setVisibility(View.VISIBLE);
                                TextView tvMobCoinActivity = (TextView) helloView
                                        .findViewById(R.id.txt_mobcoin_activity);
                                tvMobCoinActivity.setText(title);
                                TextView tvMobCoin = (TextView) helloView
                                        .findViewById(R.id.txt_mobcoin_value);
                                tvMobCoin.setText("+" + coin);
                            } else {
                                View layoutMobCoin = helloView
                                        .findViewById(R.id.layout_mobcoin);
                                layoutMobCoin.setVisibility(View.GONE);
                            }
                        } catch (Exception e) {
                        }
                        rootView.addView(helloView);

                        helloView.startAnimation(AnimationUtils.loadAnimation(activity, R.anim.top_in));
                        isShowingHello = true;
                        countShowHello = countShowHello + 1;
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            new Handler().postDelayed(new Runnable() {

                @Override
                public void run() {
                    hideHello(activity, true);
                    if (afterHideRunnable != null) {
                        afterHideRunnable.run();
                    }
                }
            }, duration + 500);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideHello(final Activity activity, boolean isAnimated) {
        isShowingHello = false;
        countShowHello = countShowHello + 1;
        if (isAnimated) {
            try {
                activity.runOnUiThread(new Runnable() {
                    public void run() {
                        Animation animation = AnimationUtils.loadAnimation(
                                activity, R.anim.top_out);
                        animation.setAnimationListener(new AnimationListener() {
                            @Override
                            public void onAnimationStart(Animation animation) {
                            }

                            @Override
                            public void onAnimationRepeat(Animation animation) {
                            }

                            @Override
                            public void onAnimationEnd(Animation animation) {
                                ViewGroup rootView = (ViewGroup) activity
                                        .findViewById(android.R.id.content);
                                rootView.removeView(helloView);
                            }
                        });
                        helloView.startAnimation(animation);
                    }
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
                rootView.removeView(helloView);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void requestOverlayPermission(final Activity activity) {
        try {
            Log.i(TAG , "Khai Tran : requestOverlayPermission");
            if (activity != null) {
                if (isValidationMode) {
                    if (!isGrantedPermission(activity)) {
                        if (!MobGameHelper.didShowPermissionDialog) {
                            showDialogRequestOverlayPermission();
                        }
                    } else {
                        if (isInForeground()) showNotiFloatButton();
                        Intent intent = new Intent(Constants.INTENT_FILTER);
                        intent.putExtra("category", "float_button");
                        LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showDialogRequestOverlayPermission() {
        try {

            AlertDialog.Builder builder;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                builder = new AlertDialog.Builder(activity, android.R.style.Theme_Material_Light_Dialog_Alert);
            } else {
                builder = new AlertDialog.Builder(activity);
            }

            String appName = activity.getApplicationInfo().loadLabel(activity.getPackageManager()).toString();
            builder.setTitle(activity.getString(R.string.attention_overlay))
                    .setMessage(String.format(activity.getString(R.string.overlay_message), appName))
                    .setPositiveButton(android.R.string.yes, new DialogInterface.OnClickListener() {
                        @SuppressLint("NewApi")
                        public void onClick(DialogInterface dialog, int which) {
                            Intent intent = null;
                            canDraw = Settings.canDrawOverlays(activity);
                            if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.O){
                                AppOpsManager opsManager = (AppOpsManager) activity.getSystemService(Context.APP_OPS_SERVICE);
                                onOpChangedListener = new AppOpsManager.OnOpChangedListener() {
                                    @Override
                                    public void onOpChanged(String op, String packageName) {
                                        PackageManager packageManager = activity.getPackageManager();
                                        String myPackageName = activity.getPackageName();
                                        if(myPackageName.equals(packageName) && AppOpsManager.OPSTR_SYSTEM_ALERT_WINDOW.equals(op)){
                                            canDraw = true;
                                        }
                                    }
                                };
                                opsManager.startWatchingMode(AppOpsManager.OPSTR_SYSTEM_ALERT_WINDOW , null , onOpChangedListener);
                            }

                            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M) {
                                intent = new Intent(Settings.ACTION_MANAGE_OVERLAY_PERMISSION,
                                        Uri.parse("package:" + activity.getPackageName()));
                            }
                            dialog.dismiss();
                            MobGameHelper.didShowPermissionDialog = false;
                            (activity).startActivityForResult(intent, Constants.REQUEST_OVERLAY_PERMISSION);
                        }
                    })
                    .setCancelable(false)
                    .setIcon(activity.getApplicationInfo().icon)
                    .show();
            MobGameHelper.didShowPermissionDialog = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public boolean isShowingLogoutPopup() {
        return isShowingLogoutPopup;
    }

    private void showNotiFloatButton() {
        if (MobGameHelper.isShowingNotiFloatButton()) return;
        MobGameHelper.showNotiFloatButton();
        Log.e("noti", "is showing " + "--------------------------------");
    }

    public void hideNotiFloatButton() {
        //if(MobGameHelper.isShowingNotiFloatButton())
        MobGameHelper.hideNotiFloatButton();
    }

    public boolean isGrantedPermission(Context context) {
        boolean isGrandted = false;
        if(Build.VERSION.SDK_INT < Build.VERSION_CODES.M){
            isGrandted = true;
        }
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.O){
            isGrandted = canDraw;
        }
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && Build.VERSION.SDK_INT <  Build.VERSION_CODES.O){
            isGrandted = Settings.canDrawOverlays(context);
        }
        return isGrandted;
    }

    private void changeInForegroundStatus(boolean isInForeground) {
        Preference.save(activity, "isInForeground", isInForeground);
    }

    private boolean isInForeground() {
        try {
            return Preference.getBoolean(activity, "isInForeground", true);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

}