/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.floatbutton;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.Transformation;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.mobgame.R;
import com.mobgame.gui.CountDownTimerEgde;
import com.mobgame.gui.view.MobAutoScrollTextView;
import com.mobgame.model.NtfModel;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.Preference;
import java.util.ArrayList;
import java.util.Calendar;

@SuppressLint(value={"InflateParams", "ClickableViewAccessibility"})
public class MobGameFloatGestureView {
    private static String TAG = MobGameFloatGestureView.class.getSimpleName();
    static final int ANIMAION_TIME_MOVE_TO_EDGE = 200;
    static final int BUTTON_SIZE = 44;
    Activity activity;
    View rootView;
    View floatArea;
    EventListener listener;
    GestureDetector gestureDetector;
    int buttonSize;
    int movableWidth;
    int movableHeight;
    float density;
    long timeTouchDown;
    long timeTouchUp;
    float deltaX;
    float deltaY;
    WindowManager windowManager;
    WindowManager.LayoutParams params;
    private LinearLayout viewNotification;
    private LinearLayout txt_linnear_layout;
    private MobAutoScrollTextView switcher;
    private RelativeLayout viewTimer;
    private RelativeLayout timer_layout;
    private CountDownTimerEgde countdownTimer;
    public boolean isLeft;
    long endTimer;
    int dem = 0;
    private View.OnTouchListener mOnTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            boolean comsumed = true;
            try {
                MobGameFloatGestureView.this.gestureDetector.onTouchEvent(event);
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        MobGameFloatGestureView.this.timeTouchDown = System.currentTimeMillis();
                        MobGameFloatGestureView.this.onTouchDown(event);
                        MobGameFloatGestureView.this.switcher.setVisibility(8);
                        MobGameFloatGestureView.this.viewNotification.setVisibility(8);
                        MobGameFloatGestureView.this.timer_layout.setVisibility(8);
                        break;
                    }
                    case 1: {
                        MobGameFloatGestureView.this.onTouchUp(event);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 2: {
                        MobGameFloatGestureView.this.onTouchMove(event);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return comsumed;
        }
    };
    OnScrollFinishedListener onScrollFinishedListener;
    GestureListener mGestureListener = new GestureListener();

    public MobGameFloatGestureView(Activity a) {
        this.activity = a;
        this.density = DeviceUtils.getDensity((Context)a);
        this.movableWidth = DeviceUtils.getScreenWidthInPixels((Context)a);
        this.movableHeight = DeviceUtils.getScreenHeightInPixels((Context)a);
        this.buttonSize = (int)(44.0f * this.density);
        this.gestureDetector = new GestureDetector((Context)a, (GestureDetector.OnGestureListener)new GestureListener());
        this.initView();
        this.attachView();
    }

    public void initView() {
        Log.d((String)TAG, (String)"initView");
        this.rootView = LayoutInflater.from((Context)this.activity).inflate(R.layout.float_area, null);
        this.floatArea = this.rootView.findViewById(R.id.layout_float);
        this.floatArea.getLayoutParams().width = this.buttonSize;
        this.floatArea.getLayoutParams().height = this.buttonSize;
        this.floatArea.setOnTouchListener(this.mOnTouchListener);
        this.viewNotification = (LinearLayout)LayoutInflater.from((Context)this.activity).inflate(R.layout.float_text_layout, null);
        this.switcher = (MobAutoScrollTextView)this.viewNotification.findViewById(R.id.txt_noti);
        this.txt_linnear_layout = (LinearLayout)this.viewNotification.findViewById(R.id.txt_linnearlayout);
        this.viewTimer = (RelativeLayout)LayoutInflater.from((Context)this.activity).inflate(R.layout.timer_layout_egde, null);
        this.countdownTimer = (CountDownTimerEgde)this.viewTimer.findViewById(R.id.countdown_timer_egde);
        this.timer_layout = (RelativeLayout)this.viewTimer.findViewById(R.id.timer_layout_egde);
    }

    public void attachView() {
        try {
            Log.d((String)TAG, (String)"attachView");
            this.windowManager = (WindowManager)this.activity.getApplicationContext().getSystemService("window");
            this.params = Build.VERSION.SDK_INT >= 26 ? new WindowManager.LayoutParams(-2, -2, 2038, 32, -2) : new WindowManager.LayoutParams(-2, -2, 2002, 32, -2);
            this.params.gravity = 51;
            this.params.x = 0;
            this.params.y = 0;
            this.windowManager.addView(this.rootView, (ViewGroup.LayoutParams)this.params);
            if (this.listener != null) {
                this.listener.onMove(this.params.x, this.params.y);
            }
            if (Build.VERSION.SDK_INT >= 26) {
                WindowManager.LayoutParams paramsTxt = new WindowManager.LayoutParams(-2, -2, 2038, 262688, -3);
                paramsTxt.gravity = 51;
                this.switcher.setVisibility(8);
                this.windowManager.addView((View)this.viewNotification, (ViewGroup.LayoutParams)paramsTxt);
                WindowManager.LayoutParams paramstimer = new WindowManager.LayoutParams(-2, -2, 2038, 262688, -3);
                paramstimer.gravity = 53;
                this.windowManager.addView((View)this.viewTimer, (ViewGroup.LayoutParams)paramstimer);
            } else {
                WindowManager.LayoutParams paramsTxt = new WindowManager.LayoutParams(-2, -2, 2002, 262688, -3);
                paramsTxt.gravity = 51;
                this.switcher.setVisibility(8);
                this.windowManager.addView((View)this.viewNotification, (ViewGroup.LayoutParams)paramsTxt);
                WindowManager.LayoutParams paramstimer = new WindowManager.LayoutParams(-2, -2, 2002, 262688, -3);
                paramstimer.gravity = 53;
                this.windowManager.addView((View)this.viewTimer, (ViewGroup.LayoutParams)paramstimer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEventListener(EventListener listener) {
        this.listener = listener;
    }

    public void setMovableWidth(int width) {
        this.movableWidth = width;
    }

    public void setMovableHeight(int height) {
        this.movableHeight = height;
    }

    public int getSize() {
        return 44;
    }

    public int getSizeInPixels() {
        return this.buttonSize;
    }

    public int getX() {
        if (this.rootView == null) {
            return 0;
        }
        return this.params.x;
    }

    public int getY() {
        if (this.rootView == null) {
            return 0;
        }
        return this.params.y;
    }

    public void moveTo(int x, int y) {
        this.moveTo(x, y, false);
    }

    public void moveTo(int x, int y, boolean isAnimated) {
        try {
            this.params.x = x;
            this.params.y = y;
            this.windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)this.params);
            if (this.listener != null) {
                this.listener.onMove(this.params.x, this.params.y);
                this.listener.onTouchUp(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setIsLeft(boolean isLeft) {
        this.isLeft = isLeft;
    }

    public boolean isLeft() {
        return this.isLeft;
    }

    public void moveToEdge(boolean isAnimated) {
        Log.d((String)TAG, (String)"moveToEdge");
        try {
            if (isAnimated) {
                Animation animation = new Animation(){

                    protected void applyTransformation(float interpolatedTime, Transformation t) {
                        super.applyTransformation(interpolatedTime, t);
                        try {
                            float left = MobGameFloatGestureView.this.params.x;
                            float right = (float)(MobGameFloatGestureView.this.movableWidth - MobGameFloatGestureView.this.buttonSize) - left;
                            if (left <= right) {
                                MobGameFloatGestureView.this.params.x = (int)(left - left * interpolatedTime);
                                MobGameFloatGestureView.this.isLeft = true;
                            } else {
                                MobGameFloatGestureView.this.params.x = (int)(left - (left - (float)MobGameFloatGestureView.this.movableWidth) * interpolatedTime);
                                MobGameFloatGestureView.this.isLeft = false;
                            }
                            MobGameFloatGestureView.this.windowManager.updateViewLayout(MobGameFloatGestureView.this.rootView, (ViewGroup.LayoutParams)MobGameFloatGestureView.this.params);
                            if (MobGameFloatGestureView.this.listener != null) {
                                MobGameFloatGestureView.this.listener.onMove(MobGameFloatGestureView.this.params.x, MobGameFloatGestureView.this.params.y);
                            }
                            MobGameFloatGestureView.this.timer_layout.setVisibility(8);
                            Log.d((String)TAG, (String)("FloatArea : " + MobGameFloatGestureView.this.params.x + " , " + MobGameFloatGestureView.this.params.y));
                            Preference.save((Context)MobGameFloatGestureView.this.activity, "shared_float_area_x", MobGameFloatGestureView.this.params.x);
                            Preference.save((Context)MobGameFloatGestureView.this.activity, "shared_float_area_y", MobGameFloatGestureView.this.params.y);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                animation.setDuration(200L);
                animation.setInterpolator((Interpolator)new OvershootInterpolator(0.5f));
                this.floatArea.startAnimation(animation);
            } else {
                float left = this.params.x;
                float right = (float)(this.movableWidth - this.buttonSize) - left;
                this.params.x = left <= right ? 0 : this.movableWidth - this.buttonSize;
                this.windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)this.params);
                if (this.listener != null) {
                    this.listener.onMove(this.params.x, this.params.y);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fadeOutRight() {
        try {
            this.timer_layout.setVisibility(0);
            WindowManager.LayoutParams params_float = (WindowManager.LayoutParams)this.rootView.getLayoutParams();
            WindowManager.LayoutParams params_right = (WindowManager.LayoutParams)this.viewTimer.getLayoutParams();
            this.timer_layout.getLayoutParams().height = this.buttonSize;
            this.timer_layout.getLayoutParams().width = (int)(16.0f * this.density);
            if (DeviceUtils.isTablet((Context)this.activity)) {
                if (!DeviceUtils.hasHardwareButtons() && this.activity.getResources().getConfiguration().orientation == 2) {
                    params_right.x = this.buttonSize / 2 - 12;
                    params_right.y = params_float.y;
                } else {
                    params_right.x = 0 + this.buttonSize / 2 - 12;
                    params_right.y = params_float.y;
                }
            } else if (!DeviceUtils.hasHardwareButtons() && this.activity.getResources().getConfiguration().orientation == 2) {
                params_right.x = this.buttonSize / 2 - 30;
                params_right.y = params_float.y;
            } else {
                params_right.x = 0 + this.buttonSize / 2 - 30;
                params_right.y = params_float.y;
            }
            if (this.countdownTimer != null) {
                this.timer_layout.removeAllViews();
            }
            long endTimer = this.getEndTimer();
            long countDown = endTimer - Calendar.getInstance().getTimeInMillis();
            if (endTimer >= 0L) {
                this.countdownTimer = new CountDownTimerEgde((Context)this.activity);
                this.countdownTimer.setDraw(true);
                Log.d((String)TAG, (String)("countDown :" + countDown + " , " + Calendar.getInstance().getTimeInMillis()));
                this.countdownTimer.setBase(Calendar.getInstance().getTime().getTime() + countDown);
                this.countdownTimer.setCountdownListener(new CountDownTimerEgde.CountdownListener(){

                    @Override
                    public void done() {
                        if (MobGameFloatGestureView.this.countdownTimer != null) {
                            MobGameFloatGestureView.this.countdownTimer.setVisibility(8);
                            MobGameFloatGestureView.this.timer_layout.setVisibility(8);
                        }
                    }
                });
                this.countdownTimer.start();
                this.countdownTimer.setTextColor(Color.parseColor((String)"#02f600"));
                this.countdownTimer.setTextSize(9.0f);
                this.countdownTimer.setTypeface(null, 1);
                this.countdownTimer.setShadowLayer(3.0f, 0.0f, 0.0f, Color.parseColor((String)"#000000"));
                RelativeLayout.LayoutParams lpView = new RelativeLayout.LayoutParams(-2, -2);
                lpView.addRule(13);
                this.viewTimer.addView((View)this.countdownTimer, (ViewGroup.LayoutParams)lpView);
            }
            this.viewTimer.setAlpha(0.5f);
            this.windowManager.updateViewLayout((View)this.viewTimer, (ViewGroup.LayoutParams)params_right);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEndTimer(long endTimer) {
        this.endTimer = endTimer;
    }

    public long getEndTimer() {
        return this.endTimer;
    }

    public void fadeOutLeft() {
        try {
            this.timer_layout.setVisibility(0);
            WindowManager.LayoutParams params_float = (WindowManager.LayoutParams)this.rootView.getLayoutParams();
            WindowManager.LayoutParams params_left = (WindowManager.LayoutParams)this.viewTimer.getLayoutParams();
            this.timer_layout.getLayoutParams().height = this.buttonSize;
            this.timer_layout.getLayoutParams().width = (int)(16.0f * this.density);
            if (DeviceUtils.isTablet((Context)this.activity)) {
                if (!DeviceUtils.hasHardwareButtons() && this.activity.getResources().getConfiguration().orientation == 2) {
                    params_left.x = this.movableWidth - this.buttonSize / 2 - (int)(16.0f * this.density) + 12;
                    params_left.y = params_float.y;
                } else {
                    params_left.x = this.movableWidth - this.buttonSize / 2 - (int)(16.0f * this.density) + 12;
                    params_left.y = params_float.y;
                }
            } else if (!DeviceUtils.hasHardwareButtons() && this.activity.getResources().getConfiguration().orientation == 2) {
                params_left.x = this.movableWidth - this.buttonSize / 2 - (int)(16.0f * this.density) + 30;
                params_left.y = params_float.y;
            } else {
                params_left.x = this.movableWidth - this.buttonSize / 2 - (int)(16.0f * this.density) + 30;
                params_left.y = params_float.y;
            }
            if (this.countdownTimer != null) {
                this.timer_layout.removeAllViews();
            }
            long endTimer = this.getEndTimer();
            long countDown = endTimer - Calendar.getInstance().getTimeInMillis();
            if (endTimer >= 0L) {
                this.countdownTimer = new CountDownTimerEgde((Context)this.activity);
                this.countdownTimer.setDraw(true);
                Log.d((String)TAG, (String)("countDown :" + countDown + " , " + Calendar.getInstance().getTimeInMillis()));
                this.countdownTimer.setBase(Calendar.getInstance().getTime().getTime() + countDown);
                this.countdownTimer.setCountdownListener(new CountDownTimerEgde.CountdownListener(){

                    @Override
                    public void done() {
                        if (MobGameFloatGestureView.this.countdownTimer != null) {
                            MobGameFloatGestureView.this.countdownTimer.setVisibility(8);
                            MobGameFloatGestureView.this.timer_layout.setVisibility(8);
                        }
                    }
                });
                this.countdownTimer.start();
                this.countdownTimer.setTextColor(Color.parseColor((String)"#02f600"));
                this.countdownTimer.setTextSize(9.0f);
                this.countdownTimer.setTypeface(null, 1);
                this.countdownTimer.setShadowLayer(3.0f, 0.0f, 0.0f, Color.parseColor((String)"#000000"));
                RelativeLayout.LayoutParams lpView = new RelativeLayout.LayoutParams(-2, -2);
                lpView.addRule(13);
                this.viewTimer.addView((View)this.countdownTimer, (ViewGroup.LayoutParams)lpView);
            }
            this.viewTimer.setAlpha(0.5f);
            this.windowManager.updateViewLayout((View)this.viewTimer, (ViewGroup.LayoutParams)params_left);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void showMsg(final ArrayList<NtfModel> listNotification) {
        try {
            this.viewNotification.setVisibility(0);
            WindowManager.LayoutParams paramsFloat = (WindowManager.LayoutParams)this.rootView.getLayoutParams();
            final WindowManager.LayoutParams paramsText = (WindowManager.LayoutParams)this.viewNotification.getLayoutParams();
            this.txt_linnear_layout.getLayoutParams().height = -2;
            this.txt_linnear_layout.getLayoutParams().width = -2;
            Log.d((String)TAG, (String)("isLeft : " + this.isLeft));
            if (this.isLeft) {
                paramsText.x = paramsFloat.x + this.buttonSize;
                paramsText.y = this.activity.getResources().getConfiguration().orientation == 2 ? paramsFloat.y + (int)((double)this.buttonSize * 0.2) : paramsFloat.y + (int)((double)this.buttonSize * 0.2);
            } else {
                paramsText.x = paramsFloat.x - (int)((double)this.buttonSize * 3.8);
                paramsText.y = this.activity.getResources().getConfiguration().orientation == 2 ? paramsFloat.y + (int)((double)this.buttonSize * 0.2) : paramsFloat.y + (int)((double)this.buttonSize * 0.2);
            }
            this.windowManager.updateViewLayout((View)this.viewNotification, (ViewGroup.LayoutParams)paramsText);
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    MobGameFloatGestureView.this.showViewNotification(listNotification, paramsText);
                }
            }, 1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showViewNotification(ArrayList<NtfModel> listNotification, WindowManager.LayoutParams paramsText) {
        this.switcher.setVisibility(0);
        if (this.isLeft) {
            this.switcher.setBackground(this.activity.getResources().getDrawable(R.drawable.noti_left));
            Animation slideLeft = AnimationUtils.loadAnimation((Context)this.activity, (int)R.anim.slide_in_left);
            this.switcher.startAnimation(slideLeft);
            Log.d((String)TAG, (String)"showMsg: show animation slide in Left");
        } else {
            this.switcher.setBackground(this.activity.getResources().getDrawable(R.drawable.noti_right));
            Animation slideRight = AnimationUtils.loadAnimation((Context)this.activity, (int)R.anim.slide_in_right);
            this.switcher.startAnimation(slideRight);
            Log.d((String)TAG, (String)"showMsg: show animation slide in right");
        }
        this.dem = 0;
        ArrayList<String> texts = new ArrayList<String>();
        for (int i = 0; i < listNotification.size(); ++i) {
            Log.d((String)TAG, (String)("list noti:" + listNotification.get(i).getTitle()));
            texts.add(listNotification.get(i).getTitle());
        }
        this.switcher.startAutoScroll(texts, 2000L, new MobAutoScrollTextView.OnTextViewScrollListener(){

            @Override
            public void onTextViewScroll(String text, boolean reverse) {
            }

            @Override
            public void onTextViewScrollFinished() {
                Animation slideOut;
                if (MobGameFloatGestureView.this.isLeft) {
                    slideOut = AnimationUtils.loadAnimation((Context)MobGameFloatGestureView.this.activity, (int)R.anim.slide_out_left);
                    Log.d((String)TAG, (String)"show animation: slide out left");
                } else {
                    slideOut = AnimationUtils.loadAnimation((Context)MobGameFloatGestureView.this.activity, (int)R.anim.slide_out_right);
                    Log.d((String)TAG, (String)"show animation: slide out right");
                }
                MobGameFloatGestureView.this.switcher.startAnimation(slideOut);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        MobGameFloatGestureView.this.onScrollFinishedListener.onScrollFinished();
                        MobGameFloatGestureView.this.switcher.setVisibility(8);
                        MobGameFloatGestureView.this.viewNotification.setVisibility(8);
                    }
                }, 300L);
            }
        });
    }

    private void onTouchDown(MotionEvent event) {
        try {
            this.deltaX = event.getX();
            this.deltaY = event.getY();
            if (this.listener != null) {
                this.listener.onTouchDown(event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onTouchMove(MotionEvent event) {
        try {
            float left = event.getRawX() - this.deltaX;
            float top = event.getRawY() - this.deltaY;
            left = Math.max(0.0f, Math.min((float)(this.movableWidth - this.buttonSize), left));
            top = Math.max(0.0f, Math.min((float)(this.movableHeight - this.buttonSize), top));
            this.params.x = (int)left;
            this.params.y = (int)top;
            this.rootView.setLayoutParams((ViewGroup.LayoutParams)this.params);
            this.windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)this.params);
            if (this.listener != null) {
                this.listener.onTouchMove(event);
                this.listener.onMove(this.params.x, this.params.y);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onTouchUp(MotionEvent event) {
        if (this.listener != null) {
            this.listener.onTouchUp(event);
        }
    }

    public void show() {
        try {
            if (this.rootView.getVisibility() == 8) {
                this.rootView.setVisibility(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hide() {
        try {
            this.viewNotification.setVisibility(8);
            this.rootView.setVisibility(8);
            this.viewTimer.setVisibility(8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dismiss() {
        try {
            this.rootView.setVisibility(8);
            this.windowManager.removeView(this.rootView);
            this.rootView = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnScrollFinishedListener(OnScrollFinishedListener onScrollFinishedListener) {
        this.onScrollFinishedListener = onScrollFinishedListener;
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            return false;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (MobGameFloatGestureView.this.listener != null) {
                MobGameFloatGestureView.this.listener.onClick(e);
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
        }
    }

    static interface OnScrollFinishedListener {
        public void onScrollFinished();
    }

    static interface EventListener {
        public void onTouchUp(MotionEvent var1);

        public void onTouchDown(MotionEvent var1);

        public void onTouchMove(MotionEvent var1);

        public void onClick(MotionEvent var1);

        public void onMove(int var1, int var2);
    }
}

