/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.float18button;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import com.mobgame.R;
import com.mobgame.gui.float18button.NotiFloatGestureView;
import com.mobgame.model.TimerData;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.Res;

@SuppressLint(value={"InflateParams", "ClickableViewAccessibility"})
public class NotiOverlayView {
    private static final String TAG = NotiOverlayView.class.getSimpleName();
    private static Activity activity;
    private View rootView;
    private View layoutBottom;
    private View layoutFloat;
    private TextView txtDismiss;
    private NotiFloatGestureView floatArea;
    private ImageView floatButton;
    private boolean isOutsideBottomArea;
    private int boundWidth;
    private int boundHeight;
    private int relativePositionOnScreen;
    private int statusBarHeight;
    private float density;
    private NotiFloatGestureView.EventListener mButtonEventListener = new NotiFloatGestureView.EventListener(){

        @Override
        public void onTouchDown(MotionEvent event) {
            NotiOverlayView.this.isOutsideBottomArea = true;
        }

        @Override
        public void onTouchMove(MotionEvent event) {
            try {
                if (NotiOverlayView.this.isInBottomArea(event.getRawX(), event.getRawY())) {
                    if (NotiOverlayView.this.isOutsideBottomArea) {
                        NotiOverlayView.this.showLayoutBottom();
                    }
                    NotiOverlayView.this.isOutsideBottomArea = false;
                } else {
                    if (!NotiOverlayView.this.isOutsideBottomArea) {
                        NotiOverlayView.this.hideLayoutBottom();
                    }
                    NotiOverlayView.this.isOutsideBottomArea = true;
                }
                if (NotiOverlayView.this.isInDismissArea(event.getRawX(), event.getRawY())) {
                    NotiOverlayView.this.txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_active, 0, 0);
                    NotiOverlayView.this.txtDismiss.setTextColor(Color.rgb((int)194, (int)39, (int)45));
                } else {
                    NotiOverlayView.this.txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_normal, 0, 0);
                    NotiOverlayView.this.txtDismiss.setTextColor(Color.rgb((int)255, (int)255, (int)255));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onTouchUp(MotionEvent event) {
            try {
                NotiOverlayView.this.floatArea.moveToEdge(true);
                if (event != null) {
                    if (NotiOverlayView.this.isInDismissArea(event.getRawX(), event.getRawY())) {
                        NotiOverlayView.this.hideLayoutBottom();
                        NotiOverlayView.this.layoutFloat.setVisibility(8);
                        NotiOverlayView.this.floatArea.hide();
                    } else {
                        NotiOverlayView.this.hideLayoutBottom();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onClick(MotionEvent event) {
        }

        @Override
        public void onMove(int x, int y) {
            try {
                x = Math.max(0, Math.min(NotiOverlayView.this.boundWidth - NotiOverlayView.this.floatArea.getSizeInPixels(), x));
                y = Math.max(0, Math.min(NotiOverlayView.this.boundHeight - NotiOverlayView.this.relativePositionOnScreen - NotiOverlayView.this.floatArea.getSizeInPixels(), y));
                NotiOverlayView.this.layoutFloat.setX((float)x);
                NotiOverlayView.this.layoutFloat.setY((float)y);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public NotiOverlayView(Activity a) {
        activity = a;
        this.floatArea = new NotiFloatGestureView(activity);
        this.density = DeviceUtils.getDensity((Context)a);
        this.statusBarHeight = DeviceUtils.getStatusBarHeightInPixels((Context)activity);
        this.attachView();
        this.initView();
        this.hide();
    }

    public void attachView() {
        try {
            this.rootView = LayoutInflater.from((Context)activity).inflate(R.layout.noti_float_overlay_view, null);
            WindowManager windowManager = (WindowManager)activity.getApplicationContext().getSystemService("window");
            if (Build.VERSION.SDK_INT >= 26) {
                WindowManager.LayoutParams params = new WindowManager.LayoutParams(-1, -1, 2038, 32, -2);
                params.gravity = 51;
                params.flags = 304;
                windowManager.addView(this.rootView, (ViewGroup.LayoutParams)params);
            } else {
                WindowManager.LayoutParams params = new WindowManager.LayoutParams(-1, -1, 2002, 32, -2);
                params.gravity = 51;
                params.flags = 304;
                windowManager.addView(this.rootView, (ViewGroup.LayoutParams)params);
            }
            this.rootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                @SuppressLint(value={"NewApi"})
                public void onGlobalLayout() {
                    if (NotiOverlayView.this.rootView != null) {
                        NotiOverlayView.this.boundWidth = NotiOverlayView.this.rootView.getWidth();
                        NotiOverlayView.this.boundHeight = NotiOverlayView.this.rootView.getHeight();
                        NotiOverlayView.this.floatArea.setMovableWidth(NotiOverlayView.this.boundWidth);
                        NotiOverlayView.this.floatArea.setMovableHeight(NotiOverlayView.this.boundHeight);
                        Log.e((String)TAG, (String)("boundWidth:" + NotiOverlayView.this.boundWidth + "||boundHeight" + NotiOverlayView.this.boundHeight + "||"));
                        int[] locations = new int[2];
                        NotiOverlayView.this.rootView.getLocationOnScreen(locations);
                        NotiOverlayView.this.relativePositionOnScreen = locations[1];
                        if (Build.VERSION.SDK_INT < 16) {
                            NotiOverlayView.this.rootView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            NotiOverlayView.this.rootView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initView() {
        try {
            this.layoutBottom = this.rootView.findViewById(R.id.layout_bottom_noti);
            this.layoutFloat = this.rootView.findViewById(R.id.layout_float_noti);
            this.txtDismiss = (TextView)this.rootView.findViewById(R.id.txt_dismiss_noti);
            this.floatButton = (ImageView)this.rootView.findViewById(R.id.img_float_noti);
            int imgRes = Res.drawableResource((Context)activity, R.drawable.logotuoi);
            this.floatButton.setImageResource(imgRes);
            this.floatArea.setEventListener(this.mButtonEventListener);
            this.floatArea.moveTo(0, 0);
            this.txtDismiss.setText((CharSequence)Res.string((Context)activity, R.string.dismiss));
            this.rootView.post(new Runnable(){

                @Override
                public void run() {
                    NotiOverlayView.this.layoutBottom.setY((float)(NotiOverlayView.this.boundHeight + NotiOverlayView.this.statusBarHeight) - 125.0f * NotiOverlayView.this.density);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"NewApi"})
    private void showCountdownTimer(int visibility) {
        try {
            TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData((Context)activity);
            if (timerData != null && timerData.getListTimerObject().isEmpty()) {
                return;
            }
            if (this.rootView != null) {
                this.rootView.postInvalidateOnAnimation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateMenu() {
    }

    private boolean isInBottomArea(float left, float top) {
        try {
            int dY = (int)((float)this.boundHeight - 100.0f * this.density);
            return top >= (float)dY || this.isInDismissArea(left, top);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isInDismissArea(float left, float top) {
        try {
            int dX = this.boundWidth / 2;
            int dY = (int)((float)this.boundHeight - 50.0f * this.density);
            double distance = Math.sqrt(Math.pow(left - (float)dX, 2.0) + Math.pow(top - (float)dY, 2.0));
            double maxDistance = Math.min(70.0f * this.density, (float)(this.boundWidth / 5));
            return distance <= maxDistance || top >= (float)dY && (double)left >= (double)dX - maxDistance && (double)left <= (double)dX + maxDistance;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void showLayoutBottom() {
        try {
            this.layoutBottom.setVisibility(0);
            this.layoutBottom.animate().setDuration(200L).y((float)(this.boundHeight + this.statusBarHeight) - 125.0f * this.density);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideLayoutBottom() {
        try {
            this.layoutBottom.animate().setDuration(200L).y((float)(this.boundHeight + this.statusBarHeight));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void show() {
        try {
            this.layoutFloat.setVisibility(0);
            this.layoutBottom.setVisibility(8);
            this.floatArea.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hide() {
        try {
            this.layoutFloat.setVisibility(8);
            this.layoutBottom.setVisibility(8);
            this.floatArea.hide();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isShowing() {
        try {
            return this.layoutFloat.getVisibility() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void dismiss() {
        try {
            this.rootView.setVisibility(8);
            WindowManager windowManager = (WindowManager)activity.getApplicationContext().getSystemService("window");
            windowManager.removeView(this.rootView);
            if (this.floatArea != null) {
                this.floatArea.dismiss();
            }
            this.rootView = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getFloatButtonX() {
        try {
            return this.floatArea.getX();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getFloatButtonY() {
        try {
            return this.floatArea.getY();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

