package com.mobgame.model;

import com.google.gson.annotations.SerializedName;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

public class MobMenuItem {

	@SerializedName("id")
	private int id;

	@SerializedName("sub_menu")
	private ArrayList<SubMenu> listSubMenu;

	@SerializedName("priority")
	private int priority;

	@SerializedName("icon")
	private String icon;

	@SerializedName("icon_active")
	private String iconActive;

	@SerializedName("show")
	private boolean isShow;

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public ArrayList<SubMenu> getSubMenu() {
		return listSubMenu;
	}

	public void setSubMenu(String subMenu) {
		try {
			JSONArray subMenuJSON = new JSONArray(subMenu);
			ArrayList<SubMenu> listSubMenu = new ArrayList<>();
			for (int i = 0 ; i < subMenuJSON.length() ; i ++){
				JSONObject json = subMenuJSON.getJSONObject(i);
				SubMenu _subMenu = new SubMenu();
				if(json.has("id")){
					_subMenu.setSubId(json.getInt("id"));
				}
				if(json.has("priority")){
					_subMenu.setSubPriority(json.getString("priority"));
				}
				if(json.has("title")){
					_subMenu.setTitle(json.getString("title"));
				}
				if(json.has("action")){
					_subMenu.setAction(json.getString("action"));
				}
				listSubMenu.add(_subMenu);

			}

			this.listSubMenu = listSubMenu;
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public int getPriority() {
		return priority;
	}

	public void setPriority(int priority) {
		this.priority = priority;
	}

	public String getIcon() {
		return icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public String getIconActive() {
		return iconActive;
	}

	public void setIconActive(String iconActive) {
		this.iconActive = iconActive;
	}

	public boolean isShow() {
		return isShow;
	}

	public void setShow(boolean show) {
		isShow = show;
	}

	public class SubMenu{
		@SerializedName("id")
		private int subId;

		@SerializedName("priority")
		private String subPriority;

		@SerializedName("title")
		private String title;

		@SerializedName("action")
		private String action;

		public int getSubId() {
			return subId;
		}

		public void setSubId(int subId) {
			this.subId = subId;
		}

		public String getSubPriority() {
			return subPriority;
		}

		public void setSubPriority(String subPriority) {
			this.subPriority = subPriority;
		}

		public String getTitle() {
			return title;
		}

		public void setTitle(String title) {
			this.title = title;
		}

		public String getAction() {
			return action;
		}

		public void setAction(String action) {
			this.action = action;
		}
	}
}