/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.model;

import com.google.gson.annotations.SerializedName;
import com.mobgame.model.MobMenuItem;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MobMenu {
    @SerializedName(value="menu")
    ArrayList<MobMenuItem> menuItems;

    public static MobMenu parse(String json) {
        try {
            ArrayList<MobMenuItem> menuItems = new ArrayList<MobMenuItem>();
            JSONArray menuJsonAray = new JSONArray(json);
            for (int i = 0; i < menuJsonAray.length(); ++i) {
                try {
                    MobMenuItem menuItem = new MobMenuItem();
                    JSONObject menuItemJSON = menuJsonAray.getJSONObject(i);
                    if (menuItemJSON.has("id")) {
                        menuItem.setId(menuItemJSON.getInt("id"));
                    }
                    if (menuItemJSON.has("sub_menu")) {
                        menuItem.setSubMenu(menuItemJSON.getString("sub_menu"));
                    }
                    if (menuItemJSON.has("priority")) {
                        menuItem.setPriority(menuItemJSON.getInt("priority"));
                    }
                    if (menuItemJSON.has("icon")) {
                        menuItem.setIcon(menuItemJSON.getString("icon"));
                    }
                    if (menuItemJSON.has("icon_active")) {
                        menuItem.setIconActive(menuItemJSON.getString("icon_active"));
                    }
                    if (menuItemJSON.has("show")) {
                        menuItem.setShow(menuItemJSON.getBoolean("show"));
                    }
                    menuItems.add(menuItem);
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            MobMenu mobMenu = new MobMenu();
            mobMenu.setMenuItems(menuItems);
            return mobMenu;
        }
        catch (JSONException e) {
            return new MobMenu();
        }
    }

    public ArrayList<MobMenuItem> getMenuItems() {
        if (this.menuItems == null) {
            this.menuItems = new ArrayList();
        }
        return this.menuItems;
    }

    public void setMenuItems(ArrayList<MobMenuItem> menuItems) {
        this.menuItems = menuItems;
    }
}

