/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.notification;

import android.text.TextUtils;
import android.util.Log;
import com.appsflyer.AppsFlyerLib;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdService;
import com.mobgame.MobGameSDK;
import com.mobgame.api.RegisterTokenAndTask;

public class MobFirebaseInstanceIDService
extends FirebaseInstanceIdService {
    private String TAG = "MobFirebaseInstanceIDService";
    private static MobFirebaseInstanceIDService INSTANCE;

    public static MobFirebaseInstanceIDService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MobFirebaseInstanceIDService();
        }
        return INSTANCE;
    }

    public void onTokenRefresh() {
        String refreshedToken = FirebaseInstanceId.getInstance().getToken();
        Log.d((String)this.TAG, (String)("Refreshed token: " + refreshedToken));
        this.sendRegistrationToServer(refreshedToken);
    }

    public void sendRegistrationToServer(String refreshedToken) {
        Log.d((String)this.TAG, (String)("sendToken/RegId to server: " + refreshedToken));
        AppsFlyerLib.getInstance().updateServerUninstallToken(MobGameSDK.getApplicationContext(), refreshedToken);
        if (!TextUtils.isEmpty((CharSequence)refreshedToken)) {
            new RegisterTokenAndTask(refreshedToken).execute(new Void[0]);
        }
    }
}

