/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.dialog;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v13.app.FragmentPagerAdapter;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.view.ViewPager;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.webkit.WebView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.google.gson.Gson;
import com.mobgame.MobGameHelper;
import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.CountdownChronometer;
import com.mobgame.gui.MobGamePagerFragment;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.model.Game;
import com.mobgame.model.MobMenuItem;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
import java.util.ArrayList;
import java.util.Calendar;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MobGameDashboardDialog
extends DialogFragment {
    public static final String TAG = MobGameDashboardDialog.class.getSimpleName();
    public static final String CLOSE_PROGRESS_BAR = "close_progress_bar";
    public static String KEY_DATA = "data";
    public static String KEY_ID = "parent_id";
    public static String KEY_ICON = "icon";
    public static String KEY_TIMER = "key_timer";
    public static String KEY_SHOW = "key_show";
    public static boolean isDashBoard = true;
    EventListener eventListener;
    private ImageButton btnClose;
    private ImageButton btnNew;
    private ImageButton btnGiftcode;
    private ImageButton btnBug;
    private ImageButton btnOther;
    private TextView txtTitle;
    private ImageView imgNtfNew;
    private ImageView imgNtfBug;
    private ImageView imgNtfGiftcode;
    private CountdownChronometer timerDashboard;
    private ProgressBar circleProgressBar;
    private View rootView;
    private View layoutMain;
    private View layoutItemLeft;
    private View layoutChildContent;
    private View layoutTmp;
    private View layoutNew;
    private View layoutGiftCode;
    private View layoutBug;
    private MobGamePagerFragment fragContent;
    private MobPagerAdapter adapter;
    private int currentPage;
    private float density;
    private final String TAG_FRAGMENT = "fragment_webview";
    private String data;
    private String urlIcon;
    private int id;
    private boolean isShow;
    private MobGameWebFragment.EventListener mWebEventListener = new MobGameWebFragment.EventListener(){

        @Override
        @SuppressLint(value={"JavascriptInterface"})
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            try {
                MobGameDashboardDialog.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MobGameWebFragment fragWeb = MobGameDashboardDialog.this.adapter.getItem(MobGameDashboardDialog.this.currentPage);
                        Log.i((String)TAG, (String)("fragContent.countTabs(): " + MobGameDashboardDialog.this.fragContent.countTabs()));
                        if (Utils.isOnline((Context)MobGameDashboardDialog.this.getActivity())) {
                            if (MobGameDashboardDialog.this.fragContent.countTabs() > 1 && !fragWeb.canGoBack()) {
                                MobGameDashboardDialog.this.fragContent.showTabs(false);
                                new Handler().postDelayed(new Runnable(){

                                    @Override
                                    public void run() {
                                    }
                                }, 1000L);
                            } else {
                                MobGameDashboardDialog.this.fragContent.hideTabs(true);
                            }
                        } else if (MobGameDashboardDialog.this.fragContent.countTabs() > 1) {
                            MobGameDashboardDialog.this.fragContent.showTabs(false);
                        } else {
                            MobGameDashboardDialog.this.fragContent.hideTabs(false);
                        }
                    }
                });
                view.addJavascriptInterface((Object)MobGameDashboardDialog.this.getActivity(), "android");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onProgressChanged(WebView view, int progress) {
            int pos = Integer.parseInt((String)view.getTag());
            if (pos == MobGameDashboardDialog.this.currentPage) {
                progress = Math.max(1, progress);
                MobGameDashboardDialog.this.circleProgressBar.setProgress(progress);
                if (progress == 100) {
                    MobGameDashboardDialog.this.hideProgressBar();
                } else {
                    MobGameDashboardDialog.this.showProgressBar();
                }
            }
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            int pos = Integer.parseInt((String)view.getTag());
            if (pos == MobGameDashboardDialog.this.currentPage) {
                MobGameDashboardDialog.this.hideProgressBar();
            }
        }

        @Override
        public void onScrollChanged(WebView view, int l, int t, int oldl, int oldt) {
        }

        @Override
        public void onSizeChanged(WebView view, int w, int h, int oldw, int oldh) {
        }
    };
    private ViewPager.SimpleOnPageChangeListener mOnPageChangeListener = new ViewPager.SimpleOnPageChangeListener(){

        public void onPageSelected(int position) {
            if (position != MobGameDashboardDialog.this.currentPage) {
                MobGameDashboardDialog.this.currentPage = position;
                MobGameWebFragment fragWeb = MobGameDashboardDialog.this.adapter.getItem(MobGameDashboardDialog.this.currentPage);
                fragWeb.loadUrlToLoadIfHave();
                MobGameDashboardDialog.this.mWebEventListener.onScrollChanged(fragWeb.getWebView(), fragWeb.getScrollX(), fragWeb.getScrollY(), fragWeb.getScrollX(), fragWeb.getScrollY());
            }
            int itemId = (int)MobGameDashboardDialog.this.adapter.getItemId(position);
            if (NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), itemId)) {
                NotificationUtils.removeNtf((Context)MobGameDashboardDialog.this.getActivity(), itemId);
                if (!NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), 2) && !NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), 3)) {
                    MobGameDashboardDialog.this.imgNtfNew.setVisibility(8);
                }
                MobGameDashboardDialog.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MobGameDashboardDialog.this.fragContent.notifiTabsChanged();
                    }
                });
            }
        }
    };
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                String category = intent.getStringExtra("category");
                if ("gcm".equalsIgnoreCase(category)) {
                    String strId = intent.getStringExtra("id");
                    Log.d((String)TAG, (String)("funtap :" + strId));
                    if (strId != null) {
                        MobGameDashboardDialog.this.fragContent.notifiTabsChanged();
                    }
                    int id2 = Integer.parseInt(strId);
                    if (NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), id2)) {
                        switch (id2) {
                            case 1: 
                            case 2: 
                            case 3: {
                                MobGameDashboardDialog.this.imgNtfNew.setVisibility(0);
                                break;
                            }
                            case 4: 
                            case 5: {
                                MobGameDashboardDialog.this.imgNtfGiftcode.setVisibility(0);
                                break;
                            }
                            case 6: 
                            case 7: {
                                MobGameDashboardDialog.this.imgNtfBug.setVisibility(0);
                            }
                        }
                    }
                } else if ("swipe_refresh".equalsIgnoreCase(category)) {
                    String strId = intent.getStringExtra("id");
                    int id3 = Integer.parseInt(strId);
                    switch (id3) {
                        case 1: 
                        case 2: 
                        case 3: {
                            if (!NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), id3)) break;
                            NotificationUtils.removeNtf((Context)MobGameDashboardDialog.this.getActivity(), id3);
                            MobGameDashboardDialog.this.imgNtfNew.setVisibility(8);
                            break;
                        }
                        case 4: 
                        case 5: {
                            if (NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), 4)) {
                                NotificationUtils.removeNtf((Context)MobGameDashboardDialog.this.getActivity(), 4);
                                MobGameDashboardDialog.this.imgNtfGiftcode.setVisibility(8);
                            }
                            if (!NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), 5)) break;
                            NotificationUtils.removeNtf((Context)MobGameDashboardDialog.this.getActivity(), 5);
                            MobGameDashboardDialog.this.imgNtfGiftcode.setVisibility(8);
                            break;
                        }
                        case 6: 
                        case 7: {
                            if (NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), 6)) {
                                NotificationUtils.removeNtf((Context)MobGameDashboardDialog.this.getActivity(), 6);
                                MobGameDashboardDialog.this.imgNtfBug.setVisibility(8);
                            }
                            if (!NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), 7)) break;
                            NotificationUtils.removeNtf((Context)MobGameDashboardDialog.this.getActivity(), 7);
                            MobGameDashboardDialog.this.imgNtfBug.setVisibility(8);
                        }
                    }
                    MobGameDashboardDialog.this.fragContent.notifiTabsChanged();
                }
                if (intent.hasExtra(MobGameDashboardDialog.CLOSE_PROGRESS_BAR)) {
                    MobGameDashboardDialog.this.circleProgressBar.setVisibility(8);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private FirebaseAnalytics mFirebaseAnalytics;

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.eventListener != null) {
            this.eventListener.onDismissDashboard();
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootView = inflater.inflate(R.layout.dialog_dashboard, container, false);
        try {
            int dialogSize = DeviceUtils.getScreenHeightInPixels(this.rootView.getContext()) > DeviceUtils.getScreenWidthInPixels(this.rootView.getContext()) ? DeviceUtils.getScreenWidthInPixels(this.rootView.getContext()) : DeviceUtils.getScreenHeightInPixels(this.rootView.getContext());
            if (DeviceUtils.getScreenOrientation(this.rootView.getContext()) == 2) {
                LinearLayout leftDrawerLayout = (LinearLayout)this.rootView.findViewById(R.id.left_drawer);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(dialogSize, -1);
                leftDrawerLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
            } else {
                LinearLayout leftDrawerLayout = (LinearLayout)this.rootView.findViewById(R.id.left_drawer);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, dialogSize);
                leftDrawerLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getDialog().getWindow().setFlags(1024, 1024);
        this.getDialog().requestWindowFeature(1);
        isDashBoard = true;
        this.getDialog().getWindow().setWindowAnimations(R.style.DialogAnimationLeftIn);
        this.density = DeviceUtils.getDensity((Context)this.getActivity());
        long endTime = this.getArguments().getLong(KEY_TIMER);
        this.initViewLayout(endTime);
        this.initFragment();
        return this.rootView;
    }

    private void initLeftLayout(ArrayList<MobMenuItem> listMenuItems) {
        try {
            if (!NotificationUtils.hasNtf((Context)this.getActivity(), 2) && !NotificationUtils.hasNtf((Context)this.getActivity(), 3)) {
                this.imgNtfNew.setVisibility(8);
            }
            ArrayList listSubMenu = new ArrayList();
            block8: for (int i = 0; i < listMenuItems.size(); ++i) {
                int id2 = listMenuItems.get(i).getId();
                switch (id2) {
                    case 1: {
                        Glide.with((Activity)this.getActivity()).load(listMenuItems.get(i).getIcon()).into((ImageView)this.btnNew);
                        this.txtTitle.setVisibility(8);
                        continue block8;
                    }
                    case 4: {
                        Glide.with((Activity)this.getActivity()).load(listMenuItems.get(i).getIcon()).into((ImageView)this.btnGiftcode);
                        this.txtTitle.setVisibility(0);
                        continue block8;
                    }
                    case 6: {
                        Glide.with((Activity)this.getActivity()).load(listMenuItems.get(i).getIcon()).into((ImageView)this.btnBug);
                        this.txtTitle.setVisibility(0);
                        continue block8;
                    }
                    case 8: {
                        Glide.with((Activity)this.getActivity()).load(listMenuItems.get(i).getIcon()).into((ImageView)this.btnOther);
                        this.txtTitle.setVisibility(0);
                    }
                }
            }
            if (listSubMenu == null) {
                Log.d((String)TAG, (String)"SubMenu null");
                return;
            }
            this.txtTitle.setVisibility(8);
            JSONArray items = null;
            this.data = new Gson().toJson(listSubMenu).toString();
            Log.d((String)TAG, (String)("data news:" + this.data));
            items = new JSONArray(this.data);
            this.loadUrls(items);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void initFragment() {
        try {
            this.fragContent = new MobGamePagerFragment(this.getActivity());
            this.fragContent.addOnPageChangeListener(this.mOnPageChangeListener);
            this.fragContent.setWebEventListener(this.mWebEventListener);
            this.getChildFragmentManager().beginTransaction().add(this.layoutChildContent.getId(), (Fragment)this.fragContent, "fragment_webview").commit();
            try {
                this.data = this.getArguments().getString(KEY_DATA);
                this.id = this.getArguments().getInt(KEY_ID);
                this.urlIcon = this.getArguments().getString(KEY_ICON);
                this.isShow = this.getArguments().getBoolean(KEY_SHOW);
                Log.d((String)TAG, (String)("data : " + this.data));
                JSONArray items = new JSONArray(this.data);
                switch (this.id) {
                    case 1: {
                        this.btnNew.setColorFilter(this.getActivity().getResources().getColor(R.color.active_icon));
                        this.txtTitle.setVisibility(8);
                        break;
                    }
                    case 4: {
                        this.btnGiftcode.setColorFilter(this.getActivity().getResources().getColor(R.color.active_icon));
                        this.txtTitle.setVisibility(0);
                        break;
                    }
                    case 6: {
                        this.btnBug.setColorFilter(this.getActivity().getResources().getColor(R.color.active_icon));
                        this.txtTitle.setVisibility(0);
                        break;
                    }
                    case 8: {
                        this.btnOther.setColorFilter(this.getActivity().getResources().getColor(R.color.active_icon));
                        this.txtTitle.setVisibility(0);
                    }
                }
                this.loadUrls(items);
            }
            catch (Exception e) {
                try {
                    this.performOnItemClick(0);
                }
                catch (IndexOutOfBoundsException | NullPointerException e2) {
                    this.performOnItemClick(0);
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initViewLayout(long endTimer) {
        try {
            this.layoutTmp = this.rootView.findViewById(R.id.layout_tmp);
            this.layoutMain = this.rootView.findViewById(R.id.layout_main_dashboard);
            this.layoutItemLeft = this.rootView.findViewById(R.id.layout_item_left);
            this.layoutChildContent = this.rootView.findViewById(R.id.layout_child_content);
            this.layoutNew = this.rootView.findViewById(R.id.layout_new);
            this.layoutGiftCode = this.rootView.findViewById(R.id.layout_giftcode);
            this.layoutBug = this.rootView.findViewById(R.id.layout_bug);
            this.btnClose = (ImageButton)this.rootView.findViewById(R.id.btn_close_dashboard);
            this.btnNew = (ImageButton)this.rootView.findViewById(R.id.btn_new_event);
            this.btnGiftcode = (ImageButton)this.rootView.findViewById(R.id.btn_giftcode);
            this.btnBug = (ImageButton)this.rootView.findViewById(R.id.btn_bug);
            this.btnOther = (ImageButton)this.rootView.findViewById(R.id.btn_show_more);
            this.timerDashboard = (CountdownChronometer)this.rootView.findViewById(R.id.countdown_timer_new);
            this.txtTitle = (TextView)this.rootView.findViewById(R.id.title_item);
            this.circleProgressBar = (ProgressBar)this.rootView.findViewById(R.id.circle_progress_bar);
            this.imgNtfNew = (ImageView)this.rootView.findViewById(R.id.img_ntf_new);
            this.imgNtfGiftcode = (ImageView)this.rootView.findViewById(R.id.img_ntf_giftcode);
            this.imgNtfBug = (ImageView)this.rootView.findViewById(R.id.img_ntf_bug);
            this.visibleViewNtf(this.getActivity());
            this.invisibleItemDashboard();
            this.imgNtfGiftcode.setVisibility(8);
            this.setTimeForDashboard(endTimer);
            final ArrayList<MobMenuItem> listMenuItems = GameConfigManager.getInstance().getMobMenu().getMenuItems();
            this.initLeftLayout(listMenuItems);
            this.btnClose.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    isDashBoard = false;
                    Log.d((String)TAG, (String)"Close button clicked");
                    MobGameDashboardDialog.this.dismiss();
                    Game game = GameConfigManager.getInstance().getGameConfig();
                    boolean isShowLogo = game.getEx().isShowLogo();
                    if (isShowLogo) {
                        MobGameHelper.showNotiFloatButton(game.getEx());
                    }
                    Preference.remove((Context)MobGameDashboardDialog.this.getActivity(), "shared_pref_show_dashboard");
                    MobGameHelper.showFloatButton();
                }
            });
            this.btnNew.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MobGameDashboardDialog.this.showTabs();
                    isDashBoard = true;
                    MobGameDashboardDialog.this.trackEventFromButton("event_news_event", "root_news_event");
                    MobGameDashboardDialog.this.timerDashboard.setTextColor(Color.parseColor((String)"#f14308"));
                    String data = "";
                    try {
                        if (!NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), 2) && !NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), 3)) {
                            MobGameDashboardDialog.this.imgNtfNew.setVisibility(8);
                        }
                        ArrayList<Object> listSubMenu = new ArrayList();
                        block8: for (int i = 0; i < listMenuItems.size(); ++i) {
                            int id2 = ((MobMenuItem)listMenuItems.get(i)).getId();
                            switch (id2) {
                                case 1: {
                                    listSubMenu = ((MobMenuItem)listMenuItems.get(i)).getSubMenu();
                                    MobGameDashboardDialog.this.btnNew.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.active_icon));
                                    continue block8;
                                }
                                case 4: {
                                    MobGameDashboardDialog.this.btnGiftcode.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.deactive_icon));
                                    continue block8;
                                }
                                case 6: {
                                    MobGameDashboardDialog.this.btnBug.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.deactive_icon));
                                    continue block8;
                                }
                                case 8: {
                                    MobGameDashboardDialog.this.btnOther.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.deactive_icon));
                                }
                            }
                        }
                        if (listSubMenu == null) {
                            Log.d((String)TAG, (String)"SubMenu null");
                            return;
                        }
                        MobGameDashboardDialog.this.txtTitle.setVisibility(8);
                        JSONArray items = null;
                        data = new Gson().toJson(listSubMenu).toString();
                        Log.d((String)TAG, (String)("data news:" + data));
                        items = new JSONArray(data);
                        MobGameDashboardDialog.this.loadUrls(items);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.btnGiftcode.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MobGameDashboardDialog.this.hideTabs();
                    isDashBoard = false;
                    MobGameDashboardDialog.this.trackEventFromButton("event_giftcode", "root_giftcode");
                    MobGameDashboardDialog.this.timerDashboard.setTextColor(Color.parseColor((String)"#7a7a7a"));
                    String data = "";
                    try {
                        if (NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), 5)) {
                            NotificationUtils.removeNtf((Context)MobGameDashboardDialog.this.getActivity(), 5);
                        }
                        if (NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), 4)) {
                            NotificationUtils.removeNtf((Context)MobGameDashboardDialog.this.getActivity(), 4);
                        }
                        MobGameDashboardDialog.this.imgNtfGiftcode.setVisibility(8);
                        ArrayList<Object> listSubMenu = new ArrayList();
                        block8: for (int i = 0; i < listMenuItems.size(); ++i) {
                            int id2 = ((MobMenuItem)listMenuItems.get(i)).getId();
                            switch (id2) {
                                case 1: {
                                    MobGameDashboardDialog.this.btnNew.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.deactive_icon));
                                    continue block8;
                                }
                                case 4: {
                                    listSubMenu = ((MobMenuItem)listMenuItems.get(i)).getSubMenu();
                                    MobGameDashboardDialog.this.btnGiftcode.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.active_icon));
                                    continue block8;
                                }
                                case 6: {
                                    MobGameDashboardDialog.this.btnBug.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.deactive_icon));
                                    continue block8;
                                }
                                case 8: {
                                    MobGameDashboardDialog.this.btnOther.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.deactive_icon));
                                }
                            }
                        }
                        if (listSubMenu == null) {
                            Log.d((String)TAG, (String)"SubMenu null");
                            return;
                        }
                        MobGameDashboardDialog.this.txtTitle.setVisibility(0);
                        JSONArray items = null;
                        data = new Gson().toJson(listSubMenu).toString();
                        Log.d((String)TAG, (String)("data giftcode :" + data));
                        items = new JSONArray(data);
                        MobGameDashboardDialog.this.loadUrls(items);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.btnBug.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MobGameDashboardDialog.this.hideTabs();
                    isDashBoard = false;
                    MobGameDashboardDialog.this.trackEventFromButton("event_report_bugs", "root_report_bugs");
                    MobGameDashboardDialog.this.timerDashboard.setTextColor(Color.parseColor((String)"#7a7a7a"));
                    String data = "";
                    try {
                        if (NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), 7)) {
                            NotificationUtils.removeNtf((Context)MobGameDashboardDialog.this.getActivity(), 7);
                        }
                        if (NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), 6)) {
                            NotificationUtils.removeNtf((Context)MobGameDashboardDialog.this.getActivity(), 6);
                        }
                        MobGameDashboardDialog.this.imgNtfBug.setVisibility(8);
                        ArrayList<Object> listSubMenu = new ArrayList();
                        block8: for (int i = 0; i < listMenuItems.size(); ++i) {
                            int id2 = ((MobMenuItem)listMenuItems.get(i)).getId();
                            if (id2 == 6) {
                                listSubMenu = ((MobMenuItem)listMenuItems.get(i)).getSubMenu();
                            }
                            switch (id2) {
                                case 1: {
                                    MobGameDashboardDialog.this.btnNew.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.deactive_icon));
                                    continue block8;
                                }
                                case 4: {
                                    MobGameDashboardDialog.this.btnGiftcode.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.deactive_icon));
                                    continue block8;
                                }
                                case 6: {
                                    listSubMenu = ((MobMenuItem)listMenuItems.get(i)).getSubMenu();
                                    MobGameDashboardDialog.this.btnBug.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.active_icon));
                                    continue block8;
                                }
                                case 8: {
                                    MobGameDashboardDialog.this.btnOther.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.deactive_icon));
                                }
                            }
                        }
                        if (listSubMenu == null) {
                            Log.d((String)TAG, (String)"SubMenu null");
                            return;
                        }
                        MobGameDashboardDialog.this.txtTitle.setVisibility(0);
                        JSONArray items = null;
                        data = new Gson().toJson(listSubMenu).toString();
                        Log.d((String)TAG, (String)("data report bug :" + data));
                        items = new JSONArray(data);
                        MobGameDashboardDialog.this.loadUrls(items);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.btnOther.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MobGameDashboardDialog.this.hideTabs();
                    isDashBoard = false;
                    MobGameDashboardDialog.this.timerDashboard.setTextColor(Color.parseColor((String)"#7a7a7a"));
                    String data = "";
                    try {
                        ArrayList<Object> listSubMenu = new ArrayList();
                        block8: for (int i = 0; i < listMenuItems.size(); ++i) {
                            int id2 = ((MobMenuItem)listMenuItems.get(i)).getId();
                            switch (id2) {
                                case 1: {
                                    MobGameDashboardDialog.this.btnNew.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.deactive_icon));
                                    continue block8;
                                }
                                case 4: {
                                    MobGameDashboardDialog.this.btnGiftcode.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.deactive_icon));
                                    continue block8;
                                }
                                case 6: {
                                    MobGameDashboardDialog.this.btnBug.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.deactive_icon));
                                    continue block8;
                                }
                                case 8: {
                                    listSubMenu = ((MobMenuItem)listMenuItems.get(i)).getSubMenu();
                                    MobGameDashboardDialog.this.btnOther.setColorFilter(MobGameDashboardDialog.this.getActivity().getResources().getColor(R.color.active_icon));
                                }
                            }
                        }
                        if (listSubMenu == null) {
                            Log.d((String)TAG, (String)"SubMenu null");
                            return;
                        }
                        MobGameDashboardDialog.this.txtTitle.setVisibility(0);
                        JSONArray items = null;
                        data = new Gson().toJson(listSubMenu).toString();
                        Log.d((String)TAG, (String)("data show more :" + data));
                        items = new JSONArray(data);
                        MobGameDashboardDialog.this.loadUrls(items);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.layoutTmp.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        Log.d((String)TAG, (String)"tmp clicked");
                        MobGameDashboardDialog.this.dismiss();
                        Game game = GameConfigManager.getInstance().getGameConfig();
                        boolean isShowLogo = game.getEx().isShowLogo();
                        if (isShowLogo) {
                            MobGameHelper.showNotiFloatButton(game.getEx());
                        }
                        Preference.remove((Context)MobGameDashboardDialog.this.getActivity(), "shared_pref_show_dashboard");
                        Intent intent = new Intent("com.mobgame.broadcast");
                        intent.putExtra("category", "float_button");
                        LocalBroadcastManager.getInstance((Context)MobGameDashboardDialog.this.getActivity()).sendBroadcast(intent);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            Animation animationTmp = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.fade_in);
            this.layoutTmp.setAnimation(animationTmp);
            this.getDialog().setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    if (event != null && keyCode == 4 && event.getAction() == 1) {
                        MobGameDashboardDialog.this.dismiss();
                        Game game = GameConfigManager.getInstance().getGameConfig();
                        boolean isShowLogo = game.getEx().isShowLogo();
                        if (isShowLogo) {
                            MobGameHelper.showNotiFloatButton(game.getEx());
                        }
                        Preference.remove((Context)MobGameDashboardDialog.this.getActivity(), "shared_pref_show_dashboard");
                        MobGameHelper.showFloatButton();
                        return true;
                    }
                    return false;
                }
            });
            Preference.save((Context)this.getActivity(), "shared_pref_show_dashboard", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showTabs() {
        try {
            if (this.fragContent != null) {
                this.fragContent.showTabs(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideTabs() {
        try {
            if (this.fragContent != null) {
                this.fragContent.hideTabs(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void invisibleItemDashboard() {
        try {
            ArrayList<Object> mobMenuItems = new ArrayList();
            mobMenuItems = GameConfigManager.getInstance().getMobMenu().getMenuItems();
            block14: for (int i = 0; i < mobMenuItems.size(); ++i) {
                if (((MobMenuItem)mobMenuItems.get(i)).isShow()) {
                    switch (((MobMenuItem)mobMenuItems.get(i)).getId()) {
                        case 1: {
                            this.layoutNew.setVisibility(0);
                            break;
                        }
                        case 4: {
                            this.layoutGiftCode.setVisibility(0);
                            break;
                        }
                        case 6: {
                            this.layoutBug.setVisibility(0);
                            break;
                        }
                        case 8: {
                            this.btnOther.setVisibility(0);
                        }
                    }
                    continue;
                }
                switch (((MobMenuItem)mobMenuItems.get(i)).getId()) {
                    case 1: {
                        this.layoutNew.setVisibility(8);
                        continue block14;
                    }
                    case 4: {
                        this.layoutGiftCode.setVisibility(8);
                        continue block14;
                    }
                    case 6: {
                        this.layoutBug.setVisibility(8);
                        continue block14;
                    }
                    case 8: {
                        this.btnOther.setVisibility(8);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void visibleViewNtf(Activity activity) {
        try {
            Log.d((String)TAG, (String)("ID : " + NotificationUtils.hasNtf((Context)activity)));
            if (NotificationUtils.hasNtf((Context)activity, 2) || NotificationUtils.hasNtf((Context)activity, 3)) {
                this.imgNtfNew.setVisibility(0);
            }
            if (NotificationUtils.hasNtf((Context)activity, 5) || NotificationUtils.hasNtf((Context)activity, 4)) {
                this.imgNtfGiftcode.setVisibility(0);
            }
            if (NotificationUtils.hasNtf((Context)activity, 7) || NotificationUtils.hasNtf((Context)activity, 6)) {
                this.imgNtfBug.setVisibility(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setTimeForDashboard(long endTime) {
        try {
            long countDownTimer = endTime - Calendar.getInstance().getTimeInMillis();
            if (countDownTimer > 0L) {
                this.timerDashboard.setVisibility(0);
            } else {
                this.timerDashboard.setVisibility(8);
            }
            this.timerDashboard.setBase(Calendar.getInstance().getTime().getTime() + countDownTimer);
            this.timerDashboard.setCountdownListener(new CountdownChronometer.CountdownListener(){

                @Override
                public void done() {
                    if (MobGameDashboardDialog.this.timerDashboard != null) {
                        MobGameDashboardDialog.this.timerDashboard.setVisibility(8);
                    }
                    Log.e((String)TAG, (String)"Vao cmn day roi");
                }
            });
            this.timerDashboard.start();
            this.timerDashboard.setTextColor(Color.parseColor((String)"#f14308"));
            this.timerDashboard.setTextSize(9.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        this.setStyle(1, 0x1030010);
        super.onCreate(savedInstanceState);
    }

    private void performOnItemClick(int position) {
    }

    public void loadUrls(JSONArray items) {
        JSONObject item;
        int i;
        Log.e((String)TAG, (String)("item:" + items.toString()));
        if (this.adapter == null) {
            this.adapter = new MobPagerAdapter(this.getChildFragmentManager());
        }
        this.currentPage = 0;
        JSONArray revItems = new JSONArray();
        for (i = 0; i < items.length(); ++i) {
            try {
                item = items.getJSONObject(i);
                revItems.put((Object)item);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (i = items.length() - 1; i >= 0; --i) {
            try {
                item = revItems.getJSONObject(i);
                if (item.getInt("priority") >= revItems.getJSONObject(this.currentPage).getInt("priority")) continue;
                this.currentPage = i;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.adapter.setItems(revItems);
            this.fragContent.setAdapter(this.adapter, this.currentPage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void show(FragmentManager manager, String tag) {
        try {
            FragmentTransaction ft = manager.beginTransaction();
            ft.add((Fragment)this, tag);
            ft.commitAllowingStateLoss();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void onPause() {
        super.onPause();
        this.circleProgressBar.setVisibility(8);
        try {
            LocalBroadcastManager.getInstance((Context)this.getActivity()).unregisterReceiver(this.mBroadcastReceiver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onResume() {
        super.onResume();
        try {
            LocalBroadcastManager.getInstance((Context)this.getActivity()).registerReceiver(this.mBroadcastReceiver, new IntentFilter("com.mobgame.broadcast"));
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "float_button");
            intent.putExtra("message", "hide");
            LocalBroadcastManager.getInstance((Context)this.getActivity()).sendBroadcast(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideProgressBar() {
        try {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MobGameDashboardDialog.this.circleProgressBar.setVisibility(8);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showProgressBar() {
        try {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MobGameDashboardDialog.this.circleProgressBar.setVisibility(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void trackEventFromButton(String eventName, String data) {
        try {
            Log.d((String)TAG, (String)("event : " + eventName + " , data : " + data));
            this.mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)this.getActivity());
            Bundle bundle = new Bundle();
            bundle.putString("data", data);
            this.mFirebaseAnalytics.logEvent(eventName, bundle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    public static interface EventListener {
        public void onDismissDashboard();
    }

    private class MobPagerAdapter
    extends FragmentPagerAdapter {
        private ArrayList<MobGameWebFragment> fragments;
        private FragmentManager fragmentManager;
        private JSONArray items;

        public MobPagerAdapter(FragmentManager fm) {
            super(fm);
            this.fragments = new ArrayList();
            this.fragmentManager = fm;
        }

        public void setItems(JSONArray items) {
            this.releaseFragments();
            this.items = items;
            this.fragments = new ArrayList();
            for (int i = 0; i < items.length(); ++i) {
                try {
                    JSONObject item = items.getJSONObject(i);
                    String url = item.getString("action");
                    int id2 = item.getInt("id");
                    MobGameWebFragment frag = i == MobGameDashboardDialog.this.currentPage ? new MobGameWebFragment(url, id2) : new MobGameWebFragment(url, true, id2);
                    frag.setEventListener(MobGameDashboardDialog.this.mWebEventListener);
                    frag.setWebViewTag(i + "");
                    this.fragments.add(frag);
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }

        public MobGameWebFragment getItem(int position) {
            try {
                return this.fragments.get(position);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getCount() {
            try {
                return this.fragments.size();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public long getItemId(int position) {
            try {
                return this.items.getJSONObject(position).getInt("id");
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1L;
            }
        }

        public int getItemPosition(Object object) {
            return -2;
        }

        public CharSequence getPageTitle(int position) {
            try {
                JSONObject item = this.items.getJSONObject(position);
                int id2 = item.getInt("id");
                if (item.has("title")) {
                    String title = item.getString("title");
                    MobGameDashboardDialog.this.txtTitle.setText((CharSequence)title.toString());
                    if (NotificationUtils.hasNtf((Context)MobGameDashboardDialog.this.getActivity(), id2)) {
                        Drawable image = Res.drawable((Context)MobGameDashboardDialog.this.getActivity(), R.drawable.ic_notification_tab_strip);
                        image.setBounds(0, 0, image.getIntrinsicWidth(), image.getIntrinsicHeight());
                        SpannableString sb = new SpannableString((CharSequence)(title + "  "));
                        ImageSpan imageSpan = new ImageSpan(image, 1);
                        sb.setSpan((Object)imageSpan, title.length() + 1, title.length() + 2, 18);
                        return sb;
                    }
                    return title;
                }
                return "Tab " + position;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "Tab " + position;
            }
        }

        private void releaseFragments() {
            try {
                if (this.fragments != null) {
                    for (MobGameWebFragment frag : this.fragments) {
                        frag.stopLoading();
                        this.fragmentManager.beginTransaction().remove((Fragment)frag).commit();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

