package com.mobgame.js;

import android.app.Activity;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;

import com.facebook.AccessToken;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.mobgame.MobGameHelper;
import com.mobgame.R;
import com.mobgame.api.PostTask;
import com.mobgame.api.PostTask.Callback;
import com.mobgame.component.EventClientManager;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAuthManager;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.gui.dialog.MobGameDialogWebviewFragment;
import com.mobgame.model.MobAccessToken;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Set;


final class CmdLogin {

	private static final String TAG = CmdLogin.class.getSimpleName();
	private static CmdLogin INSTANCE;

	private CmdLogin() {}
	
	public static CmdLogin getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new CmdLogin();
		}
		return INSTANCE;
	}

	void mobLoginSuccess(final Activity activity, MobGameWebFragment webFragment, MobGameDialogWebviewFragment dialogWebviewFragment, String params) {
		try{

			JSONObject json = new JSONObject(params);
			String user = json.getString("User");
			JSONObject jsonUser = new JSONObject(user);
			int is_register = -1;
			String register_name = "";
			if(jsonUser.has("is_register")){
				is_register = jsonUser.getInt("is_register");
			}
			if(jsonUser.has("register_name")){
				register_name = jsonUser.getString("register_name");
			}
			Log.i(TAG, "mobLoginSuccess :"  + is_register + " , "+ register_name);

			if(is_register == 1){
				FunTrackingUtil.getInstance().trackRegisterSuccess(activity , register_name);
			}else{
				FunTrackingUtil.getInstance().trackLoginSuccessFromWeb(activity , register_name);
			}
			Utils.hideLoading();
			MobAccessToken accessToken = MobAccessToken.parse(params);
			GameConfigManager.getInstance().setAccessToken(accessToken.getToken());
			EventClientManager.getInstance(activity).setMobgameToken(accessToken.getToken());
			if(MobGameHelper.isShowingDashboard()){
				MobGameHelper.hideDashboard();
			}
			if(dialogWebviewFragment!=null){
				dialogWebviewFragment.dismiss();
			}

			Intent intent = new Intent(Constants.INTENT_FILTER);
			intent.putExtra("category", "login");
			LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	void mobLoginGuest(final Activity activity, MobGameWebFragment webFragment, String params) {
		Log.i(TAG, "mobLoginGuest");
		HashMap<String , Object> map = new HashMap<>();
		map.put("TYPE_LOGIN" , "Login PlayNow");
		FunTrackingUtil.getInstance().trackLoginClick(activity , FunTrackingUtil.TRACK_LOGIN_CLICKED , map);
		try {
			Utils.showLoading(activity, Res.string(activity, R.string.logging_in));
			String mac_address = DeviceUtils.getUniqueDeviceID(activity);
			String key = Utils.getSHACheckSum(mac_address + "abc");

			HashMap<String, String> postParams = new HashMap<String, String>();
			postParams.put("mac_address", mac_address);
			postParams.put("key", key);
			webFragment.postUrlWithMobHeaders(Constants.URL_RECEIVE_MAC_ADDRESS, postParams, new PostTask.Callback() {
				
				@Override
				public void onSuccess(String response) {
					Utils.hideLoading();
				}
				
				@Override
				public void onFailure(Throwable e) {
					e.printStackTrace();
					handleException(activity, Res.string(activity, R.string.something_went_wrong));
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
			handleException(activity, Res.string(activity, R.string.something_went_wrong));
		}
	}

	void mobLoginFacebook(final Activity activity, final MobGameWebFragment webFragment, String params) {
		Log.i(TAG, "mobLoginStartFb:" + params);
		HashMap<String , Object> map = new HashMap<>();
		map.put("TYPE_LOGIN" ,"Login FB");
		FunTrackingUtil.getInstance().trackLoginClick(activity , FunTrackingUtil.TRACK_LOGIN_CLICKED , map);
		Utils.showLoading(activity, "", Res.string(activity, R.string.connecting_facebook), false);
		
		FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback() {

			@Override
			public void onSuccess(AccessToken accessToken,
					Set<String> recentlyGrantedPermissions,
					Set<String> recentlyDeniedPermissions) {

				try {
					HashMap<String, String> postParams = new HashMap<String, String>();
					postParams.put("access_token", accessToken.getToken());
					webFragment.postUrlWithMobHeaders(Constants.URL_RECEIVE_ACCESS_TOKEN, postParams, new Callback() {
						
						@Override
						public void onSuccess(String response) {
							Utils.hideLoading();
						}
						
						@Override
						public void onFailure(Throwable e) {
							Utils.hideLoading();
						}
					});
				} catch (Exception e) {
					handleException(activity, Res.string(activity, R.string.something_went_wrong));
					Utils.hideLoading();
				}
				
			}

			@Override
			public void onCancel() {
				Utils.hideLoading();
			}

			@Override
			public void onError(Throwable t) {
				Utils.hideLoading();
				handleException(activity, Res.string(activity, R.string.something_went_wrong));
			}

		});
	}

	void mobUpgradeFacebook(final Activity activity, final MobGameWebFragment webFragment ,final MobGameDialogWebviewFragment webDialogFragment, String params) {
		Log.i(TAG, "mobFacebookForUpdate:" + params);
		Utils.showLoading(activity, Res.string(activity, R.string.connecting_facebook));
		
		FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback() {

			@Override
			public void onSuccess(AccessToken accessToken,
					Set<String> recentlyGrantedPermissions,
					Set<String> recentlyDeniedPermissions) {

				Utils.hideLoading();
				try {
					HashMap<String, String> postParams = new HashMap<String, String>();
					postParams.put("token", accessToken.getToken());
					if(webDialogFragment != null){
						webDialogFragment.postUrlWithMobHeaders(Constants.URL_UPDATE_FROM_FACEBOOK, postParams);
//						webDialogFragment.dismiss();
					}else if(webFragment != null){
						webFragment.postUrlWithMobHeaders(Constants.URL_UPDATE_FROM_FACEBOOK, postParams);
					}
				} catch (Exception e) {
					handleException(activity, Res.string(activity, R.string.something_went_wrong));
				} 
			
			}

			@Override
			public void onCancel() {
				Utils.hideLoading();
			}

			@Override
			public void onError(Throwable t) {
				Utils.hideLoading();
			}
			
		});
	}

	void mobLoginGooglePlay(final Activity activity, final MobGameWebFragment webFragment, String params) {
		Log.i(TAG, "mobLoginGooglePlay");
		HashMap<String , Object> map = new HashMap<>();
		map.put("TYPE_LOGIN" , "Login GG");
		FunTrackingUtil.getInstance().trackLoginClick(activity , FunTrackingUtil.TRACK_LOGIN_CLICKED , map);
		if(!Utils.isOnline(activity)){
			handleException(activity, Res.string(activity, R.string.connection_lost));
			return;
		}

		if(!GoogleAuthManager.getInstance().isGoogleServiceAvailable(activity)){
			Log.d(TAG, "Google Play Service is out of date. Request update...");
			return;
		}
		Utils.showLoading(activity, "", Res.string(activity, R.string.connecting_google_play), true);

		GoogleAuthManager.getInstance().login(activity,new GoogleAuthManager.GooglePlusResultCallback() {


			@Override
			public void onLoginSuccess(GoogleSignInAccount account, String mToken) {
				Log.d(TAG, "Google Token: " + mToken);

				try {
					HashMap<String, String> postParams = new HashMap<String, String>();
					postParams.put("id_token", mToken);
					webFragment.postUrlWithMobHeaders(Constants.URL_LOGIN_GOOGLE_ACCOUNT,
							postParams, new PostTask.Callback() {
								@Override
								public void onSuccess(String response) {
									Log.d(TAG, "Google Login Success");
									getFullResponse(response);
									Utils.hideLoading();
								}

								@Override
								public void onFailure(Throwable e) {
									Log.wtf("onFailure", e.getLocalizedMessage());
									Utils.hideLoading();
								}
							});

				} catch (Exception e) {
					e.printStackTrace();
					handleException(activity, Res.string(activity, R.string.something_went_wrong));
					e.printStackTrace();
					Utils.hideLoading();
				}
				Log.wtf("mobLoginGooglePlay", "onLoginSuccess: Token: " + mToken + " Email: " + account.getEmail());
			}

			@Override
			public void onLoginError(String mess) {
//				Log.wtf("mobLoginGooglePlay", "Error: " + mess);
				Log.e(TAG , "Sign in google error");
				if(!TextUtils.isEmpty(mess)){
					handleException(activity, mess);
				}

				Utils.hideLoading();

			}

		});

	}
	private void getFullResponse(String sb){
		try {
			if (sb.length() > 4000) {
				Log.wtf("onResponse", "sb.length = " + sb.length());
				int chunkCount = sb.length() / 4000;     // integer division
				for (int i = 0; i <= chunkCount; i++) {
					int max = 4000 * (i + 1);
					if (max >= sb.length()) {
						Log.wtf("onResponse", "chunk " + i + " of " + chunkCount + ":" + sb.substring(4000 * i));
					} else {
						Log.wtf("onResponse", "chunk " + i + " of " + chunkCount + ":" + sb.substring(4000 * i, max));
					}
				}
			} else {
				Log.wtf(TAG, sb.toString());
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	void mobLoginGoogleAccount(Activity activity, MobGameWebFragment webFragment, String params) {
		Log.i(TAG, "mobLoginGoogleAccount");
	}
	
	private void handleException(final Activity activity, final String message) {
		Utils.hideLoading();
		activity.runOnUiThread(new Runnable() {
			
			@Override
			public void run() {
				Toast.makeText(activity, message, Toast.LENGTH_LONG).show();
			}
		});
		
		Intent intent = new Intent(Constants.INTENT_FILTER);
		intent.putExtra("category", "login");
		intent.putExtra("status", false);
		intent.putExtra("message", message);
		LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
	}

}
