package com.mobgame.gui;

import android.animation.Animator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v13.app.FragmentPagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.view.MobIndicator;
import com.mobgame.model.Game;
import com.mobgame.utils.Constants;

/**
 * Created by khaitran on 7/24/17.
 */

public class MobGamePagerFragment extends Fragment {
    private static final String TAG = MobGamePagerFragment.class.getSimpleName();

    private View layoutMain;
    private Activity activity;
    private MobGameViewPager viewPager;
    private MobGamePagerTabStrip tabs;
    private MobIndicator layoutIndicators;
    private FragmentPagerAdapter adapter;
    private MobGameWebFragment.EventListener mWebEventListener;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;

    private int selectedIndex;

    public MobGamePagerFragment(){

    }

    @SuppressLint("ValidFragment")
    public MobGamePagerFragment(Activity activity){
        this.activity = activity;
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_pager , container , false);
        layoutMain = view.findViewById(R.id.layout_main);
        viewPager = (MobGameViewPager) view.findViewById(R.id.pager);
        layoutIndicators = (MobIndicator) view.findViewById(R.id.layout_indicator_bottom);
        tabs = (MobGamePagerTabStrip) view.findViewById(R.id.pager_title_strip);

        try {
            Game gameConfigs = GameConfigManager.getInstance().getGameConfig();

            String lang = Constants.LANG_EN;
            if(gameConfigs != null){
                lang = gameConfigs.getLang();
            }

            if(Constants.LANG_VI.equalsIgnoreCase(lang)){
                tabs.setIndicatorColor(Color.rgb(241 , 67 , 8));
                tabs.setTextColor(Color.rgb(241 , 67 , 8));
            }else{
                tabs.setIndicatorColor(Color.rgb(194 , 39 , 45));
                tabs.setTextColor(Color.rgb(194 , 39 , 45));
            }
            if(adapter != null){
                setAdapter(adapter);
            }

            if(mOnPageChangeListener != null){
                viewPager.addOnPageChangeListener(mOnPageChangeListener);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return view;
    }

    public void setAdapter(FragmentPagerAdapter adapter){
        setAdapter(adapter , this.selectedIndex);
    }

    public void  setAdapter(FragmentPagerAdapter adapter , final int selectedIndex){
        try {
            if(viewPager != null && tabs != null){
                viewPager.setAdapter(null);
                viewPager.setAdapter(adapter);
                layoutIndicators.setViewPager(viewPager);

                tabs.setViewPager(viewPager);
                if(adapter.getCount() <= 1
                        && this.adapter.getCount() > 1){
                    hideTabs(false);
                }else if(adapter.getCount() > 1
                        && this.adapter.getCount() < 1){
                    showTabs(false);
                }

                for (int i = 0 ; i < adapter.getCount() ; i++){
                    Fragment frag = adapter.getItem(i);
                    if(frag instanceof MobGameWebFragment){
                        ((MobGameWebFragment) frag).setWebViewTag(i + "");
                        if(mWebEventListener != null){
                            ((MobGameWebFragment) frag).setEventListener(mWebEventListener);
                        }
                    }
                }

                viewPager.setCurrentItem(selectedIndex , false);
                if(mOnPageChangeListener != null){
                    mOnPageChangeListener.onPageSelected(selectedIndex);
                    layoutIndicators.updatePosition(selectedIndex);
                }
            }
            this.adapter = adapter;
            this.selectedIndex = selectedIndex;
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void notifiTabsChanged(){
        try {
            if(tabs != null){
                tabs.notifyDataSetChanged();
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void setWebEventListener(MobGameWebFragment.EventListener eventListener){
        try {
            this.mWebEventListener = eventListener;
            if(adapter != null){
                for (int i = 0 ; i < adapter.getCount() ; i ++){
                    Fragment frag = adapter.getItem(i);
                    if(frag instanceof MobGameWebFragment){
                        ((MobGameWebFragment) frag).setEventListener(mWebEventListener);
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void addOnPageChangeListener(ViewPager.SimpleOnPageChangeListener onPageChangeListener){
        try {
            if(viewPager != null){
                viewPager.addOnPageChangeListener(onPageChangeListener);
            }
            this.mOnPageChangeListener = onPageChangeListener;
        }catch (Exception e){
            e.printStackTrace();
        }
    }
    public int countTabs(){
        return adapter.getCount();
    }

    public void showTabs(boolean isAnimated){
        try{
            viewPager.setPagingEnabled(true);
            tabs.setVisibility(View.VISIBLE);
            if(isAnimated){
                tabs.animate()
                        .setDuration(250)
                        .y(0);

                viewPager.animate()
                        .setDuration(250)
                        .y(tabs.getHeight())
                        .setListener(mAnimatorListener);
            }else{
                tabs.animate()
                        .setDuration(0)
                        .y(0);

                viewPager.animate()
                        .setDuration(0)
                        .y(tabs.getHeight())
                        .setListener(mAnimatorListener);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void hideTabs(boolean isAnimated){
        try {
            if(viewPager == null) return;
            viewPager.setPagingEnabled(false);
            if(isAnimated){
                tabs.animate().setDuration(250)
                        .y(- tabs.getHeight());
                viewPager.animate()
                        .setDuration(250)
                        .y(0)
                        .setListener(mAnimatorListener);
            }else{
                tabs.animate().setDuration(0)
                        .y(- tabs.getHeight());
                viewPager.animate()
                        .setDuration(0)
                        .y(0)
                        .setListener(mAnimatorListener);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void updateTabs(){
        try {
            ((ViewGroup) layoutMain).updateViewLayout(
                    viewPager,
                    new RelativeLayout.LayoutParams(
                            ViewGroup.LayoutParams.MATCH_PARENT,
                            layoutMain.getHeight() - tabs.getHeight() - (int) tabs.getY()
                    )
            );
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private Animator.AnimatorListener mAnimatorListener = new Animator.AnimatorListener() {
        @Override
        public void onAnimationStart(Animator animation) {
            try {
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        ((ViewGroup) layoutMain).updateViewLayout(
                                viewPager,
                                new RelativeLayout.LayoutParams(
                                        ViewGroup.LayoutParams.MATCH_PARENT,
                                        layoutMain.getHeight()
                                )
                        );
                    }
                });
            }catch (Exception e){
                e.printStackTrace();
            }
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            try {
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        updateTabs();
                    }
                });
            }catch (Exception e){
                e.printStackTrace();
            }
        }

        @Override
        public void onAnimationCancel(Animator animation) {

        }

        @Override
        public void onAnimationRepeat(Animator animation) {

        }
    };
}
